/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
/**
 * Creates a small alerts notifications on the page to provide feedback messages.
 * @param type - success | info | warning | error
 * @param dismissable - true | false
 *
 * @returns void
 *
 * The color of the alert should be set according to the type and dismissable is false by default.
 * @remarks Link to Scaffolding example - http://web.rtp.netapp.com/~peters1/nwfjs_scaffolding/#/components/alert
 */
import { Component, EventEmitter, Input, Output } from '@angular/core';
var AlertComponent = /** @class */ (function () {
    function AlertComponent() {
        this.type = 'warning'; // this matches bootstrap's default which is warning.
        // this matches bootstrap's default which is warning.
        /* I just proxy these straight from ng-bootstrap/alert */
        this.dismissable = false;
        this.close = new EventEmitter();
        this.isShowing = true;
    }
    /**
     * @return {?}
     */
    AlertComponent.prototype.onClose = /**
     * @return {?}
     */
    function () {
        this.isShowing = false;
        this.close.emit();
    };
    AlertComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-alert',
                    template: "\n  <ngb-alert [dismissible]=\"dismissable\" [type]=\"type\" *ngIf=\"isShowing\" (close)=\"onClose()\">\n  <div class=\"d-flex\">\n    <div *ngIf=\"type\">\n      <nwf-icon [severity]=\"type\"></nwf-icon>\n    </div>\n    <div class=\"flex-grow-1 ml-2\">\n       <ng-content></ng-content>\n    </div>\n  </div>\n</ngb-alert>\n  ",
                    styles: [":host .alert{color:#000;box-shadow:2px 2px 2px 0 rgba(0,0,0,.07)}:host .alert ::ng-deep h2{margin-top:4px;color:#252525;font-weight:600;font-size:16px}:host .alert ::ng-deep .close{color:#252525;opacity:1;min-height:32px;border-radius:.1rem}:host .alert.alert-success ::ng-deep .close:hover{color:#b4e697;background:#498128}:host .alert.alert-info ::ng-deep #base-layer{fill:#252525}:host .alert.alert-info ::ng-deep .close:hover{color:#fff7c0;background:#252525}:host .alert.alert-error ::ng-deep .close:hover{color:#fccdce;background:#da1e21}:host .alert.alert-warning ::ng-deep .close:hover{color:#ffe1a1;background:#f88402}"]
                }] }
    ];
    /** @nocollapse */
    AlertComponent.ctorParameters = function () { return []; };
    AlertComponent.propDecorators = {
        type: [{ type: Input }],
        dismissable: [{ type: Input }],
        close: [{ type: Output }]
    };
    return AlertComponent;
}());
export { AlertComponent };
if (false) {
    /** @type {?} */
    AlertComponent.prototype.type;
    /** @type {?} */
    AlertComponent.prototype.dismissable;
    /** @type {?} */
    AlertComponent.prototype.close;
    /** @type {?} */
    AlertComponent.prototype.isShowing;
}
//# sourceMappingURL=data:application/json;base64,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