/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import * as tslib_1 from "tslib";
import { Injectable } from '@angular/core';
import { TransitionService } from '@uirouter/core';
import { get } from 'lodash-es';
import { interval, merge, of, Subject, zip } from 'rxjs';
import { concatMap, filter, map, share, takeUntil } from 'rxjs/operators';
import { NwfjsConfigService } from '../../../nwfjs.config.service';
var NwfBeaconService = /** @class */ (function () {
    function NwfBeaconService(transitionService, config) {
        var _this = this;
        this.transitionService = transitionService;
        this.config = config;
        // Reset beacon on transition
        this.transitionService.onBefore({}, (/**
         * @return {?}
         */
        function () {
            _this.ngOnDestroy();
            _this.ngOnInit();
        }));
        // Initial construction of the beacon service
        this.ngOnInit();
    }
    /**
     * @param {?} pollInterval
     * @return {?}
     */
    NwfBeaconService.prototype.setInterval = /**
     * @param {?} pollInterval
     * @return {?}
     */
    function (pollInterval) {
        this.resetTrigger();
        // Polling interval and signal to start the next request
        /** @type {?} */
        var pollIntervalObs = interval(pollInterval);
        // Wait for previous poll to compolete before starting another
        /** @type {?} */
        var polling = zip(pollIntervalObs, this.nextPoll.pipe(takeUntil(this.destroyTrigger)));
        polling.pipe(takeUntil(this.destroyTrigger)).subscribe(this.triggerLoad);
    };
    /**
     * @param {?} trigger
     * @return {?}
     */
    NwfBeaconService.prototype.setTrigger = /**
     * @param {?} trigger
     * @return {?}
     */
    function (trigger) {
        this.resetTrigger();
        trigger.pipe(takeUntil(this.destroyTrigger), takeUntil(this.destroy)).subscribe(this.triggerLoad);
    };
    // Trigger interval data request
    // Trigger interval data request
    /**
     * @return {?}
     */
    NwfBeaconService.prototype.start = 
    // Trigger interval data request
    /**
     * @return {?}
     */
    function () {
        this.triggerLoad.next();
    };
    // Trigger manual data request
    // Trigger manual data request
    /**
     * @return {?}
     */
    NwfBeaconService.prototype.refresh = 
    // Trigger manual data request
    /**
     * @return {?}
     */
    function () {
        this.manualLoad.next();
    };
    // Register service call to load data and return observable that emits the data
    // Register service call to load data and return observable that emits the data
    /**
     * @template T
     * @param {?} serviceCall
     * @return {?}
     */
    NwfBeaconService.prototype.register = 
    // Register service call to load data and return observable that emits the data
    /**
     * @template T
     * @param {?} serviceCall
     * @return {?}
     */
    function (serviceCall) {
        /** @type {?} */
        var serviceObservable = this.loadData.pipe(takeUntil(this.destroy), concatMap(serviceCall), share());
        this.services.push(serviceObservable);
        return serviceObservable;
    };
    /**
     * @private
     * @return {?}
     */
    NwfBeaconService.prototype.ngOnInit = /**
     * @private
     * @return {?}
     */
    function () {
        var _this = this;
        this.services = [];
        this.destroy = new Subject();
        this.manualLoad = new Subject();
        this.nextPoll = new Subject();
        this.triggerLoad = new Subject();
        this.destroyTrigger = new Subject();
        /** @type {?} */
        var beaconInterval = get(this.config, 'beaconInterval');
        if (beaconInterval) {
            this.setInterval(beaconInterval);
        }
        /*if(this.beaconListener) {
            this.setTrigger(this.beaconListener.getBeacon());
        }*/
        // Load data triggers all the service calls
        this.loadData = merge(this.triggerLoad.pipe(map((/**
         * @return {?}
         */
        function () { return NwfBeaconService.TRIGGER; }))), this.manualLoad.pipe(map((/**
         * @return {?}
         */
        function () { return NwfBeaconService.MANUAL; }))))
            .pipe(takeUntil(this.destroy), // complete all subscriptions on destroy
        share());
        // We want to wait until all request are complete before firing off the next poll request
        this.loadComplete = this.loadData.pipe(concatMap((/**
         * @param {?} value
         * @return {?}
         */
        function (value) { return zip.apply(void 0, tslib_1.__spread([of(value)], _this.services)); })), share());
        this.loadComplete.pipe(filter((/**
         * @param {?} __0
         * @return {?}
         */
        function (_a) {
            var _b = tslib_1.__read(_a, 1), val = _b[0];
            return val === NwfBeaconService.TRIGGER;
        }))).subscribe(this.nextPoll);
    };
    /**
     * @private
     * @return {?}
     */
    NwfBeaconService.prototype.resetTrigger = /**
     * @private
     * @return {?}
     */
    function () {
        if (this.destroyTrigger) {
            this.destroyTrigger.next();
            this.destroyTrigger.complete();
        }
        this.destroyTrigger = new Subject();
    };
    // Clean up subjects
    // Clean up subjects
    /**
     * @private
     * @return {?}
     */
    NwfBeaconService.prototype.ngOnDestroy = 
    // Clean up subjects
    /**
     * @private
     * @return {?}
     */
    function () {
        this.destroy.next();
        this.destroy.complete();
        this.destroyTrigger.next();
        this.destroyTrigger.complete();
        this.nextPoll.complete();
        this.manualLoad.complete();
        this.triggerLoad.complete();
    };
    NwfBeaconService.MANUAL = 'manual';
    NwfBeaconService.TRIGGER = 'trigger';
    NwfBeaconService.decorators = [
        { type: Injectable }
    ];
    /** @nocollapse */
    NwfBeaconService.ctorParameters = function () { return [
        { type: TransitionService },
        { type: NwfjsConfigService }
    ]; };
    return NwfBeaconService;
}());
export { NwfBeaconService };
if (false) {
    /**
     * @type {?}
     * @private
     */
    NwfBeaconService.MANUAL;
    /**
     * @type {?}
     * @private
     */
    NwfBeaconService.TRIGGER;
    /** @type {?} */
    NwfBeaconService.prototype.loadData;
    /** @type {?} */
    NwfBeaconService.prototype.loadComplete;
    /**
     * @type {?}
     * @private
     */
    NwfBeaconService.prototype.triggerLoad;
    /**
     * @type {?}
     * @private
     */
    NwfBeaconService.prototype.destroyTrigger;
    /**
     * @type {?}
     * @private
     */
    NwfBeaconService.prototype.destroy;
    /**
     * @type {?}
     * @private
     */
    NwfBeaconService.prototype.manualLoad;
    /**
     * @type {?}
     * @private
     */
    NwfBeaconService.prototype.nextPoll;
    /**
     * @type {?}
     * @private
     */
    NwfBeaconService.prototype.services;
    /**
     * @type {?}
     * @private
     */
    NwfBeaconService.prototype.transitionService;
    /**
     * @type {?}
     * @private
     */
    NwfBeaconService.prototype.config;
}
//# sourceMappingURL=data:application/json;base64,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