/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import * as tslib_1 from "tslib";
import { Injectable } from '@angular/core';
import { NwfLeftnavService } from '../../shell/leftnav/leftnav.service';
import * as i0 from "@angular/core";
import * as i1 from "../../shell/leftnav/leftnav.service";
var NwfFeatureTourService = /** @class */ (function () {
    function NwfFeatureTourService(leftnavService) {
        this.leftnavService = leftnavService;
        this.tours = {};
    }
    /**
     * @param {?} group
     * @param {?} pop
     * @param {?=} slf
     * @return {?}
     */
    NwfFeatureTourService.prototype.registerTour = /**
     * @param {?} group
     * @param {?} pop
     * @param {?=} slf
     * @return {?}
     */
    function (group, pop, slf) {
        var _this = this;
        var _a = tslib_1.__read(group.split('-'), 2), groupName = _a[0], order = _a[1];
        /** @type {?} */
        var orderInt = parseInt(order);
        if (!orderInt) {
            /** @type {?} */
            var tourGroup = this.tours[groupName];
            orderInt = tourGroup && tourGroup.length ? tourGroup.length : 0;
        }
        this.addTourToGroup(groupName, orderInt, pop, slf);
        pop.hidden.subscribe((/**
         * @return {?}
         */
        function () {
            /** @type {?} */
            var thisGroup = _this.tours[groupName];
            /** @type {?} */
            var nextInd;
            for (var i = 0; i < thisGroup.length; i++) {
                if (pop == thisGroup[i].pop) {
                    nextInd = i + 1;
                    break;
                }
            }
            /** @type {?} */
            var nextTour = thisGroup[nextInd];
            if (nextTour) {
                nextTour.pop.open();
            }
            else {
                // at end of tour!
            }
        }));
    };
    /**
     * @param {?} group
     * @return {?}
     */
    NwfFeatureTourService.prototype.startTour = /**
     * @param {?} group
     * @return {?}
     */
    function (group) {
        var _a = tslib_1.__read(this.tours[group], 1), nextTour = _a[0];
        if (nextTour && nextTour.self) {
            this.leftnavService.recurseNavData((/**
             * @param {?} node
             * @return {?}
             */
            function (node) {
                if (node.children.indexOf(nextTour.self) !== -1) {
                    node.isCollapsed = false;
                }
            }));
        }
        nextTour.pop.open();
    };
    /**
     * @private
     * @param {?} group
     * @param {?} order
     * @param {?} pop
     * @param {?} slf
     * @return {?}
     */
    NwfFeatureTourService.prototype.addTourToGroup = /**
     * @private
     * @param {?} group
     * @param {?} order
     * @param {?} pop
     * @param {?} slf
     * @return {?}
     */
    function (group, order, pop, slf) {
        if (!this.tours[group]) {
            this.tours[group] = [];
        }
        this.tours[group].splice(order, 1, { pop: pop, self: slf });
    };
    NwfFeatureTourService.decorators = [
        { type: Injectable, args: [{
                    providedIn: 'root',
                },] }
    ];
    /** @nocollapse */
    NwfFeatureTourService.ctorParameters = function () { return [
        { type: NwfLeftnavService }
    ]; };
    /** @nocollapse */ NwfFeatureTourService.ngInjectableDef = i0.defineInjectable({ factory: function NwfFeatureTourService_Factory() { return new NwfFeatureTourService(i0.inject(i1.NwfLeftnavService)); }, token: NwfFeatureTourService, providedIn: "root" });
    return NwfFeatureTourService;
}());
export { NwfFeatureTourService };
if (false) {
    /** @type {?} */
    NwfFeatureTourService.prototype.tours;
    /** @type {?} */
    NwfFeatureTourService.prototype.leftnavService;
}
//# sourceMappingURL=data:application/json;base64,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