/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, Input, Optional } from '@angular/core';
import { DomSanitizer } from '@angular/platform-browser';
import { icons } from '@netapp/nwfjs_theme/icons/icons';
var IconComponent = /** @class */ (function () {
    function IconComponent(sanitizer) {
        this.sanitizer = sanitizer;
        this.iconClass = ''; // they hand in kabob-case
        this.hasLoggedDep = false;
        this.stateMap = {
            ok: 'icon-status-ok-circlecheck',
            success: 'icon-status-ok-circlecheck',
            warning: 'icon-status-warning',
            critical: 'icon-status-critical',
            error: 'icon-status-error-full',
            info: 'icon-status-info',
        };
    }
    Object.defineProperty(IconComponent.prototype, "svgContent", {
        get: /**
         * @return {?}
         */
        function () {
            /* if I have a severity, we load the right one */
            /** @type {?} */
            var isSeverity = false;
            if (this.severity && this.severity.toLowerCase() in this.stateMap) {
                this.iconClass = this.stateMap[this.severity.toLowerCase()];
                isSeverity = true;
            }
            /* I set a flag so I don't log over and over */
            if (!this.hasLoggedDep && !isSeverity) {
                /* If they have sent me a key that I don't have warn them */
                if (!(this.iconClass in icons)) {
                    console.error("You tried to load <nwf-icon iconClass=\"" + this.iconClass + "\"> but it has been deprecated.");
                    this.hasLoggedDep = true;
                }
            }
            /* return the actual html from the icons.js */
            return this.sanitizer.bypassSecurityTrustHtml(icons[this.iconClass]);
        },
        enumerable: true,
        configurable: true
    });
    IconComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-icon',
                    template: "\n  <div [innerHTML]=\"svgContent\" class=\"{{iconClass}} nwf-icon {{class}}\"></div>\n  ",
                    styles: [":host{display:inline-flex;align-items:center;justify-content:center;line-height:0;pointer-events:none}:host+.nwf-icon-label{display:inline-block;vertical-align:top;margin-left:4px}"]
                }] }
    ];
    /** @nocollapse */
    IconComponent.ctorParameters = function () { return [
        { type: DomSanitizer }
    ]; };
    IconComponent.propDecorators = {
        iconClass: [{ type: Input }],
        severity: [{ type: Input }, { type: Optional }],
        class: [{ type: Input }]
    };
    return IconComponent;
}());
export { IconComponent };
if (false) {
    /** @type {?} */
    IconComponent.prototype.iconClass;
    /** @type {?} */
    IconComponent.prototype.severity;
    /** @type {?} */
    IconComponent.prototype.class;
    /** @type {?} */
    IconComponent.prototype.hasLoggedDep;
    /**
     * @type {?}
     * @private
     */
    IconComponent.prototype.stateMap;
    /**
     * @type {?}
     * @private
     */
    IconComponent.prototype.sanitizer;
}
//# sourceMappingURL=data:application/json;base64,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