/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, Input, ViewChild } from '@angular/core';
import { NgbPopover } from '@ng-bootstrap/ng-bootstrap';
import { I18NextPipe } from 'angular-i18next';
import { DxDataGridComponent } from 'devextreme-angular';
import { filter, find, findIndex, forEach, isEqual, merge, remove, sortBy } from 'lodash-es';
var ColumnChooserComponent = /** @class */ (function () {
    function ColumnChooserComponent(i18NextPipe) {
        this.i18NextPipe = i18NextPipe;
        this._availableColumns = [];
        this._columnsToDisplay = [];
        this.isInvalid = false;
        this.value = [];
    }
    /**
     * @return {?}
     */
    ColumnChooserComponent.prototype.ngOnInit = /**
     * @return {?}
     */
    function () {
        var _this = this;
        this.dataGrid.onContentReady.subscribe((/**
         * @param {?} data
         * @return {?}
         */
        function (data) {
            _this.gridInstance = data.component.instance();
            /** @type {?} */
            var newColumns = _this.gridInstance.state().columns;
            /** @type {?} */
            var areColumnsEqual = isEqual(newColumns, _this.value);
            if (!areColumnsEqual) {
                // Update columns and refresh columns to display only if columns have changed
                _this.value = newColumns;
                _this.setColumnsToDisplay();
            }
        }));
    };
    /**
     * @return {?}
     */
    ColumnChooserComponent.prototype.setColumnsToDisplay = /**
     * @return {?}
     */
    function () {
        var _this = this;
        /** @type {?} */
        var dxGridColumns = this.getAllColumnsOnDxGrid();
        // Remove all columns that are not shown in the column chooser
        /** @type {?} */
        var shownColumns = filter(dxGridColumns, (/**
         * @param {?} col
         * @return {?}
         */
        function (col) { return col.showInColumnChooser; }));
        // updating dxGridColumns with the value of column chooser.
        shownColumns.forEach((/**
         * @param {?} origCol
         * @return {?}
         */
        function (origCol) {
            // find if a column in dxGridColumns also exist in value. Columns should have same dataField.
            /** @type {?} */
            var columnInValue = find(_this.value, (/**
             * @param {?} valueCol
             * @return {?}
             */
            function (valueCol) { return origCol.dataField === valueCol.dataField; }));
            origCol = merge(origCol, columnInValue);
        }));
        // we set columnsToDisplay for visible columns and sort them in order of visibleIndex.
        this._columnsToDisplay = sortBy(filter(shownColumns, (/**
         * @param {?} col
         * @return {?}
         */
        function (col) { return col.visible; })), [(/**
             * @param {?} o
             * @return {?}
             */
            function (o) { return o.visibleIndex; })]);
        // available columns are all columns with caption but are not visible.
        this._availableColumns = filter(shownColumns, (/**
         * @param {?} col
         * @return {?}
         */
        function (col) { return !col.visible; }));
    };
    /**
     * @return {?}
     */
    ColumnChooserComponent.prototype.togglePopover = /**
     * @return {?}
     */
    function () {
        this.ngbPopover.toggle();
    };
    /**
     * @return {?}
     */
    ColumnChooserComponent.prototype.closePopover = /**
     * @return {?}
     */
    function () {
        this.ngbPopover.close();
    };
    /**
     * @param {?} selection
     * @return {?}
     */
    ColumnChooserComponent.prototype.toggleSelection = /**
     * @param {?} selection
     * @return {?}
     */
    function (selection) {
        /** @type {?} */
        var isSel = selection.isSelected || null;
        if (!isSel) {
            this.selectOption(selection);
        }
        else {
            this.deselectColumn(selection);
        }
    };
    /**
     * @param {?} selIn
     * @return {?}
     */
    ColumnChooserComponent.prototype.deselectColumn = /**
     * @param {?} selIn
     * @return {?}
     */
    function (selIn) {
        delete selIn.isSelected;
    };
    /**
     * @param {?} selIn
     * @return {?}
     */
    ColumnChooserComponent.prototype.selectOption = /**
     * @param {?} selIn
     * @return {?}
     */
    function (selIn) {
        selIn.isSelected = true;
    };
    /**
     * @return {?}
     */
    ColumnChooserComponent.prototype.deSelectAvailableColumns = /**
     * @return {?}
     */
    function () {
        // Deselect means I am taking a selected column and moving it to available the [ < ]
        /** @type {?} */
        var columnsSelectedToHide = remove(this._columnsToDisplay, { isSelected: true });
        [].splice.apply(this._availableColumns, [this._availableColumns.length, 0].concat(columnsSelectedToHide));
        this.removeIsSelectedFromAllColumns(this._availableColumns);
    };
    /**
     * @param {?} availableColumns
     * @return {?}
     */
    ColumnChooserComponent.prototype.removeIsSelectedFromAllColumns = /**
     * @param {?} availableColumns
     * @return {?}
     */
    function (availableColumns) {
        var _this = this;
        forEach(availableColumns, (/**
         * @param {?} column
         * @return {?}
         */
        function (column) {
            _this.deselectColumn(column);
        }));
    };
    /**
     * @return {?}
     */
    ColumnChooserComponent.prototype.selectAvailableColumns = /**
     * @return {?}
     */
    function () {
        // Find my self in the schema availableColumns so I Can be put back where I belong.
        /** @type {?} */
        var columnsSelectedToShow = remove(this._availableColumns, { isSelected: true });
        [].splice.apply(this._columnsToDisplay, [this._columnsToDisplay.length, 0].concat(columnsSelectedToShow));
        if (this._columnsToDisplay.length > 0) {
            this.isInvalid = false;
        }
        this.removeIsSelectedFromAllColumns(this._columnsToDisplay);
    };
    /**
     * @param {?} fromIndex
     * @param {?} toIndex
     * @return {?}
     */
    ColumnChooserComponent.prototype.moveSelection = /**
     * @param {?} fromIndex
     * @param {?} toIndex
     * @return {?}
     */
    function (fromIndex, toIndex) {
        /** @type {?} */
        var sels = this._columnsToDisplay;
        /** @type {?} */
        var element = sels[fromIndex];
        if (fromIndex === 0 && toIndex === -1) {
            return;
        }
        sels.splice(fromIndex, 1);
        sels.splice(toIndex, 0, element);
    };
    /**
     * @return {?}
     */
    ColumnChooserComponent.prototype.moveColumnsUp = /**
     * @return {?}
     */
    function () {
        var _this = this;
        /** @type {?} */
        var selectedAvailableColumns = filter(this._columnsToDisplay, { isSelected: true });
        forEach(selectedAvailableColumns, (/**
         * @param {?} optionToMove
         * @return {?}
         */
        function (optionToMove) {
            /** @type {?} */
            var idx = findIndex(_this._columnsToDisplay, { dataField: optionToMove.dataField });
            if (idx > 0) {
                // toIndex will be one greater than currentIndex.
                /** @type {?} */
                var toIndex = idx - 1;
                /** @type {?} */
                var doUpdate = false;
                // toIndex has to be greater than -1.
                while (toIndex > -1) {
                    /** @type {?} */
                    var toElement = _this._columnsToDisplay[toIndex];
                    // find element at toIndex and see if its fixed or not (i.e) cannot be reordered/hidden and it should not be selected.
                    // all selected elements are handled on their own.
                    if (toElement.allowReordering && !toElement.isSelected) {
                        toIndex = doUpdate ? toIndex + 1 : toIndex;
                        _this.moveSelection(idx, toIndex);
                        break;
                    }
                    else {
                        // else, we decrement the toIndex and move-on.
                        toIndex = toIndex - 1;
                        doUpdate = true;
                    }
                }
            }
        }));
    };
    /**
     * @return {?}
     */
    ColumnChooserComponent.prototype.moveColumnsDown = /**
     * @return {?}
     */
    function () {
        var _this = this;
        /** @type {?} */
        var selectedAvailableColumns = filter(this._columnsToDisplay, { isSelected: true }).reverse();
        forEach(selectedAvailableColumns, (/**
         * @param {?} optionToMove
         * @return {?}
         */
        function (optionToMove) {
            // find index of selected column in columnsToDisplay.
            /** @type {?} */
            var idx = findIndex(_this._columnsToDisplay, { dataField: optionToMove.dataField });
            if (idx < _this._columnsToDisplay.length - 1) {
                // toIndex will be one greater than currentIndex.
                // we also have a flag that tells us if we need to update toIndex or not.
                /** @type {?} */
                var toIndex = idx + 1;
                /** @type {?} */
                var doUpdate = false;
                // we loop over till we reach the last index of columnsToDisplay as thats the max we can go down.
                while (toIndex < _this._columnsToDisplay.length) {
                    // find element at toIndex and see if its fixed or not (i.e) cannot be reordered/hidden.
                    /** @type {?} */
                    var toElement = _this._columnsToDisplay[toIndex];
                    // if next column can be reordered, we jump to next to next spot.
                    if (toElement.allowReordering) {
                        // we move the selection.
                        toIndex = doUpdate ? toIndex - 1 : toIndex;
                        _this.moveSelection(idx, toIndex);
                        break;
                    }
                    else {
                        // else, we increment the toIndex and move on.
                        toIndex = toIndex + 1;
                        doUpdate = true;
                    }
                }
            }
        }));
    };
    /**
     * @return {?}
     */
    ColumnChooserComponent.prototype.cancel = /**
     * @return {?}
     */
    function () {
        this.setColumnsToDisplay();
        this.removeIsSelectedFromAllColumns(this._columnsToDisplay);
        this.removeIsSelectedFromAllColumns(this._availableColumns);
        this.closePopover();
    };
    /**
     * @return {?}
     */
    ColumnChooserComponent.prototype.apply = /**
     * @return {?}
     */
    function () {
        if (this._columnsToDisplay.length == 0) {
            // show error msg
            this.isInvalid = true;
            // dont close the popover
            return;
        }
        this.removeIsSelectedFromAllColumns(this._columnsToDisplay);
        this.removeIsSelectedFromAllColumns(this._availableColumns);
        this.updateIndexAndVisibilityOfColumns();
        this.closePopover();
    };
    /**
     * Method to update the index and visibility of grid columns and set it on the grid.
     */
    /**
     * Method to update the index and visibility of grid columns and set it on the grid.
     * @return {?}
     */
    ColumnChooserComponent.prototype.updateIndexAndVisibilityOfColumns = /**
     * Method to update the index and visibility of grid columns and set it on the grid.
     * @return {?}
     */
    function () {
        /** @type {?} */
        var gridInstance = this.gridInstance;
        this._columnsToDisplay.forEach((/**
         * @param {?} col
         * @param {?} index
         * @return {?}
         */
        function (col, index) {
            col.visibleIndex = index;
        }));
        gridInstance.beginUpdate();
        // _columnsToDisplay are columns on right side of column chooser, columns that are shown.
        // we loop over all _columnsToDisplay and set visible to true, and update visibleIndex.
        this._columnsToDisplay.forEach((/**
         * @param {?} col
         * @param {?} visibleIndex
         * @return {?}
         */
        function (col, visibleIndex) {
            gridInstance.columnOption(col.dataField, {
                visible: true,
                visibleIndex: visibleIndex,
            });
        }));
        // _availableColumns are columns on left side of column chooser, columns that are hidden.
        // we loop over all availableColumns and set visible to false.
        this._availableColumns.forEach((/**
         * @param {?} __0
         * @return {?}
         */
        function (_a) {
            var dataField = _a.dataField;
            gridInstance.columnOption(dataField, {
                visible: false,
                visibleIndex: undefined,
            });
        }));
        gridInstance.endUpdate();
    };
    /**
     * We find all columns on dx grid. Instead of using a method available on gridInstance directly, we use this way because
     * gridInstance.columnOption gives a complete column object (including default column settings),
     * whereas column object returned by gridInstance.option('columnms') only contains properties you explicitly set.
     * gridInstance.getVisibleColumns() method gives us the complete object but it only works for visible columns.
     */
    /**
     * We find all columns on dx grid. Instead of using a method available on gridInstance directly, we use this way because
     * gridInstance.columnOption gives a complete column object (including default column settings),
     * whereas column object returned by gridInstance.option('columnms') only contains properties you explicitly set.
     * gridInstance.getVisibleColumns() method gives us the complete object but it only works for visible columns.
     * @private
     * @return {?}
     */
    ColumnChooserComponent.prototype.getAllColumnsOnDxGrid = /**
     * We find all columns on dx grid. Instead of using a method available on gridInstance directly, we use this way because
     * gridInstance.columnOption gives a complete column object (including default column settings),
     * whereas column object returned by gridInstance.option('columnms') only contains properties you explicitly set.
     * gridInstance.getVisibleColumns() method gives us the complete object but it only works for visible columns.
     * @private
     * @return {?}
     */
    function () {
        /** @type {?} */
        var gridInstance = this.gridInstance;
        /** @type {?} */
        var columnsViaOptions = gridInstance && gridInstance.state().columns;
        if (columnsViaOptions) {
            return columnsViaOptions.map((/**
             * @param {?} __0
             * @return {?}
             */
            function (_a) {
                var dataField = _a.dataField;
                return gridInstance.columnOption(dataField);
            }));
        }
        else {
            return;
        }
    };
    ColumnChooserComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-grid-column-chooser',
                    template: "<button [ngbPopover]=\"popContent\" [autoClose]=\"'outside'\" placement=\"bottom-right\" title=\"{{'nwfjs:columnChooserTitle' | i18next}}\" (click)=\"togglePopover()\"\n    triggers=\"none\" type=\"button\" class=\"btn btn-flat btn-icon text-dark\" data-netapp-id=\"nwf-column-chooser-btn\">\n    <nwf-icon iconClass=\"icon-action-settings\"></nwf-icon>\n</button>\n<ng-template #popContent>\n    <figure class=\"nwf-column-chooser\">\n        <div class=\"l-nwf-column-chooser-options\">\n            <h4>{{'nwfjs:columnChooserAvailableColumn' | i18next}}</h4>\n            <div class=\"nwf-column-chooser-options-no-msg\" *ngIf=\"!_availableColumns.length\">{{'nwfjs:columnChooserAllColumnSelected' | i18next}}</div>\n            <ul class=\"nwf-column-chooser-selections\" data-netapp-id=\"nwf-column-chooser-selections\" [ngClass]=\"{ 'is-empty': !_availableColumns.length }\">\n                <li class=\"nwf-column-chooser-option\" *ngFor=\"let selection of _availableColumns\" (click)=\"toggleSelection(selection)\" [ngClass]=\"{ 'is-selected': selection.isSelected }\">\n                    <span class=\"nwf-column-chooser-option-label\">{{selection.caption}}</span>\n                </li>\n            </ul>\n        </div>\n        <div class=\"l-nwf-column-chooser-controls\">\n            <button type=\"button\" class=\"btn btn-default\" (click)=\"deSelectAvailableColumns()\" data-netapp-id=\"nwf-column-chooser-select-option-btn\">\n                <nwf-icon iconClass=\"icon-misc-chevronleft\"></nwf-icon>\n            </button>\n            <span class=\"nwf-column-chooser-control-divider\"></span>\n            <button type=\"button\" class=\"btn btn-default\" (click)=\"selectAvailableColumns()\" data-netapp-id=\"nwf-column-chooser-select-option-btn\">\n                <nwf-icon iconClass=\"icon-misc-chevronright\"></nwf-icon>\n            </button>\n        </div>\n        <div class=\"l-nwf-column-chooser-selections\">\n            <h4>{{'nwfjs:columnChooserColumnToDisplay' | i18next}}</h4>\n            <ul class=\"nwf-column-chooser-selections\" data-netapp-id=\"nwf-column-chooser-selections\" [ngClass]=\"{'is-invalid': isInvalid}\"\n                [ngStyle]=\"{'overflow': isInvalid ? 'hidden' : ''}\">\n                <li class=\"nwf-column-chooser-option\" *ngFor=\"let selection of _columnsToDisplay;\" (click)=\"toggleSelection(selection)\" [ngClass]=\"{ 'is-selected': selection.isSelected, 'is-disabled': !(selection.allowHiding && selection.allowReordering) }\">\n                    <span class=\"nwf-column-chooser-option-label\">{{selection.caption}}</span>\n                </li>\n            </ul>\n            <div *ngIf=\"isInvalid\" class=\"invalid-feedback\">{{'nwfjs:isRequiredAtLeastOne' | i18next}}</div>\n        </div>\n\n        <div class=\"l-nwf-column-chooser-controls\">\n            <button type=\"button\" class=\"btn btn-default\" (click)=\"moveColumnsUp()\" data-netapp-id=\"nwf-column-chooser-select-option-btn\">\n                <nwf-icon iconClass=\"icon-misc-chevronup\"></nwf-icon>\n            </button>\n            <span class=\"nwf-column-chooser-control-divider\"></span>\n            <button class=\"btn btn-default\" (click)=\"moveColumnsDown()\" data-netapp-id=\"nwf-column-chooser-select-option-btn\">\n                <nwf-icon iconClass=\"icon-misc-chevrondown\"></nwf-icon>\n            </button>\n        </div>\n    </figure>\n    <footer class=\"d-flex mt-2\">\n        <div class=\"d-flex flex-fill justify-content-end\">\n            <button type=\"button\" class=\"btn btn-secondary mr-2\" (click)=\"cancel()\" data-netapp-id=\"nwf-column-chooser-close-btn\">{{'nwfjs:cancel' | i18next}}</button>\n            <button type=\"submit\" class=\"btn btn-primary\" (click)=\"apply()\" data-netapp-id=\"nwf-column-chooser-apply-btn\">{{'nwfjs:columnChooserApplyColumns' | i18next}}</button>\n        </div>\n    </footer>\n</ng-template>",
                    styles: [".dropdown-toggle::after{display:none}.nwf-column-chooser{display:flex;width:550px}.l-nwf-column-chooser-options{width:250px}.nwf-column-chooser-options-no-msg{position:absolute;padding-left:10px;top:45%}.nwf-column-chooser-option-label{flex:1}.nwf-column-chooser-option{padding:6px;border-bottom:1px solid #9c9c9c;display:flex;flex:1;cursor:pointer}.nwf-column-chooser-option.is-selected{background-color:#88c5ff}.nwf-column-chooser-option.is-disabled{pointer-events:none;cursor:pointer;background-color:#f2f2f2}.l-nwf-column-chooser-controls{display:flex;flex-direction:column;align-items:center;justify-content:center;padding:0 10px}.l-nwf-column-chooser-controls .btn{display:inline-block}.nwf-column-chooser-control-divider{height:10px}.l-nwf-column-chooser-selections{width:250px;display:flex;flex-direction:column}.nwf-column-chooser-selections{margin:0;padding:0;list-style:none;overflow-y:scroll;border:1px solid #c2c2c2;flex:1;max-height:328px;height:328px}.nwf-column-chooser-selections.is-empty{overflow-y:hidden}"]
                }] }
    ];
    /** @nocollapse */
    ColumnChooserComponent.ctorParameters = function () { return [
        { type: I18NextPipe }
    ]; };
    ColumnChooserComponent.propDecorators = {
        dataGrid: [{ type: Input }],
        ngbPopover: [{ type: ViewChild, args: [NgbPopover,] }]
    };
    return ColumnChooserComponent;
}());
export { ColumnChooserComponent };
if (false) {
    /** @type {?} */
    ColumnChooserComponent.prototype.dataGrid;
    /** @type {?} */
    ColumnChooserComponent.prototype._availableColumns;
    /** @type {?} */
    ColumnChooserComponent.prototype._columnsToDisplay;
    /** @type {?} */
    ColumnChooserComponent.prototype.isInvalid;
    /**
     * @type {?}
     * @private
     */
    ColumnChooserComponent.prototype.ngbPopover;
    /**
     * @type {?}
     * @private
     */
    ColumnChooserComponent.prototype.gridInstance;
    /**
     * @type {?}
     * @private
     */
    ColumnChooserComponent.prototype.value;
    /**
     * @type {?}
     * @private
     */
    ColumnChooserComponent.prototype.i18NextPipe;
}
//# sourceMappingURL=data:application/json;base64,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