/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import * as tslib_1 from "tslib";
/** @type {?} */
var containsOptions = [{
        name: 'nwfjs:contains', value: 'contains',
    }, {
        name: 'nwfjs:startsWith', value: 'startswith',
    }];
/** @type {?} */
var resourceContainsOptions = [{
        name: 'nwfjs:nameContains', value: 'contains',
    }, {
        name: 'nwfjs:nameStartsWith', value: 'startswith',
    }];
/** @type {?} */
var isOption = { name: 'nwfjs:is', value: '=' };
/** @type {?} */
var booleanOptions = [
    isOption,
    { name: 'nwfjs:isNot', value: '<>' },
];
/** @type {?} */
var numericOptions = [{
        name: 'nwfjs:greaterThan', value: '>',
    }, {
        name: 'nwfjs:lessThan', value: '<',
    }];
export default {
    'string': {
        inputType: 'text',
        options: containsOptions,
    },
    'associatedobjects': {
        inputType: 'text',
        options: containsOptions,
    },
    'volumetype': {
        inputType: 'select',
        options: [
            isOption,
        ],
    },
    'resource': {
        inputType: 'text',
        options: resourceContainsOptions,
    },
    'resource_null': {
        inputType: 'text',
        options: tslib_1.__spread(resourceContainsOptions, [{ name: 'nwfjs:is', value: '=', default: 'null' },
            { name: 'nwfjs:isNot', value: '<>', default: 'null' },]),
    },
    'metric': {
        inputType: 'number',
        options: numericOptions,
    },
    'enum': {
        inputType: 'select',
        options: booleanOptions,
    },
    'enum-single': {
        inputType: 'select',
        options: [
            isOption,
        ],
    },
    'enum-multiple': {
        inputType: 'multiselect',
        options: booleanOptions,
    },
    'number': {
        inputType: 'number',
        options: numericOptions,
    },
    'datetime': {
        inputType: 'dateTime',
        options: [{
                name: 'nwfjs:inTheLast', value: 'lst',
            }, {
                name: 'nwfjs:between', value: 'between',
            }, {
                name: 'nwfjs:greaterThan', value: '>=',
            }, {
                name: 'nwfjs:lessThan', value: '<=',
            }],
    },
};
//# sourceMappingURL=data:application/json;base64,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