/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import * as tslib_1 from "tslib";
import { Component, Input } from '@angular/core';
import { NG_VALUE_ACCESSOR } from '@angular/forms';
import { I18NextPipe } from 'angular-i18next';
var NwfFilterCriterionDateComponent = /** @class */ (function () {
    function NwfFilterCriterionDateComponent(i18NextPipe) {
        var e_1, _a;
        this.datetime = '';
        // List of default date selections for the user
        this.dateRangeList = [
            { id: 'LAST_1h', label: '' },
            { id: 'LAST_24h', label: '' },
            { id: 'LAST_72h', label: '' },
            { id: 'LAST_7d', label: '' },
            { id: 'LAST_30d', label: '' },
            { id: 'LAST_390d', label: '' },
        ];
        try {
            // i18n the values (displayed label in the drop down)
            for (var _b = tslib_1.__values(this.dateRangeList), _c = _b.next(); !_c.done; _c = _b.next()) {
                var dateRangeList = _c.value;
                // pop in the the label translated (the key is e.g. last_1h)
                dateRangeList.label = i18NextPipe.transform("nwfjs:" + dateRangeList.id.toLowerCase());
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
    }
    /**
     * @param {?} changes
     * @return {?}
     */
    NwfFilterCriterionDateComponent.prototype.ngOnChanges = /**
     * @param {?} changes
     * @return {?}
     */
    function (changes) {
        // on every operator change, we set the dateTime, dateTimeVisibleValue based on operator value.
        // we can have 3 types of operator.
        // 1. <=, >=, 2. between, 3. in the last(last)
        if (!changes.operator.isFirstChange()) {
            // if current value is <=, >=, we set dateTimeVisibleValue to current Date
            if (['<=', '>='].indexOf(changes.operator.currentValue) !== -1) {
                this.datetime = new Date().toISOString();
                this.datetimeVisibleValue = new Date();
            }
            else if (changes.operator.currentValue === 'between') {
                this.datetime = new Date().toISOString() + "~" + new Date().toISOString();
            }
            else {
                this.datetime = '';
            }
            // sending out new value.
            this.onValueModelChange(this.datetime);
        }
    };
    /**
     * Writes a new value to the element.
     * This method will be called by the forms API to write to the view when programmatic (model -> view) changes are requested.
     * This is incoming 'value' into the component.This value is pre-set value to datetime widget.
     * @param value
     */
    /**
     * Writes a new value to the element.
     * This method will be called by the forms API to write to the view when programmatic (model -> view) changes are requested.
     * This is incoming 'value' into the component.This value is pre-set value to datetime widget.
     * @param {?} value
     * @return {?}
     */
    NwfFilterCriterionDateComponent.prototype.writeValue = /**
     * Writes a new value to the element.
     * This method will be called by the forms API to write to the view when programmatic (model -> view) changes are requested.
     * This is incoming 'value' into the component.This value is pre-set value to datetime widget.
     * @param {?} value
     * @return {?}
     */
    function (value) {
        // we default datetime to last_72h, in case there is no value set.
        this.datetime = value;
        this.datetimeVisibleValue = new Date(this.datetime);
    };
    /**
     * @param {?} fn
     * @return {?}
     */
    NwfFilterCriterionDateComponent.prototype.registerOnChange = /**
     * @param {?} fn
     * @return {?}
     */
    function (fn) { this._onChange = fn; };
    /**
     * @param {?} fn
     * @return {?}
     */
    NwfFilterCriterionDateComponent.prototype.registerOnTouched = /**
     * @param {?} fn
     * @return {?}
     */
    function (fn) { };
    /**
     * This method is called whenever model tied to the component changes.
     * This is outgoing value from this widget.
     * @param newModelValue
     */
    /**
     * This method is called whenever model tied to the component changes.
     * This is outgoing value from this widget.
     * @param {?} newDateValue
     * @return {?}
     */
    NwfFilterCriterionDateComponent.prototype.onValueModelChange = /**
     * This method is called whenever model tied to the component changes.
     * This is outgoing value from this widget.
     * @param {?} newDateValue
     * @return {?}
     */
    function (newDateValue) {
        this.datetimeVisibleValue = new Date(newDateValue);
        this._onChange(newDateValue);
    };
    NwfFilterCriterionDateComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-grid-filter-criterion-date',
                    template: "\n    <select class=\"form-control mr-2\" required data-netapp-id=\"filter-widget-select-operator\" *ngIf=\"operator === 'lst'\"\n    (change)=\"onValueModelChange($event.target.value)\" [(ngModel)]=\"datetime\">\n        <option [selected]=\"!datetime\" value>{{'nwfjs:choose' | i18next}}</option>\n        <option [selected]=\"datetime == dateRange.id\" *ngFor=\"let dateRange of dateRangeList\" [value]=\"dateRange.id\">{{dateRange.label}}</option>\n    </select>\n\n    <div *ngIf=\"operator === 'between'\" (click)=\"$event.stopPropagation()\">\n        <nwf-datetime-range-picker [(ngModel)]=\"datetime\" (ngModelChange)=\"onValueModelChange($event)\"></nwf-datetime-range-picker>\n    </div>\n\n    <div *ngIf=\"operator === '>=' || operator === '<='\" (click)=\"$event.stopPropagation()\">\n        <ng-template #datetimePickerTemplate>\n            <nwf-datetime-picker [(ngModel)]=\"datetime\" (ngModelChange)=\"onValueModelChange($event)\"></nwf-datetime-picker>\n        </ng-template>\n        <button type=\"button\" class=\"btn btn-default d-flex align-items-center form-control\" [ngbPopover]=\"datetimePickerTemplate\" placement=\"bottom\" data-netapp-id=\"filter-widget-btn\">\n            <nwf-icon iconClass=\"icon-action-calendar\"></nwf-icon>\n            <label data-netapp-id=\"dateTimePicker-widget-label\">{{ datetimeVisibleValue | i18nextFormat: { format: 'datetime' } }}</label>\n        </button>\n    </div>\n    ",
                    providers: [{
                            provide: NG_VALUE_ACCESSOR,
                            useExisting: NwfFilterCriterionDateComponent,
                            multi: true,
                        }]
                }] }
    ];
    /** @nocollapse */
    NwfFilterCriterionDateComponent.ctorParameters = function () { return [
        { type: I18NextPipe }
    ]; };
    NwfFilterCriterionDateComponent.propDecorators = {
        operator: [{ type: Input }]
    };
    return NwfFilterCriterionDateComponent;
}());
export { NwfFilterCriterionDateComponent };
if (false) {
    /** @type {?} */
    NwfFilterCriterionDateComponent.prototype.operator;
    /** @type {?} */
    NwfFilterCriterionDateComponent.prototype.datetime;
    /** @type {?} */
    NwfFilterCriterionDateComponent.prototype.datetimeVisibleValue;
    /** @type {?} */
    NwfFilterCriterionDateComponent.prototype.dateRangeList;
    /**
     * @type {?}
     * @private
     */
    NwfFilterCriterionDateComponent.prototype._onChange;
}
//# sourceMappingURL=data:application/json;base64,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