/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, Input } from '@angular/core';
import { I18NextPipe } from 'angular-i18next';
import { DxDataGridComponent } from 'devextreme-angular';
var FooterComponent = /** @class */ (function () {
    function FooterComponent(i18NextPipe) {
        this.i18NextPipe = i18NextPipe;
        this.usePagination = true;
        this.isSelectionEnabled = false;
    }
    Object.defineProperty(FooterComponent.prototype, "title", {
        get: /**
         * @return {?}
         */
        function () {
            return this.i18NextPipe.transform(this.titleKey, { count: this.selectedRowsCount });
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(FooterComponent.prototype, "titlePlural", {
        get: /**
         * @return {?}
         */
        function () {
            return this.i18NextPipe.transform(this.titleKey, { count: 2 });
        },
        enumerable: true,
        configurable: true
    });
    /**
     * @return {?}
     */
    FooterComponent.prototype.ngOnInit = /**
     * @return {?}
     */
    function () {
        var _this = this;
        this.dataGrid.onContentReady.subscribe((/**
         * @param {?} data
         * @return {?}
         */
        function (data) {
            /** @type {?} */
            var gridInstance = data.component.instance();
            /** @type {?} */
            var pageIndex = gridInstance.pageIndex();
            _this.currentPage = pageIndex + 1;
            _this.limit = gridInstance.pageSize();
            _this.offset = _this.limit * pageIndex;
            _this.totalRecords = gridInstance.totalCount();
            _this.selectedRowsCount = gridInstance.getSelectedRowKeys().length;
        }));
        // we listen to onSelectionChanged event and update the selected rows count based on that.
        this.dataGrid.onSelectionChanged.subscribe((/**
         * @param {?} selectedItems
         * @return {?}
         */
        function (selectedItems) {
            _this.selectedRowsCount = selectedItems.selectedRowsData.length;
        }));
    };
    /**
     * @param {?} newPageNumber
     * @return {?}
     */
    FooterComponent.prototype.pageChangeHandler = /**
     * @param {?} newPageNumber
     * @return {?}
     */
    function (newPageNumber) {
        this.dataGrid.instance.pageIndex(newPageNumber - 1);
    };
    FooterComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-grid-footer',
                    template: "\n    <nav class=\"navbar navbar-expand-lg bg-light px-2 py-1\" *ngIf=\"totalRecords\">\n        <div class=\"w-100\" *ngIf=\"isSelectionEnabled\">\n            <div data-netapp-id=\"grid-footer-row-selected-count\" *ngIf=\"selectedRowsCount\">\n                {{'nwfjs:gridFooterSelectedCount' | i18next: { title: title, count: selectedRowsCount} }}\n            </div>\n        </div>\n        <div class=\"w-100\" [ngClass]=\"{ 'text-center': isSelectionEnabled }\">\n            <div class=\"paginator-page-info\" data-netapp-id=\"paginator-count-message\"\n            *ngIf=\"usePagination\">\n              {{'nwfjs:paginatorShowRecords' | i18next: { pageStart: offset + 1,\n                pageEnd: offset + limit > totalRecords ? totalRecords : offset + limit ,\n                totalRecords: totalRecords, title: titlePlural } }}\n            </div>\n        </div>\n        <div class=\"w-100 d-flex justify-content-end\">\n            <ng-content *ngIf=\"!usePagination\"></ng-content>\n            <nwf-grid-paginator *ngIf=\"usePagination && totalRecords > 0\" [maxSize]=\"5\"\n            [pageSize]=\"limit\" (pageChange)=\"pageChangeHandler($event)\"\n            [collectionSize]=\"totalRecords\" [(page)]=\"currentPage\" class=\"pagination\">\n            </nwf-grid-paginator>\n        </div>\n    </nav>\n    ",
                    providers: [],
                    styles: [".paginator-page-info { white-space: nowrap; }"]
                }] }
    ];
    /** @nocollapse */
    FooterComponent.ctorParameters = function () { return [
        { type: I18NextPipe }
    ]; };
    FooterComponent.propDecorators = {
        dataGrid: [{ type: Input }],
        titleKey: [{ type: Input }],
        usePagination: [{ type: Input }],
        isSelectionEnabled: [{ type: Input }]
    };
    return FooterComponent;
}());
export { FooterComponent };
if (false) {
    /** @type {?} */
    FooterComponent.prototype.dataGrid;
    /** @type {?} */
    FooterComponent.prototype.titleKey;
    /** @type {?} */
    FooterComponent.prototype.usePagination;
    /** @type {?} */
    FooterComponent.prototype.isSelectionEnabled;
    /** @type {?} */
    FooterComponent.prototype.currentPage;
    /** @type {?} */
    FooterComponent.prototype.limit;
    /** @type {?} */
    FooterComponent.prototype.offset;
    /** @type {?} */
    FooterComponent.prototype.totalRecords;
    /** @type {?} */
    FooterComponent.prototype.selectedRowsCount;
    /** @type {?} */
    FooterComponent.prototype.i18NextPipe;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZm9vdGVyLmNvbXBvbmVudC5qcyIsInNvdXJjZVJvb3QiOiJuZzovL0BuZXRhcHAvbndmanNfYW5ndWxhcl9jb21wb25lbnRzLyIsInNvdXJjZXMiOlsibGliL2dyaWQvZm9vdGVyL2Zvb3Rlci5jb21wb25lbnQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7OztBQUFBLE9BQU8sRUFBRSxTQUFTLEVBQUUsS0FBSyxFQUFVLE1BQU0sZUFBZSxDQUFDO0FBQ3pELE9BQU8sRUFBRSxXQUFXLEVBQUUsTUFBTSxpQkFBaUIsQ0FBQztBQUM5QyxPQUFPLEVBQUUsbUJBQW1CLEVBQUUsTUFBTSxvQkFBb0IsQ0FBQztBQUd6RDtJQTZDSSx5QkFBbUIsV0FBd0I7UUFBeEIsZ0JBQVcsR0FBWCxXQUFXLENBQWE7UUFWM0Isa0JBQWEsR0FBYSxJQUFJLENBQUM7UUFDL0IsdUJBQWtCLEdBQWEsS0FBSyxDQUFDO0lBU04sQ0FBQztJQUVoRCxzQkFBSSxrQ0FBSzs7OztRQUFUO1lBQ0ksT0FBTyxJQUFJLENBQUMsV0FBVyxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsUUFBUSxFQUFFLEVBQUUsS0FBSyxFQUFFLElBQUksQ0FBQyxpQkFBaUIsRUFBRSxDQUFDLENBQUM7UUFDeEYsQ0FBQzs7O09BQUE7SUFFRCxzQkFBSSx3Q0FBVzs7OztRQUFmO1lBQ0ksT0FBTyxJQUFJLENBQUMsV0FBVyxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsUUFBUSxFQUFFLEVBQUUsS0FBSyxFQUFFLENBQUMsRUFBRSxDQUFDLENBQUM7UUFDbkUsQ0FBQzs7O09BQUE7Ozs7SUFFTSxrQ0FBUTs7O0lBQWY7UUFBQSxpQkFlQztRQWRHLElBQUksQ0FBQyxRQUFRLENBQUMsY0FBYyxDQUFDLFNBQVM7Ozs7UUFBQyxVQUFDLElBQUk7O2dCQUNsQyxZQUFZLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxRQUFRLEVBQUU7O2dCQUN4QyxTQUFTLEdBQUcsWUFBWSxDQUFDLFNBQVMsRUFBRTtZQUMxQyxLQUFJLENBQUMsV0FBVyxHQUFHLFNBQVMsR0FBRyxDQUFDLENBQUM7WUFDakMsS0FBSSxDQUFDLEtBQUssR0FBRyxZQUFZLENBQUMsUUFBUSxFQUFFLENBQUM7WUFDckMsS0FBSSxDQUFDLE1BQU0sR0FBRyxLQUFJLENBQUMsS0FBSyxHQUFHLFNBQVMsQ0FBQztZQUNyQyxLQUFJLENBQUMsWUFBWSxHQUFHLFlBQVksQ0FBQyxVQUFVLEVBQUUsQ0FBQztZQUM5QyxLQUFJLENBQUMsaUJBQWlCLEdBQUcsWUFBWSxDQUFDLGtCQUFrQixFQUFFLENBQUMsTUFBTSxDQUFDO1FBQ3RFLENBQUMsRUFBQyxDQUFDO1FBRUgsMEZBQTBGO1FBQzFGLElBQUksQ0FBQyxRQUFRLENBQUMsa0JBQWtCLENBQUMsU0FBUzs7OztRQUFDLFVBQUMsYUFBYTtZQUNyRCxLQUFJLENBQUMsaUJBQWlCLEdBQUcsYUFBYSxDQUFDLGdCQUFnQixDQUFDLE1BQU0sQ0FBQztRQUNuRSxDQUFDLEVBQUMsQ0FBQztJQUNQLENBQUM7Ozs7O0lBRU0sMkNBQWlCOzs7O0lBQXhCLFVBQXlCLGFBQWE7UUFDbEMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxRQUFRLENBQUMsU0FBUyxDQUFDLGFBQWEsR0FBRyxDQUFDLENBQUMsQ0FBQztJQUN4RCxDQUFDOztnQkExRUosU0FBUyxTQUFDO29CQUNQLFFBQVEsRUFBRSxpQkFBaUI7b0JBSTNCLFFBQVEsRUFBRSxxekNBdUJUO29CQUNELFNBQVMsRUFBRSxFQUFFOzZCQTFCVCwrQ0FBK0M7aUJBMkJ0RDs7OztnQkFsQ1EsV0FBVzs7OzJCQXFDZixLQUFLOzJCQUNMLEtBQUs7Z0NBQ0wsS0FBSztxQ0FDTCxLQUFLOztJQXVDVixzQkFBQztDQUFBLEFBM0VELElBMkVDO1NBNUNZLGVBQWU7OztJQUV4QixtQ0FBOEM7O0lBQzlDLG1DQUFpQzs7SUFDakMsd0NBQStDOztJQUMvQyw2Q0FBcUQ7O0lBR3JELHNDQUEyQjs7SUFDM0IsZ0NBQXFCOztJQUNyQixpQ0FBc0I7O0lBQ3RCLHVDQUE0Qjs7SUFDNUIsNENBQWlDOztJQUVyQixzQ0FBK0IiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDb21wb25lbnQsIElucHV0LCBPbkluaXQgfSBmcm9tICdAYW5ndWxhci9jb3JlJztcbmltcG9ydCB7IEkxOE5leHRQaXBlIH0gZnJvbSAnYW5ndWxhci1pMThuZXh0JztcbmltcG9ydCB7IER4RGF0YUdyaWRDb21wb25lbnQgfSBmcm9tICdkZXZleHRyZW1lLWFuZ3VsYXInO1xuaW1wb3J0IHsgZmluZCB9IGZyb20gJ2xvZGFzaC1lcyc7XG5cbkBDb21wb25lbnQoe1xuICAgIHNlbGVjdG9yOiAnbndmLWdyaWQtZm9vdGVyJyxcbiAgICBzdHlsZXM6IFtcbiAgICAgICAgYC5wYWdpbmF0b3ItcGFnZS1pbmZvIHsgd2hpdGUtc3BhY2U6IG5vd3JhcDsgfWAsXG4gICAgXSxcbiAgICB0ZW1wbGF0ZTogYFxuICAgIDxuYXYgY2xhc3M9XCJuYXZiYXIgbmF2YmFyLWV4cGFuZC1sZyBiZy1saWdodCBweC0yIHB5LTFcIiAqbmdJZj1cInRvdGFsUmVjb3Jkc1wiPlxuICAgICAgICA8ZGl2IGNsYXNzPVwidy0xMDBcIiAqbmdJZj1cImlzU2VsZWN0aW9uRW5hYmxlZFwiPlxuICAgICAgICAgICAgPGRpdiBkYXRhLW5ldGFwcC1pZD1cImdyaWQtZm9vdGVyLXJvdy1zZWxlY3RlZC1jb3VudFwiICpuZ0lmPVwic2VsZWN0ZWRSb3dzQ291bnRcIj5cbiAgICAgICAgICAgICAgICB7eydud2ZqczpncmlkRm9vdGVyU2VsZWN0ZWRDb3VudCcgfCBpMThuZXh0OiB7IHRpdGxlOiB0aXRsZSwgY291bnQ6IHNlbGVjdGVkUm93c0NvdW50fSB9fVxuICAgICAgICAgICAgPC9kaXY+XG4gICAgICAgIDwvZGl2PlxuICAgICAgICA8ZGl2IGNsYXNzPVwidy0xMDBcIiBbbmdDbGFzc109XCJ7ICd0ZXh0LWNlbnRlcic6IGlzU2VsZWN0aW9uRW5hYmxlZCB9XCI+XG4gICAgICAgICAgICA8ZGl2IGNsYXNzPVwicGFnaW5hdG9yLXBhZ2UtaW5mb1wiIGRhdGEtbmV0YXBwLWlkPVwicGFnaW5hdG9yLWNvdW50LW1lc3NhZ2VcIlxuICAgICAgICAgICAgKm5nSWY9XCJ1c2VQYWdpbmF0aW9uXCI+XG4gICAgICAgICAgICAgIHt7J253ZmpzOnBhZ2luYXRvclNob3dSZWNvcmRzJyB8IGkxOG5leHQ6IHsgcGFnZVN0YXJ0OiBvZmZzZXQgKyAxLFxuICAgICAgICAgICAgICAgIHBhZ2VFbmQ6IG9mZnNldCArIGxpbWl0ID4gdG90YWxSZWNvcmRzID8gdG90YWxSZWNvcmRzIDogb2Zmc2V0ICsgbGltaXQgLFxuICAgICAgICAgICAgICAgIHRvdGFsUmVjb3JkczogdG90YWxSZWNvcmRzLCB0aXRsZTogdGl0bGVQbHVyYWwgfSB9fVxuICAgICAgICAgICAgPC9kaXY+XG4gICAgICAgIDwvZGl2PlxuICAgICAgICA8ZGl2IGNsYXNzPVwidy0xMDAgZC1mbGV4IGp1c3RpZnktY29udGVudC1lbmRcIj5cbiAgICAgICAgICAgIDxuZy1jb250ZW50ICpuZ0lmPVwiIXVzZVBhZ2luYXRpb25cIj48L25nLWNvbnRlbnQ+XG4gICAgICAgICAgICA8bndmLWdyaWQtcGFnaW5hdG9yICpuZ0lmPVwidXNlUGFnaW5hdGlvbiAmJiB0b3RhbFJlY29yZHMgPiAwXCIgW21heFNpemVdPVwiNVwiXG4gICAgICAgICAgICBbcGFnZVNpemVdPVwibGltaXRcIiAocGFnZUNoYW5nZSk9XCJwYWdlQ2hhbmdlSGFuZGxlcigkZXZlbnQpXCJcbiAgICAgICAgICAgIFtjb2xsZWN0aW9uU2l6ZV09XCJ0b3RhbFJlY29yZHNcIiBbKHBhZ2UpXT1cImN1cnJlbnRQYWdlXCIgY2xhc3M9XCJwYWdpbmF0aW9uXCI+XG4gICAgICAgICAgICA8L253Zi1ncmlkLXBhZ2luYXRvcj5cbiAgICAgICAgPC9kaXY+XG4gICAgPC9uYXY+XG4gICAgYCxcbiAgICBwcm92aWRlcnM6IFtdLFxufSlcbmV4cG9ydCBjbGFzcyBGb290ZXJDb21wb25lbnQgaW1wbGVtZW50cyBPbkluaXQge1xuXG4gICAgQElucHV0KCkgcHVibGljIGRhdGFHcmlkOiBEeERhdGFHcmlkQ29tcG9uZW50O1xuICAgIEBJbnB1dCgpIHB1YmxpYyB0aXRsZUtleTogc3RyaW5nO1xuICAgIEBJbnB1dCgpIHB1YmxpYyB1c2VQYWdpbmF0aW9uPzogYm9vbGVhbiA9IHRydWU7XG4gICAgQElucHV0KCkgcHVibGljIGlzU2VsZWN0aW9uRW5hYmxlZD86IGJvb2xlYW4gPSBmYWxzZTtcblxuICAgIC8vIHRoZXNlIGFyZSBpbnRlcm5hbCB0byB1aWItcGFnaW5hdGlvbiwgY3VycmVudFBhZ2UgaXMgYW4gbmdNb2RlbC5cbiAgICBwdWJsaWMgY3VycmVudFBhZ2U6IG51bWJlcjtcbiAgICBwdWJsaWMgbGltaXQ6IG51bWJlcjtcbiAgICBwdWJsaWMgb2Zmc2V0OiBudW1iZXI7XG4gICAgcHVibGljIHRvdGFsUmVjb3JkczogbnVtYmVyO1xuICAgIHB1YmxpYyBzZWxlY3RlZFJvd3NDb3VudDogbnVtYmVyO1xuXG4gICAgY29uc3RydWN0b3IocHVibGljIGkxOE5leHRQaXBlOiBJMThOZXh0UGlwZSkgeyB9XG5cbiAgICBnZXQgdGl0bGUoKSB7XG4gICAgICAgIHJldHVybiB0aGlzLmkxOE5leHRQaXBlLnRyYW5zZm9ybSh0aGlzLnRpdGxlS2V5LCB7IGNvdW50OiB0aGlzLnNlbGVjdGVkUm93c0NvdW50IH0pO1xuICAgIH1cblxuICAgIGdldCB0aXRsZVBsdXJhbCgpIHtcbiAgICAgICAgcmV0dXJuIHRoaXMuaTE4TmV4dFBpcGUudHJhbnNmb3JtKHRoaXMudGl0bGVLZXksIHsgY291bnQ6IDIgfSk7XG4gICAgfVxuXG4gICAgcHVibGljIG5nT25Jbml0KCkge1xuICAgICAgICB0aGlzLmRhdGFHcmlkLm9uQ29udGVudFJlYWR5LnN1YnNjcmliZSgoZGF0YSkgPT4ge1xuICAgICAgICAgICAgY29uc3QgZ3JpZEluc3RhbmNlID0gZGF0YS5jb21wb25lbnQuaW5zdGFuY2UoKTtcbiAgICAgICAgICAgIGNvbnN0IHBhZ2VJbmRleCA9IGdyaWRJbnN0YW5jZS5wYWdlSW5kZXgoKTtcbiAgICAgICAgICAgIHRoaXMuY3VycmVudFBhZ2UgPSBwYWdlSW5kZXggKyAxO1xuICAgICAgICAgICAgdGhpcy5saW1pdCA9IGdyaWRJbnN0YW5jZS5wYWdlU2l6ZSgpO1xuICAgICAgICAgICAgdGhpcy5vZmZzZXQgPSB0aGlzLmxpbWl0ICogcGFnZUluZGV4O1xuICAgICAgICAgICAgdGhpcy50b3RhbFJlY29yZHMgPSBncmlkSW5zdGFuY2UudG90YWxDb3VudCgpO1xuICAgICAgICAgICAgdGhpcy5zZWxlY3RlZFJvd3NDb3VudCA9IGdyaWRJbnN0YW5jZS5nZXRTZWxlY3RlZFJvd0tleXMoKS5sZW5ndGg7XG4gICAgICAgIH0pO1xuXG4gICAgICAgIC8vIHdlIGxpc3RlbiB0byBvblNlbGVjdGlvbkNoYW5nZWQgZXZlbnQgYW5kIHVwZGF0ZSB0aGUgc2VsZWN0ZWQgcm93cyBjb3VudCBiYXNlZCBvbiB0aGF0LlxuICAgICAgICB0aGlzLmRhdGFHcmlkLm9uU2VsZWN0aW9uQ2hhbmdlZC5zdWJzY3JpYmUoKHNlbGVjdGVkSXRlbXMpID0+IHtcbiAgICAgICAgICAgIHRoaXMuc2VsZWN0ZWRSb3dzQ291bnQgPSBzZWxlY3RlZEl0ZW1zLnNlbGVjdGVkUm93c0RhdGEubGVuZ3RoO1xuICAgICAgICB9KTtcbiAgICB9XG5cbiAgICBwdWJsaWMgcGFnZUNoYW5nZUhhbmRsZXIobmV3UGFnZU51bWJlcikge1xuICAgICAgICB0aGlzLmRhdGFHcmlkLmluc3RhbmNlLnBhZ2VJbmRleChuZXdQYWdlTnVtYmVyIC0gMSk7XG4gICAgfVxufVxuIl19