/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Injectable } from '@angular/core';
import DataGrid from 'devextreme/ui/data_grid';
import { merge } from 'lodash-es';
import { NwfColumnsChangingService } from '../components/grid-columns-changing.service';
var NwfGridOptionsService = /** @class */ (function () {
    function NwfGridOptionsService(columnsChangingService) {
        this.columnsChangingService = columnsChangingService;
    }
    /**
     * Set the global options on the DxDataGrid with defaults from nwfjs and passed in values
     * @param options for overriding the default options
     */
    /**
     * Set the global options on the DxDataGrid with defaults from nwfjs and passed in values
     * @param {?=} options for overriding the default options
     * @return {?}
     */
    NwfGridOptionsService.prototype.setGridDefaultOptions = /**
     * Set the global options on the DxDataGrid with defaults from nwfjs and passed in values
     * @param {?=} options for overriding the default options
     * @return {?}
     */
    function (options) {
        var _this = this;
        if (options === void 0) { options = {}; }
        DataGrid.defaultOptions(merge({
            device: { deviceType: 'desktop' },
            options: {
                // following options are standard for all nwfjs grids.
                allowColumnResizing: true,
                allowColumnReordering: true,
                showColumnLines: false,
                showRowLines: true,
                hoverStateEnabled: true,
                // this property synchronize the filter row, header filter, and filter builder.
                // The synchronized filter expression is stored in the filterValue option.
                filterSyncEnabled: true,
                // This disables right click context menus.
                onContextMenuPreparing: 
                // This disables right click context menus.
                /**
                 * @param {?} e
                 * @return {?}
                 */
                function (e) {
                    e.items = [];
                },
                onInitialized: (/**
                 * @param {?} e
                 * @return {?}
                 */
                function (e) {
                    // Wire onColumnsChanging event to service observable
                    e.component.option('onColumnsChanging', (/**
                     * @param {?} columnChangeEvent
                     * @return {?}
                     */
                    function (columnChangeEvent) {
                        _this.columnsChangingService.onColumnsChanging(columnChangeEvent);
                    }));
                }),
                pager: {
                    visible: false,
                },
                scrolling: {
                    useNative: false,
                },
            },
        }, options));
    };
    NwfGridOptionsService.decorators = [
        { type: Injectable }
    ];
    /** @nocollapse */
    NwfGridOptionsService.ctorParameters = function () { return [
        { type: NwfColumnsChangingService }
    ]; };
    return NwfGridOptionsService;
}());
export { NwfGridOptionsService };
if (false) {
    /**
     * @type {?}
     * @private
     */
    NwfGridOptionsService.prototype.columnsChangingService;
}
// Our custom 'lst' operation. This is used by filterWidget 'in the last' operator for datetime values.
/** @type {?} */
export var NwfFilterBuilderCustomOperations = [{
        name: 'lst',
        caption: 'Last',
        dataTypes: ['date', 'datetime'],
        hasValue: false,
        calculateFilterExpression: /**
         * @param {?} filterValue
         * @param {?} field
         * @return {?}
         */
        function (filterValue, field) {
            /** @type {?} */
            var newStartDate = new Date();
            /** @type {?} */
            var hours = new Date().getHours();
            switch (filterValue.toLowerCase()) {
                case 'last_1h':
                    newStartDate.setHours(hours - 1);
                    break;
                case 'last_24h':
                    newStartDate.setHours(hours - 24);
                    break;
                case 'last_72h':
                    newStartDate.setHours(hours - 72);
                    break;
                case 'last_7d':
                    newStartDate.setHours(hours - (7 * 24));
                    break;
                case 'last_30d':
                    newStartDate.setHours(hours - (30 * 24));
                    break;
                case 'last_390d':
                    newStartDate.setHours(hours - (390 * 24));
                    break;
            }
            return [[field.dataField, '>=', newStartDate], 'and', [field.dataField, '<=', new Date()]];
        },
    }];
//# sourceMappingURL=data:application/json;base64,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