/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { CommonModule } from '@angular/common';
import { NgModule } from '@angular/core';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { BrowserModule } from '@angular/platform-browser';
import { NgbModule } from '@ng-bootstrap/ng-bootstrap';
import { I18NextModule } from 'angular-i18next';
import { DxDataGridModule, DxScrollViewModule } from 'devextreme-angular';
import { NwfjsSharedComponentsModule } from '../components/nwfjs.shared-components.module';
import { NwfjsSharedPipesModule } from '../pipes/nwfjs.shared-pipes.module';
import { CellsComponent } from './cells/cells.component';
import { ColumnChooserComponent } from './column-chooser/column-chooser.component';
import { ColumnVisibilityComponent } from './column-visibility/column-visibility.component';
import { FilterCriterionRowComponent } from './filter/filter-criterion-row/filter-criterion-row.component';
import { NwfFilterCriterionDateComponent } from './filter/filter-date/filter-date.component';
// filter components
import { FilterMultiselectComponent } from './filter/filter-multiselect/filter-multiselect.component';
import { NwfFilterComponent } from './filter/filter.component';
import { FooterComponent } from './footer/footer.component';
import { NwfGridOptionsService } from './grid-options.service';
// grid components
import { NwfGridPaginatorComponent } from './paginator/paginator.component';
import { SearchComponent } from './search/search.component';
/** @type {?} */
var allComponents = [
    NwfGridPaginatorComponent, SearchComponent, ColumnChooserComponent, ColumnVisibilityComponent,
    NwfFilterComponent, FilterMultiselectComponent, FilterCriterionRowComponent,
    NwfFilterCriterionDateComponent, FooterComponent, CellsComponent,
];
var NwfGridModule = /** @class */ (function () {
    function NwfGridModule() {
    }
    NwfGridModule.decorators = [
        { type: NgModule, args: [{
                    imports: [
                        NgbModule,
                        CommonModule,
                        BrowserModule,
                        ReactiveFormsModule,
                        FormsModule,
                        I18NextModule,
                        NwfjsSharedComponentsModule,
                        DxDataGridModule,
                        DxScrollViewModule,
                        NwfjsSharedPipesModule,
                    ],
                    providers: [NwfGridOptionsService],
                    declarations: allComponents,
                    exports: allComponents,
                },] }
    ];
    /** @nocollapse */
    NwfGridModule.ctorParameters = function () { return []; };
    return NwfGridModule;
}());
export { NwfGridModule };
//# sourceMappingURL=data:application/json;base64,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