/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import * as tslib_1 from "tslib";
import { DxiDataGridColumn } from 'devextreme-angular/ui/nested/base/data-grid-column-dxi';
import { assign, get } from 'lodash-es';
var NwfGridSchemaProcessor = /** @class */ (function () {
    function NwfGridSchemaProcessor(schemaObject, schemaIdToDxColumn, customSchemaTypeToDxColumn) {
        /* First, we take the schemaIdToDxColumn and mix it over our own standard definition ,
            so we allow the user to provide us with custom schemaType to DxColumns,
            but we also handle a standard dataType provided by nwf, to make it easy.
            Note: this schemaTypeToDxColumn we have in this class is married to um's ftm.
        */
        if (schemaIdToDxColumn === void 0) { schemaIdToDxColumn = {}; }
        this.columns = [];
        this.filterableColumns = [];
        this.schemaTypeToDxColumn = {
            dateTime: NwfDateColumn,
            metric: NwfMetricColumn,
            number: NwfNumberColumn,
        };
        for (var columnId in schemaObject) {
            if (schemaObject.hasOwnProperty(columnId)) {
                /** @type {?} */
                var schemaProp = schemaObject[columnId];
                /** @type {?} */
                var hasMatchingId = columnId in schemaIdToDxColumn ? true : false;
                // updating schemaTypeToDxColumn mapping.
                this.schemaTypeToDxColumn = assign({}, this.schemaTypeToDxColumn, customSchemaTypeToDxColumn);
                /** @type {?} */
                var hasMatchingType = schemaProp.type in this.schemaTypeToDxColumn ? true : false;
                /** @type {?} */
                var dxColumnObject = void 0;
                /* First I see if the id has an associated columnId from the caller's schemaIdToDxColumn map.
                    This is because I want to allow the user to easily customize the cell based on the id.
                    for example, they tell me how to render a clusterObject. If it has a matching id, it wins over the nwf
                    mapped type.
                */
                if (hasMatchingId) {
                    dxColumnObject = new schemaIdToDxColumn[schemaProp.id](schemaProp);
                }
                else if (hasMatchingType) {
                    /* There is no matching Id, so I next try to create a column based on the schemaProp's type.
                        This is so I can best render a column's value based on the type (date, number) to a nice i18n default.
                    */
                    dxColumnObject = new this.schemaTypeToDxColumn[schemaProp.type](schemaProp);
                }
                else {
                    /* now I dont know */
                    dxColumnObject = new NwfSchemaColumn(schemaProp);
                }
                this.columns.push(dxColumnObject);
                // finding all filterable properties.
                if (schemaProp.filterable) {
                    this.filterableColumns.push(schemaProp);
                }
            }
        }
    }
    return NwfGridSchemaProcessor;
}());
export { NwfGridSchemaProcessor };
if (false) {
    /** @type {?} */
    NwfGridSchemaProcessor.prototype.columns;
    /** @type {?} */
    NwfGridSchemaProcessor.prototype.filterableColumns;
    /**
     * @type {?}
     * @private
     */
    NwfGridSchemaProcessor.prototype.schemaTypeToDxColumn;
}
var NwfSchemaColumn = /** @class */ (function (_super) {
    tslib_1.__extends(NwfSchemaColumn, _super);
    function NwfSchemaColumn(schemaProp) {
        var _this = _super.call(this) || this;
        _this.allowHeaderFiltering = false;
        _this.alignment = 'left';
        _this.visible = true;
        _this.allowFiltering = true;
        _this.allowSorting = true;
        _this.allowHiding = true;
        _this.allowReordering = true;
        _this.cellTemplate = 'nwfDefaultCellTemplate';
        _this.width = '100%';
        var id = schemaProp.id, label = schemaProp.label, type = schemaProp.type, options = schemaProp.options, visible = schemaProp.visible;
        // the dataField is how dx identifies the column, for us it is the same as the id, name is needed because that is how
        // we identify the column by name later to set options.
        _this.name = _this.dataField = id;
        // set a descriptive or friendly name for the column.
        _this.caption = label;
        // our type field is pretty close to the default dataTypes (which are just lowercased strings)
        // this can be improved if we have other types, but I bet it will work.
        _this.dataType = type.toLowerCase();
        // we allow search only for columns having 'resource','string', or associatedObjects dataType;
        _this.allowSearch = ['resource', 'string', 'associatedObjects'].indexOf(_this.dataType) !== -1;
        _this.allowFiltering = get(schemaProp, 'filterable', _this.allowFiltering);
        _this.allowSorting = get(schemaProp, 'sortable', _this.allowSorting);
        // editorOptions becomes options for 'enum-single' and 'enum-multiple' values.
        _this.editorOptions = options;
        _this.showInColumnChooser = visible;
        return _this;
    }
    return NwfSchemaColumn;
}(DxiDataGridColumn));
export { NwfSchemaColumn };
if (false) {
    /** @type {?} */
    NwfSchemaColumn.prototype.allowHeaderFiltering;
    /** @type {?} */
    NwfSchemaColumn.prototype.alignment;
    /** @type {?} */
    NwfSchemaColumn.prototype.visible;
    /** @type {?} */
    NwfSchemaColumn.prototype.allowFiltering;
    /** @type {?} */
    NwfSchemaColumn.prototype.allowSorting;
    /** @type {?} */
    NwfSchemaColumn.prototype.allowHiding;
    /** @type {?} */
    NwfSchemaColumn.prototype.allowReordering;
    /** @type {?} */
    NwfSchemaColumn.prototype.cellTemplate;
    /** @type {?} */
    NwfSchemaColumn.prototype.width;
    /** @type {?} */
    NwfSchemaColumn.prototype._optionPath;
}
var NwfNumberColumn = /** @class */ (function (_super) {
    tslib_1.__extends(NwfNumberColumn, _super);
    function NwfNumberColumn(schemaProp) {
        var _this = _super.call(this, schemaProp) || this;
        _this.cellTemplate = 'nwfNumberCellTemplate';
        return _this;
    }
    return NwfNumberColumn;
}(NwfSchemaColumn));
export { NwfNumberColumn };
if (false) {
    /** @type {?} */
    NwfNumberColumn.prototype.cellTemplate;
}
var NwfMetricColumn = /** @class */ (function (_super) {
    tslib_1.__extends(NwfMetricColumn, _super);
    function NwfMetricColumn(schemaProp) {
        var _this = _super.call(this, schemaProp) || this;
        _this.cellTemplate = 'nwfMetricCellTemplate';
        _this.unit = schemaProp.unit;
        return _this;
    }
    return NwfMetricColumn;
}(NwfSchemaColumn));
export { NwfMetricColumn };
if (false) {
    /** @type {?} */
    NwfMetricColumn.prototype.cellTemplate;
    /** @type {?} */
    NwfMetricColumn.prototype.unit;
}
var NwfDateColumn = /** @class */ (function (_super) {
    tslib_1.__extends(NwfDateColumn, _super);
    function NwfDateColumn(schemaProp) {
        var _this = _super.call(this, schemaProp) || this;
        _this.cellTemplate = 'nwfDateCellTemplate';
        return _this;
    }
    return NwfDateColumn;
}(NwfSchemaColumn));
export { NwfDateColumn };
if (false) {
    /** @type {?} */
    NwfDateColumn.prototype.cellTemplate;
}
var NwfStatusColumn = /** @class */ (function (_super) {
    tslib_1.__extends(NwfStatusColumn, _super);
    // creating a cell template based on UX requirements.
    function NwfStatusColumn(schemaProp) {
        var _this = _super.call(this, schemaProp) || this;
        _this.alignment = 'center';
        _this.width = 80;
        _this.cellTemplate = 'nwfStatusCellTemplate';
        _this.calculateSortValue = (/**
         * @param {?} __0
         * @return {?}
         */
        function (_a) {
            var status = _a.status;
            // we assign 'z' to critical so that it shows as first,last when sorted alphabettically
            // for possible status values.
            if (status.toLowerCase() === 'critical') {
                status = 'z'; // Critical are always displayed at the top
            }
            return status;
        });
        return _this;
    }
    return NwfStatusColumn;
}(NwfSchemaColumn));
export { NwfStatusColumn };
if (false) {
    /** @type {?} */
    NwfStatusColumn.prototype.alignment;
    /** @type {?} */
    NwfStatusColumn.prototype.width;
    /** @type {?} */
    NwfStatusColumn.prototype.cellTemplate;
    /** @type {?} */
    NwfStatusColumn.prototype.calculateSortValue;
}
//# sourceMappingURL=data:application/json;base64,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