/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, Input } from '@angular/core';
import { I18NextPipe } from 'angular-i18next';
import { DxDataGridComponent } from 'devextreme-angular';
import { Subject } from 'rxjs';
import { debounceTime, map } from 'rxjs/operators';
var SearchComponent = /** @class */ (function () {
    function SearchComponent(i18NextPipe) {
        this.i18NextPipe = i18NextPipe;
        this.keyUp = new Subject();
        this.value = '';
    }
    Object.defineProperty(SearchComponent.prototype, "type", {
        get: /**
         * @return {?}
         */
        function () {
            return this.i18NextPipe.transform(this.typeKey);
        },
        enumerable: true,
        configurable: true
    });
    /**
     * @return {?}
     */
    SearchComponent.prototype.ngOnInit = /**
     * @return {?}
     */
    function () {
        var _this = this;
        this.dataGrid.onContentReady.subscribe((/**
         * @param {?} data
         * @return {?}
         */
        function (data) {
            /** @type {?} */
            var gridInstance = data.component.instance();
            _this.value = gridInstance.state().searchText;
            _this.setSearchOnDxGrid();
        }));
        // on keyUp, we get the value of the event,
        // wait for 3s, and then set the search on dxGridInstance.
        this.keyUp
            .pipe(map((/**
         * @param {?} event
         * @return {?}
         */
        function (event) { return event.target.value; })))
            .pipe(debounceTime(300))
            .subscribe((/**
         * @return {?}
         */
        function () { return _this.setSearchOnDxGrid(); }));
    };
    /**
     * Method to reset the input to empty, and update dxGrid instance.
     */
    /**
     * Method to reset the input to empty, and update dxGrid instance.
     * @return {?}
     */
    SearchComponent.prototype.resetInput = /**
     * Method to reset the input to empty, and update dxGrid instance.
     * @return {?}
     */
    function () {
        this.value = '';
        this.setSearchOnDxGrid();
    };
    /**
     * @return {?}
     */
    SearchComponent.prototype.setSearchOnDxGrid = /**
     * @return {?}
     */
    function () {
        // apply search text.
        this.dataGrid.instance.searchByText(this.value);
    };
    SearchComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-grid-search',
                    template: "<div class=\"btn-group\">\n    <nwf-icon iconClass=\"icon-view-search\" class=\"text-secondary grid-search-icon\"></nwf-icon>\n    <input #searchInput class=\"form-control grid-search-input\" type=\"text\" (keyup)=\"keyUp.next($event)\" [placeholder]=\"'nwfjs:searchPlaceholderText' | i18next: { type: type }\"\n    [(ngModel)]=\"value\" data-netapp-id=\"angular-search-enter-input\" name=\"angular-grid-search-input\">\n    <div (click)=\"resetInput()\" *ngIf=\"value?.length\" class=\"grid-search-clear-icon\">\n    <nwf-icon iconClass=\"icon-action-close\" data-netapp-id=\"search-clear-input\"></nwf-icon>\n    </div>\n    </div>",
                    styles: ["::host{white-space:nowrap}.text-secondary{position:absolute;display:flex;align-items:center;left:10px;height:100%}.grid-search-input{text-indent:20px;width:250px}.grid-search-input::-ms-clear{display:none}.grid-search-clear-icon{z-index:100;position:absolute;display:flex;align-items:center;right:5px;top:8px;cursor:pointer}"]
                }] }
    ];
    /** @nocollapse */
    SearchComponent.ctorParameters = function () { return [
        { type: I18NextPipe }
    ]; };
    SearchComponent.propDecorators = {
        typeKey: [{ type: Input }],
        dataGrid: [{ type: Input }]
    };
    return SearchComponent;
}());
export { SearchComponent };
if (false) {
    /** @type {?} */
    SearchComponent.prototype.typeKey;
    /** @type {?} */
    SearchComponent.prototype.dataGrid;
    /** @type {?} */
    SearchComponent.prototype.keyUp;
    /** @type {?} */
    SearchComponent.prototype.placeholderText;
    /** @type {?} */
    SearchComponent.prototype.value;
    /**
     * @type {?}
     * @private
     */
    SearchComponent.prototype.i18NextPipe;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2VhcmNoLmNvbXBvbmVudC5qcyIsInNvdXJjZVJvb3QiOiJuZzovL0BuZXRhcHAvbndmanNfYW5ndWxhcl9jb21wb25lbnRzLyIsInNvdXJjZXMiOlsibGliL2dyaWQvc2VhcmNoL3NlYXJjaC5jb21wb25lbnQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7OztBQUFBLE9BQU8sRUFBRSxTQUFTLEVBQUUsS0FBSyxFQUFVLE1BQU0sZUFBZSxDQUFDO0FBQ3pELE9BQU8sRUFBRSxXQUFXLEVBQUUsTUFBTSxpQkFBaUIsQ0FBQztBQUM5QyxPQUFPLEVBQUUsbUJBQW1CLEVBQUUsTUFBTSxvQkFBb0IsQ0FBQztBQUN6RCxPQUFPLEVBQUUsT0FBTyxFQUFFLE1BQU0sTUFBTSxDQUFDO0FBQy9CLE9BQU8sRUFBRSxZQUFZLEVBQUUsR0FBRyxFQUFFLE1BQU0sZ0JBQWdCLENBQUM7QUFFbkQ7SUFvQkkseUJBQW9CLFdBQXdCO1FBQXhCLGdCQUFXLEdBQVgsV0FBVyxDQUFhO1FBSnJDLFVBQUssR0FBRyxJQUFJLE9BQU8sRUFBVSxDQUFDO1FBRTlCLFVBQUssR0FBVyxFQUFFLENBQUM7SUFFc0IsQ0FBQztJQUVqRCxzQkFBSSxpQ0FBSTs7OztRQUFSO1lBQ0ksT0FBTyxJQUFJLENBQUMsV0FBVyxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLENBQUM7UUFDcEQsQ0FBQzs7O09BQUE7Ozs7SUFFTSxrQ0FBUTs7O0lBQWY7UUFBQSxpQkFhQztRQVpHLElBQUksQ0FBQyxRQUFRLENBQUMsY0FBYyxDQUFDLFNBQVM7Ozs7UUFBQyxVQUFDLElBQUk7O2dCQUNsQyxZQUFZLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxRQUFRLEVBQUU7WUFDOUMsS0FBSSxDQUFDLEtBQUssR0FBRyxZQUFZLENBQUMsS0FBSyxFQUFFLENBQUMsVUFBVSxDQUFDO1lBQzdDLEtBQUksQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO1FBQzdCLENBQUMsRUFBQyxDQUFDO1FBRUgsMkNBQTJDO1FBQzNDLDBEQUEwRDtRQUMxRCxJQUFJLENBQUMsS0FBSzthQUNMLElBQUksQ0FBQyxHQUFHOzs7O1FBQUMsVUFBQyxLQUFVLElBQUssT0FBQSxLQUFLLENBQUMsTUFBTSxDQUFDLEtBQUssRUFBbEIsQ0FBa0IsRUFBQyxDQUFDO2FBQzdDLElBQUksQ0FBQyxZQUFZLENBQUMsR0FBRyxDQUFDLENBQUM7YUFDdkIsU0FBUzs7O1FBQUMsY0FBTSxPQUFBLEtBQUksQ0FBQyxpQkFBaUIsRUFBRSxFQUF4QixDQUF3QixFQUFDLENBQUM7SUFDbkQsQ0FBQztJQUVEOztPQUVHOzs7OztJQUNJLG9DQUFVOzs7O0lBQWpCO1FBQ0ksSUFBSSxDQUFDLEtBQUssR0FBRyxFQUFFLENBQUM7UUFDaEIsSUFBSSxDQUFDLGlCQUFpQixFQUFFLENBQUM7SUFDN0IsQ0FBQzs7OztJQUVNLDJDQUFpQjs7O0lBQXhCO1FBQ0kscUJBQXFCO1FBQ3JCLElBQUksQ0FBQyxRQUFRLENBQUMsUUFBUSxDQUFDLFlBQVksQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUM7SUFDcEQsQ0FBQzs7Z0JBcERKLFNBQVMsU0FBQztvQkFDUCxRQUFRLEVBQUUsaUJBQWlCO29CQUMzQixRQUFRLEVBQUUsMm5CQU9IOztpQkFFVjs7OztnQkFoQlEsV0FBVzs7OzBCQWtCZixLQUFLOzJCQUNMLEtBQUs7O0lBdUNWLHNCQUFDO0NBQUEsQUFyREQsSUFxREM7U0F6Q1ksZUFBZTs7O0lBQ3hCLGtDQUFnQzs7SUFDaEMsbUNBQThDOztJQUU5QyxnQ0FBcUM7O0lBQ3JDLDBDQUErQjs7SUFDL0IsZ0NBQTBCOzs7OztJQUVkLHNDQUFnQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IENvbXBvbmVudCwgSW5wdXQsIE9uSW5pdCB9IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xuaW1wb3J0IHsgSTE4TmV4dFBpcGUgfSBmcm9tICdhbmd1bGFyLWkxOG5leHQnO1xuaW1wb3J0IHsgRHhEYXRhR3JpZENvbXBvbmVudCB9IGZyb20gJ2RldmV4dHJlbWUtYW5ndWxhcic7XG5pbXBvcnQgeyBTdWJqZWN0IH0gZnJvbSAncnhqcyc7XG5pbXBvcnQgeyBkZWJvdW5jZVRpbWUsIG1hcCB9IGZyb20gJ3J4anMvb3BlcmF0b3JzJztcblxuQENvbXBvbmVudCh7XG4gICAgc2VsZWN0b3I6ICdud2YtZ3JpZC1zZWFyY2gnLFxuICAgIHRlbXBsYXRlOiBgPGRpdiBjbGFzcz1cImJ0bi1ncm91cFwiPlxuICAgIDxud2YtaWNvbiBpY29uQ2xhc3M9XCJpY29uLXZpZXctc2VhcmNoXCIgY2xhc3M9XCJ0ZXh0LXNlY29uZGFyeSBncmlkLXNlYXJjaC1pY29uXCI+PC9ud2YtaWNvbj5cbiAgICA8aW5wdXQgI3NlYXJjaElucHV0IGNsYXNzPVwiZm9ybS1jb250cm9sIGdyaWQtc2VhcmNoLWlucHV0XCIgdHlwZT1cInRleHRcIiAoa2V5dXApPVwia2V5VXAubmV4dCgkZXZlbnQpXCIgW3BsYWNlaG9sZGVyXT1cIidud2ZqczpzZWFyY2hQbGFjZWhvbGRlclRleHQnIHwgaTE4bmV4dDogeyB0eXBlOiB0eXBlIH1cIlxuICAgIFsobmdNb2RlbCldPVwidmFsdWVcIiBkYXRhLW5ldGFwcC1pZD1cImFuZ3VsYXItc2VhcmNoLWVudGVyLWlucHV0XCIgbmFtZT1cImFuZ3VsYXItZ3JpZC1zZWFyY2gtaW5wdXRcIj5cbiAgICA8ZGl2IChjbGljayk9XCJyZXNldElucHV0KClcIiAqbmdJZj1cInZhbHVlPy5sZW5ndGhcIiBjbGFzcz1cImdyaWQtc2VhcmNoLWNsZWFyLWljb25cIj5cbiAgICA8bndmLWljb24gaWNvbkNsYXNzPVwiaWNvbi1hY3Rpb24tY2xvc2VcIiBkYXRhLW5ldGFwcC1pZD1cInNlYXJjaC1jbGVhci1pbnB1dFwiPjwvbndmLWljb24+XG4gICAgPC9kaXY+XG4gICAgPC9kaXY+YCxcbiAgICBzdHlsZVVybHM6IFsnLi9zZWFyY2guY29tcG9uZW50LnNjc3MnXSxcbn0pXG5leHBvcnQgY2xhc3MgU2VhcmNoQ29tcG9uZW50IGltcGxlbWVudHMgT25Jbml0IHtcbiAgICBASW5wdXQoKSBwdWJsaWMgdHlwZUtleTogc3RyaW5nO1xuICAgIEBJbnB1dCgpIHB1YmxpYyBkYXRhR3JpZDogRHhEYXRhR3JpZENvbXBvbmVudDtcblxuICAgIHB1YmxpYyBrZXlVcCA9IG5ldyBTdWJqZWN0PHN0cmluZz4oKTtcbiAgICBwdWJsaWMgcGxhY2Vob2xkZXJUZXh0OiBzdHJpbmc7XG4gICAgcHVibGljIHZhbHVlOiBzdHJpbmcgPSAnJztcblxuICAgIGNvbnN0cnVjdG9yKHByaXZhdGUgaTE4TmV4dFBpcGU6IEkxOE5leHRQaXBlKSB7IH1cblxuICAgIGdldCB0eXBlKCkge1xuICAgICAgICByZXR1cm4gdGhpcy5pMThOZXh0UGlwZS50cmFuc2Zvcm0odGhpcy50eXBlS2V5KTtcbiAgICB9XG5cbiAgICBwdWJsaWMgbmdPbkluaXQoKSB7XG4gICAgICAgIHRoaXMuZGF0YUdyaWQub25Db250ZW50UmVhZHkuc3Vic2NyaWJlKChkYXRhKSA9PiB7XG4gICAgICAgICAgICBjb25zdCBncmlkSW5zdGFuY2UgPSBkYXRhLmNvbXBvbmVudC5pbnN0YW5jZSgpO1xuICAgICAgICAgICAgdGhpcy52YWx1ZSA9IGdyaWRJbnN0YW5jZS5zdGF0ZSgpLnNlYXJjaFRleHQ7XG4gICAgICAgICAgICB0aGlzLnNldFNlYXJjaE9uRHhHcmlkKCk7XG4gICAgICAgIH0pO1xuXG4gICAgICAgIC8vIG9uIGtleVVwLCB3ZSBnZXQgdGhlIHZhbHVlIG9mIHRoZSBldmVudCxcbiAgICAgICAgLy8gd2FpdCBmb3IgM3MsIGFuZCB0aGVuIHNldCB0aGUgc2VhcmNoIG9uIGR4R3JpZEluc3RhbmNlLlxuICAgICAgICB0aGlzLmtleVVwXG4gICAgICAgICAgICAucGlwZShtYXAoKGV2ZW50OiBhbnkpID0+IGV2ZW50LnRhcmdldC52YWx1ZSkpXG4gICAgICAgICAgICAucGlwZShkZWJvdW5jZVRpbWUoMzAwKSlcbiAgICAgICAgICAgIC5zdWJzY3JpYmUoKCkgPT4gdGhpcy5zZXRTZWFyY2hPbkR4R3JpZCgpKTtcbiAgICB9XG5cbiAgICAvKipcbiAgICAgKiBNZXRob2QgdG8gcmVzZXQgdGhlIGlucHV0IHRvIGVtcHR5LCBhbmQgdXBkYXRlIGR4R3JpZCBpbnN0YW5jZS5cbiAgICAgKi9cbiAgICBwdWJsaWMgcmVzZXRJbnB1dCgpIHtcbiAgICAgICAgdGhpcy52YWx1ZSA9ICcnO1xuICAgICAgICB0aGlzLnNldFNlYXJjaE9uRHhHcmlkKCk7XG4gICAgfVxuXG4gICAgcHVibGljIHNldFNlYXJjaE9uRHhHcmlkKCkge1xuICAgICAgICAvLyBhcHBseSBzZWFyY2ggdGV4dC5cbiAgICAgICAgdGhpcy5kYXRhR3JpZC5pbnN0YW5jZS5zZWFyY2hCeVRleHQodGhpcy52YWx1ZSk7XG4gICAgfVxufVxuIl19