/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Pipe } from '@angular/core';
import { I18NextFormatPipe } from 'angular-i18next';
var NwfRoundUnit = /** @class */ (function () {
    function NwfRoundUnit(i18NextPipeFormatPipe) {
        this.i18NextPipeFormatPipe = i18NextPipeFormatPipe;
        this.units = ['bytes', 'KB', 'MB', 'GB', 'TB', 'PB'];
    }
    /**
     * @param {?} value
     * @param {?} config
     * @return {?}
     */
    NwfRoundUnit.prototype.transform = /**
     * @param {?} value
     * @param {?} config
     * @return {?}
     */
    function (value, config) {
        var unit = config.unit, statType = config.statType;
        /** @type {?} */
        var isPercent = (unit === '%');
        if (this.units.indexOf(unit) >= 0) {
            var _a = this.getReadable(value, unit), newValue = _a.value, newUnit = _a.unit;
            value = newValue;
            unit = newUnit;
        }
        /** @type {?} */
        var text = this.round(value, isPercent, statType);
        if (text) { // parsing through number locale if value is truthy.if (value !== null) {
            if (!isNaN(parseFloat(text))) {
                // Use i18next formatting for number
                text = this.i18NextPipeFormatPipe.transform(parseFloat(text), { format: 'number' });
            }
            if (unit) { // add unit only if unit is not undefined and not null
                text += (isPercent ? '' : ' ') + unit;
            }
            return text;
        }
        else {
            return 'N/A';
        }
    };
    /**
     * @param {?} value
     * @param {?=} isPercent
     * @param {?=} statType
     * @return {?}
     */
    NwfRoundUnit.prototype.round = /**
     * @param {?} value
     * @param {?=} isPercent
     * @param {?=} statType
     * @return {?}
     */
    function (value, isPercent, statType) {
        if (isPercent === void 0) { isPercent = false; }
        if (statType === void 0) { statType = ''; }
        if (value === null) { //  return null if null
            return null;
        }
        else if (value === 0) {
            return '0';
        }
        if (isPercent) {
            if (value < 1) { // "<1" if < 1
                return '< 1';
            }
            else { // Whole number otherwise
                return parseFloat(value).toFixed();
            }
        }
        else {
            if (value < 1) {
                switch (statType) {
                    case 'latency':
                        return parseFloat(value).toFixed(3); // 3 decimal points between 0 and 1 for Latency
                    default:
                        return '< 1'; // "<1" if < 1 for everything else
                }
            }
            else if (value < 10 && value >= 1) { // 2 decimal points between 1 and 10
                return parseFloat(value).toFixed(2);
            }
            else if (value < 100 && value >= 10) { // 1 decimal point between 10 and  100
                return parseFloat(value).toFixed(1);
            }
            else if (value >= 100) { // Whole number if greater than 100
                return parseFloat(value).toFixed();
            }
            else {
                return value;
            }
        }
    };
    /**
     * @param {?} value
     * @param {?} unit
     * @return {?}
     */
    NwfRoundUnit.prototype.getReadable = /**
     * @param {?} value
     * @param {?} unit
     * @return {?}
     */
    function (value, unit) {
        /** @type {?} */
        var idx = this.units.indexOf(unit);
        /** @type {?} */
        var result;
        // we always need a value handling undefined case
        while (value && !(value >= 1 && value < 1024)) {
            if (value < 1) {
                // The current unit is too big
                if (idx > 0) {
                    // Decrease the unit by one level
                    value *= 1024.0;
                    idx -= 1;
                }
                else {
                    // The current unit is KB, there is no smaller unit, we have the result
                    result = { value: value, unit: this.units[idx] };
                    break;
                }
            }
            if (value >= 1024) {
                // The current unit is too small
                if (idx < this.units.length - 1) {
                    // Increase the unit by one level
                    value /= 1024.0;
                    idx += 1;
                }
                else {
                    // The current unit is PB, there is no bigger unit, we have the result
                    result = { value: value, unit: this.units[idx] };
                    break;
                }
            }
        }
        if (!result) {
            // The give arguments are proper value and unit
            result = { value: value, unit: this.units[idx] };
        }
        return result;
    };
    NwfRoundUnit.decorators = [
        { type: Pipe, args: [{ name: 'NwfRoundUnit' },] }
    ];
    /** @nocollapse */
    NwfRoundUnit.ctorParameters = function () { return [
        { type: I18NextFormatPipe }
    ]; };
    return NwfRoundUnit;
}());
export { NwfRoundUnit };
if (false) {
    /** @type {?} */
    NwfRoundUnit.prototype.units;
    /**
     * @type {?}
     * @private
     */
    NwfRoundUnit.prototype.i18NextPipeFormatPipe;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibndmanMuc2hhcmVkLXBpcGVzLmpzIiwic291cmNlUm9vdCI6Im5nOi8vQG5ldGFwcC9ud2Zqc19hbmd1bGFyX2NvbXBvbmVudHMvIiwic291cmNlcyI6WyJsaWIvcGlwZXMvbndmanMuc2hhcmVkLXBpcGVzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7QUFBQSxPQUFPLEVBQUUsSUFBSSxFQUFpQixNQUFNLGVBQWUsQ0FBQztBQUNwRCxPQUFPLEVBQUUsaUJBQWlCLEVBQUUsTUFBTSxpQkFBaUIsQ0FBQztBQUVwRDtJQUtJLHNCQUFvQixxQkFBd0M7UUFBeEMsMEJBQXFCLEdBQXJCLHFCQUFxQixDQUFtQjtRQUZyRCxVQUFLLEdBQUcsQ0FBQyxPQUFPLEVBQUUsSUFBSSxFQUFFLElBQUksRUFBRSxJQUFJLEVBQUUsSUFBSSxFQUFFLElBQUksQ0FBQyxDQUFDO0lBRVMsQ0FBQzs7Ozs7O0lBRTFELGdDQUFTOzs7OztJQUFoQixVQUFpQixLQUFLLEVBQUUsTUFBTTtRQUNwQixJQUFBLGtCQUFJLEVBQUUsMEJBQVE7O1lBRWQsU0FBUyxHQUFHLENBQUMsSUFBSSxLQUFLLEdBQUcsQ0FBQztRQUVoQyxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsRUFBRTtZQUN6QixJQUFBLGtDQUFrRSxFQUFoRSxtQkFBZSxFQUFFLGlCQUErQztZQUN4RSxLQUFLLEdBQUcsUUFBUSxDQUFDO1lBQ2pCLElBQUksR0FBRyxPQUFPLENBQUM7U0FDbEI7O1lBRUcsSUFBSSxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsS0FBSyxFQUFFLFNBQVMsRUFBRSxRQUFRLENBQUM7UUFDakQsSUFBSSxJQUFJLEVBQUUsRUFBRSx5RUFBeUU7WUFDakYsSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUMsRUFBRTtnQkFDMUIsb0NBQW9DO2dCQUNwQyxJQUFJLEdBQUcsSUFBSSxDQUFDLHFCQUFxQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLEVBQUUsRUFBRSxNQUFNLEVBQUUsUUFBUSxFQUFFLENBQUMsQ0FBQzthQUN2RjtZQUNELElBQUksSUFBSSxFQUFFLEVBQUUsc0RBQXNEO2dCQUM5RCxJQUFJLElBQUksQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsR0FBRyxDQUFDLEdBQUcsSUFBSSxDQUFDO2FBQ3pDO1lBQ0QsT0FBTyxJQUFJLENBQUM7U0FDZjthQUFNO1lBQ0gsT0FBTyxLQUFLLENBQUM7U0FDaEI7SUFDTCxDQUFDOzs7Ozs7O0lBRU0sNEJBQUs7Ozs7OztJQUFaLFVBQWEsS0FBSyxFQUFFLFNBQTBCLEVBQUUsUUFBcUI7UUFBakQsMEJBQUEsRUFBQSxpQkFBMEI7UUFBRSx5QkFBQSxFQUFBLGFBQXFCO1FBQ2pFLElBQUksS0FBSyxLQUFLLElBQUksRUFBRSxFQUFJLHVCQUF1QjtZQUMzQyxPQUFPLElBQUksQ0FBQztTQUNmO2FBQU0sSUFBSSxLQUFLLEtBQUssQ0FBQyxFQUFFO1lBQ3BCLE9BQU8sR0FBRyxDQUFDO1NBQ2Q7UUFFRCxJQUFJLFNBQVMsRUFBRTtZQUNYLElBQUksS0FBSyxHQUFHLENBQUMsRUFBRSxFQUFFLGNBQWM7Z0JBQzNCLE9BQU8sS0FBSyxDQUFDO2FBQ2hCO2lCQUFNLEVBQUsseUJBQXlCO2dCQUNqQyxPQUFPLFVBQVUsQ0FBQyxLQUFLLENBQUMsQ0FBQyxPQUFPLEVBQUUsQ0FBQzthQUN0QztTQUNKO2FBQU07WUFDSCxJQUFJLEtBQUssR0FBRyxDQUFDLEVBQUU7Z0JBQ1gsUUFBUSxRQUFRLEVBQUU7b0JBQ2QsS0FBSyxTQUFTO3dCQUNWLE9BQU8sVUFBVSxDQUFDLEtBQUssQ0FBQyxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFHLCtDQUErQztvQkFDMUY7d0JBQ0ksT0FBTyxLQUFLLENBQUMsQ0FBSyxrQ0FBa0M7aUJBQzNEO2FBQ0o7aUJBQU0sSUFBSSxLQUFLLEdBQUcsRUFBRSxJQUFJLEtBQUssSUFBSSxDQUFDLEVBQUUsRUFBSyxvQ0FBb0M7Z0JBQzFFLE9BQU8sVUFBVSxDQUFDLEtBQUssQ0FBQyxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsQ0FBQzthQUN2QztpQkFBTSxJQUFJLEtBQUssR0FBRyxHQUFHLElBQUksS0FBSyxJQUFJLEVBQUUsRUFBRSxFQUFHLHNDQUFzQztnQkFDNUUsT0FBTyxVQUFVLENBQUMsS0FBSyxDQUFDLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxDQUFDO2FBQ3ZDO2lCQUFNLElBQUksS0FBSyxJQUFJLEdBQUcsRUFBRSxFQUFJLG1DQUFtQztnQkFDNUQsT0FBTyxVQUFVLENBQUMsS0FBSyxDQUFDLENBQUMsT0FBTyxFQUFFLENBQUM7YUFDdEM7aUJBQU07Z0JBQ0gsT0FBTyxLQUFLLENBQUM7YUFDaEI7U0FDSjtJQUNMLENBQUM7Ozs7OztJQUVNLGtDQUFXOzs7OztJQUFsQixVQUFtQixLQUFLLEVBQUUsSUFBSTs7WUFDdEIsR0FBRyxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQzs7WUFDOUIsTUFBdUM7UUFDM0MsaURBQWlEO1FBQ2pELE9BQU8sS0FBSyxJQUFJLENBQUMsQ0FBQyxLQUFLLElBQUksQ0FBQyxJQUFJLEtBQUssR0FBRyxJQUFJLENBQUMsRUFBRTtZQUMzQyxJQUFJLEtBQUssR0FBRyxDQUFDLEVBQUU7Z0JBQ1gsOEJBQThCO2dCQUM5QixJQUFJLEdBQUcsR0FBRyxDQUFDLEVBQUU7b0JBQ1QsaUNBQWlDO29CQUNqQyxLQUFLLElBQUksTUFBTSxDQUFDO29CQUNoQixHQUFHLElBQUksQ0FBQyxDQUFDO2lCQUNaO3FCQUFNO29CQUNILHVFQUF1RTtvQkFDdkUsTUFBTSxHQUFHLEVBQUUsS0FBSyxPQUFBLEVBQUUsSUFBSSxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsR0FBRyxDQUFDLEVBQUUsQ0FBQztvQkFDMUMsTUFBTTtpQkFDVDthQUNKO1lBRUQsSUFBSSxLQUFLLElBQUksSUFBSSxFQUFFO2dCQUNmLGdDQUFnQztnQkFDaEMsSUFBSSxHQUFHLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxNQUFNLEdBQUcsQ0FBQyxFQUFFO29CQUM3QixpQ0FBaUM7b0JBQ2pDLEtBQUssSUFBSSxNQUFNLENBQUM7b0JBQ2hCLEdBQUcsSUFBSSxDQUFDLENBQUM7aUJBQ1o7cUJBQU07b0JBQ0gsc0VBQXNFO29CQUN0RSxNQUFNLEdBQUcsRUFBRSxLQUFLLE9BQUEsRUFBRSxJQUFJLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUMsRUFBRSxDQUFDO29CQUMxQyxNQUFNO2lCQUNUO2FBQ0o7U0FDSjtRQUVELElBQUksQ0FBQyxNQUFNLEVBQUU7WUFDVCwrQ0FBK0M7WUFDL0MsTUFBTSxHQUFHLEVBQUUsS0FBSyxPQUFBLEVBQUUsSUFBSSxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsR0FBRyxDQUFDLEVBQUUsQ0FBQztTQUM3QztRQUVELE9BQU8sTUFBTSxDQUFDO0lBQ2xCLENBQUM7O2dCQXhHSixJQUFJLFNBQUMsRUFBRSxJQUFJLEVBQUUsY0FBYyxFQUFFOzs7O2dCQUZyQixpQkFBaUI7O0lBMkcxQixtQkFBQztDQUFBLEFBekdELElBeUdDO1NBeEdZLFlBQVk7OztJQUVyQiw2QkFBdUQ7Ozs7O0lBRTNDLDZDQUFnRCIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IFBpcGUsIFBpcGVUcmFuc2Zvcm0gfSBmcm9tICdAYW5ndWxhci9jb3JlJztcbmltcG9ydCB7IEkxOE5leHRGb3JtYXRQaXBlIH0gZnJvbSAnYW5ndWxhci1pMThuZXh0JztcblxuQFBpcGUoeyBuYW1lOiAnTndmUm91bmRVbml0JyB9KVxuZXhwb3J0IGNsYXNzIE53ZlJvdW5kVW5pdCBpbXBsZW1lbnRzIFBpcGVUcmFuc2Zvcm0ge1xuXG4gICAgcHVibGljIHVuaXRzID0gWydieXRlcycsICdLQicsICdNQicsICdHQicsICdUQicsICdQQiddO1xuXG4gICAgY29uc3RydWN0b3IocHJpdmF0ZSBpMThOZXh0UGlwZUZvcm1hdFBpcGU6IEkxOE5leHRGb3JtYXRQaXBlKSB7IH1cblxuICAgIHB1YmxpYyB0cmFuc2Zvcm0odmFsdWUsIGNvbmZpZykge1xuICAgICAgICBsZXQgeyB1bml0LCBzdGF0VHlwZSB9ID0gY29uZmlnO1xuXG4gICAgICAgIGNvbnN0IGlzUGVyY2VudCA9ICh1bml0ID09PSAnJScpO1xuXG4gICAgICAgIGlmICh0aGlzLnVuaXRzLmluZGV4T2YodW5pdCkgPj0gMCkge1xuICAgICAgICAgICAgY29uc3QgeyB2YWx1ZTogbmV3VmFsdWUsIHVuaXQ6IG5ld1VuaXQgfSA9IHRoaXMuZ2V0UmVhZGFibGUodmFsdWUsIHVuaXQpO1xuICAgICAgICAgICAgdmFsdWUgPSBuZXdWYWx1ZTtcbiAgICAgICAgICAgIHVuaXQgPSBuZXdVbml0O1xuICAgICAgICB9XG5cbiAgICAgICAgbGV0IHRleHQgPSB0aGlzLnJvdW5kKHZhbHVlLCBpc1BlcmNlbnQsIHN0YXRUeXBlKTtcbiAgICAgICAgaWYgKHRleHQpIHsgLy8gcGFyc2luZyB0aHJvdWdoIG51bWJlciBsb2NhbGUgaWYgdmFsdWUgaXMgdHJ1dGh5LmlmICh2YWx1ZSAhPT0gbnVsbCkge1xuICAgICAgICAgICAgaWYgKCFpc05hTihwYXJzZUZsb2F0KHRleHQpKSkge1xuICAgICAgICAgICAgICAgIC8vIFVzZSBpMThuZXh0IGZvcm1hdHRpbmcgZm9yIG51bWJlclxuICAgICAgICAgICAgICAgIHRleHQgPSB0aGlzLmkxOE5leHRQaXBlRm9ybWF0UGlwZS50cmFuc2Zvcm0ocGFyc2VGbG9hdCh0ZXh0KSwgeyBmb3JtYXQ6ICdudW1iZXInIH0pO1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgaWYgKHVuaXQpIHsgLy8gYWRkIHVuaXQgb25seSBpZiB1bml0IGlzIG5vdCB1bmRlZmluZWQgYW5kIG5vdCBudWxsXG4gICAgICAgICAgICAgICAgdGV4dCArPSAoaXNQZXJjZW50ID8gJycgOiAnICcpICsgdW5pdDtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIHJldHVybiB0ZXh0O1xuICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgcmV0dXJuICdOL0EnO1xuICAgICAgICB9XG4gICAgfVxuXG4gICAgcHVibGljIHJvdW5kKHZhbHVlLCBpc1BlcmNlbnQ6IGJvb2xlYW4gPSBmYWxzZSwgc3RhdFR5cGU6IHN0cmluZyA9ICcnKSB7XG4gICAgICAgIGlmICh2YWx1ZSA9PT0gbnVsbCkgeyAgIC8vICByZXR1cm4gbnVsbCBpZiBudWxsXG4gICAgICAgICAgICByZXR1cm4gbnVsbDtcbiAgICAgICAgfSBlbHNlIGlmICh2YWx1ZSA9PT0gMCkge1xuICAgICAgICAgICAgcmV0dXJuICcwJztcbiAgICAgICAgfVxuXG4gICAgICAgIGlmIChpc1BlcmNlbnQpIHtcbiAgICAgICAgICAgIGlmICh2YWx1ZSA8IDEpIHsgLy8gXCI8MVwiIGlmIDwgMVxuICAgICAgICAgICAgICAgIHJldHVybiAnPCAxJztcbiAgICAgICAgICAgIH0gZWxzZSB7ICAgIC8vIFdob2xlIG51bWJlciBvdGhlcndpc2VcbiAgICAgICAgICAgICAgICByZXR1cm4gcGFyc2VGbG9hdCh2YWx1ZSkudG9GaXhlZCgpO1xuICAgICAgICAgICAgfVxuICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgaWYgKHZhbHVlIDwgMSkge1xuICAgICAgICAgICAgICAgIHN3aXRjaCAoc3RhdFR5cGUpIHtcbiAgICAgICAgICAgICAgICAgICAgY2FzZSAnbGF0ZW5jeSc6XG4gICAgICAgICAgICAgICAgICAgICAgICByZXR1cm4gcGFyc2VGbG9hdCh2YWx1ZSkudG9GaXhlZCgzKTsgICAvLyAzIGRlY2ltYWwgcG9pbnRzIGJldHdlZW4gMCBhbmQgMSBmb3IgTGF0ZW5jeVxuICAgICAgICAgICAgICAgICAgICBkZWZhdWx0OlxuICAgICAgICAgICAgICAgICAgICAgICAgcmV0dXJuICc8IDEnOyAgICAgLy8gXCI8MVwiIGlmIDwgMSBmb3IgZXZlcnl0aGluZyBlbHNlXG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfSBlbHNlIGlmICh2YWx1ZSA8IDEwICYmIHZhbHVlID49IDEpIHsgICAgLy8gMiBkZWNpbWFsIHBvaW50cyBiZXR3ZWVuIDEgYW5kIDEwXG4gICAgICAgICAgICAgICAgcmV0dXJuIHBhcnNlRmxvYXQodmFsdWUpLnRvRml4ZWQoMik7XG4gICAgICAgICAgICB9IGVsc2UgaWYgKHZhbHVlIDwgMTAwICYmIHZhbHVlID49IDEwKSB7ICAvLyAxIGRlY2ltYWwgcG9pbnQgYmV0d2VlbiAxMCBhbmQgIDEwMFxuICAgICAgICAgICAgICAgIHJldHVybiBwYXJzZUZsb2F0KHZhbHVlKS50b0ZpeGVkKDEpO1xuICAgICAgICAgICAgfSBlbHNlIGlmICh2YWx1ZSA+PSAxMDApIHsgICAvLyBXaG9sZSBudW1iZXIgaWYgZ3JlYXRlciB0aGFuIDEwMFxuICAgICAgICAgICAgICAgIHJldHVybiBwYXJzZUZsb2F0KHZhbHVlKS50b0ZpeGVkKCk7XG4gICAgICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgICAgIHJldHVybiB2YWx1ZTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgIH1cblxuICAgIHB1YmxpYyBnZXRSZWFkYWJsZSh2YWx1ZSwgdW5pdCk6IHsgdmFsdWU6IG51bWJlciwgdW5pdDogc3RyaW5nIH0ge1xuICAgICAgICBsZXQgaWR4ID0gdGhpcy51bml0cy5pbmRleE9mKHVuaXQpO1xuICAgICAgICBsZXQgcmVzdWx0OiB7IHZhbHVlOiBudW1iZXIsIHVuaXQ6IHN0cmluZyB9O1xuICAgICAgICAvLyB3ZSBhbHdheXMgbmVlZCBhIHZhbHVlIGhhbmRsaW5nIHVuZGVmaW5lZCBjYXNlXG4gICAgICAgIHdoaWxlICh2YWx1ZSAmJiAhKHZhbHVlID49IDEgJiYgdmFsdWUgPCAxMDI0KSkge1xuICAgICAgICAgICAgaWYgKHZhbHVlIDwgMSkge1xuICAgICAgICAgICAgICAgIC8vIFRoZSBjdXJyZW50IHVuaXQgaXMgdG9vIGJpZ1xuICAgICAgICAgICAgICAgIGlmIChpZHggPiAwKSB7XG4gICAgICAgICAgICAgICAgICAgIC8vIERlY3JlYXNlIHRoZSB1bml0IGJ5IG9uZSBsZXZlbFxuICAgICAgICAgICAgICAgICAgICB2YWx1ZSAqPSAxMDI0LjA7XG4gICAgICAgICAgICAgICAgICAgIGlkeCAtPSAxO1xuICAgICAgICAgICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICAgICAgICAgIC8vIFRoZSBjdXJyZW50IHVuaXQgaXMgS0IsIHRoZXJlIGlzIG5vIHNtYWxsZXIgdW5pdCwgd2UgaGF2ZSB0aGUgcmVzdWx0XG4gICAgICAgICAgICAgICAgICAgIHJlc3VsdCA9IHsgdmFsdWUsIHVuaXQ6IHRoaXMudW5pdHNbaWR4XSB9O1xuICAgICAgICAgICAgICAgICAgICBicmVhaztcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9XG5cbiAgICAgICAgICAgIGlmICh2YWx1ZSA+PSAxMDI0KSB7XG4gICAgICAgICAgICAgICAgLy8gVGhlIGN1cnJlbnQgdW5pdCBpcyB0b28gc21hbGxcbiAgICAgICAgICAgICAgICBpZiAoaWR4IDwgdGhpcy51bml0cy5sZW5ndGggLSAxKSB7XG4gICAgICAgICAgICAgICAgICAgIC8vIEluY3JlYXNlIHRoZSB1bml0IGJ5IG9uZSBsZXZlbFxuICAgICAgICAgICAgICAgICAgICB2YWx1ZSAvPSAxMDI0LjA7XG4gICAgICAgICAgICAgICAgICAgIGlkeCArPSAxO1xuICAgICAgICAgICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICAgICAgICAgIC8vIFRoZSBjdXJyZW50IHVuaXQgaXMgUEIsIHRoZXJlIGlzIG5vIGJpZ2dlciB1bml0LCB3ZSBoYXZlIHRoZSByZXN1bHRcbiAgICAgICAgICAgICAgICAgICAgcmVzdWx0ID0geyB2YWx1ZSwgdW5pdDogdGhpcy51bml0c1tpZHhdIH07XG4gICAgICAgICAgICAgICAgICAgIGJyZWFrO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH1cbiAgICAgICAgfVxuXG4gICAgICAgIGlmICghcmVzdWx0KSB7XG4gICAgICAgICAgICAvLyBUaGUgZ2l2ZSBhcmd1bWVudHMgYXJlIHByb3BlciB2YWx1ZSBhbmQgdW5pdFxuICAgICAgICAgICAgcmVzdWx0ID0geyB2YWx1ZSwgdW5pdDogdGhpcy51bml0c1tpZHhdIH07XG4gICAgICAgIH1cblxuICAgICAgICByZXR1cm4gcmVzdWx0O1xuICAgIH1cbn1cbiJdfQ==