/**
 * Sets the date-time range as provided by the user. The widget has 2 calendars for selecting a set of fromDate and toDate.
 */
import { OnChanges, OnInit, SimpleChanges } from '@angular/core';
import { ControlValueAccessor } from '@angular/forms';
export declare class NwfDatetimeRangePicker implements OnInit, OnChanges, ControlValueAccessor {
    fromDateISOString: string;
    toDateISOString: string;
    fromDate: Date;
    toDate: Date;
    private _onChange;
    constructor();
    ngOnInit(): void;
    ngOnChanges(changes: SimpleChanges): void;
    /**
     * writeValue() - Sets the fromDate and toDate according to the input.
     * @param datetimeRangeValue - any
     * @returns void
     */
    writeValue(datetimeRangeValue: any): void;
    registerOnChange(fn: any): void;
    registerOnTouched(fn: any): void;
    /**
     * setDatetimeRange() - Sets the fromDate and toDate from the ISOStrings
     * These dates are updated according to the min and max data provided in the argument of the function.
     * @param changes - SimpleChanges
     * @returns void
     */
    setDatetimeRange(): void;
    setVisibleValue(): void;
}
