import { OnInit } from '@angular/core';
import { I18NextPipe } from 'angular-i18next';
import { DxDataGridComponent } from 'devextreme-angular';
import { NwfSchemaColumn } from '../schema/schema';
export declare class ColumnChooserComponent implements OnInit {
    private i18NextPipe;
    dataGrid: DxDataGridComponent;
    _availableColumns: NwfSchemaColumn[];
    _columnsToDisplay: NwfSchemaColumn[];
    isInvalid: boolean;
    private ngbPopover;
    private gridInstance;
    private value;
    constructor(i18NextPipe: I18NextPipe);
    ngOnInit(): void;
    setColumnsToDisplay(): void;
    togglePopover(): void;
    closePopover(): void;
    toggleSelection(selection: any): void;
    deselectColumn(selIn: any): void;
    selectOption(selIn: any): void;
    deSelectAvailableColumns(): void;
    removeIsSelectedFromAllColumns(availableColumns: any[]): void;
    selectAvailableColumns(): void;
    moveSelection(fromIndex: number, toIndex: number): void;
    moveColumnsUp(): void;
    moveColumnsDown(): void;
    cancel(): void;
    apply(): void;
    /**
     * Method to update the index and visibility of grid columns and set it on the grid.
     */
    updateIndexAndVisibilityOfColumns(): void;
    /**
     * We find all columns on dx grid. Instead of using a method available on gridInstance directly, we use this way because
     * gridInstance.columnOption gives a complete column object (including default column settings),
     * whereas column object returned by gridInstance.option('columnms') only contains properties you explicitly set.
     * gridInstance.getVisibleColumns() method gives us the complete object but it only works for visible columns.
     */
    private getAllColumnsOnDxGrid;
}
