import { OnInit } from '@angular/core';
import { FormArray, FormBuilder, FormGroup } from '@angular/forms';
import { NgbPopover } from '@ng-bootstrap/ng-bootstrap';
import { DxDataGridComponent } from 'devextreme-angular';
import { NwfSchemaColumn } from '../schema/schema';
export declare class NwfFilterComponent implements OnInit {
    private _fb;
    _ngbPopover: NgbPopover;
    dataGrid: DxDataGridComponent;
    nwfFilters: any[];
    filterableColumns: NwfSchemaColumn[];
    filterFormGrp: FormGroup;
    private config;
    private gridInstance;
    private initialColumns;
    constructor(_fb: FormBuilder);
    ngOnInit(): void;
    setDxGridFilterOnNwfFilterWidget(): void;
    togglePopover(): void;
    /**
     * Creates the form that holds all the filter criterion as formControl inside it.
     * FormGroup holds the state of the filter widget.
     */
    createFormGroup(): void;
    /**
     * @description adds a new default criterion on click of "Add Filter" button
     */
    addCriterion(): void;
    /**
     * Method to create a new filter criterion. Each filter criterion is form group of 3 form controls.
     * 1. property, 2. operator, 3. value.
     * @param criterion new filter criterion
     */
    initCriterion(criterion?: {
        property: NwfSchemaColumn;
        operator: any;
        value: string;
    }): FormGroup;
    /**
     * @description deletes a criterion from current criterion, else deletes all the applied criterion. Invoked on clicking Trash icon.
     * @param id
     */
    deleteCriterion(criterionIndex: any): void;
    /**
     * @description deletes all the criterion.
     */
    reset(): void;
    getFormArray(): FormArray;
    /**
     * @description applies the filter on dx grid instance on hitting Apply button.
     */
    apply(): void;
    validateAllFormFields(formControls: FormGroup[]): void;
    setFiltersOnDxGridInstance(): void;
    /**
     * @description cancel on hitting 'Cancel' button.
     */
    cancel(): void;
    getCriterionObject(): {
        property: NwfSchemaColumn;
        operator: any;
        value: string;
    };
    /**
     * @description fetch the property from the original params passed into the widget.
     * @param id
     */
    getPropertyById(id: any): NwfSchemaColumn;
    /**
     * @description method that return the options from filter config bundle based on the type passed, returns an object containing inputType and options.
     * @param paramType
     */
    getOperatorOptions(paramType: any): any;
    /**
     * @description: method to create the applied criteria from appliedFilters coming from filter widget consumer.
     * This allows to preset the filterWidget this it he VALUE of the filter widget.
     * @param
     */
    dxToNwfFilterConverter(dxGridFilters: any): void;
    getFilterCriterionFromDxFilter(filter: any): {
        property: NwfSchemaColumn;
        operator: any;
        value: any;
    };
    /**
     * We find all columns on dx grid. Instead of using a method available on gridInstance directly, we use this way because
     * gridInstance.columnOption gives a complete column object (including default column settings),
     * whereas column object returned by gridInstance.option('columnms') only contains properties you explicitly set.
     * gridInstance.getVisibleColumns() method gives us the complete object but it only works for visible columns.
     */
    private getAllColumnsOnDxGrid;
}
