#!/bin/sh
':' //; exec "$(command -v nodejs || command -v node)" "$0" "$@"

const { join } = require('path');
const { readFileSync, writeFileSync } = require('fs');
const rl = require('readline-sync');

// Load the deps from this package.json
const thisPkg = loadJson(join(__dirname, 'package.platform.json'));

// Load the dependencies from the parent package.json. Create the dependencies
// list in the parent package.json if it doesn't already exist.
const parentPkg = loadJson('package.json');


//I want to loop on deps, pardon the duplication.
const properDeps = thisPkg.dependencies || null;
const properDevDeps = thisPkg.devDependencies || null;

const originalParentPkg = JSON.stringify(parentPkg);
const parentDeps = parentPkg.dependencies || {};
const parentDevDeps = parentPkg.devDependencies || {};
if (parentPkg.dependencies == null) {
	parentPkg.dependencies = parentDeps;
}
if (parentPkg.devDependencies == null) {
	parentPkg.devDependencies = parentDevDeps;
}

if (properDeps) {
	// Walk through this packages dependencies
	Object.keys(properDeps)
		.forEach(dep => {
			let shouldUse = false;
			const isKeyInParent = dep in parentDeps;
			const isDepDifferent = parentDeps[dep] != properDeps[dep];
			if (isKeyInParent && isDepDifferent) {
				// The parent does have this dependency, and it's a different version
				// from this project, so ask the user what to do 
				const answer = rl.question(
					`Versions differ for ${dep} (have ${parentDeps[dep]}, ` +
					`need ${properDeps[dep]}). Overwrite [y/n]? `
				);
				shouldUse = answer.toLowerCase()[0] === 'y';
			}

			if (shouldUse) {
				parentDeps[dep] = properDeps[dep];
			}
		});
}
if (properDevDeps) {
	// Walk through this packages devDependencies
	Object.keys(properDevDeps)
		.forEach(dep => {
			let shouldUse = false;
			const isKeyInParent = dep in parentDevDeps;
			const isDepDifferent = parentDevDeps[dep] != properDevDeps[dep];
			if (isKeyInParent && isDepDifferent) {
				// The parent does have this dependency, and it's a different version
				// from this project, so ask the user what to do 
				const answer = rl.question(
					`Versions differ for ${dep} (have ${parentDevDeps[dep]}, ` +
					`need ${properDevDeps[dep]}). Overwrite [y/n]? `
				);
				shouldUse = answer.toLowerCase()[0] === 'y';
			}

			if (shouldUse) {
				parentDevDeps[dep] = properDevDeps[dep];
			}
		});
}


// Check if we changed anything
if (JSON.stringify(parentPkg) !== originalParentPkg) {
	// Save the updated package.json
	saveJson('package.json', parentPkg);
	console.log('Updated package.json, now run >npm install...\n');
}


function loadJson(filename) {
	const data = readFileSync(filename, { encoding: 'utf8' });
	return JSON.parse(data);
}

function saveJson(filename, data) {
	// If the package.json should have a particular format (e.g., tab or 4-space
	// indent), set it here.
	const text = JSON.stringify(data, null, '  ');
	writeFileSync(filename, text);
}
