"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var OPERATION_KIND;
(function (OPERATION_KIND) {
    OPERATION_KIND[OPERATION_KIND["Remove"] = 0] = "Remove";
    OPERATION_KIND[OPERATION_KIND["Add"] = 1] = "Add";
    OPERATION_KIND[OPERATION_KIND["Replace"] = 2] = "Replace";
})(OPERATION_KIND = exports.OPERATION_KIND || (exports.OPERATION_KIND = {}));
class TransformOperation {
    constructor(kind, sourceFile, target) {
        this.kind = kind;
        this.sourceFile = sourceFile;
        this.target = target;
    }
}
exports.TransformOperation = TransformOperation;
class RemoveNodeOperation extends TransformOperation {
    constructor(sourceFile, target) {
        super(OPERATION_KIND.Remove, sourceFile, target);
    }
}
exports.RemoveNodeOperation = RemoveNodeOperation;
class AddNodeOperation extends TransformOperation {
    constructor(sourceFile, target, before, after) {
        super(OPERATION_KIND.Add, sourceFile, target);
        this.before = before;
        this.after = after;
    }
}
exports.AddNodeOperation = AddNodeOperation;
class ReplaceNodeOperation extends TransformOperation {
    constructor(sourceFile, target, replacement) {
        super(OPERATION_KIND.Replace, sourceFile, target);
        this.replacement = replacement;
    }
}
exports.ReplaceNodeOperation = ReplaceNodeOperation;
//# sourceMappingURL=data:application/json;base64,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