"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function appendPropertyInAstObject(recorder, node, propertyName, value, indent) {
    const indentStr = _buildIndent(indent);
    if (node.properties.length > 0) {
        // Insert comma.
        const last = node.properties[node.properties.length - 1];
        recorder.insertRight(last.start.offset + last.text.replace(/\s+$/, '').length, ',');
    }
    recorder.insertLeft(node.end.offset - 1, '  '
        + `"${propertyName}": ${JSON.stringify(value, null, 2).replace(/\n/g, indentStr)}`
        + indentStr.slice(0, -2));
}
exports.appendPropertyInAstObject = appendPropertyInAstObject;
function insertPropertyInAstObjectInOrder(recorder, node, propertyName, value, indent) {
    if (node.properties.length === 0) {
        appendPropertyInAstObject(recorder, node, propertyName, value, indent);
        return;
    }
    // Find insertion info.
    let insertAfterProp = null;
    let prev = null;
    let isLastProp = false;
    const last = node.properties[node.properties.length - 1];
    for (const prop of node.properties) {
        if (prop.key.value > propertyName) {
            if (prev) {
                insertAfterProp = prev;
            }
            break;
        }
        if (prop === last) {
            isLastProp = true;
            insertAfterProp = last;
        }
        prev = prop;
    }
    if (isLastProp) {
        appendPropertyInAstObject(recorder, node, propertyName, value, indent);
        return;
    }
    const indentStr = _buildIndent(indent);
    const insertIndex = insertAfterProp === null
        ? node.start.offset + 1
        : insertAfterProp.end.offset + 1;
    recorder.insertRight(insertIndex, indentStr
        + `"${propertyName}": ${JSON.stringify(value, null, 2).replace(/\n/g, indentStr)}`
        + ',');
}
exports.insertPropertyInAstObjectInOrder = insertPropertyInAstObjectInOrder;
function appendValueInAstArray(recorder, node, value, indent = 4) {
    const indentStr = _buildIndent(indent);
    if (node.elements.length > 0) {
        // Insert comma.
        const last = node.elements[node.elements.length - 1];
        recorder.insertRight(last.start.offset + last.text.replace(/\s+$/, '').length, ',');
    }
    recorder.insertLeft(node.end.offset - 1, '  '
        + JSON.stringify(value, null, 2).replace(/\n/g, indentStr)
        + indentStr.slice(0, -2));
}
exports.appendValueInAstArray = appendValueInAstArray;
function findPropertyInAstObject(node, propertyName) {
    let maybeNode = null;
    for (const property of node.properties) {
        if (property.key.value == propertyName) {
            maybeNode = property.value;
        }
    }
    return maybeNode;
}
exports.findPropertyInAstObject = findPropertyInAstObject;
function _buildIndent(count) {
    return '\n' + new Array(count + 1).join(' ');
}
//# sourceMappingURL=data:application/json;base64,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