import { UIRouter, extend, isNumber } from '@uirouter/core';
import { Directive, Inject, Input, Optional, ElementRef, Renderer2, HostListener, } from '@angular/core';
import { UIView } from './uiView';
import { ReplaySubject } from 'rxjs';
/**
 * @internalapi
 * # blah blah blah
 */
var AnchorUISref = /** @class */ (function () {
    function AnchorUISref(_el, _renderer) {
        this._el = _el;
        this._renderer = _renderer;
    }
    AnchorUISref.prototype.openInNewTab = function () {
        return this._el.nativeElement.target === '_blank';
    };
    AnchorUISref.prototype.update = function (href) {
        if (href && href !== '') {
            this._renderer.setProperty(this._el.nativeElement, 'href', href);
        }
        else {
            this._renderer.removeAttribute(this._el.nativeElement, 'href');
        }
    };
    AnchorUISref.decorators = [
        { type: Directive, args: [{ selector: 'a[uiSref]' },] },
    ];
    /** @nocollapse */
    AnchorUISref.ctorParameters = function () { return [
        { type: ElementRef, },
        { type: Renderer2, },
    ]; };
    return AnchorUISref;
}());
export { AnchorUISref };
/**
 * A directive when clicked, initiates a [[Transition]] to a [[TargetState]].
 *
 * ### Purpose
 *
 * This directive is applied to anchor tags (`<a>`) or any other clickable element.  It is a state reference (or sref --
 * similar to an href).  When clicked, the directive will transition to that state by calling [[StateService.go]],
 * and optionally supply state parameter values and transition options.
 *
 * When this directive is on an anchor tag, it will also add an `href` attribute to the anchor.
 *
 * ### Selector
 *
 * - `[uiSref]`: The directive is created as an attribute on an element, e.g., `<a uiSref></a>`
 *
 * ### Inputs
 *
 * - `uiSref`: the target state's name, e.g., `uiSref="foostate"`.  If a component template uses a relative `uiSref`,
 * e.g., `uiSref=".child"`, the reference is relative to that component's state.
 *
 * - `uiParams`: any target state parameter values, as an object, e.g., `[uiParams]="{ fooId: bar.fooId }"`
 *
 * - `uiOptions`: [[TransitionOptions]], e.g., `[uiOptions]="{ inherit: false }"`
 *
 * @example
 * ```html
 *
 * <!-- Targets bar state' -->
 * <a uiSref="bar">Bar</a>
 *
 * <!-- Assume this component's state is "foo".
 *      Relatively targets "foo.child" -->
 * <a uiSref=".child">Foo Child</a>
 *
 * <!-- Targets "bar" state and supplies parameter value -->
 * <a uiSref="bar" [uiParams]="{ barId: foo.barId }">Bar {{foo.barId}}</a>
 *
 * <!-- Targets "bar" state and parameter, doesn't inherit existing parameters-->
 * <a uiSref="bar" [uiParams]="{ barId: foo.barId }" [uiOptions]="{ inherit: false }">Bar {{foo.barId}}</a>
 * ```
 */
var UISref = /** @class */ (function () {
    function UISref(_router, _anchorUISref, parent) {
        var _this = this;
        /**
           * An observable (ReplaySubject) of the state this UISref is targeting.
           * When the UISref is clicked, it will transition to this [[TargetState]].
           */
        this.targetState$ = new ReplaySubject(1);
        /** @internalapi */ this._emit = false;
        this._router = _router;
        this._anchorUISref = _anchorUISref;
        this._parent = parent;
        this._statesSub = _router.globals.states$.subscribe(function () { return _this.update(); });
    }
    Object.defineProperty(UISref.prototype, "uiSref", {
        /** @internalapi */
        set: /** @internalapi */
        function (val) {
            this.state = val;
            this.update();
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(UISref.prototype, "uiParams", {
        /** @internalapi */
        set: /** @internalapi */
        function (val) {
            this.params = val;
            this.update();
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(UISref.prototype, "uiOptions", {
        /** @internalapi */
        set: /** @internalapi */
        function (val) {
            this.options = val;
            this.update();
        },
        enumerable: true,
        configurable: true
    });
    UISref.prototype.ngOnInit = function () {
        this._emit = true;
        this.update();
    };
    UISref.prototype.ngOnChanges = function (changes) {
        this.update();
    };
    UISref.prototype.ngOnDestroy = function () {
        this._emit = false;
        this._statesSub.unsubscribe();
        this.targetState$.unsubscribe();
    };
    UISref.prototype.update = function () {
        var $state = this._router.stateService;
        if (this._emit) {
            var newTarget = $state.target(this.state, this.params, this.getOptions());
            this.targetState$.next(newTarget);
        }
        if (this._anchorUISref) {
            var href = $state.href(this.state, this.params, this.getOptions());
            this._anchorUISref.update(href);
        }
    };
    UISref.prototype.getOptions = function () {
        var defaultOpts = {
            relative: this._parent && this._parent.context && this._parent.context.name,
            inherit: true,
            source: 'sref',
        };
        return extend(defaultOpts, this.options || {});
    };
    /** When triggered by a (click) event, this function transitions to the UISref's target state */
    UISref.prototype.go = /** When triggered by a (click) event, this function transitions to the UISref's target state */
    function (button, ctrlKey, metaKey) {
        if ((this._anchorUISref &&
            (this._anchorUISref.openInNewTab() || button || !isNumber(button) || ctrlKey || metaKey)) ||
            !this.state) {
            return;
        }
        this._router.stateService.go(this.state, this.params, this.getOptions());
        return false;
    };
    UISref.decorators = [
        { type: Directive, args: [{
                    selector: '[uiSref]',
                    exportAs: 'uiSref',
                },] },
    ];
    /** @nocollapse */
    UISref.ctorParameters = function () { return [
        { type: UIRouter, },
        { type: AnchorUISref, decorators: [{ type: Optional },] },
        { type: undefined, decorators: [{ type: Inject, args: [UIView.PARENT_INJECT,] },] },
    ]; };
    UISref.propDecorators = {
        "state": [{ type: Input, args: ['uiSref',] },],
        "params": [{ type: Input, args: ['uiParams',] },],
        "options": [{ type: Input, args: ['uiOptions',] },],
        "go": [{ type: HostListener, args: ['click', ['$event.button', '$event.ctrlKey', '$event.metaKey'],] },],
    };
    return UISref;
}());
export { UISref };
//# sourceMappingURL=uiSref.js.map