/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import * as Highcharts from 'highcharts';
import { AsyncSubject } from 'rxjs';
var Chart = /** @class */ (function () {
    function Chart(options) {
        if (options === void 0) { options = { series: [] }; }
        this.options = options;
        this.refSubject = new AsyncSubject();
        this.ref$ = this.refSubject.asObservable();
    }
    /**
     * Add Point
     * @param point         Highcharts.DataPoint, number touple or number
     * @param serieIndex    Index position of series. This defaults to 0.
     * @param redraw        Flag whether or not to redraw point. This defaults to true.
     * @param shift         Shift point to the start of series. This defaults to false.
     */
    /**
     * Add Point
     * @param {?} point         Highcharts.DataPoint, number touple or number
     * @param {?=} serieIndex    Index position of series. This defaults to 0.
     * @param {?=} redraw        Flag whether or not to redraw point. This defaults to true.
     * @param {?=} shift         Shift point to the start of series. This defaults to false.
     * @return {?}
     */
    Chart.prototype.addPoint = /**
     * Add Point
     * @param {?} point         Highcharts.DataPoint, number touple or number
     * @param {?=} serieIndex    Index position of series. This defaults to 0.
     * @param {?=} redraw        Flag whether or not to redraw point. This defaults to true.
     * @param {?=} shift         Shift point to the start of series. This defaults to false.
     * @return {?}
     */
    function (point, serieIndex, redraw, shift) {
        if (serieIndex === void 0) { serieIndex = 0; }
        if (redraw === void 0) { redraw = true; }
        if (shift === void 0) { shift = false; }
        this.ref$.subscribe(function (chart) {
            if (chart.series.length > serieIndex) {
                chart.series[serieIndex].addPoint(point, redraw, shift);
            }
        });
    };
    /**
     * Add Series
     * @param series        Series Configuration
     * @param redraw        Flag whether or not to redraw series. This defaults to true.
     * @param animation     Whether to apply animation, and optionally animation configuration. This defaults to false.
     */
    /**
     * Add Series
     * @param {?} series        Series Configuration
     * @param {?=} redraw        Flag whether or not to redraw series. This defaults to true.
     * @param {?=} animation     Whether to apply animation, and optionally animation configuration. This defaults to false.
     * @return {?}
     */
    Chart.prototype.addSeries = /**
     * Add Series
     * @param {?} series        Series Configuration
     * @param {?=} redraw        Flag whether or not to redraw series. This defaults to true.
     * @param {?=} animation     Whether to apply animation, and optionally animation configuration. This defaults to false.
     * @return {?}
     */
    function (series, redraw, animation) {
        if (redraw === void 0) { redraw = true; }
        this.ref$.subscribe(function (chart) {
            chart.addSeries(series, redraw, animation);
        });
    };
    /**
     * Remove Point
     * @param pointIndex    Index of Point
     * @param serieIndex    Specified Index of Series. Defaults to 0.
     */
    /**
     * Remove Point
     * @param {?} pointIndex    Index of Point
     * @param {?=} serieIndex    Specified Index of Series. Defaults to 0.
     * @return {?}
     */
    Chart.prototype.removePoint = /**
     * Remove Point
     * @param {?} pointIndex    Index of Point
     * @param {?=} serieIndex    Specified Index of Series. Defaults to 0.
     * @return {?}
     */
    function (pointIndex, serieIndex) {
        if (serieIndex === void 0) { serieIndex = 0; }
        this.ref$.subscribe(function (chart) {
            if (chart.series.length > serieIndex && chart.series[serieIndex].data.length > pointIndex) {
                chart.series[serieIndex].removePoint(pointIndex, true);
            }
        });
    };
    /**
     * Remove Series
     * @param seriesIndex    Index position of series to remove.
     */
    /**
     * Remove Series
     * @param {?} seriesIndex    Index position of series to remove.
     * @return {?}
     */
    Chart.prototype.removeSeries = /**
     * Remove Series
     * @param {?} seriesIndex    Index position of series to remove.
     * @return {?}
     */
    function (seriesIndex) {
        this.ref$.subscribe(function (chart) {
            if (chart.series.length > seriesIndex) {
                chart.series[seriesIndex].remove(true);
            }
        });
    };
    /**
     * @param {?} el
     * @return {?}
     */
    Chart.prototype.init = /**
     * @param {?} el
     * @return {?}
     */
    function (el) {
        var _this = this;
        if (!this.ref) {
            Highcharts.chart(el.nativeElement, this.options, function (chart) {
                _this.refSubject.next(chart);
                _this.ref = chart;
                _this.refSubject.complete();
            });
        }
    };
    /**
     * @return {?}
     */
    Chart.prototype.destroy = /**
     * @return {?}
     */
    function () {
        if (this.ref) {
            this.options = this.ref.options;
            this.ref.destroy();
            this.ref = undefined;
            // new init subject
            this.refSubject = new AsyncSubject();
            this.ref$ = this.refSubject.asObservable();
        }
    };
    return Chart;
}());
export { Chart };
if (false) {
    /**
     * @type {?}
     * @private
     */
    Chart.prototype.refSubject;
    /** @type {?} */
    Chart.prototype.ref$;
    /** @type {?} */
    Chart.prototype.ref;
    /**
     * @type {?}
     * @private
     */
    Chart.prototype.options;
}
//# sourceMappingURL=data:application/json;base64,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