/*!
 * devextreme-angular
 * Version: 18.1.6
 * Build date: Wed Sep 05 2018
 *
 * Copyright (c) 2012 - 2018 Developer Express Inc. ALL RIGHTS RESERVED
 *
 * This software may be modified and distributed under the terms
 * of the MIT license. See the LICENSE file in the root of the project for details.
 *
 * https://github.com/DevExpress/devextreme-angular
 */
import { QueryList } from '@angular/core';
import DevExpress from 'devextreme/bundles/dx.all';
import { NestedOptionHost } from '../../core/nested-option';
import { NestedOption } from '../../core/nested-option';
import { DxiBreakComponent } from './break-dxi';
export declare class DxoScaleComponent extends NestedOption {
    allowDecimals: boolean;
    customMinorTicks: Array<number>;
    customTicks: Array<number>;
    endValue: number | Date | string;
    hideFirstLabel: boolean;
    hideFirstTick: boolean;
    hideLastLabel: boolean;
    hideLastTick: boolean;
    label: {
        customizeText?: Function;
        font?: DevExpress.viz.Font;
        format?: DevExpress.ui.format | string;
        hideFirstOrLast?: string;
        indentFromTick?: number;
        overlappingBehavior?: string | {
            hideFirstOrLast?: string;
            useAutoArrangement?: boolean;
        };
        precision?: number;
        useRangeColors?: boolean;
        visible?: boolean;
    } | {
        customizeText?: Function;
        font?: DevExpress.viz.Font;
        format?: DevExpress.ui.format | string;
        indentFromTick?: number;
        overlappingBehavior?: string | {
            hideFirstOrLast?: string;
            useAutoArrangement?: boolean;
        };
        precision?: number;
        useRangeColors?: boolean;
        visible?: boolean;
    } | {
        customizeText?: Function;
        font?: DevExpress.viz.Font;
        format?: DevExpress.ui.format | string;
        overlappingBehavior?: string;
        precision?: number;
        topIndent?: number;
        visible?: boolean;
    };
    majorTick: {
        color?: string;
        customTickValues?: Array<number>;
        length?: number;
        showCalculatedTicks?: boolean;
        tickInterval?: number;
        useTicksAutoArrangement?: boolean;
        visible?: boolean;
        width?: number;
    };
    minorTick: {
        color?: string;
        customTickValues?: Array<number>;
        length?: number;
        opacity?: number;
        showCalculatedTicks?: boolean;
        tickInterval?: number;
        visible?: boolean;
        width?: number;
    } | {
        color?: string;
        opacity?: number;
        visible?: boolean;
        width?: number;
    };
    minorTickInterval: number | string | {
        days?: number;
        hours?: number;
        milliseconds?: number;
        minutes?: number;
        months?: number;
        quarters?: number;
        seconds?: number;
        weeks?: number;
        years?: number;
    };
    orientation: string;
    startValue: number | Date | string;
    tick: {
        color?: string;
        length?: number;
        opacity?: number;
        visible?: boolean;
        width?: number;
    } | {
        color?: string;
        opacity?: number;
        width?: number;
    };
    tickInterval: number | string | {
        days?: number;
        hours?: number;
        milliseconds?: number;
        minutes?: number;
        months?: number;
        quarters?: number;
        seconds?: number;
        weeks?: number;
        years?: number;
    };
    horizontalOrientation: string;
    verticalOrientation: string;
    aggregationGroupWidth: number;
    aggregationInterval: number | string | {
        days?: number;
        hours?: number;
        milliseconds?: number;
        minutes?: number;
        months?: number;
        quarters?: number;
        seconds?: number;
        weeks?: number;
        years?: number;
    };
    breaks: Array<DevExpress.viz.ScaleBreak | {
        endValue?: Date | number | string;
        startValue?: Date | number | string;
    }>;
    breakStyle: {
        color?: string;
        line?: string;
        width?: number;
    };
    categories: Array<number | string | Date>;
    endOnTick: boolean;
    holidays: Array<Date | string | number>;
    logarithmBase: number;
    majorTickInterval: number | string | {
        days?: number;
        hours?: number;
        milliseconds?: number;
        minutes?: number;
        months?: number;
        seconds?: number;
        years?: number;
    };
    marker: {
        label?: {
            customizeText?: Function;
            format?: DevExpress.ui.format | string;
        };
        separatorHeight?: number;
        textLeftIndent?: number;
        textTopIndent?: number;
        topIndent?: number;
        visible?: boolean;
    };
    maxRange: number | string | {
        days?: number;
        hours?: number;
        milliseconds?: number;
        minutes?: number;
        months?: number;
        quarters?: number;
        seconds?: number;
        weeks?: number;
        years?: number;
    };
    minorTickCount: number;
    minRange: number | string | {
        days?: number;
        hours?: number;
        milliseconds?: number;
        minutes?: number;
        months?: number;
        quarters?: number;
        seconds?: number;
        weeks?: number;
        years?: number;
    };
    placeholderHeight: number;
    setTicksAtUnitBeginning: boolean;
    showCustomBoundaryTicks: boolean;
    showMinorTicks: boolean;
    singleWorkdays: Array<Date | string | number>;
    type: string;
    useTicksAutoArrangement: boolean;
    valueType: string;
    workdaysOnly: boolean;
    workWeek: Array<number>;
    protected readonly _optionPath: string;
    breaksChildren: QueryList<DxiBreakComponent>;
    constructor(parentOptionHost: NestedOptionHost, optionHost: NestedOptionHost);
}
export declare class DxoScaleModule {
}
