/*
  Highcharts JS v7.0.2 (2019-01-17)

 All technical indicators for Highstock

 (c) 2010-2019 Pawel Fus

 License: www.highcharts.com/license
*/
(function(t){"object"===typeof module&&module.exports?(t["default"]=t,module.exports=t):"function"===typeof define&&define.amd?define(function(){return t}):t("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(t){var D=function(d){var k=d.error;return{isParentLoaded:function(d,f,b,c,e){if(d)return c?c(d):!0;k(e||this.generateMessage(b,f));return!1},generateMessage:function(d,f){return'Error: "'+d+'" indicator type requires "'+f+'" indicator loaded before. Please read docs: https://api.highcharts.com/highstock/plotOptions.'+
d}}}(t);(function(d,k){var n=d.pick,f=d.error,b=d.Series,c=d.isArray,e=d.addEvent,a=d.seriesType,g=d.seriesTypes,r=d.seriesTypes.ohlc.prototype,q=k.generateMessage;e(d.Series,"init",function(a){a=a.options;var c=a.dataGrouping;a.useOhlcData&&"highcharts-navigator-series"!==a.id&&(c&&c.enabled&&(c.approximation="ohlc"),d.extend(this,{pointValKey:r.pointValKey,keys:r.keys,pointArrayMap:r.pointArrayMap,toYData:r.toYData}))});a("sma","line",{name:void 0,tooltip:{valueDecimals:4},linkedTo:void 0,params:{index:0,
period:14}},{bindTo:{series:!0,eventName:"updatedData"},useCommonDataGrouping:!0,nameComponents:["period"],nameSuffixes:[],calculateOn:"init",requiredIndicators:[],requireIndicators:function(){var a={allLoaded:!0};this.requiredIndicators.forEach(function(c){g[c]?g[c].prototype.requireIndicators():(a.allLoaded=!1,a.needed=c)});return a},init:function(a,c){function g(){var a=(l.xData||[]).length,c=l.getValues(l.linkedParent,l.options.params)||{values:[],xData:[],yData:[]};a&&a===c.xData.length&&!l.cropped&&
!l.hasGroupedData&&l.visible&&l.points?l.updateData(c.values):(l.xData=c.xData,l.yData=c.yData,l.options.data=c.values);!1===l.bindTo.series&&(delete l.processedXData,l.isDirty=!0,l.redraw());l.isDirtyData=!1}var l=this,r=l.requireIndicators();if(!r.allLoaded)return f(q(l.type,r.needed));b.prototype.init.call(l,a,c);a.linkSeries();l.dataEventsToUnbind=[];if(!l.linkedParent)return f("Series "+l.options.linkedTo+" not found! Check `linkedTo`.",!1,a);l.dataEventsToUnbind.push(e(l.bindTo.series?l.linkedParent:
l.linkedParent.xAxis,l.bindTo.eventName,g));if("init"===l.calculateOn)g();else var m=e(l.chart,l.calculateOn,function(){g();m()});return l},getName:function(){var a=this.name,c=[];a||((this.nameComponents||[]).forEach(function(a,b){c.push(this.options.params[a]+n(this.nameSuffixes[b],""))},this),a=(this.nameBase||this.type.toUpperCase())+(this.nameComponents?" ("+c.join(", ")+")":""));return a},getValues:function(a,b){var e=b.period,g=a.xData;a=a.yData;var r=a.length,q=0,m=0,f=[],p=[],d=[],k=-1,n;
if(g.length<e)return!1;for(c(a[0])&&(k=b.index?b.index:0);q<e-1;)m+=0>k?a[q]:a[q][k],q++;for(b=q;b<r;b++)m+=0>k?a[b]:a[b][k],n=[g[b],m/e],f.push(n),p.push(n[0]),d.push(n[1]),m-=0>k?a[b-q]:a[b-q][k];return{values:f,xData:p,yData:d}},destroy:function(){this.dataEventsToUnbind.forEach(function(a){a()});b.prototype.destroy.call(this)}})})(t,D);(function(d){var k=d.seriesType;k("ad","sma",{params:{volumeSeriesID:"volume"}},{nameComponents:!1,nameBase:"Accumulation/Distribution",getValues:function(k,f){var b=
f.period,c=k.xData,e=k.yData,a=f.volumeSeriesID,g=k.chart.get(a);f=g&&g.yData;var r=e?e.length:0,q=[],m=[],p=[];if(c.length<=b&&r&&4!==e[0].length)return!1;if(!g)return d.error("Series "+a+" not found! Check `volumeSeriesID`.",!0,k.chart);for(;b<r;b++){k=q.length;var a=e[b][1],g=e[b][2],h=e[b][3],l=f[b],a=[c[b],h===a&&h===g||a===g?0:(2*h-g-a)/(a-g)*l];0<k&&(a[1]+=q[k-1][1]);q.push(a);m.push(a[0]);p.push(a[1])}return{values:q,xData:m,yData:p}}})})(t);(function(d){var k=d.correctFloat,n=d.isArray;d.seriesType("ao",
"sma",{greaterBarColor:"#06B535",lowerBarColor:"#F21313",threshold:0,groupPadding:.2,pointPadding:.2,states:{hover:{halo:{size:0}}}},{nameBase:"AO",nameComponents:!1,markerAttribs:d.noop,getColumnMetrics:d.seriesTypes.column.prototype.getColumnMetrics,crispCol:d.seriesTypes.column.prototype.crispCol,translate:d.seriesTypes.column.prototype.translate,drawPoints:d.seriesTypes.column.prototype.drawPoints,drawGraph:function(){var f=this.options,b=this.points,c=f.greaterBarColor,f=f.lowerBarColor,e=b[0];
if(!this.userOptions.color&&e)for(e.color=c,e=1;e<b.length;e++)b[e].color=b[e].y>b[e-1].y?c:b[e].y<b[e-1].y?f:b[e-1].color},getValues:function(f){var b=f.xData||[];f=f.yData||[];var c=f.length,e=[],a=[],g=[],r=0,q=0,m,p,h;if(34>=b.length||!n(f[0])||4!==f[0].length)return!1;for(h=0;33>h;h++)m=(f[h][1]+f[h][2])/2,29<=h&&(r=k(r+m)),q=k(q+m);for(h=33;h<c;h++)m=(f[h][1]+f[h][2])/2,r=k(r+m),q=k(q+m),m=r/5,p=q/34,m=k(m-p),e.push([b[h],m]),a.push(b[h]),g.push(m),m=h+1-5,p=h+1-34,r=k(r-(f[m][1]+f[m][2])/2),
q=k(q-(f[p][1]+f[p][2])/2);return{values:e,xData:a,yData:g}}})})(t);var F=function(d){var k=d.each,n=d.merge,f=d.error,b=d.defined,c=d.seriesTypes.sma;return{pointArrayMap:["top","bottom"],pointValKey:"top",linesApiNames:["bottomLine"],getTranslatedLinesNames:function(c){var a=[];k(this.pointArrayMap,function(b){b!==c&&a.push("plot"+b.charAt(0).toUpperCase()+b.slice(1))});return a},toYData:function(c){var a=[];k(this.pointArrayMap,function(b){a.push(c[b])});return a},translate:function(){var b=this,
a=b.pointArrayMap,g=[],r,g=b.getTranslatedLinesNames();c.prototype.translate.apply(b,arguments);k(b.points,function(c){k(a,function(a,e){r=c[a];null!==r&&(c[g[e]]=b.yAxis.toPixels(r,!0))})})},drawGraph:function(){var e=this,a=e.linesApiNames,g=e.points,r=g.length,q=e.options,m=e.graph,p={options:{gapSize:q.gapSize}},h=[],l=e.getTranslatedLinesNames(e.pointValKey),z;k(l,function(a,c){for(h[c]=[];r--;)z=g[r],h[c].push({x:z.x,plotX:z.plotX,plotY:z[a],isNull:!b(z[a])});r=g.length});k(a,function(a,b){h[b]?
(e.points=h[b],q[a]?e.options=n(q[a].styles,p):f('Error: "There is no '+a+' in DOCS options declared. Check if linesApiNames are consistent with your DOCS line names." at mixin/multiple-line.js:34'),e.graph=e["graph"+a],c.prototype.drawGraph.call(e),e["graph"+a]=e.graph):f('Error: "'+a+" doesn't have equivalent in pointArrayMap. To many elements in linesApiNames relative to pointArrayMap.\"")});e.points=g;e.options=q;e.graph=m;c.prototype.drawGraph.call(e)}}}(t);(function(d,k){function n(f,b){var c=
f[0],e=0,a;for(a=1;a<f.length;a++)if("max"===b&&f[a]>=c||"min"===b&&f[a]<=c)c=f[a],e=a;return e}d.seriesType("aroon","sma",{params:{period:25},marker:{enabled:!1},tooltip:{pointFormat:'\x3cspan style\x3d"color:{point.color}"\x3e\u25cf\x3c/span\x3e\x3cb\x3e {series.name}\x3c/b\x3e\x3cbr/\x3eAroon Up: {point.y}\x3cbr/\x3eAroon Down: {point.aroonDown}\x3cbr/\x3e'},aroonDown:{styles:{lineWidth:1,lineColor:void 0}},dataGrouping:{approximation:"averages"}},d.merge(k,{nameBase:"Aroon",pointArrayMap:["y",
"aroonDown"],pointValKey:"y",linesApiNames:["aroonDown"],getValues:function(f,b){b=b.period;var c=f.xData,e=(f=f.yData)?f.length:0,a=[],g=[],r=[],q,m,p;for(p=b-1;p<e;p++)q=f.slice(p-b+1,p+2),m=n(q.map(function(a){return d.pick(a[2],a)}),"min"),q=n(q.map(function(a){return d.pick(a[1],a)}),"max"),q=q/b*100,m=m/b*100,c[p+1]&&(a.push([c[p+1],q,m]),g.push(c[p+1]),r.push([q,m]));return{values:a,xData:g,yData:r}}}))})(t,F);(function(d,k,n){var f=d.seriesTypes.aroon;d.seriesType("aroonoscillator","aroon",
{params:{period:25},tooltip:{pointFormat:'\x3cspan style\x3d"color:{point.color}"\x3e\u25cf\x3c/span\x3e\x3cb\x3e {series.name}\x3c/b\x3e: {point.y}'}},d.merge(k,{nameBase:"Aroon Oscillator",pointArrayMap:["y"],pointValKey:"y",linesApiNames:[],init:function(){var b=arguments,c=this;n.isParentLoaded(f,"aroon",c.type,function(e){e.prototype.init.apply(c,b)})},getValues:function(b,c){var e=[],a=[],g=[],r,q;b=f.prototype.getValues.call(this,b,c);for(c=0;c<b.yData.length;c++)r=b.yData[c][0],q=b.yData[c][1],
r-=q,e.push([b.xData[c],r]),a.push(b.xData[c]),g.push(r);return{values:e,xData:a,yData:g}}}))})(t,F,D);(function(d){function k(b,c){return Math.max(b[1]-b[2],c===f?0:Math.abs(b[1]-c[3]),c===f?0:Math.abs(b[2]-c[3]))}var n=d.isArray;d=d.seriesType;var f;d("atr","sma",{params:{period:14}},{getValues:function(b,c){c=c.period;var e=b.xData,a=(b=b.yData)?b.length:0,g=1,r=0,q=0,f=[],p=[],h=[],l,z,d;d=[[e[0],b[0]]];if(e.length<=c||!n(b[0])||4!==b[0].length)return!1;for(z=1;z<=a;z++)if(d.push([e[z],b[z]]),
c<g){l=c;var y=e[z-1],u=k(b[z-1],b[z-2]);l=[y,(r*(l-1)+u)/l];r=l[1];f.push(l);p.push(l[0]);h.push(l[1])}else c===g?(r=q/(z-1),f.push([e[z-1],r]),p.push(e[z-1]),h.push(r)):q+=k(b[z-1],b[z-2]),g++;return{values:f,xData:p,yData:h}}})})(t);(function(d,k){var n=d.merge,f=d.isArray,b=d.seriesTypes.sma;d.seriesType("bb","sma",{params:{period:20,standardDeviation:2,index:3},bottomLine:{styles:{lineWidth:1,lineColor:void 0}},topLine:{styles:{lineWidth:1,lineColor:void 0}},tooltip:{pointFormat:'\x3cspan style\x3d"color:{point.color}"\x3e\u25cf\x3c/span\x3e\x3cb\x3e {series.name}\x3c/b\x3e\x3cbr/\x3eTop: {point.top}\x3cbr/\x3eMiddle: {point.middle}\x3cbr/\x3eBottom: {point.bottom}\x3cbr/\x3e'},
marker:{enabled:!1},dataGrouping:{approximation:"averages"}},d.merge(k,{pointArrayMap:["top","middle","bottom"],pointValKey:"middle",nameComponents:["period","standardDeviation"],linesApiNames:["topLine","bottomLine"],init:function(){b.prototype.init.apply(this,arguments);this.options=n({topLine:{styles:{lineColor:this.color}},bottomLine:{styles:{lineColor:this.color}}},this.options)},getValues:function(c,e){var a=e.period,g=e.standardDeviation,r=c.xData,q=(c=c.yData)?c.length:0,m=[],d,h,l,z,x=[],
k=[],n,H;if(r.length<a)return!1;n=f(c[0]);for(H=a;H<=q;H++){z=r.slice(H-a,H);h=c.slice(H-a,H);d=b.prototype.getValues.call(this,{xData:z,yData:h},e);z=d.xData[0];d=d.yData[0];l=0;for(var v=h.length,w=0,A;w<v;w++)A=(n?h[w][e.index]:h[w])-d,l+=A*A;l=Math.sqrt(l/(v-1));h=d+g*l;l=d-g*l;m.push([z,h,d,l]);x.push(z);k.push([h,d,l])}return{values:m,xData:x,yData:k}}}))})(t,F);(function(d){function k(f){return f.reduce(function(b,c){return b+c},0)}var n=d.isArray;d=d.seriesType;d("cci","sma",{params:{period:14}},
{getValues:function(f,b){b=b.period;var c=f.xData,e=(f=f.yData)?f.length:0,a=[],g,r=1,q=[],d=[],p=[],h,l;if(c.length<=b||!n(f[0])||4!==f[0].length)return!1;for(;r<b;)h=f[r-1],a.push((h[1]+h[2]+h[3])/3),r++;for(r=b;r<=e;r++){h=f[r-1];h=(h[1]+h[2]+h[3])/3;l=a.push(h);g=a.slice(l-b);l=k(g)/b;var z=g.length,x=0,y;for(y=0;y<z;y++)x+=Math.abs(l-g[y]);g=x/b;h=(h-l)/(.015*g);q.push([c[r-1],h]);d.push(c[r-1]);p.push(h)}return{values:q,xData:d,yData:p}}})})(t);(function(d){d.seriesType("cmf","sma",{params:{period:14,
volumeSeriesID:"volume"}},{nameBase:"Chaikin Money Flow",isValid:function(){var d=this.chart,n=this.options,f=this.linkedParent,d=this.volumeSeries||(this.volumeSeries=d.get(n.params.volumeSeriesID)),b=f&&f.yData&&4===f.yData[0].length;return!!(f&&d&&f.xData&&f.xData.length>=n.params.period&&d.xData&&d.xData.length>=n.params.period&&b)},getValues:function(d,n){return this.isValid()?this.getMoneyFlow(d.xData,d.yData,this.volumeSeries.yData,n.period):!1},getMoneyFlow:function(d,n,f,b){function c(a,
c){var b=a[1],e=a[2];a=a[3];return null!==c&&null!==b&&null!==e&&null!==a&&b!==e?(a-e-(b-a))/(b-e)*c:(z=h,null)}var e=n.length,a=[],g=0,r=0,q=[],m=[],p=[],h,l,z=-1;if(0<b&&b<=e){for(h=0;h<b;h++)a[h]=c(n[h],f[h]),g+=f[h],r+=a[h];q.push(d[h-1]);m.push(h-z>=b&&0!==g?r/g:null);for(p.push([q[0],m[0]]);h<e;h++)a[h]=c(n[h],f[h]),g-=f[h-b],g+=f[h],r-=a[h-b],r+=a[h],l=[d[h],h-z>=b?r/g:null],q.push(l[0]),m.push(l[1]),p.push([l[0],l[1]])}return{values:p,xData:q,yData:m}}})})(t);(function(d){function k(b,c,e,
a,g){c=f(c[e][a],c[e]);return g?n(b-c):n(b+c)}var n=d.correctFloat,f=d.pick;d.seriesType("dpo","sma",{params:{period:21}},{nameBase:"DPO",getValues:function(b,c){var e=c.period;c=c.index;var a=e+Math.floor(e/2+1),g=b.xData||[];b=b.yData||[];var r=b.length,q=[],d=[],p=[],h=0,l,z,x;if(g.length<=a)return!1;for(z=0;z<e-1;z++)h=k(h,b,z,c);for(x=0;x<=r-a;x++)l=x+e-1,z=x+a-1,h=k(h,b,l,c),l=f(b[z][c],b[z]),l-=h/e,h=k(h,b,x,c,!0),q.push([g[z],l]),d.push(g[z]),p.push(l);return{values:q,xData:d,yData:p}}})})(t);
(function(d){var k=d.isArray,n=d.seriesType,f=d.correctFloat;n("ema","sma",{params:{index:3,period:9}},{accumulatePeriodPoints:function(b,c,e){for(var a=0,g=0,r;g<b;)r=0>c?e[g]:e[g][c],a+=r,g++;return a},calculateEma:function(b,c,e,a,g,r,q){b=b[e-1];c=0>r?c[e-1]:c[e-1][r];a=void 0===g?q:f(c*a+g*(1-a));return[b,a]},getValues:function(b,c){var e=c.period,a=b.xData,g=(b=b.yData)?b.length:0,r=2/(e+1),q=[],d=[],f=[],h=-1,l;if(g<e)return!1;k(b[0])&&(h=c.index?c.index:0);for(c=this.accumulatePeriodPoints(e,
h,b)/e;e<g+1;e++)l=this.calculateEma(a,b,e,r,l,h,c),q.push(l),d.push(l[0]),f.push(l[1]),l=l[1];return{values:q,xData:d,yData:f}}})})(t);(function(d,k){var n=d.seriesTypes.ema,f=d.seriesTypes.ad,b=d.error,c=d.correctFloat;d.seriesType("chaikin","ema",{params:{volumeSeriesID:"volume",periods:[3,10]}},{nameBase:"Chaikin Osc",nameComponents:["periods"],init:function(){var c=arguments,a=this;k.isParentLoaded(n,"ema",a.type,function(b){b.prototype.init.apply(a,c)})},getValues:function(e,a){var g=a.periods,
r=a.period,d=[],m=[],p=[],h;if(2!==g.length||g[1]<=g[0])return b('Error: "Chaikin requires two periods. Notice, first period should be lower than the second one."'),!1;a=f.prototype.getValues.call(this,e,{volumeSeriesID:a.volumeSeriesID,period:r});if(!a)return!1;e=n.prototype.getValues.call(this,a,{period:g[0]});a=n.prototype.getValues.call(this,a,{period:g[1]});if(!e||!a)return!1;g=g[1]-g[0];for(h=0;h<a.yData.length;h++)r=c(e.yData[h+g]-a.yData[h]),d.push([a.xData[h],r]),m.push(a.xData[h]),p.push(r);
return{values:d,xData:m,yData:p}}})})(t,D);(function(d,k){var n=d.isArray,f=d.seriesTypes.ema,b=d.correctFloat;d.seriesType("dema","ema",{},{init:function(){var c=arguments,b=this;k.isParentLoaded(f,"ema",b.type,function(a){a.prototype.init.apply(b,c)})},getEMA:function(c,b,a,g,r,d){return f.prototype.calculateEma(d||[],c,void 0===r?1:r,this.chart.series[0].EMApercent,b,void 0===g?-1:g,a)},getValues:function(c,e){var a=e.period,g=2*a,r=c.xData,d=c.yData,m=d?d.length:0,p=-1,h=[],l=[],z=[],x=0,k,u,
H=[],v,w;c.EMApercent=2/(a+1);if(m<2*a-1)return!1;n(d[0])&&(p=e.index?e.index:0);c=f.prototype.accumulatePeriodPoints(a,p,d);e=c/a;c=0;for(v=a;v<m+2;v++)v<m+1&&(x=this.getEMA(d,u,e,p,v)[1],H.push(x)),u=x,v<g?c+=x:(v===g&&(e=c/a),x=H[v-a-1],k=this.getEMA([x],k,e)[1],w=[r[v-2],b(2*x-k)],h.push(w),l.push(w[0]),z.push(w[1]));return{values:h,xData:l,yData:z}}})})(t,D);(function(d,k){var n=d.isArray,f=d.seriesTypes.ema,b=d.correctFloat;d.seriesType("tema","ema",{},{init:function(){var c=arguments,b=this;
k.isParentLoaded(f,"ema",b.type,function(a){a.prototype.init.apply(b,c)})},getEMA:function(c,b,a,g,r,d){return f.prototype.calculateEma(d||[],c,void 0===r?1:r,this.chart.series[0].EMApercent,b,void 0===g?-1:g,a)},getPoint:function(c,e,a,g){return[c[g-3],b(3*a.level1-3*a.level2+a.level3)]},getValues:function(c,b){var a=b.period,g=2*a,e=3*a,d=c.xData,m=c.yData,p=m?m.length:0,h=-1,l=[],z=[],x=[],k,u,H=[],v=[],w,A,C={};c.EMApercent=2/(a+1);if(p<3*a-2)return!1;n(m[0])&&(h=b.index?b.index:0);c=f.prototype.accumulatePeriodPoints(a,
h,m);b=c/a;c=0;for(w=a;w<p+3;w++)if(w<p+1&&(C.level1=this.getEMA(m,k,b,h,w)[1],H.push(C.level1)),k=C.level1,w<g)c+=C.level1;else if(w===g&&(b=c/a,c=0),C.level1=H[w-a-1],C.level2=this.getEMA([C.level1],u,b)[1],v.push(C.level2),u=C.level2,w<e)c+=C.level2;else{w===e&&(b=c/a);w===p+1&&(C.level1=H[w-a-1],C.level2=this.getEMA([C.level1],u,b)[1],v.push(C.level2));C.level1=H[w-a-2];C.level2=v[w-2*a-1];C.level3=this.getEMA([C.level2],C.prevLevel3,b)[1];if(A=this.getPoint(d,e,C,w))l.push(A),z.push(A[0]),x.push(A[1]);
C.prevLevel3=C.level3}return{values:l,xData:z,yData:x}}})})(t,D);(function(d,k){var n=d.correctFloat,f=d.seriesTypes.tema;d.seriesType("trix","tema",{},{init:function(){var b=arguments,c=this;k.isParentLoaded(f,"tema",c.type,function(e){e.prototype.init.apply(c,b)})},getPoint:function(b,c,e,a){if(a>c)var g=[b[a-3],0!==e.prevLevel3?n(e.level3-e.prevLevel3)/e.prevLevel3*100:null];return g}})})(t,D);(function(d,k){var n=d.seriesTypes.ema,f=d.error;d.seriesType("apo","ema",{params:{periods:[10,20]}},
{nameBase:"APO",nameComponents:["periods"],init:function(){var b=arguments,c=this;k.isParentLoaded(n,"ema",c.type,function(e){e.prototype.init.apply(c,b)})},getValues:function(b,c){var e=c.periods,a=c.index;c=[];var g=[],r=[],d,m;if(2!==e.length||e[1]<=e[0])return f('Error: "APO requires two periods. Notice, first period should be lower than the second one."'),!1;d=n.prototype.getValues.call(this,b,{index:a,period:e[0]});b=n.prototype.getValues.call(this,b,{index:a,period:e[1]});if(!d||!b)return!1;
e=e[1]-e[0];for(m=0;m<b.yData.length;m++)a=d.yData[m+e]-b.yData[m],c.push([b.xData[m],a]),g.push(b.xData[m]),r.push(a);return{values:c,xData:g,yData:r}}})})(t,D);(function(d){function k(a){return a.reduce(function(a,c){return Math.max(a,c[1])},-Infinity)}function n(a){return a.reduce(function(a,c){return Math.min(a,c[2])},Infinity)}function f(a){return{high:k(a),low:n(a)}}function b(c){var b,g,e,l,r;c.series.forEach(function(c){if(c.xData)for(l=c.xData,r=g=c.xIncrement?1:l.length-1;0<r;r--)if(e=l[r]-
l[r-1],b===a||e<b)b=e});return b}function c(a,c,b,e){if(a&&c&&b&&e){var g=c.plotX-a.plotX;c=c.plotY-a.plotY;var l=e.plotX-b.plotX;e=e.plotY-b.plotY;var r=a.plotX-b.plotX,d=a.plotY-b.plotY;b=(-c*r+g*d)/(-l*c+g*e);l=(l*d-e*r)/(-l*c+g*e);if(0<=b&&1>=b&&0<=l&&1>=l)return{plotX:a.plotX+l*g,plotY:a.plotY+l*c}}return!1}function e(a){var c=a.indicator;c.points=a.points;c.nextPoints=a.nextPoints;c.color=a.color;c.options=r(a.options.senkouSpan.styles,a.gap);c.graph=a.graph;c.fillGraph=!0;h.prototype.drawGraph.call(c)}
var a,g=d.seriesType,r=d.merge,q=d.color,m=d.isArray,p=d.defined,h=d.seriesTypes.sma;d.approximations["ichimoku-averages"]=function(){var a=[],c;[].forEach.call(arguments,function(b,e){a.push(d.approximations.average(b));c=!c&&void 0===a[e]});return c?void 0:a};g("ikh","sma",{params:{period:26,periodTenkan:9,periodSenkouSpanB:52},marker:{enabled:!1},tooltip:{pointFormat:'\x3cspan style\x3d"color:{point.color}"\x3e\u25cf\x3c/span\x3e \x3cb\x3e {series.name}\x3c/b\x3e\x3cbr/\x3eTENKAN SEN: {point.tenkanSen:.3f}\x3cbr/\x3eKIJUN SEN: {point.kijunSen:.3f}\x3cbr/\x3eCHIKOU SPAN: {point.chikouSpan:.3f}\x3cbr/\x3eSENKOU SPAN A: {point.senkouSpanA:.3f}\x3cbr/\x3eSENKOU SPAN B: {point.senkouSpanB:.3f}\x3cbr/\x3e'},
tenkanLine:{styles:{lineWidth:1,lineColor:void 0}},kijunLine:{styles:{lineWidth:1,lineColor:void 0}},chikouLine:{styles:{lineWidth:1,lineColor:void 0}},senkouSpanA:{styles:{lineWidth:1,lineColor:void 0}},senkouSpanB:{styles:{lineWidth:1,lineColor:void 0}},senkouSpan:{styles:{fill:"rgba(255, 0, 0, 0.5)"}},dataGrouping:{approximation:"ichimoku-averages"}},{pointArrayMap:["tenkanSen","kijunSen","chikouSpan","senkouSpanA","senkouSpanB"],pointValKey:"tenkanSen",nameComponents:["periodSenkouSpanB","period",
"periodTenkan"],init:function(){h.prototype.init.apply(this,arguments);this.options=r({tenkanLine:{styles:{lineColor:this.color}},kijunLine:{styles:{lineColor:this.color}},chikouLine:{styles:{lineColor:this.color}},senkouSpanA:{styles:{lineColor:this.color,fill:q(this.color).setOpacity(.5).get()}},senkouSpanB:{styles:{lineColor:this.color,fill:q(this.color).setOpacity(.5).get()}},senkouSpan:{styles:{fill:q(this.color).setOpacity(.2).get()}}},this.options)},toYData:function(a){return[a.tenkanSen,a.kijunSen,
a.chikouSpan,a.senkouSpanA,a.senkouSpanB]},translate:function(){var a=this;h.prototype.translate.apply(a);a.points.forEach(function(c){a.pointArrayMap.forEach(function(b){p(c[b])&&(c["plot"+b]=a.yAxis.toPixels(c[b],!0),c.plotY=c["plot"+b],c.tooltipPos=[c.plotX,c["plot"+b]],c.isNull=!1)})})},drawGraph:function(){var a=this,b=a.points,g=b.length,f=a.options,q=a.graph,m=a.color,k={options:{gapSize:f.gapSize}},n=a.pointArrayMap.length,A=[[],[],[],[],[],[]],C={tenkanLine:A[0],kijunLine:A[1],chikouLine:A[2],
senkouSpanA:A[3],senkouSpanB:A[4],senkouSpan:A[5]},t=[],B=a.options.senkouSpan,L=B.color||B.styles.fill,K=B.negativeColor,E=[[],[]],D=[[],[]],F=0,G,I,M,J;for(a.ikhMap=C;g--;){G=b[g];for(I=0;I<n;I++)B=a.pointArrayMap[I],p(G[B])&&A[I].push({plotX:G.plotX,plotY:G["plot"+B],isNull:!1});K&&g!==b.length-1&&(B=C.senkouSpanB.length-1,G=c(C.senkouSpanA[B-1],C.senkouSpanA[B],C.senkouSpanB[B-1],C.senkouSpanB[B]),I={plotX:G.plotX,plotY:G.plotY,isNull:!1,intersectPoint:!0},G&&(C.senkouSpanA.splice(B,0,I),C.senkouSpanB.splice(B,
0,I),t.push(B)))}d.objectEach(C,function(c,b){f[b]&&"senkouSpan"!==b&&(a.points=A[F],a.options=r(f[b].styles,k),a.graph=a["graph"+b],a.fillGraph=!1,a.color=m,h.prototype.drawGraph.call(a),a["graph"+b]=a.graph);F++});a.graphCollection&&a.graphCollection.forEach(function(c){a[c].element.remove();delete a[c]});a.graphCollection=[];if(K&&C.senkouSpanA[0]&&C.senkouSpanB[0]){t.unshift(0);t.push(C.senkouSpanA.length-1);for(n=0;n<t.length-1;n++){B=t[n];G=t[n+1];g=C.senkouSpanB.slice(B,G+1);B=C.senkouSpanA.slice(B,
G+1);if(1<=Math.floor(g.length/2))if(G=Math.floor(g.length/2),g[G].plotY===B[G].plotY){for(J=I=G=0;J<g.length;J++)G+=g[J].plotY,I+=B[J].plotY;G=G>I?0:1}else G=g[G].plotY>B[G].plotY?0:1;else G=g[0].plotY>B[0].plotY?0:1;E[G]=E[G].concat(g);D[G]=D[G].concat(B)}["graphsenkouSpanColor","graphsenkouSpanNegativeColor"].forEach(function(c,b){E[b].length&&D[b].length&&(M=0===b?L:K,e({indicator:a,points:E[b],nextPoints:D[b],color:M,options:f,gap:k,graph:a[c]}),a[c]=a.graph,a.graphCollection.push(c))})}else e({indicator:a,
points:C.senkouSpanB,nextPoints:C.senkouSpanA,color:L,options:f,gap:k,graph:a.graphsenkouSpan}),a.graphsenkouSpan=a.graph;delete a.nextPoints;delete a.fillGraph;a.points=b;a.options=f;a.graph=q},getGraphPath:function(a){var c,b,g=[];a=a||this.points;if(this.fillGraph&&this.nextPoints){b=h.prototype.getGraphPath.call(this,this.nextPoints);b[0]="L";c=h.prototype.getGraphPath.call(this,a);b=b.slice(0,c.length);for(var e=b.length-1;0<e;e-=3)g.push(b[e-2],b[e-1],b[e]);c=c.concat(g)}else c=h.prototype.getGraphPath.apply(this,
arguments);return c},getValues:function(c,g){var e=g.period,r=g.periodTenkan;g=g.periodSenkouSpanB;var d=c.xData,h=c.yData,l=h&&h.length||0;c=b(c.xAxis);var q=[],p=[],z,k,n,t,D,E,F;if(d.length<=e||!m(h[0])||4!==h[0].length)return!1;z=d[0]-e*c;for(E=0;E<e;E++)p.push(z+E*c);for(E=0;E<l;E++)E>=r&&(n=h.slice(E-r,E),n=f(n),n=(n.high+n.low)/2),E>=e&&(t=h.slice(E-e,E),t=f(t),t=(t.high+t.low)/2,F=(n+t)/2),E>=g&&(D=h.slice(E-g,E),D=f(D),D=(D.high+D.low)/2),z=h[E][3],k=d[E],q[E]===a&&(q[E]=[]),q[E+e]===a&&
(q[E+e]=[]),q[E+e][0]=n,q[E+e][1]=t,q[E+e][2]=a,q[E][2]=z,E<=e&&(q[E+e][3]=a,q[E+e][4]=a),q[E+2*e]===a&&(q[E+2*e]=[]),q[E+2*e][3]=F,q[E+2*e][4]=D,p.push(k);for(E=1;E<=e;E++)p.push(k+E*c);return{values:q,xData:p,yData:q}}})})(t);(function(d,k){var n=d.seriesTypes.sma,f=d.seriesTypes.ema,b=d.seriesTypes.atr,c=d.merge,e=d.correctFloat;d.seriesType("keltnerchannels","sma",{params:{period:20,periodATR:10,multiplierATR:2},bottomLine:{styles:{lineWidth:1,lineColor:void 0}},topLine:{styles:{lineWidth:1,lineColor:void 0}},
tooltip:{pointFormat:'\x3cspan style\x3d"color:{point.color}"\x3e\u25cf\x3c/span\x3e\x3cb\x3e {series.name}\x3c/b\x3e\x3cbr/\x3eUpper Channel: {point.top}\x3cbr/\x3eEMA({series.options.params.period}): {point.middle}\x3cbr/\x3eLower Channel: {point.bottom}\x3cbr/\x3e'},marker:{enabled:!1},dataGrouping:{approximation:"averages"},lineWidth:1},c(k,{pointArrayMap:["top","middle","bottom"],pointValKey:"middle",nameBase:"Keltner Channels",nameComponents:["period","periodATR","multiplierATR"],linesApiNames:["topLine",
"bottomLine"],requiredIndicators:["ema","atr"],init:function(){n.prototype.init.apply(this,arguments);this.options=c({topLine:{styles:{lineColor:this.color}},bottomLine:{styles:{lineColor:this.color}}},this.options)},getValues:function(a,c){var g=c.period,d=c.periodATR,m=c.multiplierATR,p=a.yData,p=p?p.length:0,h=[],l,z,k;c=f.prototype.getValues(a,{period:g,index:c.index});var n=b.prototype.getValues(a,{period:d}),u=[],t=[],v;if(p<g)return!1;for(v=g;v<=p;v++)l=c.values[v-g],z=n.values[v-d],k=l[0],
a=e(l[1]+m*z[1]),z=e(l[1]-m*z[1]),l=l[1],h.push([k,a,l,z]),u.push(k),t.push([a,l,z]);return{values:h,xData:u,yData:t}}}))})(t,F);(function(d){var k=d.seriesType,n=d.merge,f=d.defined,b=d.seriesTypes.sma,c=d.seriesTypes.ema,e=d.correctFloat;k("macd","sma",{params:{shortPeriod:12,longPeriod:26,signalPeriod:9,period:26},signalLine:{zones:[],styles:{lineWidth:1,lineColor:void 0}},macdLine:{zones:[],styles:{lineWidth:1,lineColor:void 0}},threshold:0,groupPadding:.1,pointPadding:.1,states:{hover:{halo:{size:0}}},
tooltip:{pointFormat:'\x3cspan style\x3d"color:{point.color}"\x3e\u25cf\x3c/span\x3e \x3cb\x3e {series.name}\x3c/b\x3e\x3cbr/\x3eValue: {point.MACD}\x3cbr/\x3eSignal: {point.signal}\x3cbr/\x3eHistogram: {point.y}\x3cbr/\x3e'},dataGrouping:{approximation:"averages"},minPointLength:0},{nameComponents:["longPeriod","shortPeriod","signalPeriod"],requiredIndicators:["ema"],pointArrayMap:["y","signal","MACD"],parallelArrays:["x","y","signal","MACD"],pointValKey:"y",markerAttribs:d.noop,getColumnMetrics:d.seriesTypes.column.prototype.getColumnMetrics,
crispCol:d.seriesTypes.column.prototype.crispCol,init:function(){b.prototype.init.apply(this,arguments);this.options&&(this.options=n({signalLine:{styles:{lineColor:this.color}},macdLine:{styles:{color:this.color}}},this.options),this.macdZones={zones:this.options.macdLine.zones,startIndex:0},this.signalZones={zones:this.macdZones.zones.concat(this.options.signalLine.zones),startIndex:this.macdZones.zones.length},this.resetZones=!0)},toYData:function(a){return[a.y,a.signal,a.MACD]},translate:function(){var a=
this,c=["plotSignal","plotMACD"];d.seriesTypes.column.prototype.translate.apply(a);a.points.forEach(function(b){[b.signal,b.MACD].forEach(function(e,g){null!==e&&(b[c[g]]=a.yAxis.toPixels(e,!0))})})},destroy:function(){this.graph=null;this.graphmacd=this.graphmacd&&this.graphmacd.destroy();this.graphsignal=this.graphsignal&&this.graphsignal.destroy();b.prototype.destroy.apply(this,arguments)},drawPoints:d.seriesTypes.column.prototype.drawPoints,drawGraph:function(){for(var a=this,c=a.points,e=c.length,
d=a.options,m=a.zones,p={options:{gapSize:d.gapSize}},h=[[],[]],l;e--;)l=c[e],f(l.plotMACD)&&h[0].push({plotX:l.plotX,plotY:l.plotMACD,isNull:!f(l.plotMACD)}),f(l.plotSignal)&&h[1].push({plotX:l.plotX,plotY:l.plotSignal,isNull:!f(l.plotMACD)});["macd","signal"].forEach(function(c,e){a.points=h[e];a.options=n(d[c+"Line"].styles,p);a.graph=a["graph"+c];a.currentLineZone=c+"Zones";a.zones=a[a.currentLineZone].zones;b.prototype.drawGraph.call(a);a["graph"+c]=a.graph});a.points=c;a.options=d;a.zones=m;
a.currentLineZone=null},getZonesGraphs:function(a){var c=b.prototype.getZonesGraphs.call(this,a),e=c;this.currentLineZone&&(e=c.splice(this[this.currentLineZone].startIndex+1),e.length?e.splice(0,0,a[0]):e=[a[0]]);return e},applyZones:function(){var a=this.zones;this.zones=this.signalZones.zones;b.prototype.applyZones.call(this);this.options.macdLine.zones.length&&this.graphmacd.hide();this.zones=a},getValues:function(a,b){var g=0,d=[],m=[],p=[],h,l;if(a.xData.length<b.longPeriod+b.signalPeriod)return!1;
h=c.prototype.getValues(a,{period:b.shortPeriod});l=c.prototype.getValues(a,{period:b.longPeriod});h=h.values;l=l.values;for(a=1;a<=h.length;a++)f(l[a-1])&&f(l[a-1][1])&&f(h[a+b.shortPeriod+1])&&f(h[a+b.shortPeriod+1][0])&&d.push([h[a+b.shortPeriod+1][0],0,null,h[a+b.shortPeriod+1][1]-l[a-1][1]]);for(a=0;a<d.length;a++)m.push(d[a][0]),p.push([0,null,d[a][3]]);b=c.prototype.getValues({xData:m,yData:p},{period:b.signalPeriod,index:2});b=b.values;for(a=0;a<d.length;a++)d[a][0]>=b[0][0]&&(d[a][2]=b[g][1],
p[a]=[0,b[g][1],d[a][3]],null===d[a][3]?(d[a][1]=0,p[a][0]=0):(d[a][1]=e(d[a][3]-b[g][1]),p[a][0]=e(d[a][3]-b[g][1])),g++);return{values:d,xData:m,yData:p}}})})(t);(function(d){function k(b){return b.reduce(function(c,b){return c+b})}function n(b){return(b[1]+b[2]+b[3])/3}var f=d.isArray;d.seriesType("mfi","sma",{params:{period:14,volumeSeriesID:"volume",decimals:4}},{nameBase:"Money Flow Index",getValues:function(b,c){var e=c.period,a=b.xData,g=b.yData,r=g?g.length:0,q=c.decimals,m=1,p=b.chart.get(c.volumeSeriesID),
h=p&&p.yData,l=[],z=[],x=[],y=[],u=[];if(!p)return d.error("Series "+c.volumeSeriesID+" not found! Check `volumeSeriesID`.",!0,b.chart);if(a.length<=e||!f(g[0])||4!==g[0].length||!h)return!1;for(b=n(g[m]);m<e+1;)c=b,b=n(g[m]),c=b>=c,p=b*h[m],y.push(c?p:0),u.push(c?0:p),m++;for(e=m-1;e<r;e++)e>m-1&&(y.shift(),u.shift(),c=b,b=n(g[e]),c=b>c,p=b*h[e],y.push(c?p:0),u.push(c?0:p)),c=k(u),p=k(y),c=p/c,c=parseFloat((100-100/(1+c)).toFixed(q)),l.push([a[e],c]),z.push(a[e]),x.push(c);return{values:l,xData:z,
yData:x}}})})(t);(function(d){function k(d,b,c,e,a){c=c[e-1][3]-c[e-a-1][3];b=b[e-1];d.shift();return[b,c]}var n=d.isArray;d=d.seriesType;d("momentum","sma",{params:{period:14}},{nameBase:"Momentum",getValues:function(d,b){b=b.period;var c=d.xData,e=(d=d.yData)?d.length:0,a=c[0],g=[],r=[],f=[],m,p;if(c.length<=b||!n(d[0]))return!1;m=[[a,d[0][3]]];for(a=b+1;a<e;a++)p=k(m,c,d,a,b,void 0),g.push(p),r.push(p[0]),f.push(p[1]);p=k(m,c,d,a,b,void 0);g.push(p);r.push(p[0]);f.push(p[1]);return{values:g,xData:r,
yData:f}}})})(t);(function(d){var k=d.seriesTypes.atr;d.seriesType("natr","sma",{tooltip:{valueSuffix:"%"}},{requiredIndicators:["atr"],getValues:function(d,f){for(var b=k.prototype.getValues.apply(this,arguments),c=b.values.length,e=f.period-1,a=d.yData,g=0;g<c;g++)b.yData[g]=b.values[g][1]/a[e][3]*100,b.values[g][1]=b.yData[g],e++;return b}})})(t);(function(d){function k(c,e){var a=c.series.pointArrayMap,g=a.length;for(b.prototype.pointClass.prototype[e].call(c);g--;)e="dataLabel"+a[g],c[e]&&c[e].element&&
c[e].destroy(),c[e]=null}var n=d.defined,f=d.isArray,b=d.seriesTypes.sma;d.seriesType("pivotpoints","sma",{params:{period:28,algorithm:"standard"},marker:{enabled:!1},enableMouseTracking:!1,dataLabels:{enabled:!0,format:"{point.pivotLine}"},dataGrouping:{approximation:"averages"}},{nameBase:"Pivot Points",pointArrayMap:"R4 R3 R2 R1 P S1 S2 S3 S4".split(" "),pointValKey:"P",toYData:function(c){return[c.P]},translate:function(){var c=this;b.prototype.translate.apply(c);c.points.forEach(function(b){c.pointArrayMap.forEach(function(a){n(b[a])&&
(b["plot"+a]=c.yAxis.toPixels(b[a],!0))})});c.plotEndPoint=c.xAxis.toPixels(c.endPoint,!0)},getGraphPath:function(c){for(var e=this,a=c.length,g=[[],[],[],[],[],[],[],[],[]],d=[],f=e.plotEndPoint,m=e.pointArrayMap.length,p,h,l;a--;){h=c[a];for(l=0;l<m;l++)p=e.pointArrayMap[l],n(h[p])&&g[l].push({plotX:h.plotX,plotY:h["plot"+p],isNull:!1},{plotX:f,plotY:h["plot"+p],isNull:!1},{plotX:f,plotY:null,isNull:!0});f=h.plotX}g.forEach(function(a){d=d.concat(b.prototype.getGraphPath.call(e,a))});return d},
drawDataLabels:function(){var c=this,e=c.pointArrayMap,a,g,d,f;c.options.dataLabels.enabled&&(g=c.points.length,e.concat([!1]).forEach(function(r,q){for(f=g;f--;)d=c.points[f],r?(d.y=d[r],d.pivotLine=r,d.plotY=d["plot"+r],a=d["dataLabel"+r],q&&(d["dataLabel"+e[q-1]]=d.dataLabel),d.dataLabels||(d.dataLabels=[]),d.dataLabels[0]=d.dataLabel=a=a&&a.element?a:null):d["dataLabel"+e[q-1]]=d.dataLabel;b.prototype.drawDataLabels.apply(c,arguments)}))},getValues:function(c,b){var a=b.period,e=c.xData,d=(c=
c.yData)?c.length:0;b=this[b.algorithm+"Placement"];var q=[],m,p=[],h=[],l,k,n,y;if(e.length<a||!f(c[0])||4!==c[0].length)return!1;for(y=a+1;y<=d+a;y+=a)k=e.slice(y-a-1,y),n=c.slice(y-a-1,y),l=k.length,m=k[l-1],n=this.getPivotAndHLC(n),n=b(n),n=q.push([m].concat(n)),p.push(m),h.push(q[n-1].slice(1));this.endPoint=k[0]+(m-k[0])/l*a;return{values:q,xData:p,yData:h}},getPivotAndHLC:function(c){var b=-Infinity,a=Infinity,d=c[c.length-1][3];c.forEach(function(c){b=Math.max(b,c[1]);a=Math.min(a,c[2])});
return[(b+a+d)/3,b,a,d]},standardPlacement:function(c){var b=c[1]-c[2];return[null,null,c[0]+b,2*c[0]-c[2],c[0],2*c[0]-c[1],c[0]-b,null,null]},camarillaPlacement:function(c){var b=c[1]-c[2];return[c[3]+1.5*b,c[3]+1.25*b,c[3]+1.1666*b,c[3]+1.0833*b,c[0],c[3]-1.0833*b,c[3]-1.1666*b,c[3]-1.25*b,c[3]-1.5*b]},fibonacciPlacement:function(c){var b=c[1]-c[2];return[null,c[0]+b,c[0]+.618*b,c[0]+.382*b,c[0],c[0]-.382*b,c[0]-.618*b,c[0]-b,null]}},{destroyElements:function(){k(this,"destroyElements")},destroy:function(){k(this,
"destroyElements")}})})(t);(function(d,k){var n=d.seriesTypes.ema,f=d.error,b=d.correctFloat;d.seriesType("ppo","ema",{params:{periods:[12,26]}},{nameBase:"PPO",nameComponents:["periods"],init:function(){var b=arguments,e=this;k.isParentLoaded(n,"ema",e.type,function(a){a.prototype.init.apply(e,b)})},getValues:function(c,e){var a=e.periods,d=e.index;e=[];var r=[],q=[],m,p;if(2!==a.length||a[1]<=a[0])return f('Error: "PPO requires two periods. Notice, first period should be lower than the second one."'),
!1;m=n.prototype.getValues.call(this,c,{index:d,period:a[0]});c=n.prototype.getValues.call(this,c,{index:d,period:a[1]});if(!m||!c)return!1;a=a[1]-a[0];for(p=0;p<c.yData.length;p++)d=b((m.yData[p+a]-c.yData[p])/c.yData[p]*100),e.push([c.xData[p],d]),r.push(c.xData[p]),q.push(d);return{values:e,xData:r,yData:q}}})})(t,D);D=function(d){var k=d.reduce;return{minInArray:function(d,f){return k(d,function(b,c){return Math.min(b,c[f])},Number.MAX_VALUE)},maxInArray:function(d,f){return k(d,function(b,c){return Math.max(b,
c[f])},-Number.MAX_VALUE)},getArrayExtremes:function(d,f,b){return k(d,function(c,d){return[Math.min(c[0],d[f]),Math.max(c[1],d[b])]},[Number.MAX_VALUE,-Number.MAX_VALUE])}}}(t);(function(d,k,n){var f=k.getArrayExtremes;k=d.merge;d.seriesType("pc","sma",{params:{period:20},lineWidth:1,topLine:{styles:{lineColor:"#90ed7d",lineWidth:1}},bottomLine:{styles:{lineColor:"#f45b5b",lineWidth:1}},dataGrouping:{approximation:"averages"}},k(n,{pointArrayMap:["top","middle","bottom"],pointValKey:"middle",nameBase:"Price Channel",
nameComponents:["period"],linesApiNames:["topLine","bottomLine"],getValues:function(b,c){c=c.period;var d=b.xData,a=(b=b.yData)?b.length:0,g=[],r,q,m,p,h=[],l=[],k;if(a<c)return!1;for(k=c;k<=a;k++)p=d[k-1],q=b.slice(k-c,k),r=f(q,2,1),q=r[1],m=r[0],r=(q+m)/2,g.push([p,q,r,m]),h.push(p),l.push([q,r,m]);return{values:g,xData:h,yData:l}}}))})(t,D,F);(function(d){var k=d.merge,n=d.isArray,f=d.seriesTypes.sma;d.seriesType("priceenvelopes","sma",{marker:{enabled:!1},tooltip:{pointFormat:'\x3cspan style\x3d"color:{point.color}"\x3e\u25cf\x3c/span\x3e\x3cb\x3e {series.name}\x3c/b\x3e\x3cbr/\x3eTop: {point.top}\x3cbr/\x3eMiddle: {point.middle}\x3cbr/\x3eBottom: {point.bottom}\x3cbr/\x3e'},
params:{period:20,topBand:.1,bottomBand:.1},bottomLine:{styles:{lineWidth:1,lineColor:void 0}},topLine:{styles:{lineWidth:1}},dataGrouping:{approximation:"averages"}},{nameComponents:["period","topBand","bottomBand"],nameBase:"Price envelopes",pointArrayMap:["top","middle","bottom"],parallelArrays:["x","y","top","bottom"],pointValKey:"middle",init:function(){f.prototype.init.apply(this,arguments);this.options=k({topLine:{styles:{lineColor:this.color}},bottomLine:{styles:{lineColor:this.color}}},this.options)},
toYData:function(b){return[b.top,b.middle,b.bottom]},translate:function(){var b=this,c=["plotTop","plotMiddle","plotBottom"];f.prototype.translate.apply(b);b.points.forEach(function(d){[d.top,d.middle,d.bottom].forEach(function(a,e){null!==a&&(d[c[e]]=b.yAxis.toPixels(a,!0))})})},drawGraph:function(){for(var b=this,c=b.points,d=c.length,a=b.options,g=b.graph,r={options:{gapSize:a.gapSize}},q=[[],[]],m;d--;)m=c[d],q[0].push({plotX:m.plotX,plotY:m.plotTop,isNull:m.isNull}),q[1].push({plotX:m.plotX,
plotY:m.plotBottom,isNull:m.isNull});["topLine","bottomLine"].forEach(function(c,d){b.points=q[d];b.options=k(a[c].styles,r);b.graph=b["graph"+c];f.prototype.drawGraph.call(b);b["graph"+c]=b.graph});b.points=c;b.options=a;b.graph=g;f.prototype.drawGraph.call(b)},getValues:function(b,c){var d=c.period,a=c.topBand,g=c.bottomBand,r=b.xData,q=(b=b.yData)?b.length:0,m=[],p,h,l,k,x=[],y=[],u;if(r.length<d||!n(b[0])||4!==b[0].length)return!1;for(u=d;u<=q;u++)k=r.slice(u-d,u),p=b.slice(u-d,u),p=f.prototype.getValues.call(this,
{xData:k,yData:p},c),k=p.xData[0],p=p.yData[0],h=p*(1+a),l=p*(1-g),m.push([k,h,p,l]),x.push(k),y.push([h,p,l]);return{values:m,xData:x,yData:y}}})})(t);(function(d){d.seriesType("psar","sma",{lineWidth:0,marker:{enabled:!0},states:{hover:{lineWidthPlus:0}},params:{initialAccelerationFactor:.02,maxAccelerationFactor:.2,increment:.02,index:2,decimals:4}},{nameComponents:!1,getValues:function(d,n){var f=d.xData;d=d.yData;var b=d[0][1],c=n.maxAccelerationFactor,e=n.increment,a=n.initialAccelerationFactor,
g=d[0][2],r=n.decimals,q=n.index,m=[],p=[],h=[],l=1,k,x,y,u,t,v,w,A;if(q>=d.length)return!1;for(A=0;A<q;A++)b=Math.max(d[A][1],b),g=Math.min(d[A][2],parseFloat(g.toFixed(r)));k=d[A][1]>g?1:-1;n=n.initialAccelerationFactor;x=n*(b-g);m.push([f[q],g]);p.push(f[q]);h.push(parseFloat(g.toFixed(r)));for(A=q+1;A<d.length;A++)q=d[A-1][2],u=d[A-2][2],t=d[A-1][1],v=d[A-2][1],y=d[A][1],w=d[A][2],null!==u&&null!==v&&null!==q&&null!==t&&null!==y&&null!==w&&(g=k===l?1===k?g+x<Math.min(u,q)?g+x:Math.min(u,q):g+
x>Math.max(v,t)?g+x:Math.max(v,t):b,q=1===k?y>b?y:b:w<b?w:b,y=1===l&&w>g||-1===l&&y>g?1:-1,l=y,x=q,w=e,u=c,t=a,n=l===k?1===l&&x>b?n===u?u:parseFloat((n+w).toFixed(2)):-1===l&&x<b?n===u?u:parseFloat((n+w).toFixed(2)):n:t,b=q-g,x=n*b,m.push([f[A],parseFloat(g.toFixed(r))]),p.push(f[A]),h.push(parseFloat(g.toFixed(r))),l=k,k=y,b=q);return{values:m,xData:p,yData:h}}})})(t);(function(d){var k=d.seriesType,n=d.isArray;k("roc","sma",{params:{index:3,period:9}},{nameBase:"Rate of Change",getValues:function(d,
b){var c=b.period,e=d.xData,a=(d=d.yData)?d.length:0,g=[],r=[],f=[],m=-1,p;if(e.length<=c)return!1;n(d[0])&&(m=b.index);for(b=c;b<a;b++)p=0>m?(p=d[b-c])?(d[b]-p)/p*100:null:(p=d[b-c][m])?(d[b][m]-p)/p*100:null,p=[e[b],p],g.push(p),r.push(p[0]),f.push(p[1]);return{values:g,xData:r,yData:f}}})})(t);(function(d){var k=d.isArray;d.seriesType("rsi","sma",{params:{period:14,decimals:4}},{getValues:function(d,f){var b=f.period,c=d.xData,e=(d=d.yData)?d.length:0;f=f.decimals;var a=1,g=[],r=[],q=[],m=0,p=
0,h,l,n;if(c.length<b||!k(d[0])||4!==d[0].length)return!1;for(;a<b;)h=parseFloat((d[a][3]-d[a-1][3]).toFixed(f)),0<h?m+=h:p+=Math.abs(h),a++;l=parseFloat((m/(b-1)).toFixed(f));for(n=parseFloat((p/(b-1)).toFixed(f));a<e;a++)h=parseFloat((d[a][3]-d[a-1][3]).toFixed(f)),0<h?(m=h,p=0):(m=0,p=Math.abs(h)),l=parseFloat(((l*(b-1)+m)/b).toFixed(f)),n=parseFloat(((n*(b-1)+p)/b).toFixed(f)),m=0===n?100:0===l?0:parseFloat((100-100/(1+l/n)).toFixed(f)),g.push([c[a],m]),r.push(c[a]),q.push(m);return{values:g,
xData:r,yData:q}}})})(t);(function(d,k,n){var f=d.merge,b=d.isArray,c=d.seriesTypes.sma,e=k.getArrayExtremes;d.seriesType("stochastic","sma",{params:{periods:[14,3]},marker:{enabled:!1},tooltip:{pointFormat:'\x3cspan style\x3d"color:{point.color}"\x3e\u25cf\x3c/span\x3e\x3cb\x3e {series.name}\x3c/b\x3e\x3cbr/\x3e%K: {point.y}\x3cbr/\x3e%D: {point.smoothed}\x3cbr/\x3e'},smoothedLine:{styles:{lineWidth:1,lineColor:void 0}},dataGrouping:{approximation:"averages"}},d.merge(n,{nameComponents:["periods"],
nameBase:"Stochastic",pointArrayMap:["y","smoothed"],parallelArrays:["x","y","smoothed"],pointValKey:"y",linesApiNames:["smoothedLine"],init:function(){c.prototype.init.apply(this,arguments);this.options=f({smoothedLine:{styles:{lineColor:this.color}}},this.options)},getValues:function(a,d){var g=d.periods[0];d=d.periods[1];var f=a.xData,m=(a=a.yData)?a.length:0,p=[],h=[],l=[],k,n,y=null,u,t;if(m<g||!b(a[0])||4!==a[0].length)return!1;for(t=g-1;t<m;t++)k=a.slice(t-g+1,t+1),u=e(k,2,1),n=u[0],k=a[t][3]-
n,n=u[1]-n,k=k/n*100,h.push(f[t]),l.push([k,null]),t>=g-1+(d-1)&&(y=c.prototype.getValues.call(this,{xData:h.slice(-d),yData:l.slice(-d)},{period:d}),y=y.yData[0]),p.push([f[t],k,y]),l[l.length-1][1]=y;return{values:p,xData:h,yData:l}}}))})(t,D,F);(function(d){function k(a,b,c){return{index:b,close:a.yData[b][c],x:a.xData[b]}}var n=d.seriesTypes.atr,f=d.seriesTypes.sma,b=d.isArray,c=d.merge,e=d.correctFloat;d.seriesType("supertrend","sma",{params:{multiplier:3,period:10},risingTrendColor:"#06B535",
fallingTrendColor:"#F21313",changeTrendLine:{styles:{lineWidth:1,lineColor:"#333333",dashStyle:"LongDash"}}},{nameBase:"Supertrend",nameComponents:["multiplier","period"],requiredIndicators:["atr"],init:function(){var a;f.prototype.init.apply(this,arguments);a=this.options;a.cropThreshold=this.linkedParent.options.cropThreshold-(a.params.period-1)},drawGraph:function(){for(var a=this,b=a.options,e=a.linkedParent,q=e?e.points:[],m=a.points,p=a.graph,h=m.length,l=q.length-h,l=0<l?l:0,n={options:{gapSize:b.gapSize}},
x={top:[],bottom:[],intersect:[]},y={top:{styles:{lineWidth:b.lineWidth,lineColor:b.fallingTrendColor,dashStyle:b.dashStyle}},bottom:{styles:{lineWidth:b.lineWidth,lineColor:b.risingTrendColor,dashStyle:b.dashStyle}},intersect:b.changeTrendLine},u,t,v,w,A,C,D,B;h--;)u=m[h],t=m[h-1],v=q[h-1+l],w=q[h-2+l],A=q[h+l],C=q[h+l+1],D=u.options.color,B={x:u.x,plotX:u.plotX,plotY:u.plotY,isNull:!1},!w&&v&&e.yData[v.index-1]&&(w=k(e,v.index-1,3)),!C&&A&&e.yData[A.index+1]&&(C=k(e,A.index+1,3)),!v&&w&&e.yData[w.index+
1]?v=k(e,w.index+1,3):!v&&A&&e.yData[A.index-1]&&(v=k(e,A.index-1,3)),u&&v&&A&&w&&u.x!==v.x&&(u.x===A.x?(w=v,v=A):u.x===w.x?(v=w,w={close:e.yData[v.index-1][3],x:e.xData[v.index-1]}):C&&u.x===C.x&&(v=C,w=A)),t&&w&&v?(A={x:t.x,plotX:t.plotX,plotY:t.plotY,isNull:!1},u.y>=v.close&&t.y>=w.close?(u.color=D||b.fallingTrendColor,x.top.push(B)):u.y<v.close&&t.y<w.close?(u.color=D||b.risingTrendColor,x.bottom.push(B)):(x.intersect.push(B),x.intersect.push(A),x.intersect.push(c(A,{isNull:!0})),u.y>=v.close&&
t.y<w.close?(u.color=D||b.fallingTrendColor,t.color=D||b.risingTrendColor,x.top.push(B),x.top.push(c(A,{isNull:!0}))):u.y<v.close&&t.y>=w.close&&(u.color=D||b.risingTrendColor,t.color=D||b.fallingTrendColor,x.bottom.push(B),x.bottom.push(c(A,{isNull:!0}))))):v&&(u.y>=v.close?(u.color=D||b.fallingTrendColor,x.top.push(B)):(u.color=D||b.risingTrendColor,x.bottom.push(B)));d.objectEach(x,function(b,d){a.points=b;a.options=c(y[d].styles,n);a.graph=a["graph"+d+"Line"];f.prototype.drawGraph.call(a);a["graph"+
d+"Line"]=a.graph});a.points=m;a.options=b;a.graph=p},getValues:function(a,c){var d=c.period;c=c.multiplier;var g=a.xData,f=a.yData,p=[],h=[],l=[],k=0===d?0:d-1,x,t=[],u=[],D,v,w,A,C,F,B;if(g.length<=d||!b(f[0])||4!==f[0].length||0>d)return!1;a=n.prototype.getValues.call(this,a,{period:d}).yData;for(B=0;B<a.length;B++){F=f[k+B];C=f[k+B-1]||[];v=t[B-1];w=u[B-1];A=l[B-1];0===B&&(v=w=A=0);d=e((F[1]+F[2])/2+c*a[B]);x=e((F[1]+F[2])/2-c*a[B]);t[B]=d<v||C[3]>v?d:v;u[B]=x>w||C[3]<w?x:w;if(A===v&&F[3]<t[B]||
A===w&&F[3]<u[B])D=t[B];else if(A===v&&F[3]>t[B]||A===w&&F[3]>u[B])D=u[B];p.push([g[k+B],D]);h.push(g[k+B]);l.push(D)}return{values:p,xData:h,yData:l}}})})(t);(function(d){var k=Math.abs,n=d.noop,f=d.addEvent,b=d.correctFloat,c=d.seriesType,e=d.seriesTypes.column.prototype;c("vbp","sma",{params:{ranges:12,volumeSeriesID:"volume"},zoneLines:{enabled:!0,styles:{color:"#0A9AC9",dashStyle:"LongDash",lineWidth:1}},volumeDivision:{enabled:!0,styles:{positiveColor:"rgba(144, 237, 125, 0.8)",negativeColor:"rgba(244, 91, 91, 0.8)"}},
animationLimit:1E3,enableMouseTracking:!1,pointPadding:0,zIndex:-1,crisp:!0,dataGrouping:{enabled:!1},dataLabels:{enabled:!0,allowOverlap:!0,verticalAlign:"top",format:"P: {point.volumePos:.2f} | N: {point.volumeNeg:.2f}",padding:0,style:{fontSize:"7px"}}},{nameBase:"Volume by Price",bindTo:{series:!1,eventName:"afterSetExtremes"},calculateOn:"render",markerAttribs:n,drawGraph:n,getColumnMetrics:e.getColumnMetrics,crispCol:e.crispCol,init:function(a){var b,c;d.seriesTypes.sma.prototype.init.apply(this,
arguments);b=this.options.params;c=this.linkedParent;b=a.get(b.volumeSeriesID);this.addCustomEvents(c,b);return this},addCustomEvents:function(a,b){function c(){d.chart.redraw();d.setData([]);d.zoneStarts=[];d.zoneLinesSVG&&(d.zoneLinesSVG.destroy(),delete d.zoneLinesSVG)}var d=this;d.dataEventsToUnbind.push(f(a,"remove",function(){c()}));b&&d.dataEventsToUnbind.push(f(b,"remove",function(){c()}));return d},animate:function(a){var b=this,c={};d.svg&&!a&&(c.translateX=b.yAxis.pos,b.group.animate(c,
d.extend(d.animObject(b.options.animation),{step:function(a,c){b.group.attr({scaleX:Math.max(.001,c.pos)})}})),b.animate=null)},drawPoints:function(){this.options.volumeDivision.enabled&&(this.posNegVolume(!0,!0),e.drawPoints.apply(this,arguments),this.posNegVolume(!1,!1));e.drawPoints.apply(this,arguments)},posNegVolume:function(a,b){var c=b?["positive","negative"]:["negative","positive"],d=this.options.volumeDivision,e=this.points.length,g=[],h=[],f=0,k,n,t,u;a?(this.posWidths=g,this.negWidths=
h):(g=this.posWidths,h=this.negWidths);for(;f<e;f++)u=this.points[f],u[c[0]+"Graphic"]=u.graphic,u.graphic=u[c[1]+"Graphic"],a&&(k=u.shapeArgs.width,n=this.priceZones[f],(t=n.wholeVolumeData)?(g.push(k/t*n.positiveVolumeData),h.push(k/t*n.negativeVolumeData)):(g.push(0),h.push(0))),u.color=b?d.styles.positiveColor:d.styles.negativeColor,u.shapeArgs.width=b?this.posWidths[f]:this.negWidths[f],u.shapeArgs.x=b?u.shapeArgs.x:this.posWidths[f]},translate:function(){var a=this,c=a.options,f=a.chart,q=a.yAxis,
m=q.min,p=a.options.zoneLines,h=a.priceZones,l=0,n,t,y,u,D,v,w,A,C,F;e.translate.apply(a);n=a.points;n.length&&(w=.5>c.pointPadding?c.pointPadding:.1,c=a.volumeDataArray,t=d.arrayMax(c),y=f.plotWidth/2,A=f.plotTop,u=k(q.toPixels(m)-q.toPixels(m+a.rangeStep)),D=k(q.toPixels(m)-q.toPixels(m+a.rangeStep)),w&&(m=k(u*(1-2*w)),l=k((u-m)/2),u=k(m)),n.forEach(function(c,d){C=c.barX=c.plotX=0;F=c.plotY=q.toPixels(h[d].start)-A-(q.reversed?u-D:u)-l;v=b(y*h[d].wholeVolumeData/t);c.pointWidth=v;c.shapeArgs=a.crispCol.apply(a,
[C,F,v,u]);c.volumeNeg=h[d].negativeVolumeData;c.volumePos=h[d].positiveVolumeData;c.volumeAll=h[d].wholeVolumeData}),p.enabled&&a.drawZones(f,q,a.zoneStarts,p.styles))},getValues:function(a,b){var c=a.processedXData,e=a.processedYData,f=this.chart,g=b.ranges,h=[],l=[],k=[],n;if(!a.chart)return d.error("Base series not found! In case it has been removed, add a new one.",!0,f);if(!(n=f.get(b.volumeSeriesID)))return d.error("Series "+b.volumeSeriesID+" not found! Check `volumeSeriesID`.",!0,f);if((b=
d.isArray(e[0]))&&4!==e[0].length)return d.error("Type of "+a.name+" series is different than line, OHLC or candlestick.",!0,f);(this.priceZones=this.specifyZones(b,c,e,g,n)).forEach(function(a,b){h.push([a.x,a.end]);l.push(h[b][0]);k.push(h[b][1])});return{values:h,xData:l,yData:k}},specifyZones:function(a,c,e,f,m){var g;if(a){g=e.length;for(var h=e[0][3],l=h,k=1,r;k<g;k++)r=e[k][3],r<h&&(h=r),r>l&&(l=r);g={min:h,max:l}}else g=!1;g=(h=g)?h.min:d.arrayMin(e);r=h?h.max:d.arrayMax(e);var h=this.zoneStarts=
[],l=[],q=0,k=1,n;if(!g||!r)return this.points.length&&(this.setData([]),this.zoneStarts=[],this.zoneLinesSVG.destroy()),[];n=this.rangeStep=b(r-g)/f;for(h.push(g);q<f-1;q++)h.push(b(h[q]+n));h.push(r);for(f=h.length;k<f;k++)l.push({index:k-1,x:c[0],start:h[k-1],end:h[k]});return this.volumePerZone(a,l,m,c,e)},volumePerZone:function(a,b,c,d,e){var f=this,g=c.processedXData,l=c.processedYData,m=b.length-1,r=e.length;c=l.length;var q,n,t,v,w;k(r-c)&&(d[0]!==g[0]&&l.unshift(0),d[r-1]!==g[c-1]&&l.push(0));
f.volumeDataArray=[];b.forEach(function(b){b.wholeVolumeData=0;b.positiveVolumeData=0;for(w=b.negativeVolumeData=0;w<r;w++)t=n=!1,v=a?e[w][3]:e[w],q=w?a?e[w-1][3]:e[w-1]:v,v<=b.start&&0===b.index&&(n=!0),v>=b.end&&b.index===m&&(t=!0),(v>b.start||n)&&(v<b.end||t)&&(b.wholeVolumeData+=l[w],q>v?b.negativeVolumeData+=l[w]:b.positiveVolumeData+=l[w]);f.volumeDataArray.push(b.wholeVolumeData)});return b},drawZones:function(a,b,c,d){var e=a.renderer,f=this.zoneLinesSVG,g=[],l=a.plotWidth,k=a.plotTop,r;c.forEach(function(c){r=
b.toPixels(c)-k;g=g.concat(a.renderer.crispLine(["M",0,r,"L",l,r],d.lineWidth))});f?f.animate({d:g}):f=this.zoneLinesSVG=e.path(g).attr({"stroke-width":d.lineWidth,stroke:d.color,dashstyle:d.dashStyle,zIndex:this.group.zIndex+.1}).add(this.group)}},{destroy:function(){this.negativeGraphic&&(this.negativeGraphic=this.negativeGraphic.destroy());return d.Point.prototype.destroy.apply(this,arguments)}})})(t);(function(d){var k=d.isArray,n=d.seriesType;n("vwap","sma",{params:{period:30,volumeSeriesID:"volume"}},
{getValues:function(f,b){var c=f.chart,e=f.xData;f=f.yData;var a=b.period,g=!0,r;if(!(r=c.get(b.volumeSeriesID)))return d.error("Series "+b.volumeSeriesID+" not found! Check `volumeSeriesID`.",!0,c);k(f[0])||(g=!1);return this.calculateVWAPValues(g,e,f,r,a)},calculateVWAPValues:function(d,b,c,e,a){var f=e.yData,k=e.xData.length,q=b.length;e=[];var m=[],p=[],h=[],l=[],n,t,y,k=q<=k?q:k;for(y=q=0;q<k;q++)n=d?(c[q][1]+c[q][2]+c[q][3])/3:c[q],n*=f[q],n=y?e[q-1]+n:n,t=y?m[q-1]+f[q]:f[q],e.push(n),m.push(t),
l.push([b[q],n/t]),p.push(l[q][0]),h.push(l[q][1]),y++,y===a&&(y=0);return{values:l,xData:p,yData:h}}})})(t);(function(d,k){var n=d.isArray,f=k.getArrayExtremes;d.seriesType("williamsr","sma",{params:{period:14}},{nameBase:"Williams %R",getValues:function(b,c){c=c.period;var d=b.xData,a=(b=b.yData)?b.length:0,g=[],k=[],q=[],m,p,h,l;if(d.length<c||!n(b[0])||4!==b[0].length)return!1;for(l=c-1;l<a;l++)m=b.slice(l-c+1,l+1),p=f(m,2,1),m=p[0],p=p[1],h=b[l][3],m=(p-h)/(p-m)*-100,d[l]&&(g.push([d[l],m]),
k.push(d[l]),q.push(m));return{values:g,xData:k,yData:q}}})})(t,D);(function(d){function k(b,c){c*=(c+1)/2;return b.reduce(function(b,a,c){return[null,b[1]+a[1]*(c+1)]})[1]/c}function n(b,c,d,a){d=k(b,b.length);c=c[a-1];b.shift();return[c,d]}var f=d.isArray;d=d.seriesType;d("wma","sma",{params:{index:3,period:9}},{getValues:function(b,c){var d=c.period,a=b.xData,g=(b=b.yData)?b.length:0,k=1,q=a[0],m=b[0],p=[],h=[],l=[],t=-1;if(a.length<d)return!1;f(b[0])&&(t=c.index,m=b[0][t]);for(c=[[q,m]];k!==d;)c.push([a[k],
0>t?b[k]:b[k][t]]),k++;for(d=k;d<g;d++)k=n(c,a,b,d),p.push(k),h.push(k[0]),l.push(k[1]),c.push([a[d],0>t?b[d]:b[d][t]]);k=n(c,a,b,d);p.push(k);h.push(k[0]);l.push(k[1]);return{values:p,xData:h,yData:l}}})})(t);(function(d){d=d.seriesType;d("zigzag","sma",{params:{lowIndex:2,highIndex:1,deviation:1}},{nameComponents:["deviation"],nameSuffixes:["%"],nameBase:"Zig Zag",getValues:function(d,n){var f=n.lowIndex,b=n.highIndex,c=n.deviation/100;n=1+c;var e=1-c,c=d.xData,a=d.yData;d=a?a.length:0;var g=[],
k=[],q=[],m,p,h,l,t,x,y=!1,u=!1;if(1>=c.length||d&&(void 0===a[0][f]||void 0===a[0][b]))return!1;l=a[0][f];t=a[0][b];for(m=1;m<d;m++)a[m][f]<=t*e?(g.push([c[0],t]),h=[c[m],a[m][f]],y=x=!0):a[m][b]>=l*n&&(g.push([c[0],l]),h=[c[m],a[m][b]],x=!1,y=!0),y&&(k.push(g[0][0]),q.push(g[0][1]),p=m++,m=d);for(m=p;m<d;m++)x?(a[m][f]<=h[1]&&(h=[c[m],a[m][f]]),a[m][b]>=h[1]*n&&(u=b)):(a[m][b]>=h[1]&&(h=[c[m],a[m][b]]),a[m][f]<=h[1]*e&&(u=f)),!1!==u&&(g.push(h),k.push(h[0]),q.push(h[1]),h=[c[m],a[m][u]],x=!x,u=
!1);f=g.length;0!==f&&g[f-1][0]<c[d-1]&&(g.push(h),k.push(h[0]),q.push(h[1]));return{values:g,xData:k,yData:q}}})})(t);(function(d){var k=d.seriesType,n=d.isArray;k("linearRegression","sma",{params:{xAxisUnit:void 0},tooltip:{valueDecimals:4}},{nameBase:"Linear Regression Indicator",getRegressionLineParameters:function(d,b){var c=this.options.params.index,e=function(a,b){return n(a)?a[b]:a},a=d.reduce(function(a,b){return b+a},0),f=b.reduce(function(a,b){return e(b,c)+a},0),a=a/d.length,f=f/b.length,
k,q,m=0,p=0,h;for(h=0;h<d.length;h++)k=d[h]-a,q=e(b[h],c)-f,m+=k*q,p+=Math.pow(k,2);d=p?m/p:0;return{slope:d,intercept:f-d*a}},getEndPointY:function(d,b){return d.slope*b+d.intercept},transformXData:function(d,b){var c=d[0];return d.map(function(d){return(d-c)/b})},findClosestDistance:function(d){var b,c,e;for(e=1;e<d.length-1;e++)b=d[e]-d[e-1],0<b&&(void 0===c||b<c)&&(c=b);return c},getValues:function(d,b){var c=d.xData;d=d.yData;b=b.period;var e,a,f,k,n={xData:[],yData:[],values:[]},m,p=this.options.params.xAxisUnit||
this.findClosestDistance(c);for(a=b-1;a<=c.length-1;a++)f=a-b+1,k=a+1,m=c[a],e=c.slice(f,k),f=d.slice(f,k),k=this.transformXData(e,p),e=this.getRegressionLineParameters(k,f),f=this.getEndPointY(e,k[k.length-1]),n.values.push({regressionLineParameters:e,x:m,y:f}),n.xData.push(m),n.yData.push(f);return n}});k("linearRegressionSlope","linearRegression",{},{nameBase:"Linear Regression Slope Indicator",getEndPointY:function(d){return d.slope}});k("linearRegressionIntercept","linearRegression",{},{nameBase:"Linear Regression Intercept Indicator",
getEndPointY:function(d){return d.intercept}});k("linearRegressionAngle","linearRegression",{tooltip:{pointFormat:'\x3cspan style\x3d"color:{point.color}"\x3e\u25cf\x3c/span\x3e{series.name}: \x3cb\x3e{point.y}\u00b0\x3c/b\x3e\x3cbr/\x3e'}},{nameBase:"Linear Regression Angle Indicator",slopeToAngle:function(d){return 180/Math.PI*Math.atan(d)},getEndPointY:function(d){return this.slopeToAngle(d.slope)}})})(t);(function(d,k){var n=d.seriesTypes.sma,f=d.merge,b=d.correctFloat;d.seriesType("abands","sma",
{params:{period:20,factor:.001,index:3},lineWidth:1,topLine:{styles:{lineWidth:1}},bottomLine:{styles:{lineWidth:1}},dataGrouping:{approximation:"averages"}},f(k,{pointArrayMap:["top","middle","bottom"],pointValKey:"middle",nameBase:"Acceleration Bands",nameComponents:["period","factor"],linesApiNames:["topLine","bottomLine"],getValues:function(c,d){var a=d.period,e=d.factor;d=d.index;var f=c.xData,k=(c=c.yData)?c.length:0,m=[],p=[],h=[],l,t,x,y,u=[],D=[],v;if(k<a)return!1;for(v=0;v<=k;v++)v<k&&(y=
c[v][2],x=c[v][1],t=e,y=b(x-y)/(b(x+y)/2)*1E3*t,m.push(c[v][1]*b(1+2*y)),p.push(c[v][2]*b(1-2*y))),v>=a&&(y=f.slice(v-a,v),l=c.slice(v-a,v),t=n.prototype.getValues.call(this,{xData:y,yData:m.slice(v-a,v)},{period:a}),x=n.prototype.getValues.call(this,{xData:y,yData:p.slice(v-a,v)},{period:a}),l=n.prototype.getValues.call(this,{xData:y,yData:l},{period:a,index:d}),y=l.xData[0],t=t.yData[0],x=x.yData[0],l=l.yData[0],h.push([y,t,l,x]),u.push(y),D.push([t,l,x]));return{values:h,xData:u,yData:D}}}))})(t,
F)});
//# sourceMappingURL=indicators-all.js.map