/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
var __values = (this && this.__values) || function (o) {
    var m = typeof Symbol === "function" && o[Symbol.iterator], i = 0;
    if (m) return m.call(o);
    return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
};
(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define("tsickle/src/tsickle", ["require", "exports", "path", "source-map", "tsickle/src/decorator_downlevel_transformer", "tsickle/src/decorators", "tsickle/src/enum_transformer", "tsickle/src/fileoverview_comment_transformer", "tsickle/src/googmodule", "tsickle/src/jsdoc", "tsickle/src/modules_manifest", "tsickle/src/rewriter", "tsickle/src/source_map_utils", "tsickle/src/transformer_sourcemap", "tsickle/src/transformer_util", "tsickle/src/type-translator", "tsickle/src/typescript", "tsickle/src/util", "tsickle/src/modules_manifest"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var path = require("path");
    var source_map_1 = require("source-map");
    var decorator_downlevel_transformer_1 = require("tsickle/src/decorator_downlevel_transformer");
    var decorators_1 = require("tsickle/src/decorators");
    var enum_transformer_1 = require("tsickle/src/enum_transformer");
    var fileoverview_comment_transformer_1 = require("tsickle/src/fileoverview_comment_transformer");
    var googmodule = require("tsickle/src/googmodule");
    var jsdoc = require("tsickle/src/jsdoc");
    var modules_manifest_1 = require("tsickle/src/modules_manifest");
    var rewriter_1 = require("tsickle/src/rewriter");
    var source_map_utils_1 = require("tsickle/src/source_map_utils");
    var transformer_sourcemap_1 = require("tsickle/src/transformer_sourcemap");
    var transformer_util_1 = require("tsickle/src/transformer_util");
    var typeTranslator = require("tsickle/src/type-translator");
    var ts = require("tsickle/src/typescript");
    var util_1 = require("tsickle/src/util");
    var modules_manifest_2 = require("tsickle/src/modules_manifest");
    exports.ModulesManifest = modules_manifest_2.ModulesManifest;
    /**
     * The header to be used in generated externs.  This is not included in the
     * output of annotate() because annotate() works one file at a time, and
     * typically you create one externs file from the entire compilation unit.
     */
    exports.EXTERNS_HEADER = "/**\n * @externs\n * @suppress {duplicate,checkTypes}\n */\n// NOTE: generated by tsickle, do not edit.\n";
    /**
     * Symbols that are already declared as externs in Closure, that should
     * be avoided by tsickle's "declare ..." => externs.js conversion.
     */
    exports.closureExternsBlacklist = [
        'exports',
        'global',
        'module',
        // ErrorConstructor is the interface of the Error object itself.
        // tsickle detects that this is part of the TypeScript standard library
        // and assumes it's part of the Closure standard library, but this
        // assumption is wrong for ErrorConstructor.  To properly handle this
        // we'd somehow need to map methods defined on the ErrorConstructor
        // interface into properties on Closure's Error object, but for now it's
        // simpler to just blacklist it.
        'ErrorConstructor',
        'Symbol',
        'WorkerGlobalScope',
    ];
    /** Returns a fileName:line:column string for the given position in the file. */
    function formatLocation(sf, start) {
        // TODO(evanm): remove this, because to be correct it needs a
        // ts.FormatDiagnosticsHost to resolve paths against.
        var res = sf.fileName;
        if (start !== undefined) {
            var _a = sf.getLineAndCharacterOfPosition(start), line = _a.line, character = _a.character;
            res += ':' + (line + 1) + ':' + (character + 1);
        }
        return res;
    }
    /** @return true if node has the specified modifier flag set. */
    function isAmbient(node) {
        var current = node;
        while (current) {
            if (util_1.hasModifierFlag(current, ts.ModifierFlags.Ambient))
                return true;
            current = current.parent;
        }
        return false;
    }
    /**
     * TypeScript allows you to write identifiers quoted, like:
     *   interface Foo {
     *     'bar': string;
     *     'complex name': string;
     *   }
     *   Foo.bar;  // ok
     *   Foo['bar']  // ok
     *   Foo['complex name']  // ok
     *
     * In Closure-land, we want identify that the legal name 'bar' can become an
     * ordinary field, but we need to skip strings like 'complex name'.
     */
    function isValidClosurePropertyName(name) {
        // In local experimentation, it appears that reserved words like 'var' and
        // 'if' are legal JS and still accepted by Closure.
        return /^[a-zA-Z_][a-zA-Z0-9_]*$/.test(name);
    }
    /** Returns the Closure name of a function parameter, special-casing destructuring. */
    function getParameterName(param, index) {
        switch (param.name.kind) {
            case ts.SyntaxKind.Identifier:
                var name_1 = rewriter_1.getIdentifierText(param.name);
                // TypeScript allows parameters named "arguments", but Closure
                // disallows this, even in externs.
                if (name_1 === 'arguments')
                    name_1 = 'tsickle_arguments';
                return name_1;
            case ts.SyntaxKind.ArrayBindingPattern:
            case ts.SyntaxKind.ObjectBindingPattern:
                // Closure crashes if you put a binding pattern in the externs.
                // Avoid this by just generating an unused name; the name is
                // ignored anyway.
                return "__" + index;
            default:
                // The above list of kinds is exhaustive.  param.name is 'never' at this point.
                var paramName = param.name;
                throw new Error("unhandled function parameter kind: " + ts.SyntaxKind[paramName.kind]);
        }
    }
    /** Flags that declare a field of the same name if set on a ctor parameter. */
    var FIELD_DECLARATION_MODIFIERS = ts.ModifierFlags.Private |
        ts.ModifierFlags.Protected | ts.ModifierFlags.Public | ts.ModifierFlags.Readonly;
    /**
     * A Rewriter subclass that adds Tsickle-specific (Closure translation) functionality.
     *
     * One Rewriter subclass manages .ts => .ts+Closure translation.
     * Another Rewriter subclass manages .ts => externs translation.
     */
    var ClosureRewriter = /** @class */ (function (_super) {
        __extends(ClosureRewriter, _super);
        function ClosureRewriter(typeChecker, file, host, sourceMapper) {
            var _this = _super.call(this, file, sourceMapper) || this;
            _this.typeChecker = typeChecker;
            _this.host = host;
            /**
             * A mapping of aliases for symbols in the current file, used when emitting types.
             * TypeScript emits imported symbols with unpredictable prefixes. To generate correct type
             * annotations, tsickle creates its own aliases for types, and registers them in this map (see
             * `emitImportDeclaration` and `forwardDeclare()` below). The aliases are then used when emitting
             * types.
             */
            _this.symbolsToAliasedNames = new Map();
            return _this;
        }
        /** Finds an exported (i.e. not global) declaration for the given symbol. */
        ClosureRewriter.prototype.findExportedDeclaration = function (sym) {
            var _this = this;
            // TODO(martinprobst): it's unclear when a symbol wouldn't have a declaration, maybe just for
            // some builtins (e.g. Symbol)?
            if (!sym.declarations || sym.declarations.length === 0)
                return undefined;
            // A symbol declared in this file does not need to be imported.
            if (sym.declarations.some(function (d) { return d.getSourceFile() === _this.file; }))
                return undefined;
            // Find an exported declaration.
            // Because tsickle runs with the --declaration flag, all types referenced from exported types
            // must be exported, too, so there must either be some declaration that is exported, or the
            // symbol is actually a global declaration (declared in a script file, not a module).
            var decl = sym.declarations.find(function (d) {
                // Check for Export | Default (default being a default export).
                if (!util_1.hasModifierFlag(d, ts.ModifierFlags.ExportDefault))
                    return false;
                // Exclude symbols declared in `declare global {...}` blocks, they are global and don't need
                // imports.
                var current = d;
                while (current) {
                    if (current.flags & ts.NodeFlags.GlobalAugmentation)
                        return false;
                    current = current.parent;
                }
                return true;
            });
            return decl;
        };
        /**
         * Get the ts.Symbol at a location or throw.
         * The TypeScript API can return undefined when fetching a symbol, but
         * in many contexts we know it won't (e.g. our input is already type-checked).
         */
        ClosureRewriter.prototype.mustGetSymbolAtLocation = function (node) {
            var sym = this.typeChecker.getSymbolAtLocation(node);
            if (!sym)
                throw new Error('no symbol');
            return sym;
        };
        /**
         * Handles emittng the jsdoc for methods, including overloads.
         * If overloaded, merges the signatures in the list of SignatureDeclarations into a single jsdoc.
         * - Total number of parameters will be the maximum count found across all variants.
         * - Different names at the same parameter index will be joined with "_or_"
         * - Variable args (...type[] in TypeScript) will be output as "...type",
         *    except if found at the same index as another argument.
         * @param  fnDecls Pass > 1 declaration for overloads of same name
         * @return The list of parameter names that should be used to emit the actual
         *    function statement; for overloads, name will have been merged.
         */
        ClosureRewriter.prototype.emitFunctionType = function (fnDecls, extraTags) {
            if (extraTags === void 0) { extraTags = []; }
            var e_1, _a, e_2, _b, e_3, _c, e_4, _d, e_5, _e;
            var typeChecker = this.typeChecker;
            var newDoc = extraTags;
            var lens = fnDecls.map(function (fnDecl) { return fnDecl.parameters.length; });
            var minArgsCount = Math.min.apply(Math, __spread(lens));
            var maxArgsCount = Math.max.apply(Math, __spread(lens));
            var isConstructor = fnDecls.find(function (d) { return d.kind === ts.SyntaxKind.Constructor; }) !== undefined;
            // For each parameter index i, paramTags[i] is an array of parameters
            // that can be found at index i.  E.g.
            //    function foo(x: string)
            //    function foo(y: number, z: string)
            // then paramTags[0] = [info about x, info about y].
            var paramTags = [];
            var returnTags = [];
            var typeParameterNames = new Set();
            try {
                for (var fnDecls_1 = __values(fnDecls), fnDecls_1_1 = fnDecls_1.next(); !fnDecls_1_1.done; fnDecls_1_1 = fnDecls_1.next()) {
                    var fnDecl = fnDecls_1_1.value;
                    // Construct the JSDoc comment by reading the existing JSDoc, if
                    // any, and merging it with the known types of the function
                    // parameters and return type.
                    var docTags = this.getJSDoc(fnDecl) || [];
                    try {
                        // Copy all the tags other than @param/@return into the new
                        // JSDoc without any change; @param/@return are handled specially.
                        // TODO: there may be problems if an annotation doesn't apply to all overloads;
                        // is it worth checking for this and erroring?
                        for (var docTags_1 = __values(docTags), docTags_1_1 = docTags_1.next(); !docTags_1_1.done; docTags_1_1 = docTags_1.next()) {
                            var tag = docTags_1_1.value;
                            if (tag.tagName === 'param' || tag.tagName === 'return')
                                continue;
                            newDoc.push(tag);
                        }
                    }
                    catch (e_2_1) { e_2 = { error: e_2_1 }; }
                    finally {
                        try {
                            if (docTags_1_1 && !docTags_1_1.done && (_b = docTags_1.return)) _b.call(docTags_1);
                        }
                        finally { if (e_2) throw e_2.error; }
                    }
                    // Add @abstract on "abstract" declarations.
                    if (util_1.hasModifierFlag(fnDecl, ts.ModifierFlags.Abstract)) {
                        newDoc.push({ tagName: 'abstract' });
                    }
                    // Add any @template tags.
                    // Multiple declarations with the same template variable names should work:
                    // the declarations get turned into union types, and Closure Compiler will need
                    // to find a union where all type arguments are satisfied.
                    if (fnDecl.typeParameters) {
                        try {
                            for (var _f = __values(fnDecl.typeParameters), _g = _f.next(); !_g.done; _g = _f.next()) {
                                var tp = _g.value;
                                typeParameterNames.add(rewriter_1.getIdentifierText(tp.name));
                            }
                        }
                        catch (e_3_1) { e_3 = { error: e_3_1 }; }
                        finally {
                            try {
                                if (_g && !_g.done && (_c = _f.return)) _c.call(_f);
                            }
                            finally { if (e_3) throw e_3.error; }
                        }
                    }
                    // Merge the parameters into a single list of merged names and list of types
                    var sig = typeChecker.getSignatureFromDeclaration(fnDecl);
                    if (!sig || !sig.declaration)
                        throw new Error("invalid signature " + fnDecl.name);
                    if (sig.declaration.kind === ts.SyntaxKindJSDocSignature) {
                        throw new Error("JSDoc signature " + fnDecl.name);
                    }
                    for (var i = 0; i < sig.declaration.parameters.length; i++) {
                        var paramNode = sig.declaration.parameters[i];
                        var name_2 = getParameterName(paramNode, i);
                        var isThisParam = name_2 === 'this';
                        var newTag = {
                            tagName: isThisParam ? 'this' : 'param',
                            optional: paramNode.initializer !== undefined || paramNode.questionToken !== undefined,
                            parameterName: isThisParam ? undefined : name_2,
                        };
                        var type = typeChecker.getTypeAtLocation(paramNode);
                        if (paramNode.dotDotDotToken !== undefined) {
                            newTag.restParam = true;
                            // In TypeScript you write "...x: number[]", but in Closure
                            // you don't write the array: "@param {...number} x".  Unwrap
                            // the Array<> wrapper.
                            var typeRef = type;
                            if (!typeRef.typeArguments)
                                throw new Error('invalid rest param');
                            type = typeRef.typeArguments[0];
                        }
                        newTag.type = this.typeToClosure(fnDecl, type);
                        try {
                            for (var docTags_2 = __values(docTags), docTags_2_1 = docTags_2.next(); !docTags_2_1.done; docTags_2_1 = docTags_2.next()) {
                                var _h = docTags_2_1.value, tagName = _h.tagName, parameterName = _h.parameterName, text = _h.text;
                                if (tagName === 'param' && parameterName === newTag.parameterName) {
                                    newTag.text = text;
                                    break;
                                }
                            }
                        }
                        catch (e_4_1) { e_4 = { error: e_4_1 }; }
                        finally {
                            try {
                                if (docTags_2_1 && !docTags_2_1.done && (_d = docTags_2.return)) _d.call(docTags_2);
                            }
                            finally { if (e_4) throw e_4.error; }
                        }
                        if (!paramTags[i])
                            paramTags.push([]);
                        paramTags[i].push(newTag);
                    }
                    // Return type.
                    if (!isConstructor) {
                        var retType = typeChecker.getReturnTypeOfSignature(sig);
                        var retTypeString = this.typeToClosure(fnDecl, retType);
                        var returnDoc = void 0;
                        try {
                            for (var docTags_3 = __values(docTags), docTags_3_1 = docTags_3.next(); !docTags_3_1.done; docTags_3_1 = docTags_3.next()) {
                                var _j = docTags_3_1.value, tagName = _j.tagName, text = _j.text;
                                if (tagName === 'return') {
                                    returnDoc = text;
                                    break;
                                }
                            }
                        }
                        catch (e_5_1) { e_5 = { error: e_5_1 }; }
                        finally {
                            try {
                                if (docTags_3_1 && !docTags_3_1.done && (_e = docTags_3.return)) _e.call(docTags_3);
                            }
                            finally { if (e_5) throw e_5.error; }
                        }
                        returnTags.push({
                            tagName: 'return',
                            type: retTypeString,
                            text: returnDoc,
                        });
                    }
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (fnDecls_1_1 && !fnDecls_1_1.done && (_a = fnDecls_1.return)) _a.call(fnDecls_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
            if (typeParameterNames.size > 0) {
                newDoc.push({ tagName: 'template', text: Array.from(typeParameterNames.values()).join(', ') });
            }
            // Merge the JSDoc tags for each overloaded parameter.
            // Ensure each parameter has a unique name; the merging process can otherwise
            // accidentally generate the same parameter name twice.
            var paramNames = new Set();
            var foundOptional = false;
            for (var i = 0; i < maxArgsCount; i++) {
                var paramTag = jsdoc.merge(paramTags[i]);
                if (paramNames.has(paramTag.parameterName)) {
                    paramTag.parameterName += i.toString();
                }
                paramNames.add(paramTag.parameterName);
                // If the tag is optional, mark parameters following optional as optional,
                // even if they are not, since Closure restricts this, see
                // https://github.com/google/closure-compiler/issues/2314
                if (!paramTag.restParam && (paramTag.optional || foundOptional || i >= minArgsCount)) {
                    foundOptional = true;
                    paramTag.optional = true;
                }
                newDoc.push(paramTag);
                if (paramTag.restParam) {
                    // Cannot have any parameters after a rest param.
                    // Just dump the remaining parameters.
                    break;
                }
            }
            // Merge the JSDoc tags for each overloaded return.
            if (!isConstructor) {
                newDoc.push(jsdoc.merge(returnTags));
            }
            this.emit('\n' + jsdoc.toString(newDoc));
            return newDoc.filter(function (t) { return t.tagName === 'param'; }).map(function (t) { return t.parameterName; });
        };
        /**
         * Returns null if there is no existing comment.
         */
        ClosureRewriter.prototype.getJSDoc = function (node) {
            var text = node.getFullText();
            var comments = ts.getLeadingCommentRanges(text, 0);
            if (!comments || comments.length === 0)
                return null;
            // We need to search backwards for the first JSDoc comment to avoid ignoring such when another
            // code-level comment is between that comment and the function declaration (see
            // testfiles/doc_params for an example).
            var docRelativePos = 0;
            var parsed = null;
            for (var i = comments.length - 1; i >= 0; i--) {
                var _a = comments[i], pos = _a.pos, end = _a.end;
                // end is relative within node.getFullText(), add getFullStart to obtain coordinates that are
                // comparable to node positions.
                var docRelativeEnd = end + node.getFullStart();
                if (docRelativeEnd <= this.file.getStart() &&
                    this.file.text.substring(docRelativeEnd).startsWith('\n\n')) {
                    // This comment is at the very beginning of the file and there's an empty line between the
                    // comment and this node, it's a "detached comment". That means we should treat it as a
                    // file-level comment, not attached to this code node.
                    return null;
                }
                var comment = text.substring(pos, end);
                parsed = jsdoc.parse(comment);
                if (parsed) {
                    docRelativePos = node.getFullStart() + pos;
                    break;
                }
            }
            if (!parsed)
                return null;
            if (parsed.warnings) {
                var start = docRelativePos;
                this.diagnostics.push({
                    file: this.file,
                    start: start,
                    length: node.getStart() - start,
                    messageText: parsed.warnings.join('\n'),
                    category: ts.DiagnosticCategory.Warning,
                    code: 0,
                });
            }
            return parsed.tags;
        };
        ClosureRewriter.prototype.maybeAddTemplateClause = function (docTags, decl) {
            var _this = this;
            if (!decl.typeParameters)
                return;
            // Closure does not support template constraints (T extends X).
            docTags.push({
                tagName: 'template',
                text: decl.typeParameters
                    .map(function (tp) {
                    if (tp.constraint) {
                        _this.emit('\n// unsupported: template constraints.');
                    }
                    return rewriter_1.getIdentifierText(tp.name);
                })
                    .join(', ')
            });
        };
        ClosureRewriter.prototype.maybeAddHeritageClauses = function (docTags, decl) {
            var e_6, _a, e_7, _b;
            if (!decl.heritageClauses)
                return;
            try {
                for (var _c = __values(decl.heritageClauses), _d = _c.next(); !_d.done; _d = _c.next()) {
                    var heritage = _d.value;
                    if (!heritage.types)
                        continue;
                    var isClass = decl.kind === ts.SyntaxKind.ClassDeclaration;
                    if (isClass && heritage.token !== ts.SyntaxKind.ImplementsKeyword && !isAmbient(decl)) {
                        // If a class has "extends Foo", that is preserved in the ES6 output
                        // and we don't need to do anything.  But if it has "implements Foo",
                        // that is a TS-specific thing and we need to translate it to the
                        // the Closure "@implements {Foo}".
                        // However for ambient declarations, we only emit externs, and in those we do need to
                        // add "@extends {Foo}" as they use ES5 syntax.
                        continue;
                    }
                    try {
                        for (var _e = __values(heritage.types), _f = _e.next(); !_f.done; _f = _e.next()) {
                            var impl = _f.value;
                            var tagName = decl.kind === ts.SyntaxKind.InterfaceDeclaration ? 'extends' : 'implements';
                            // We can only @implements an interface, not a class.
                            // But it's fine to translate TS "implements Class" into Closure
                            // "@extends {Class}" because this is just a type hint.
                            var typeChecker = this.typeChecker;
                            var sym = this.typeChecker.getSymbolAtLocation(impl.expression);
                            if (!sym) {
                                // It's possible for a class declaration to extend an expression that
                                // does not have have a symbol, for example when a mixin function is
                                // used to build a base class, as in `declare MyClass extends
                                // MyMixin(MyBaseClass)`.
                                //
                                // Handling this correctly is tricky. Closure throws on this
                                // `extends <expression>` syntax (see
                                // https://github.com/google/closure-compiler/issues/2182). We would
                                // probably need to generate an intermediate class declaration and
                                // extend that. For now, just omit the `extends` annotation.
                                this.debugWarn(decl, "could not resolve supertype: " + impl.getText());
                                docTags.push({
                                    tagName: '',
                                    text: 'NOTE: tsickle could not resolve supertype, ' +
                                        'class definition may be incomplete.\n'
                                });
                                continue;
                            }
                            var alias = sym;
                            if (sym.flags & ts.SymbolFlags.TypeAlias) {
                                // It's implementing a type alias.  Follow the type alias back
                                // to the original symbol to check whether it's a type or a value.
                                var type = this.typeChecker.getDeclaredTypeOfSymbol(sym);
                                if (!type.symbol) {
                                    // It's not clear when this can happen, but if it does all we
                                    // do is fail to emit the @implements, which isn't so harmful.
                                    continue;
                                }
                                alias = type.symbol;
                            }
                            if (alias.flags & ts.SymbolFlags.Alias) {
                                alias = typeChecker.getAliasedSymbol(alias);
                            }
                            var typeTranslator_1 = this.newTypeTranslator(impl.expression);
                            if (typeTranslator_1.isBlackListed(alias)) {
                                continue;
                            }
                            if (alias.flags & ts.SymbolFlags.Class) {
                                if (!isClass) {
                                    // Only classes can extend classes in TS. Ignoring the heritage clause should be safe,
                                    // as interfaces are @record anyway, so should prevent property disambiguation.
                                    // Problem: validate that methods are there?
                                    continue;
                                }
                                tagName = 'extends';
                            }
                            else if (alias.flags & ts.SymbolFlags.Value) {
                                // If the symbol was already in the value namespace, then it will
                                // not be a type in the Closure output (because Closure collapses
                                // the type and value namespaces).  Just ignore the implements.
                                continue;
                            }
                            // typeToClosure includes nullability modifiers, so call symbolToString directly here.
                            docTags.push({ tagName: tagName, type: typeTranslator_1.symbolToString(sym, true) });
                        }
                    }
                    catch (e_7_1) { e_7 = { error: e_7_1 }; }
                    finally {
                        try {
                            if (_f && !_f.done && (_b = _e.return)) _b.call(_e);
                        }
                        finally { if (e_7) throw e_7.error; }
                    }
                }
            }
            catch (e_6_1) { e_6 = { error: e_6_1 }; }
            finally {
                try {
                    if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
                }
                finally { if (e_6) throw e_6.error; }
            }
        };
        /**
         * Emits a type annotation in JSDoc, or {?} if the type is unavailable.
         * @param skipBlacklisted if true, do not emit a type at all for blacklisted types.
         */
        ClosureRewriter.prototype.emitJSDocType = function (node, additionalDocTag, type, skipBlacklisted) {
            if (skipBlacklisted === void 0) { skipBlacklisted = false; }
            if (skipBlacklisted) {
                // Check if the type is blacklisted, and do not emit any @type at all if so.
                type = type || this.typeChecker.getTypeAtLocation(node);
                var sym = type.symbol;
                if (sym) {
                    if (sym.flags & ts.SymbolFlags.Alias) {
                        sym = this.typeChecker.getAliasedSymbol(sym);
                    }
                    var typeTranslator_2 = this.newTypeTranslator(node);
                    if (typeTranslator_2.isBlackListed(sym)) {
                        if (additionalDocTag)
                            this.emit(" /** " + additionalDocTag + " */");
                        return;
                    }
                }
            }
            this.emit(' /**');
            if (additionalDocTag) {
                this.emit(' ' + additionalDocTag);
            }
            this.emit(" @type {" + this.typeToClosure(node, type) + "} */");
        };
        /**
         * Convert a TypeScript ts.Type into the equivalent Closure type.
         *
         * @param context The ts.Node containing the type reference; used for resolving symbols
         *     in context.
         * @param type The type to translate; if not provided, the Node's type will be used.
         * @param resolveAlias If true, do not emit aliases as their symbol, but rather as the resolved
         *     type underlying the alias. This should be true only when emitting the typedef itself.
         */
        ClosureRewriter.prototype.typeToClosure = function (context, type, resolveAlias) {
            if (this.host.untyped) {
                return '?';
            }
            var typeChecker = this.typeChecker;
            if (!type) {
                type = typeChecker.getTypeAtLocation(context);
            }
            return this.newTypeTranslator(context).translate(type, resolveAlias);
        };
        ClosureRewriter.prototype.newTypeTranslator = function (context) {
            var _this = this;
            var translator = new typeTranslator.TypeTranslator(this.typeChecker, context, this.host.typeBlackListPaths, this.symbolsToAliasedNames, function (sym) { return _this.ensureSymbolDeclared(sym); });
            translator.warn = function (msg) { return _this.debugWarn(context, msg); };
            return translator;
        };
        /**
         * debug logs a debug warning.  These should only be used for cases
         * where tsickle is making a questionable judgement about what to do.
         * By default, tsickle does not report any warnings to the caller,
         * and warnings are hidden behind a debug flag, as warnings are only
         * for tsickle to debug itself.
         */
        ClosureRewriter.prototype.debugWarn = function (node, messageText) {
            if (!this.host.logWarning)
                return;
            // Use a ts.Diagnosic so that the warning includes context and file offets.
            var diagnostic = {
                file: this.file,
                start: node.getStart(),
                length: node.getEnd() - node.getStart(),
                messageText: messageText,
                category: ts.DiagnosticCategory.Warning,
                code: 0,
            };
            this.host.logWarning(diagnostic);
        };
        return ClosureRewriter;
    }(rewriter_1.Rewriter));
    /** Annotator translates a .ts to a .ts with Closure annotations. */
    var Annotator = /** @class */ (function (_super) {
        __extends(Annotator, _super);
        function Annotator(typeChecker, file, host, tsHost, tsOpts, sourceMapper) {
            var _this = _super.call(this, typeChecker, file, host, sourceMapper) || this;
            _this.tsHost = tsHost;
            _this.tsOpts = tsOpts;
            /** Exported symbol names that have been generated by expanding an "export * from ...". */
            _this.generatedExports = new Set();
            /** Collection of Identifiers used in an `import {foo}` declaration with their Symbol */
            _this.importedNames = [];
            _this.templateSpanStackCount = 0;
            _this.polymerBehaviorStackCount = 0;
            /**
             * The set of module symbols forward declared in the local namespace (with goog.forwarDeclare).
             *
             * Symbols not imported must be declared, which is done by adding forward declares to
             * `extraImports` below.
             */
            _this.forwardDeclaredModules = new Set();
            _this.extraDeclares = '';
            _this.forwardDeclareCounter = 0;
            return _this;
        }
        Annotator.prototype.annotate = function () {
            this.visit(this.file);
            return this.getOutput(this.extraDeclares);
        };
        Annotator.prototype.ensureSymbolDeclared = function (sym) {
            var decl = this.findExportedDeclaration(sym);
            if (!decl)
                return;
            // Actually import the symbol.
            var sf = decl.getSourceFile();
            var moduleSymbol = this.typeChecker.getSymbolAtLocation(sf);
            if (!moduleSymbol) {
                return; // A source file might not have a symbol if it's not a module (no ES6 im/exports).
            }
            // Already imported?
            if (this.forwardDeclaredModules.has(moduleSymbol))
                return;
            // TODO(martinprobst): this should possibly use fileNameToModuleId.
            var text = this.getForwardDeclareText(sf.fileName, moduleSymbol);
            this.extraDeclares += text;
        };
        Annotator.prototype.getExportDeclarationNames = function (node) {
            var _this = this;
            switch (node.kind) {
                case ts.SyntaxKind.VariableStatement:
                    var varDecl = node;
                    return varDecl.declarationList.declarations.map(function (d) { return _this.getExportDeclarationNames(d)[0]; });
                case ts.SyntaxKind.VariableDeclaration:
                case ts.SyntaxKind.FunctionDeclaration:
                case ts.SyntaxKind.InterfaceDeclaration:
                case ts.SyntaxKind.ClassDeclaration:
                case ts.SyntaxKind.ModuleDeclaration:
                    var decl = node;
                    if (!decl.name || decl.name.kind !== ts.SyntaxKind.Identifier) {
                        break;
                    }
                    return [decl.name];
                case ts.SyntaxKind.TypeAliasDeclaration:
                    var typeAlias = node;
                    return [typeAlias.name];
                default:
                    break;
            }
            this.error(node, "unsupported export declaration " + ts.SyntaxKind[node.kind] + ": " + node.getText());
            return [];
        };
        /**
         * Emits an ES6 export for the ambient declaration behind node, if it is indeed exported.
         */
        Annotator.prototype.maybeEmitAmbientDeclarationExport = function (node) {
            var e_8, _a;
            // In TypeScript, `export declare` simply generates no code in the exporting module, but does
            // generate a regular import in the importing module.
            // For Closure Compiler, such declarations must still be exported, so that importing code in
            // other modules can reference them. Because tsickle generates global symbols for such types,
            // the appropriate semantics are referencing the global name.
            if (this.host.untyped || !util_1.hasModifierFlag(node, ts.ModifierFlags.Export)) {
                return;
            }
            var declNames = this.getExportDeclarationNames(node);
            try {
                for (var declNames_1 = __values(declNames), declNames_1_1 = declNames_1.next(); !declNames_1_1.done; declNames_1_1 = declNames_1.next()) {
                    var decl = declNames_1_1.value;
                    var sym = this.mustGetSymbolAtLocation(decl);
                    var isValue = sym.flags & ts.SymbolFlags.Value;
                    var declName = rewriter_1.getIdentifierText(decl);
                    if (node.kind === ts.SyntaxKind.VariableStatement) {
                        // For variables, TypeScript rewrites every reference to the variable name as an
                        // "exports." access, to maintain mutable ES6 exports semantics. Indirecting through the
                        // window object means we reference the correct global symbol. Closure Compiler does
                        // understand that "var foo" in externs corresponds to "window.foo".
                        this.emit("\nexports." + declName + " = window." + declName + ";\n");
                    }
                    else if (!isValue) {
                        // Do not emit re-exports for ModuleDeclarations.
                        // Ambient ModuleDeclarations are always referenced as global symbols, so they don't need to
                        // be exported.
                        if (node.kind === ts.SyntaxKind.ModuleDeclaration)
                            continue;
                        // Non-value objects do not exist at runtime, so we cannot access the symbol (it only
                        // exists in externs). Export them as a typedef, which forwards to the type in externs.
                        this.emit("\n/** @typedef {!" + declName + "} */\nexports." + declName + ";\n");
                    }
                    else {
                        this.emit("\nexports." + declName + " = " + declName + ";\n");
                    }
                }
            }
            catch (e_8_1) { e_8 = { error: e_8_1 }; }
            finally {
                try {
                    if (declNames_1_1 && !declNames_1_1.done && (_a = declNames_1.return)) _a.call(declNames_1);
                }
                finally { if (e_8) throw e_8.error; }
            }
        };
        /**
         * Examines a ts.Node and decides whether to do special processing of it for output.
         *
         * @return True if the ts.Node has been handled, false if we should
         *     emit it as is and visit its children.
         */
        Annotator.prototype.maybeProcess = function (node) {
            var _this = this;
            if (util_1.hasModifierFlag(node, ts.ModifierFlags.Ambient) || util_1.isDtsFileName(this.file.fileName)) {
                // An ambient declaration declares types for TypeScript's benefit, so we want to skip Tsickle
                // conversion of its contents.
                this.writeRange(node, node.getFullStart(), node.getEnd());
                // ... but it might need to be exported for downstream importing code.
                this.maybeEmitAmbientDeclarationExport(node);
                return true;
            }
            switch (node.kind) {
                case ts.SyntaxKind.SourceFile:
                    this.handleSourceFile(node);
                    return true;
                case ts.SyntaxKind.ImportDeclaration:
                    var importDecl = node;
                    // No need to forward declare side effect imports.
                    if (!importDecl.importClause)
                        break;
                    // Introduce a goog.forwardDeclare for the module, so that if TypeScript does not emit the
                    // module because it's only used in type positions, the JSDoc comments still reference a
                    // valid Closure level symbol.
                    var sym = this.typeChecker.getSymbolAtLocation(importDecl.moduleSpecifier);
                    // modules might not have a symbol if they are unused.
                    if (!sym)
                        break;
                    // Write the export declaration here so that forward declares come after it, and
                    // fileoverview comments do not get moved behind statements.
                    this.writeNode(importDecl);
                    this.forwardDeclare(importDecl.moduleSpecifier, /* default import? */ !!importDecl.importClause.name);
                    this.addSourceMapping(node);
                    return true;
                case ts.SyntaxKind.ExportDeclaration:
                    var exportDecl = node;
                    var exportedSymbols = [];
                    var emittedExport = false;
                    if (!exportDecl.exportClause && exportDecl.moduleSpecifier) {
                        // It's an "export * from ..." statement.
                        // Rewrite it to re-export each exported symbol directly.
                        exportedSymbols = this.expandSymbolsFromExportStar(exportDecl);
                        var exportSymbolsToEmit = exportedSymbols.filter(function (s) { return _this.shouldEmitExportSymbol(s.sym); });
                        this.writeLeadingTrivia(exportDecl);
                        // Only emit the export if any non-type symbols are exported; otherwise it is not needed,
                        // as type only exports are elided by TS anyway.
                        if (exportSymbolsToEmit.length) {
                            emittedExport = true;
                            this.emit('export');
                            this.emit(" {" + exportSymbolsToEmit.map(function (e) { return rewriter_1.unescapeName(e.name); }).join(',') + "}");
                            this.emit(' from ');
                            this.visit(exportDecl.moduleSpecifier);
                            this.emit(';');
                            this.addSourceMapping(exportDecl);
                        }
                    }
                    else {
                        // Write the export declaration here so that forward declares come after it, and
                        // fileoverview comments do not get moved behind statements.
                        emittedExport = true;
                        this.writeNode(exportDecl);
                        if (exportDecl.exportClause) {
                            exportedSymbols = this.getNamedSymbols(exportDecl.exportClause.elements);
                        }
                    }
                    if (emittedExport && exportDecl.moduleSpecifier) {
                        // Only emit the forward declare if we did emit an export - otherwise we might forward
                        // declare a module that's never imported, leading to Closure level missing provides.
                        this.forwardDeclare(exportDecl.moduleSpecifier);
                    }
                    if (exportedSymbols.length) {
                        this.emitTypeDefExports(exportedSymbols);
                    }
                    this.addSourceMapping(node);
                    return true;
                case ts.SyntaxKind.InterfaceDeclaration:
                    this.emitInterface(node);
                    // Emit the TS interface verbatim, with no tsickle processing of properties.
                    this.writeRange(node, node.getFullStart(), node.getEnd());
                    return true;
                case ts.SyntaxKind.ClassDeclaration:
                    var classNode = node;
                    this.visitClassDeclaration(classNode);
                    return true;
                case ts.SyntaxKind.PublicKeyword:
                case ts.SyntaxKind.PrivateKeyword:
                    // The "public"/"private" keywords are encountered in two places:
                    // 1) In class fields (which don't appear in the transformed output).
                    // 2) In "parameter properties", e.g.
                    //      constructor(/** @export */ public foo: string).
                    // In case 2 it's important to not emit that JSDoc in the generated
                    // constructor, as this is illegal for Closure.  It's safe to just
                    // always skip comments preceding the 'public' keyword.
                    // See test_files/parameter_properties.ts.
                    this.writeNode(node, /* skipComments */ true);
                    return true;
                case ts.SyntaxKind.Constructor:
                    var ctor = node;
                    this.emitFunctionType([ctor]);
                    // Write the "constructor(...) {" bit, but iterate through any
                    // parameters if given so that we can examine them more closely.
                    this.writeNodeFrom(ctor, ctor.getStart());
                    return true;
                case ts.SyntaxKind.ArrowFunction:
                    // It's difficult to annotate arrow functions due to a bug in
                    // TypeScript (see tsickle issue 57).  For now, just pass them
                    // through unannotated.
                    return false;
                case ts.SyntaxKind.FunctionDeclaration:
                case ts.SyntaxKind.MethodDeclaration:
                case ts.SyntaxKind.GetAccessor:
                case ts.SyntaxKind.SetAccessor:
                    var fnDecl = node;
                    var tags = decorators_1.hasExportingDecorator(node, this.typeChecker) ? [{ tagName: 'export' }] : [];
                    if (!fnDecl.body) {
                        // Two cases: abstract methods and overloaded methods/functions.
                        // Abstract methods are handled in emitTypeAnnotationsHandler.
                        // Overloads are union-ized into the shared type in emitFunctionType.
                        return false;
                    }
                    this.emitFunctionType([fnDecl], tags);
                    this.newTypeTranslator(fnDecl).blacklistTypeParameters(this.symbolsToAliasedNames, fnDecl.typeParameters);
                    this.writeNodeFrom(fnDecl, fnDecl.getStart());
                    return true;
                case ts.SyntaxKind.TypeAliasDeclaration:
                    this.writeNode(node);
                    this.visitTypeAlias(node);
                    return true;
                case ts.SyntaxKind.TemplateSpan:
                    this.templateSpanStackCount++;
                    this.writeNode(node);
                    this.templateSpanStackCount--;
                    return true;
                case ts.SyntaxKind.TypeAssertionExpression:
                case ts.SyntaxKind.AsExpression:
                    // Both of these cases are AssertionExpressions.
                    var typeAssertion = node;
                    if (this.polymerBehaviorStackCount > 0) {
                        // Don't emit type casts for Polymer behaviors that are declared
                        // by calling the Polymer function
                        // as the Polymer closure plugin does not work when emitting them.
                        // See b/64389806.
                        // Note: This only matters in the transformer version of tsickle,
                        // as the non transformer version never emitted type casts due to
                        // https://github.com/Microsoft/TypeScript/issues/9873 (see below).
                        return false;
                    }
                    // When using a type casts in template expressions,
                    // closure requires another pair of parens, otherwise it will
                    // complain with "Misplaced type annotation. Type annotations are not allowed here."
                    if (this.templateSpanStackCount > 0) {
                        this.emit('(');
                    }
                    this.emitJSDocType(typeAssertion);
                    // When TypeScript emits JS, it removes one layer of "redundant"
                    // parens, but we need them for the Closure type assertion.  Work
                    // around this by using two parens.  See test_files/coerce.*.
                    // This is needed in both, the transformer and non transformer version.
                    // TODO: in the non transformer version, the comment is currently dropped
                    //  alltegether from pure assignments due to
                    //  https://github.com/Microsoft/TypeScript/issues/9873.
                    this.emit('((');
                    this.writeNode(node);
                    this.emit('))');
                    if (this.templateSpanStackCount > 0) {
                        this.emit(')');
                    }
                    return true;
                case ts.SyntaxKind.NonNullExpression:
                    var nnexpr = node;
                    var type = this.typeChecker.getTypeAtLocation(nnexpr.expression);
                    if (type.flags & ts.TypeFlags.Union) {
                        var nonNullUnion = type
                            .types.filter(function (t) { return (t.flags & (ts.TypeFlags.Null | ts.TypeFlags.Undefined)) === 0; });
                        var typeCopy = Object.assign({}, type);
                        typeCopy.types = nonNullUnion;
                        type = typeCopy;
                    }
                    // See comment above.
                    if (this.templateSpanStackCount > 0) {
                        this.emit('(');
                    }
                    this.emitJSDocType(nnexpr, undefined, type);
                    // See comment above.
                    this.emit('((');
                    this.writeNode(nnexpr.expression);
                    this.emit('))');
                    if (this.templateSpanStackCount > 0) {
                        this.emit(')');
                    }
                    return true;
                case ts.SyntaxKind.PropertyDeclaration:
                case ts.SyntaxKind.VariableStatement:
                    var docTags = this.getJSDoc(node) || [];
                    if (decorators_1.hasExportingDecorator(node, this.typeChecker)) {
                        docTags.push({ tagName: 'export' });
                    }
                    if (docTags.length > 0 && node.getFirstToken()) {
                        var isPolymerBehavior = docTags.some(function (t) { return t.tagName === 'polymerBehavior'; });
                        if (isPolymerBehavior) {
                            this.polymerBehaviorStackCount++;
                        }
                        if (ts.isVariableStatement(node)) {
                            this.visitVariableStatement(node, docTags);
                        }
                        else {
                            // Property declaration.
                            this.emit('\n');
                            this.emit(jsdoc.toString(docTags));
                            this.writeNodeFrom(node, node.getStart());
                        }
                        if (isPolymerBehavior) {
                            this.polymerBehaviorStackCount--;
                        }
                        return true;
                    }
                    else if (ts.isVariableStatement(node)) {
                        this.visitVariableStatement(node, docTags);
                        return true;
                    }
                    // Property declaration without doc tags.
                    break;
                case ts.SyntaxKind.PropertyAssignment:
                    var pa = node;
                    if (isPolymerBehaviorPropertyInCallExpression(pa)) {
                        this.polymerBehaviorStackCount++;
                        this.writeNodeFrom(node, node.getStart());
                        this.polymerBehaviorStackCount--;
                        return true;
                    }
                    return false;
                case ts.SyntaxKind.ElementAccessExpression:
                    // Warn for quoted accesses to properties that have a symbol declared.
                    // Mixing quoted and non-quoted access to a symbol (x['foo'] and x.foo) risks breaking
                    // Closure Compiler renaming. Quoted access is more cumbersome to write than dotted access
                    // though, so chances are users did intend to avoid renaming. The better fix is to use
                    // `declare interface` though.
                    var eae = node;
                    if (!eae.argumentExpression ||
                        eae.argumentExpression.kind !== ts.SyntaxKind.StringLiteral) {
                        return false;
                    }
                    var quotedPropSym = this.typeChecker.getSymbolAtLocation(eae.argumentExpression);
                    // If it has a symbol, it's actually a regular declared property.
                    if (!quotedPropSym)
                        return false;
                    var declarationHasQuotes = !quotedPropSym.declarations || quotedPropSym.declarations.some(function (d) {
                        var decl = d;
                        if (!decl.name)
                            return false;
                        return decl.name.kind === ts.SyntaxKind.StringLiteral;
                    });
                    // If the property is declared with quotes, it should also be accessed with them.
                    if (declarationHasQuotes)
                        return false;
                    var propName = eae.argumentExpression.text;
                    // Properties containing non-JS identifier names can only be accessed with quotes.
                    if (!isValidClosurePropertyName(propName))
                        return false;
                    var symName = this.typeChecker.symbolToString(quotedPropSym);
                    this.debugWarn(eae, "Declared property " + symName + " accessed with quotes. " +
                        "This can lead to renaming bugs. A better fix is to use 'declare interface' " +
                        "on the declaration.");
                    // Previously, the code below changed the quoted into a non-quoted access.
                    // this.writeNode(eae.expression);
                    // this.emit(`.${propName}`);
                    return false;
                case ts.SyntaxKind.PropertyAccessExpression:
                    if (this.host.disableAutoQuoting) {
                        return false;
                    }
                    // Convert dotted accesses to types that have an index type declared to quoted accesses, to
                    // avoid Closure renaming one access but not the other.
                    // This can happen because TS allows dotted access to string index types.
                    var pae = node;
                    var t = this.typeChecker.getTypeAtLocation(pae.expression);
                    if (!t.getStringIndexType())
                        return false;
                    // Types can have string index signatures and declared properties (of the matching type).
                    // These properties have a symbol, as opposed to pure string index types.
                    var propSym = this.typeChecker.getSymbolAtLocation(pae.name);
                    // The decision to return below is a judgement call. Presumably, in most situations, dotted
                    // access to a property is correct, and should not be turned into quoted access even if
                    // there is a string index on the type. However it is possible to construct programs where
                    // this is incorrect, e.g. where user code assigns into a property through the index access
                    // in another location.
                    if (propSym)
                        return false;
                    this.debugWarn(pae, this.typeChecker.typeToString(t) +
                        " has a string index type but is accessed using dotted access. " +
                        "Quoting the access.");
                    this.writeNode(pae.expression);
                    this.emit('["');
                    this.writeNode(pae.name);
                    this.emit('"]');
                    return true;
                default:
                    break;
            }
            return false;
        };
        Annotator.prototype.shouldEmitExportSymbol = function (sym) {
            if (sym.flags & ts.SymbolFlags.Alias) {
                sym = this.typeChecker.getAliasedSymbol(sym);
            }
            if ((sym.flags & ts.SymbolFlags.Value) === 0) {
                // Note: We create explicit reexports via closure at another place in
                return false;
            }
            if (!this.tsOpts.preserveConstEnums && sym.flags & ts.SymbolFlags.ConstEnum) {
                return false;
            }
            return true;
        };
        Annotator.prototype.handleSourceFile = function (sf) {
            // Emit leading detached comments: comments separated by a \n\n from the document.
            // While handlers below generally emit comments preceding them, not all of them do in all
            // situations (e.g. JSDoc preceding a class).
            // This is symmetric with `getJSDoc` below not returning detached file level comments.
            var comments = ts.getLeadingCommentRanges(sf.text, 0) || [];
            var start = sf.getFullStart();
            for (var i = comments.length - 1; i >= 0; i--) {
                if (sf.text.substring(comments[i].end, comments[i].end + 2) === '\n\n') {
                    this.emit(sf.text.substring(0, comments[i].end + 2));
                    start = comments[i].end + 2;
                    break;
                }
            }
            this.writeNodeFrom(sf, start);
        };
        /**
         * Given a "export * from ..." statement, gathers the symbol names it actually
         * exports to be used in a statement like "export {foo, bar, baz} from ...".
         *
         * This is necessary because TS transpiles "export *" by just doing a runtime loop
         * over the target module's exports, which means Closure won't see the declarations/types
         * that are exported.
         */
        Annotator.prototype.expandSymbolsFromExportStar = function (exportDecl) {
            var e_9, _a;
            // You can't have an "export *" without a module specifier.
            var moduleSpecifier = exportDecl.moduleSpecifier;
            // Gather the names of local exports, to avoid reexporting any
            // names that are already locally exported.
            var moduleSymbol = this.typeChecker.getSymbolAtLocation(this.file);
            var moduleExports = moduleSymbol && moduleSymbol.exports || new Map();
            // Expand the export list, then filter it to the symbols we want to reexport.
            var exports = this.typeChecker.getExportsOfModule(this.mustGetSymbolAtLocation(moduleSpecifier));
            var reexports = new Set();
            try {
                for (var exports_1 = __values(exports), exports_1_1 = exports_1.next(); !exports_1_1.done; exports_1_1 = exports_1.next()) {
                    var sym = exports_1_1.value;
                    var name_3 = rewriter_1.unescapeName(sym.name);
                    if (moduleExports instanceof Map) {
                        if (moduleExports.has(name_3)) {
                            // This name is shadowed by a local definition, such as:
                            // - export var foo ...
                            // - export {foo} from ...
                            // - export {bar as foo} from ...
                            continue;
                        }
                    }
                    else {
                        // TODO(#634): check if this is a safe cast.
                        if (moduleExports.has(name_3))
                            continue;
                    }
                    if (this.generatedExports.has(name_3)) {
                        // Already exported via an earlier expansion of an "export * from ...".
                        continue;
                    }
                    this.generatedExports.add(name_3);
                    reexports.add(sym);
                }
            }
            catch (e_9_1) { e_9 = { error: e_9_1 }; }
            finally {
                try {
                    if (exports_1_1 && !exports_1_1.done && (_a = exports_1.return)) _a.call(exports_1);
                }
                finally { if (e_9) throw e_9.error; }
            }
            return Array.from(reexports.keys()).map(function (sym) {
                return { name: sym.name, sym: sym };
            });
        };
        /**
         * Write an `exports.` assignment for each type alias exported in the given `exports`.
         * TypeScript by itself does not export non-value symbols (e.g. interfaces, typedefs), as it
         * expects to remove those entirely for runtime. For Closure, types must be
         * exported as downstream code will import the type.
         *
         * The tsickle pass turns interfaces into values by generating a `function MyInterface() {}` for
         * them, so in the second conversion pass, TypeScript does export a value for them. However for
         * pure typedefs, tsickle only generates a property access with a JSDoc comment, so they need to
         * be exported explicitly here.
         */
        Annotator.prototype.emitTypeDefExports = function (exports) {
            var e_10, _a;
            if (this.host.untyped)
                return;
            try {
                for (var exports_2 = __values(exports), exports_2_1 = exports_2.next(); !exports_2_1.done; exports_2_1 = exports_2.next()) {
                    var exp = exports_2_1.value;
                    if (exp.sym.flags & ts.SymbolFlags.Alias) {
                        exp.sym = this.typeChecker.getAliasedSymbol(exp.sym);
                    }
                    var isTypeAlias = ((exp.sym.flags & ts.SymbolFlags.TypeAlias) !== 0 &&
                        (exp.sym.flags & ts.SymbolFlags.Value) === 0) ||
                        (exp.sym.flags & ts.SymbolFlags.Interface) !== 0 &&
                            (exp.sym.flags & ts.SymbolFlags.Value) === 0;
                    if (!isTypeAlias)
                        continue;
                    var typeName = this.symbolsToAliasedNames.get(exp.sym) || exp.sym.name;
                    // Leading newline prevents the typedef from being swallowed.
                    this.emit("\n/** @typedef {!" + typeName + "} */\nexports." + exp.name + "; // re-export typedef\n");
                }
            }
            catch (e_10_1) { e_10 = { error: e_10_1 }; }
            finally {
                try {
                    if (exports_2_1 && !exports_2_1.done && (_a = exports_2.return)) _a.call(exports_2);
                }
                finally { if (e_10) throw e_10.error; }
            }
        };
        Annotator.prototype.getNamedSymbols = function (specifiers) {
            var _this = this;
            return specifiers.map(function (e) {
                return {
                    // e.name might be renaming symbol as in `export {Foo as Bar}`, where e.name would be 'Bar'
                    // and != sym.name. Store away the name so forwardDeclare below can emit the right name.
                    name: rewriter_1.getIdentifierText(e.name),
                    sym: _this.mustGetSymbolAtLocation(e.name),
                };
            });
        };
        /**
         * Emits a `goog.forwardDeclare` alias for each symbol from the given list.
         * @param specifier the import specifier, i.e. module path ("from '...'").
         */
        Annotator.prototype.forwardDeclare = function (specifier, isDefaultImport) {
            if (isDefaultImport === void 0) { isDefaultImport = false; }
            var importPath = googmodule.resolveIndexShorthand({ options: this.tsOpts, host: this.tsHost }, this.file.fileName, specifier.text);
            var moduleSymbol = this.typeChecker.getSymbolAtLocation(specifier);
            this.emit(this.getForwardDeclareText(importPath, moduleSymbol, isDefaultImport));
        };
        /**
         * Returns the `const x = goog.forwardDeclare...` text for an import of the given `importPath`.
         * This also registers aliases for symbols from the module that map to this forward declare.
         */
        Annotator.prototype.getForwardDeclareText = function (importPath, moduleSymbol, isDefaultImport) {
            var _this = this;
            if (isDefaultImport === void 0) { isDefaultImport = false; }
            var e_11, _a;
            if (this.host.untyped)
                return '';
            var nsImport = googmodule.extractGoogNamespaceImport(importPath);
            var forwardDeclarePrefix = "tsickle_forward_declare_" + ++this.forwardDeclareCounter;
            var moduleNamespace = nsImport !== null ? nsImport : this.host.pathToModuleName(this.file.fileName, importPath);
            // In TypeScript, importing a module for use in a type annotation does not cause a runtime load.
            // In Closure Compiler, goog.require'ing a module causes a runtime load, so emitting requires
            // here would cause a change in load order, which is observable (and can lead to errors).
            // Instead, goog.forwardDeclare types, which allows using them in type annotations without
            // causing a load. See below for the exception to the rule.
            var emitText = "const " + forwardDeclarePrefix + " = goog.forwardDeclare(\"" + moduleNamespace + "\");\n";
            // Scripts do not have a symbol. Scripts can still be imported, either as side effect imports or
            // with an empty import set ("{}"). TypeScript does not emit a runtime load for an import with
            // an empty list of symbols, but the import forces any global declarations from the library to
            // be visible, which is what users use this for. No symbols from the script need forward
            // declaration, so just return.
            if (!moduleSymbol)
                return '';
            this.forwardDeclaredModules.add(moduleSymbol);
            var exports = this.typeChecker.getExportsOfModule(moduleSymbol).map(function (e) {
                if (e.flags & ts.SymbolFlags.Alias) {
                    e = _this.typeChecker.getAliasedSymbol(e);
                }
                return e;
            });
            var hasValues = exports.some(function (e) {
                var isValue = (e.flags & ts.SymbolFlags.Value) !== 0;
                var isConstEnum = (e.flags & ts.SymbolFlags.ConstEnum) !== 0;
                // const enums are inlined by TypeScript (if preserveConstEnums=false), so there is never a
                // value import generated for them. That means for the purpose of force-importing modules,
                // they do not count as values. If preserveConstEnums=true, this shouldn't hurt.
                return isValue && !isConstEnum;
            });
            if (!hasValues) {
                // Closure Compiler's toolchain will drop files that are never goog.require'd *before* type
                // checking (e.g. when using --closure_entry_point or similar tools). This causes errors
                // complaining about values not matching 'NoResolvedType', or modules not having a certain
                // member.
                // To fix, explicitly goog.require() modules that only export types. This should usually not
                // cause breakages due to load order (as no symbols are accessible from the module - though
                // contrived code could observe changes in side effects).
                // This is a heuristic - if the module exports some values, but those are never imported,
                // the file will still end up not being imported. Hopefully modules that export values are
                // imported for their value in some place.
                emitText += "goog.require(\"" + moduleNamespace + "\"); // force type-only module to be loaded\n";
            }
            try {
                for (var exports_3 = __values(exports), exports_3_1 = exports_3.next(); !exports_3_1.done; exports_3_1 = exports_3.next()) {
                    var sym = exports_3_1.value;
                    // tsickle does not emit exports for ambient namespace declarations:
                    //    "export declare namespace {...}"
                    // So tsickle must not introduce aliases for them that point to the imported module, as those
                    // then don't resolve in Closure Compiler.
                    if (!sym.declarations ||
                        !sym.declarations.some(function (d) { return d.kind !== ts.SyntaxKind.ModuleDeclaration || !isAmbient(d); })) {
                        continue;
                    }
                    // goog: imports don't actually use the .default property that TS thinks they have.
                    var qualifiedName = nsImport && isDefaultImport ? forwardDeclarePrefix :
                        forwardDeclarePrefix + '.' + sym.name;
                    this.symbolsToAliasedNames.set(sym, qualifiedName);
                }
            }
            catch (e_11_1) { e_11 = { error: e_11_1 }; }
            finally {
                try {
                    if (exports_3_1 && !exports_3_1.done && (_a = exports_3.return)) _a.call(exports_3);
                }
                finally { if (e_11) throw e_11.error; }
            }
            return emitText;
        };
        /** Emits a variable statement per declaration in this variable statement, duplicating JSDoc. */
        Annotator.prototype.visitVariableStatement = function (varStmt, docTags) {
            var e_12, _a;
            // Previously tsickle would emit inline types (`var /** @type {string} */ x;`), but TypeScript's
            // emit strips those comments for exports. Instead, break up the variable declaration list into
            // separate variable statements, each with a leading (not inline) comment.
            var keyword = varStmt.declarationList.getFirstToken().getText();
            var additionalTags = jsdoc.toStringWithoutStartEnd(docTags, jsdoc.TAGS_CONFLICTING_WITH_TYPE);
            try {
                for (var _b = __values(varStmt.declarationList.declarations), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var decl = _c.value;
                    this.emit('\n');
                    this.addSourceMapping(decl);
                    // Only emit a type for plain identifiers. Binding patterns have no type syntax in Closure
                    // Compiler, and TypeScript 2.6 crashes on "getTypeAtLocation(bindingpattern)". By omitting a
                    // type altogether, there is a chance Closure Compiler infers the correct type.
                    if (ts.isIdentifier(decl.name)) {
                        // Don't emit type annotation when the variable statement is a @polymerBehavior, as
                        // otherwise the polymer closure checker will fail. See b/64389806.
                        if (this.polymerBehaviorStackCount === 0) {
                            // Skip emitting a JSDoc type for blacklisted types if and only if this variable is
                            // initialized (and thus probably type inferred).
                            var hasInitializer = !!decl.initializer;
                            this.emitJSDocType(decl, additionalTags, /*type=*/ undefined, /*skipBlacklisted=*/ hasInitializer);
                        }
                        else {
                            this.emit("/**" + additionalTags + "*/");
                        }
                    }
                    this.emit('\n');
                    var finishMapping = this.startSourceMapping(varStmt);
                    if (util_1.hasModifierFlag(varStmt, ts.ModifierFlags.Export))
                        this.emit('export ');
                    this.addSourceMapping(decl);
                    this.emit(keyword);
                    this.visit(decl.name);
                    if (decl.initializer) {
                        this.emit(' = ');
                        this.visit(decl.initializer);
                    }
                    this.emit(';');
                    finishMapping();
                }
            }
            catch (e_12_1) { e_12 = { error: e_12_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_12) throw e_12.error; }
            }
        };
        Annotator.prototype.visitClassDeclaration = function (classDecl) {
            this.addSourceMapping(classDecl);
            var docTags = this.getJSDoc(classDecl) || [];
            if (util_1.hasModifierFlag(classDecl, ts.ModifierFlags.Abstract)) {
                docTags.push({ tagName: 'abstract' });
            }
            this.maybeAddTemplateClause(docTags, classDecl);
            if (!this.host.untyped) {
                this.maybeAddHeritageClauses(docTags, classDecl);
            }
            this.emit('\n');
            if (docTags.length > 0)
                this.emit(jsdoc.toString(docTags));
            // this.writeNode(classDecl, true /*skipComments*/);
            this.writeNodeFrom(classDecl, classDecl.getStart(), classDecl.getEnd());
            this.emitMemberTypes(classDecl);
            return true;
        };
        Annotator.prototype.emitInterface = function (iface) {
            var e_13, _a;
            // If this symbol is both a type and a value, we cannot emit both into Closure's
            // single namespace.
            var sym = this.mustGetSymbolAtLocation(iface.name);
            if (sym.flags & ts.SymbolFlags.Value)
                return;
            var docTags = this.getJSDoc(iface) || [];
            docTags.push({ tagName: 'record' });
            this.maybeAddTemplateClause(docTags, iface);
            if (!this.host.untyped) {
                this.maybeAddHeritageClauses(docTags, iface);
            }
            this.emit('\n');
            this.emit(jsdoc.toString(docTags));
            if (util_1.hasModifierFlag(iface, ts.ModifierFlags.Export))
                this.emit('export ');
            var name = rewriter_1.getIdentifierText(iface.name);
            this.emit("function " + name + "() {}\n");
            var memberNamespace = [name, 'prototype'];
            try {
                for (var _b = __values(iface.members), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var elem = _c.value;
                    var isOptional = elem.questionToken != null;
                    this.visitProperty(memberNamespace, elem, isOptional);
                }
            }
            catch (e_13_1) { e_13 = { error: e_13_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_13) throw e_13.error; }
            }
        };
        /**
         * emitMemberTypes emits the type annotations for members of a class.
         * It's necessary in the case where TypeScript syntax specifies
         * there are additional properties on the class, because to declare
         * these in Closure you must declare these separately from the class.
         */
        Annotator.prototype.emitMemberTypes = function (classDecl) {
            var _this = this;
            var e_14, _a, e_15, _b;
            // Gather parameter properties from the constructor, if it exists.
            var ctors = [];
            var paramProps = [];
            var nonStaticProps = [];
            var staticProps = [];
            var abstractMethods = [];
            try {
                for (var _c = __values(classDecl.members), _d = _c.next(); !_d.done; _d = _c.next()) {
                    var member = _d.value;
                    if (member.kind === ts.SyntaxKind.Constructor) {
                        ctors.push(member);
                    }
                    else if (member.kind === ts.SyntaxKind.PropertyDeclaration) {
                        var prop = member;
                        var isStatic = util_1.hasModifierFlag(prop, ts.ModifierFlags.Static);
                        if (isStatic) {
                            staticProps.push(prop);
                        }
                        else {
                            nonStaticProps.push(prop);
                        }
                    }
                    else if (util_1.hasModifierFlag(member, ts.ModifierFlags.Abstract) &&
                        (member.kind === ts.SyntaxKind.MethodDeclaration ||
                            member.kind === ts.SyntaxKind.GetAccessor ||
                            member.kind === ts.SyntaxKind.SetAccessor)) {
                        abstractMethods.push(member);
                    }
                }
            }
            catch (e_14_1) { e_14 = { error: e_14_1 }; }
            finally {
                try {
                    if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
                }
                finally { if (e_14) throw e_14.error; }
            }
            if (ctors.length > 0) {
                var ctor = ctors[0];
                paramProps = ctor.parameters.filter(function (p) { return util_1.hasModifierFlag(p, FIELD_DECLARATION_MODIFIERS); });
            }
            if (nonStaticProps.length === 0 && paramProps.length === 0 && staticProps.length === 0 &&
                abstractMethods.length === 0) {
                // There are no members so we don't need to emit any type
                // annotations helper.
                return;
            }
            if (!classDecl.name)
                return;
            var className = rewriter_1.getIdentifierText(classDecl.name);
            // See test_files/fields/fields.ts:BaseThatThrows for a note on this wrapper.
            this.emit("\n\nif (false) {");
            staticProps.forEach(function (p) { return _this.visitProperty([className], p); });
            var memberNamespace = [className, 'prototype'];
            nonStaticProps.forEach(function (p) { return _this.visitProperty(memberNamespace, p); });
            paramProps.forEach(function (p) { return _this.visitProperty(memberNamespace, p); });
            try {
                for (var abstractMethods_1 = __values(abstractMethods), abstractMethods_1_1 = abstractMethods_1.next(); !abstractMethods_1_1.done; abstractMethods_1_1 = abstractMethods_1.next()) {
                    var fnDecl = abstractMethods_1_1.value;
                    var name_4 = this.propertyName(fnDecl);
                    if (!name_4) {
                        this.error(fnDecl, 'anonymous abstract function');
                        continue;
                    }
                    var tags = decorators_1.hasExportingDecorator(fnDecl, this.typeChecker) ? [{ tagName: 'export' }] : [];
                    var paramNames = this.emitFunctionType([fnDecl], tags);
                    // memberNamespace because abstract methods cannot be static in TypeScript.
                    this.emit(memberNamespace.join('.') + "." + name_4 + " = function(" + paramNames.join(', ') + ") {};\n");
                }
            }
            catch (e_15_1) { e_15 = { error: e_15_1 }; }
            finally {
                try {
                    if (abstractMethods_1_1 && !abstractMethods_1_1.done && (_b = abstractMethods_1.return)) _b.call(abstractMethods_1);
                }
                finally { if (e_15) throw e_15.error; }
            }
            this.emit("}\n");
        };
        Annotator.prototype.propertyName = function (prop) {
            if (!prop.name)
                return null;
            switch (prop.name.kind) {
                case ts.SyntaxKind.Identifier:
                    return rewriter_1.getIdentifierText(prop.name);
                case ts.SyntaxKind.StringLiteral:
                    // E.g. interface Foo { 'bar': number; }
                    // If 'bar' is a name that is not valid in Closure then there's nothing we can do.
                    var text = prop.name.text;
                    if (!isValidClosurePropertyName(text))
                        return null;
                    return text;
                default:
                    return null;
            }
        };
        /**
         * @param optional If true, property is optional (e.g. written "foo?: string").
         */
        Annotator.prototype.visitProperty = function (namespace, prop, optional) {
            if (optional === void 0) { optional = false; }
            var name = this.propertyName(prop);
            if (!name) {
                this.emit("/* TODO: handle strange member:\n" + this.escapeForComment(prop.getText()) + "\n*/\n");
                return;
            }
            var type = this.typeToClosure(prop);
            // When a property is optional, e.g.
            //   foo?: string;
            // Then the TypeScript type of the property is string|undefined, the
            // typeToClosure translation handles it correctly, and string|undefined is
            // how you write an optional property in Closure.
            //
            // But in the special case of an optional property with type any:
            //   foo?: any;
            // The TypeScript type of the property is just "any" (because any includes
            // undefined as well) so our default translation of the type is just "?".
            // To mark the property as optional in Closure it must have "|undefined",
            // so the Closure type must be ?|undefined.
            if (optional && type === '?')
                type += '|undefined';
            var tags = this.getJSDoc(prop) || [];
            tags.push({ tagName: 'type', type: type });
            if (decorators_1.hasExportingDecorator(prop, this.typeChecker)) {
                tags.push({ tagName: 'export' });
            }
            // Avoid printing annotations that can conflict with @type
            // This avoids Closure's error "type annotation incompatible with other annotations"
            this.emit(jsdoc.toString(tags, jsdoc.TAGS_CONFLICTING_WITH_TYPE));
            namespace = namespace.concat([name]);
            this.emit(namespace.join('.') + ";\n");
        };
        Annotator.prototype.visitTypeAlias = function (node) {
            // If the type is also defined as a value, skip emitting it. Closure collapses type & value
            // namespaces, the two emits would conflict if tsickle emitted both.
            var sym = this.mustGetSymbolAtLocation(node.name);
            if (sym.flags & ts.SymbolFlags.Value)
                return;
            // Write a Closure typedef, which involves an unused "var" declaration.
            this.newTypeTranslator(node).blacklistTypeParameters(this.symbolsToAliasedNames, node.typeParameters);
            var typeStr = this.host.untyped ? '?' : this.typeToClosure(node, undefined, true /* resolveAlias */);
            var typeName = node.name.getText();
            this.emit("\n/** @typedef {" + typeStr + "} */\n");
            this.emit("var " + typeName + ";\n");
            // In the case of an export, we cannot emit a `export var foo;` because TypeScript drops exports
            // that are never assigned values (and Closure requires us to not assign values to typedef
            // exports).
            // tsickle must also still emit the `var` line above so that the type can be used within the
            // local module scope (Closure does not allow refering to "exports.Foo" within a module).
            // With that, emit an additional "export {foo};" to export the type.
            if (util_1.hasModifierFlag(node, ts.ModifierFlags.Export)) {
                this.emit("export {" + typeName + "};\n");
            }
        };
        return Annotator;
    }(ClosureRewriter));
    /** ExternsWriter generates Closure externs from TypeScript source. */
    var ExternsWriter = /** @class */ (function (_super) {
        __extends(ExternsWriter, _super);
        function ExternsWriter() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        ExternsWriter.prototype.process = function () {
            var _this = this;
            this.findExternRoots().forEach(function (node) { return _this.visit(node); });
            return this.getOutput();
        };
        ExternsWriter.prototype.ensureSymbolDeclared = function (sym) {
            var decl = this.findExportedDeclaration(sym);
            if (!decl)
                return; // symbol does not need declaring.
            this.error(this.file, "Cannot reference a non-global symbol from an externs: " + sym.name + " declared at " + formatLocation(decl.getSourceFile(), decl.getStart()));
        };
        ExternsWriter.prototype.newTypeTranslator = function (context) {
            var tt = _super.prototype.newTypeTranslator.call(this, context);
            tt.isForExterns = true;
            return tt;
        };
        ExternsWriter.prototype.findExternRoots = function () {
            if (util_1.isDtsFileName(this.file.fileName)) {
                return [this.file];
            }
            return this.file.statements.filter(function (stmt) { return util_1.hasModifierFlag(stmt, ts.ModifierFlags.Ambient); });
        };
        /** visit is the main entry point.  It generates externs from a ts.Node. */
        ExternsWriter.prototype.visit = function (node, namespace) {
            if (namespace === void 0) { namespace = []; }
            var e_16, _a, e_17, _b, e_18, _c;
            switch (node.kind) {
                case ts.SyntaxKind.SourceFile:
                    var sourceFile = node;
                    try {
                        for (var _d = __values(sourceFile.statements), _e = _d.next(); !_e.done; _e = _d.next()) {
                            var stmt = _e.value;
                            this.visit(stmt, namespace);
                        }
                    }
                    catch (e_16_1) { e_16 = { error: e_16_1 }; }
                    finally {
                        try {
                            if (_e && !_e.done && (_a = _d.return)) _a.call(_d);
                        }
                        finally { if (e_16) throw e_16.error; }
                    }
                    break;
                case ts.SyntaxKind.ModuleDeclaration:
                    var decl = node;
                    switch (decl.name.kind) {
                        case ts.SyntaxKind.Identifier:
                            // E.g. "declare namespace foo {"
                            var name_5 = rewriter_1.getIdentifierText(decl.name);
                            if (name_5 === 'global') {
                                // E.g. "declare global { ... }".  Reset to the outer namespace.
                                namespace = [];
                            }
                            else {
                                if (this.isFirstDeclaration(decl)) {
                                    this.emit('/** @const */\n');
                                    this.writeExternsVariable(name_5, namespace, '{}');
                                }
                                namespace = namespace.concat(name_5);
                            }
                            if (decl.body)
                                this.visit(decl.body, namespace);
                            break;
                        case ts.SyntaxKind.StringLiteral:
                            // E.g. "declare module 'foo' {" (note the quotes).
                            // We still want to emit externs for this module, but
                            // Closure doesn't really provide a mechanism for
                            // module-scoped externs.  For now, ignore the enclosing
                            // namespace (because this is declaring a top-level module)
                            // and emit into a fake namespace.
                            // Declare the top-level "tsickle_declare_module".
                            this.emit('/** @const */\n');
                            this.writeExternsVariable('tsickle_declare_module', [], '{}');
                            namespace = ['tsickle_declare_module'];
                            // Declare the inner "tsickle_declare_module.foo", if it's not
                            // declared already elsewhere.
                            var importName = decl.name.text;
                            this.emit("// Derived from: declare module \"" + importName + "\"\n");
                            // We also don't care about the actual name of the module ("foo"
                            // in the above example), except that we want it to not conflict.
                            importName = importName.replace(/_/, '__').replace(/[^A-Za-z]/g, '_');
                            if (this.isFirstDeclaration(decl)) {
                                this.emit('/** @const */\n');
                                this.writeExternsVariable(importName, namespace, '{}');
                            }
                            // Declare the contents inside the "tsickle_declare_module.foo".
                            if (decl.body)
                                this.visit(decl.body, namespace.concat(importName));
                            break;
                        default:
                            this.errorUnimplementedKind(decl.name, 'externs generation of namespace');
                    }
                    break;
                case ts.SyntaxKind.ModuleBlock:
                    var block = node;
                    try {
                        for (var _f = __values(block.statements), _g = _f.next(); !_g.done; _g = _f.next()) {
                            var stmt = _g.value;
                            this.visit(stmt, namespace);
                        }
                    }
                    catch (e_17_1) { e_17 = { error: e_17_1 }; }
                    finally {
                        try {
                            if (_g && !_g.done && (_b = _f.return)) _b.call(_f);
                        }
                        finally { if (e_17) throw e_17.error; }
                    }
                    break;
                case ts.SyntaxKind.ImportEqualsDeclaration:
                    var importEquals = node;
                    var localName = rewriter_1.getIdentifierText(importEquals.name);
                    if (localName === 'ng') {
                        this.emit("\n/* Skipping problematic import ng = ...; */\n");
                        break;
                    }
                    if (importEquals.moduleReference.kind === ts.SyntaxKind.ExternalModuleReference) {
                        this.emit("\n/* TODO: import " + localName + " = require(...) */\n");
                        break;
                    }
                    var qn = rewriter_1.getEntityNameText(importEquals.moduleReference);
                    // @const so that Closure Compiler understands this is an alias.
                    if (namespace.length === 0)
                        this.emit('/** @const */\n');
                    this.writeExternsVariable(localName, namespace, qn);
                    break;
                case ts.SyntaxKind.ClassDeclaration:
                case ts.SyntaxKind.InterfaceDeclaration:
                    this.writeExternsType(node, namespace);
                    break;
                case ts.SyntaxKind.FunctionDeclaration:
                    var fnDecl = node;
                    var name_6 = fnDecl.name;
                    if (!name_6) {
                        this.error(fnDecl, 'anonymous function in externs');
                        break;
                    }
                    // Gather up all overloads of this function.
                    var sym = this.mustGetSymbolAtLocation(name_6);
                    var decls = sym.declarations.filter(function (d) { return d.kind === ts.SyntaxKind.FunctionDeclaration; });
                    // Only emit the first declaration of each overloaded function.
                    if (fnDecl !== decls[0])
                        break;
                    var params = this.emitFunctionType(decls);
                    this.writeExternsFunction(name_6, params, namespace);
                    break;
                case ts.SyntaxKind.VariableStatement:
                    try {
                        for (var _h = __values(node.declarationList.declarations), _j = _h.next(); !_j.done; _j = _h.next()) {
                            var decl_1 = _j.value;
                            this.writeExternsVariableDecl(decl_1, namespace);
                        }
                    }
                    catch (e_18_1) { e_18 = { error: e_18_1 }; }
                    finally {
                        try {
                            if (_j && !_j.done && (_c = _h.return)) _c.call(_h);
                        }
                        finally { if (e_18) throw e_18.error; }
                    }
                    break;
                case ts.SyntaxKind.EnumDeclaration:
                    this.writeExternsEnum(node, namespace);
                    break;
                case ts.SyntaxKind.TypeAliasDeclaration:
                    this.writeExternsTypeAlias(node, namespace);
                    break;
                default:
                    var locationStr = namespace.join('.') || path.basename(node.getSourceFile().fileName);
                    this.emit("\n// TODO(tsickle): " + ts.SyntaxKind[node.kind] + " in " + locationStr + "\n");
                    break;
            }
        };
        /**
         * isFirstDeclaration returns true if decl is the first declaration
         * of its symbol.  E.g. imagine
         *   interface Foo { x: number; }
         *   interface Foo { y: number; }
         * we only want to emit the "@record" for Foo on the first one.
         */
        ExternsWriter.prototype.isFirstDeclaration = function (decl) {
            if (!decl.name)
                return true;
            var sym = this.mustGetSymbolAtLocation(decl.name);
            if (!sym.declarations || sym.declarations.length < 2)
                return true;
            return decl === sym.declarations[0];
        };
        ExternsWriter.prototype.writeExternsType = function (decl, namespace) {
            var e_19, _a, e_20, _b;
            var name = decl.name;
            if (!name) {
                this.error(decl, 'anonymous type in externs');
                return;
            }
            var typeName = namespace.concat([name.getText()]).join('.');
            if (exports.closureExternsBlacklist.indexOf(typeName) >= 0)
                return;
            if (this.isFirstDeclaration(decl)) {
                var paramNames = [];
                var jsdocTags = [];
                var writeJsDoc = true;
                this.maybeAddHeritageClauses(jsdocTags, decl);
                if (decl.kind === ts.SyntaxKind.ClassDeclaration) {
                    jsdocTags.push({ tagName: 'constructor' });
                    jsdocTags.push({ tagName: 'struct' });
                    var ctors = decl
                        .members.filter(function (m) { return m.kind === ts.SyntaxKind.Constructor; });
                    if (ctors.length) {
                        writeJsDoc = false;
                        var firstCtor = ctors[0];
                        var ctorTags = [{ tagName: 'constructor' }, { tagName: 'struct' }];
                        if (ctors.length > 1) {
                            paramNames = this.emitFunctionType(ctors, ctorTags);
                        }
                        else {
                            paramNames = this.emitFunctionType([firstCtor], ctorTags);
                        }
                    }
                }
                else {
                    jsdocTags.push({ tagName: 'record' });
                    jsdocTags.push({ tagName: 'struct' });
                }
                if (writeJsDoc)
                    this.emit(jsdoc.toString(jsdocTags));
                this.writeExternsFunction(name, paramNames, namespace);
            }
            // Process everything except (MethodSignature|MethodDeclaration|Constructor)
            var methods = new Map();
            try {
                for (var _c = __values(decl.members), _d = _c.next(); !_d.done; _d = _c.next()) {
                    var member = _d.value;
                    switch (member.kind) {
                        case ts.SyntaxKind.PropertySignature:
                        case ts.SyntaxKind.PropertyDeclaration:
                            var prop = member;
                            if (prop.name.kind === ts.SyntaxKind.Identifier) {
                                this.emitJSDocType(prop);
                                if (util_1.hasModifierFlag(prop, ts.ModifierFlags.Static)) {
                                    this.emit("\n" + typeName + "." + prop.name.getText() + ";\n");
                                }
                                else {
                                    this.emit("\n" + typeName + ".prototype." + prop.name.getText() + ";\n");
                                }
                                continue;
                            }
                            // TODO: For now property names other than Identifiers are not handled; e.g.
                            //    interface Foo { "123bar": number }
                            break;
                        case ts.SyntaxKind.MethodSignature:
                        case ts.SyntaxKind.MethodDeclaration:
                            var method = member;
                            var isStatic = util_1.hasModifierFlag(method, ts.ModifierFlags.Static);
                            var methodSignature = method.name.getText() + "$$$" + (isStatic ? 'static' : 'instance');
                            if (methods.has(methodSignature)) {
                                methods.get(methodSignature).push(method);
                            }
                            else {
                                methods.set(methodSignature, [method]);
                            }
                            continue;
                        case ts.SyntaxKind.Constructor:
                            continue; // Handled above.
                        default:
                            // Members can include things like index signatures, for e.g.
                            //   interface Foo { [key: string]: number; }
                            // For now, just skip it.
                            break;
                    }
                    // If we get here, the member wasn't handled in the switch statement.
                    var memberName = namespace;
                    if (member.name) {
                        memberName = memberName.concat([member.name.getText()]);
                    }
                    this.emit("\n/* TODO: " + ts.SyntaxKind[member.kind] + ": " + memberName.join('.') + " */\n");
                }
            }
            catch (e_19_1) { e_19 = { error: e_19_1 }; }
            finally {
                try {
                    if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
                }
                finally { if (e_19) throw e_19.error; }
            }
            try {
                // Handle method declarations/signatures separately, since we need to deal with overloads.
                for (var _e = __values(Array.from(methods.values())), _f = _e.next(); !_f.done; _f = _e.next()) {
                    var methodVariants = _f.value;
                    var firstMethodVariant = methodVariants[0];
                    var parameterNames = void 0;
                    if (methodVariants.length > 1) {
                        parameterNames = this.emitFunctionType(methodVariants);
                    }
                    else {
                        parameterNames = this.emitFunctionType([firstMethodVariant]);
                    }
                    var methodNamespace = namespace.concat([name.getText()]);
                    // If the method is static, don't add the prototype.
                    if (!util_1.hasModifierFlag(firstMethodVariant, ts.ModifierFlags.Static)) {
                        methodNamespace.push('prototype');
                    }
                    this.writeExternsFunction(firstMethodVariant.name, parameterNames, methodNamespace);
                }
            }
            catch (e_20_1) { e_20 = { error: e_20_1 }; }
            finally {
                try {
                    if (_f && !_f.done && (_b = _e.return)) _b.call(_e);
                }
                finally { if (e_20) throw e_20.error; }
            }
        };
        ExternsWriter.prototype.writeExternsVariableDecl = function (decl, namespace) {
            if (decl.name.kind === ts.SyntaxKind.Identifier) {
                var name_7 = rewriter_1.getIdentifierText(decl.name);
                if (exports.closureExternsBlacklist.indexOf(name_7) >= 0)
                    return;
                this.emitJSDocType(decl);
                this.emit('\n');
                this.writeExternsVariable(name_7, namespace);
            }
            else {
                this.errorUnimplementedKind(decl.name, 'externs for variable');
            }
        };
        ExternsWriter.prototype.writeExternsVariable = function (name, namespace, value) {
            var qualifiedName = namespace.concat([name]).join('.');
            if (namespace.length === 0)
                this.emit("var ");
            this.emit(qualifiedName);
            if (value)
                this.emit(" = " + value);
            this.emit(';\n');
        };
        ExternsWriter.prototype.writeExternsFunction = function (name, params, namespace) {
            var paramsStr = params.join(', ');
            if (namespace.length > 0) {
                var fqn = namespace.join('.');
                if (name.kind === ts.SyntaxKind.Identifier) {
                    fqn += '.'; // computed names include [ ] in their getText() representation.
                }
                fqn += name.getText();
                this.emit(fqn + " = function(" + paramsStr + ") {};\n");
            }
            else {
                if (name.kind !== ts.SyntaxKind.Identifier) {
                    this.error(name, 'Non-namespaced computed name in externs');
                }
                this.emit("function " + name.getText() + "(" + paramsStr + ") {}\n");
            }
        };
        ExternsWriter.prototype.writeExternsEnum = function (decl, namespace) {
            var e_21, _a;
            var name = rewriter_1.getIdentifierText(decl.name);
            this.emit('\n/** @const */\n');
            this.writeExternsVariable(name, namespace, '{}');
            namespace = namespace.concat([name]);
            try {
                for (var _b = __values(decl.members), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var member = _c.value;
                    var memberName = void 0;
                    switch (member.name.kind) {
                        case ts.SyntaxKind.Identifier:
                            memberName = rewriter_1.getIdentifierText(member.name);
                            break;
                        case ts.SyntaxKind.StringLiteral:
                            var text = member.name.text;
                            if (isValidClosurePropertyName(text))
                                memberName = text;
                            break;
                        default:
                            break;
                    }
                    if (!memberName) {
                        this.emit("\n/* TODO: " + ts.SyntaxKind[member.name.kind] + ": " + member.name.getText() + " */\n");
                        continue;
                    }
                    this.emit('/** @const {number} */\n');
                    this.writeExternsVariable(memberName, namespace);
                }
            }
            catch (e_21_1) { e_21 = { error: e_21_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_21) throw e_21.error; }
            }
        };
        ExternsWriter.prototype.writeExternsTypeAlias = function (decl, namespace) {
            var typeStr = this.typeToClosure(decl, undefined, true /* resolveAlias */);
            this.emit("\n/** @typedef {" + typeStr + "} */\n");
            this.writeExternsVariable(rewriter_1.getIdentifierText(decl.name), namespace);
        };
        return ExternsWriter;
    }(ClosureRewriter));
    function isPolymerBehaviorPropertyInCallExpression(pa) {
        var parentParent = pa.parent && pa.parent.parent;
        if (pa.name.kind !== ts.SyntaxKind.Identifier ||
            pa.name.text !== 'behaviors' || !pa.parent || !pa.parent.parent ||
            pa.parent.parent.kind !== ts.SyntaxKind.CallExpression) {
            return false;
        }
        var expr = parentParent.expression;
        return expr.kind === ts.SyntaxKind.Identifier && expr.text === 'Polymer';
    }
    function annotate(typeChecker, file, host, tsHost, tsOpts, sourceMapper) {
        return new Annotator(typeChecker, file, host, tsHost, tsOpts, sourceMapper).annotate();
    }
    exports.annotate = annotate;
    function writeExterns(typeChecker, file, host) {
        return new ExternsWriter(typeChecker, file, host).process();
    }
    exports.writeExterns = writeExterns;
    /** Concatenate all generated externs definitions together into a string. */
    function getGeneratedExterns(externs) {
        var e_22, _a;
        var allExterns = exports.EXTERNS_HEADER;
        try {
            for (var _b = __values(Object.keys(externs)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var fileName = _c.value;
                allExterns += "// externs from " + fileName + ":\n";
                allExterns += externs[fileName];
            }
        }
        catch (e_22_1) { e_22 = { error: e_22_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_22) throw e_22.error; }
        }
        return allExterns;
    }
    exports.getGeneratedExterns = getGeneratedExterns;
    function mergeEmitResults(emitResults) {
        var e_23, _a;
        var diagnostics = [];
        var emitSkipped = true;
        var emittedFiles = [];
        var externs = {};
        var modulesManifest = new modules_manifest_1.ModulesManifest();
        try {
            for (var emitResults_1 = __values(emitResults), emitResults_1_1 = emitResults_1.next(); !emitResults_1_1.done; emitResults_1_1 = emitResults_1.next()) {
                var er = emitResults_1_1.value;
                diagnostics.push.apply(diagnostics, __spread(er.diagnostics));
                emitSkipped = emitSkipped || er.emitSkipped;
                emittedFiles.push.apply(emittedFiles, __spread(er.emittedFiles));
                Object.assign(externs, er.externs);
                modulesManifest.addManifest(er.modulesManifest);
            }
        }
        catch (e_23_1) { e_23 = { error: e_23_1 }; }
        finally {
            try {
                if (emitResults_1_1 && !emitResults_1_1.done && (_a = emitResults_1.return)) _a.call(emitResults_1);
            }
            finally { if (e_23) throw e_23.error; }
        }
        return { diagnostics: diagnostics, emitSkipped: emitSkipped, emittedFiles: emittedFiles, externs: externs, modulesManifest: modulesManifest };
    }
    exports.mergeEmitResults = mergeEmitResults;
    function emitWithTsickle(program, host, tsHost, tsOptions, targetSourceFile, writeFile, cancellationToken, emitOnlyDtsFiles, customTransformers) {
        if (customTransformers === void 0) { customTransformers = {}; }
        var tsickleDiagnostics = [];
        var typeChecker = program.getTypeChecker();
        var tsickleSourceTransformers = [];
        if (host.transformTypesToClosure) {
            // Note: tsickle.annotate can also lower decorators in the same run.
            tsickleSourceTransformers.push(transformer_sourcemap_1.createTransformerFromSourceMap(function (sourceFile, sourceMapper) {
                var _a = annotate(typeChecker, sourceFile, host, tsHost, tsOptions, sourceMapper), output = _a.output, diagnostics = _a.diagnostics;
                tsickleDiagnostics.push.apply(tsickleDiagnostics, __spread(diagnostics));
                return output;
            }));
            tsickleSourceTransformers.push(enum_transformer_1.enumTransformer(typeChecker, tsickleDiagnostics));
            // Only add @suppress {checkTypes} comments when also adding type annotations.
            tsickleSourceTransformers.push(fileoverview_comment_transformer_1.transformFileoverviewComment);
            tsickleSourceTransformers.push(decorator_downlevel_transformer_1.decoratorDownlevelTransformer(typeChecker, tsickleDiagnostics));
        }
        else if (host.transformDecorators) {
            tsickleSourceTransformers.push(decorator_downlevel_transformer_1.decoratorDownlevelTransformer(typeChecker, tsickleDiagnostics));
        }
        var modulesManifest = new modules_manifest_1.ModulesManifest();
        var tsickleTransformers = {};
        if (tsickleSourceTransformers.length) {
            // Only add the various fixup transformers if tsickle is actually doing a source map powered
            // transformation. Without a source map transformation, some information is not
            // available/initialized correctly for these passes to work, which causes subtle emit errors
            // (such as comments appearing in incorrect locations, breaking source code due to automatic
            // semicolon insertion).
            tsickleTransformers = transformer_util_1.createCustomTransformers({ before: tsickleSourceTransformers });
        }
        var tsTransformers = {
            before: __spread((customTransformers.beforeTsickle || []), (tsickleTransformers.before || []).map(function (tf) { return skipTransformForSourceFileIfNeeded(host, tf); }), (customTransformers.beforeTs || [])),
            after: __spread((customTransformers.afterTs || []), (tsickleTransformers.after || []).map(function (tf) { return skipTransformForSourceFileIfNeeded(host, tf); }))
        };
        if (host.googmodule) {
            tsTransformers.after.push(googmodule.commonJsToGoogmoduleTransformer(host, modulesManifest, typeChecker, tsickleDiagnostics));
        }
        var writeFileDelegate = writeFile || tsHost.writeFile.bind(tsHost);
        var writeFileImpl = function (fileName, content, writeByteOrderMark, onError, sourceFiles) {
            if (path.extname(fileName) !== '.map') {
                if (tsOptions.inlineSourceMap) {
                    content = combineInlineSourceMaps(program, fileName, content);
                }
                else {
                    content = source_map_utils_1.removeInlineSourceMap(content);
                }
            }
            else {
                content = combineSourceMaps(program, fileName, content);
            }
            if (host.addDtsClutzAliases && util_1.isDtsFileName(fileName) && sourceFiles) {
                // Only bundle emits pass more than one source file for .d.ts writes. Bundle emits however
                // are not supported by tsickle, as we cannot annotate them for Closure in any meaningful
                // way anyway.
                if (!sourceFiles || sourceFiles.length > 1) {
                    throw new Error("expected exactly one source file for .d.ts emit, got " + sourceFiles.map(function (sf) { return sf.fileName; }));
                }
                var originalSource = sourceFiles[0];
                content = addClutzAliases(fileName, content, originalSource, typeChecker, host);
            }
            writeFileDelegate(fileName, content, writeByteOrderMark, onError, sourceFiles);
        };
        var _a = program.emit(targetSourceFile, writeFileImpl, cancellationToken, emitOnlyDtsFiles, tsTransformers), tsDiagnostics = _a.diagnostics, emitSkipped = _a.emitSkipped, emittedFiles = _a.emittedFiles;
        var externs = {};
        if (host.transformTypesToClosure) {
            var sourceFiles = targetSourceFile ? [targetSourceFile] : program.getSourceFiles();
            sourceFiles.forEach(function (sf) {
                if (util_1.isDtsFileName(sf.fileName) && host.shouldSkipTsickleProcessing(sf.fileName)) {
                    return;
                }
                // fileName might be absolute, which would cause emits different by checkout location or
                // non-deterministic output for build systems that use hashed work directories (bazel).
                // fileNameToModuleId gives the logical, base path relative ID for the given fileName, which
                // avoids this issue.
                var moduleId = host.fileNameToModuleId(sf.fileName);
                var _a = writeExterns(typeChecker, sf, host), output = _a.output, diagnostics = _a.diagnostics;
                if (output) {
                    externs[moduleId] = output;
                }
                if (diagnostics) {
                    tsickleDiagnostics.push.apply(tsickleDiagnostics, __spread(diagnostics));
                }
            });
        }
        // All diagnostics (including warnings) are treated as errors.
        // If the host decides to ignore warnings, just discard them.
        // Warnings include stuff like "don't use @type in your jsdoc"; tsickle
        // warns and then fixes up the code to be Closure-compatible anyway.
        tsickleDiagnostics = tsickleDiagnostics.filter(function (d) { return d.category === ts.DiagnosticCategory.Error ||
            !host.shouldIgnoreWarningsForPath(d.file.fileName); });
        return {
            modulesManifest: modulesManifest,
            emitSkipped: emitSkipped,
            emittedFiles: emittedFiles || [],
            diagnostics: __spread(tsDiagnostics, tsickleDiagnostics),
            externs: externs
        };
    }
    exports.emitWithTsickle = emitWithTsickle;
    /** Compares two strings and returns a number suitable for use in sort(). */
    function stringCompare(a, b) {
        if (a < b)
            return -1;
        if (a > b)
            return 1;
        return 0;
    }
    /**
     * A tsickle produced declaration file might be consumed be referenced by Clutz
     * produced .d.ts files, which use symbol names based on Closure's internal
     * naming conventions, so we need to provide aliases for all the exported symbols
     * in the Clutz naming convention.
     */
    function addClutzAliases(fileName, dtsFileContent, sourceFile, typeChecker, host) {
        var e_24, _a;
        var moduleSymbol = typeChecker.getSymbolAtLocation(sourceFile);
        var moduleExports = moduleSymbol && typeChecker.getExportsOfModule(moduleSymbol);
        if (!moduleExports)
            return dtsFileContent;
        // .d.ts files can be transformed, too, so we need to compare the original node below.
        var origSourceFile = ts.getOriginalNode(sourceFile);
        // The module exports might be re-exports, and in the case of "export *" might not even be
        // available in the module scope, which makes them difficult to export. Avoid the problem by
        // filtering out symbols who do not have a declaration in the local module.
        var localExports = moduleExports.filter(function (e) {
            // If there are no declarations, be conservative and emit the aliases.
            if (!e.declarations)
                return true;
            // Skip default exports, they are not currently supported.
            // default is a keyword in typescript, so the name of the export being default means that it's a
            // default export.
            if (e.name === 'default')
                return false;
            // Otherwise check that some declaration is from the local module.
            return e.declarations.some(function (d) { return d.getSourceFile() === origSourceFile; });
        });
        if (!localExports.length)
            return dtsFileContent;
        // TypeScript 2.8 and TypeScript 2.9 differ on the order in which the
        // module symbols come out, so sort here to make the tests stable.
        localExports.sort(function (a, b) { return stringCompare(a.name, b.name); });
        var moduleName = host.pathToModuleName('', sourceFile.fileName);
        var clutzModuleName = moduleName.replace(/\./g, '$');
        // Clutz might refer to the name in two different forms (stemming from goog.provide and
        // goog.module respectively).
        // 1) global in clutz:   ಠ_ಠ.clutz.module$contents$path$to$module_Symbol...
        // 2) local in a module: ಠ_ಠ.clutz.module$exports$path$to$module.Symbol ..
        // See examples at:
        // https://github.com/angular/clutz/tree/master/src/test/java/com/google/javascript/clutz
        // Case (1) from above.
        var globalSymbols = '';
        // Case (2) from above.
        var nestedSymbols = '';
        try {
            for (var localExports_1 = __values(localExports), localExports_1_1 = localExports_1.next(); !localExports_1_1.done; localExports_1_1 = localExports_1.next()) {
                var symbol = localExports_1_1.value;
                globalSymbols +=
                    "\t\texport {" + symbol.name + " as module$contents$" + clutzModuleName + "_" + symbol.name + "}\n";
                nestedSymbols +=
                    "\t\texport {module$contents$" + clutzModuleName + "_" + symbol.name + " as " + symbol.name + "}\n";
                if (symbol.flags & ts.SymbolFlags.Class) {
                    globalSymbols += "\t\texport {" + symbol.name + " as module$contents$" + clutzModuleName + "_" + symbol.name + "_Instance}\n";
                    nestedSymbols += "\t\texport {module$contents$" + clutzModuleName + "_" + symbol.name + " as " + symbol.name + "_Instance}\n";
                }
            }
        }
        catch (e_24_1) { e_24 = { error: e_24_1 }; }
        finally {
            try {
                if (localExports_1_1 && !localExports_1_1.done && (_a = localExports_1.return)) _a.call(localExports_1);
            }
            finally { if (e_24) throw e_24.error; }
        }
        dtsFileContent += 'declare global {\n';
        dtsFileContent += "\tnamespace \u0CA0_\u0CA0.clutz {\n";
        dtsFileContent += globalSymbols;
        dtsFileContent += "\t}\n";
        dtsFileContent += "\tnamespace \u0CA0_\u0CA0.clutz.module$exports$" + clutzModuleName + " {\n";
        dtsFileContent += nestedSymbols;
        dtsFileContent += "\t}\n";
        dtsFileContent += '}\n';
        return dtsFileContent;
    }
    function skipTransformForSourceFileIfNeeded(host, delegateFactory) {
        return function (context) {
            var delegate = delegateFactory(context);
            return function (sourceFile) {
                if (host.shouldSkipTsickleProcessing(sourceFile.fileName)) {
                    return sourceFile;
                }
                return delegate(sourceFile);
            };
        };
    }
    function combineInlineSourceMaps(program, filePath, compiledJsWithInlineSourceMap) {
        if (util_1.isDtsFileName(filePath)) {
            return compiledJsWithInlineSourceMap;
        }
        var sourceMapJson = source_map_utils_1.extractInlineSourceMap(compiledJsWithInlineSourceMap);
        compiledJsWithInlineSourceMap = source_map_utils_1.removeInlineSourceMap(compiledJsWithInlineSourceMap);
        var composedSourceMap = combineSourceMaps(program, filePath, sourceMapJson);
        return source_map_utils_1.setInlineSourceMap(compiledJsWithInlineSourceMap, composedSourceMap);
    }
    function combineSourceMaps(program, filePath, tscSourceMapText) {
        var e_25, _a;
        var tscSourceMap = source_map_utils_1.parseSourceMap(tscSourceMapText);
        if (tscSourceMap.sourcesContent) {
            // strip incoming sourcemaps from the sources in the sourcemap
            // to reduce the size of the sourcemap.
            tscSourceMap.sourcesContent = tscSourceMap.sourcesContent.map(function (content) {
                if (source_map_utils_1.containsInlineSourceMap(content)) {
                    content = source_map_utils_1.removeInlineSourceMap(content);
                }
                return content;
            });
        }
        var fileDir = path.dirname(filePath);
        var tscSourceMapGenerator;
        try {
            for (var _b = __values(tscSourceMap.sources), _c = _b.next(); !_c.done; _c = _b.next()) {
                var sourceFileName = _c.value;
                var sourceFile = program.getSourceFile(path.resolve(fileDir, sourceFileName));
                if (!sourceFile || !source_map_utils_1.containsInlineSourceMap(sourceFile.text)) {
                    continue;
                }
                var preexistingSourceMapText = source_map_utils_1.extractInlineSourceMap(sourceFile.text);
                if (!tscSourceMapGenerator) {
                    tscSourceMapGenerator = source_map_1.SourceMapGenerator.fromSourceMap(new source_map_1.SourceMapConsumer(tscSourceMap));
                }
                tscSourceMapGenerator.applySourceMap(new source_map_1.SourceMapConsumer(source_map_utils_1.parseSourceMap(preexistingSourceMapText, sourceFileName)));
            }
        }
        catch (e_25_1) { e_25 = { error: e_25_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_25) throw e_25.error; }
        }
        return tscSourceMapGenerator ? tscSourceMapGenerator.toString() : tscSourceMapText;
    }
});
//# sourceMappingURL=data:application/json;base64,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