/*
  $Id$

  Copyright (C) 2003-2013 Virginia Tech.
  All rights reserved.

  SEE LICENSE FOR MORE INFORMATION

  Author:  Middleware Services
  Email:   middleware@vt.edu
  Version: $Revision$
  Updated: $Date$
*/
package edu.vt.middleware.password;

/**
 * Rule for determining if a password contains the correct number of digit
 * characters.
 *
 * @author  Middleware Services
 * @version  $Revision: 1636 $ $Date: 2010-10-04 11:12:15 -0400 (Mon, 04 Oct 2010) $
 */
public class DigitCharacterRule extends AbstractCharacterRule
{

  /** Character type. */
  private static final String CHARACTER_TYPE = "digit";


  /** Default constructor. */
  public DigitCharacterRule() {}


  /**
   * Create a new digit character rule.
   *
   * @param  num  of digit characters to enforce
   */
  public DigitCharacterRule(final int num)
  {
    setNumberOfCharacters(num);
  }


  /** {@inheritDoc} */
  @Override
  public String getValidCharacters()
  {
    return "0123456789";
  }


  /** {@inheritDoc} */
  @Override
  protected int getNumberOfCharacterType(final Password password)
  {
    return password.getNumberOfDigits();
  }


  /** {@inheritDoc} */
  @Override
  protected String getCharacterType()
  {
    return CHARACTER_TYPE;
  }
}
