"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const path = require("path");
const webpack_1 = require("@ngtools/webpack");
const common_1 = require("./common");
const g = typeof global !== 'undefined' ? global : {};
const webpackLoader = g['_DevKitIsLocal']
    ? require.resolve('@ngtools/webpack')
    : '@ngtools/webpack';
function _createAotPlugin(wco, options, _host, useMain = true, extract = false) {
    const { root, buildOptions } = wco;
    options.compilerOptions = options.compilerOptions || {};
    if (wco.buildOptions.preserveSymlinks) {
        options.compilerOptions.preserveSymlinks = true;
    }
    let i18nInFile = buildOptions.i18nFile
        ? path.resolve(root, buildOptions.i18nFile)
        : undefined;
    const i18nFileAndFormat = extract
        ? {
            i18nOutFile: buildOptions.i18nFile,
            i18nOutFormat: buildOptions.i18nFormat,
        } : {
        i18nInFile: i18nInFile,
        i18nInFormat: buildOptions.i18nFormat,
    };
    const additionalLazyModules = {};
    if (buildOptions.lazyModules) {
        for (const lazyModule of buildOptions.lazyModules) {
            additionalLazyModules[lazyModule] = path.resolve(root, lazyModule);
        }
    }
    const hostReplacementPaths = {};
    if (buildOptions.fileReplacements) {
        for (const replacement of buildOptions.fileReplacements) {
            hostReplacementPaths[replacement.replace] = replacement.with;
        }
    }
    const pluginOptions = Object.assign({ mainPath: useMain ? path.join(root, buildOptions.main) : undefined }, i18nFileAndFormat, { locale: buildOptions.i18nLocale, platform: buildOptions.platform === 'server' ? webpack_1.PLATFORM.Server : webpack_1.PLATFORM.Browser, missingTranslation: buildOptions.i18nMissingTranslation, sourceMap: buildOptions.sourceMap, additionalLazyModules,
        hostReplacementPaths, nameLazyFiles: buildOptions.namedChunks, forkTypeChecker: buildOptions.forkTypeChecker, contextElementDependencyConstructor: require('webpack/lib/dependencies/ContextElementDependency') }, options);
    return new webpack_1.AngularCompilerPlugin(pluginOptions);
}
function getNonAotConfig(wco, host) {
    const { tsConfigPath } = wco;
    return {
        module: { rules: [{ test: /\.tsx?$/, loader: webpackLoader }] },
        plugins: [_createAotPlugin(wco, { tsConfigPath, skipCodeGeneration: true }, host)]
    };
}
exports.getNonAotConfig = getNonAotConfig;
function getAotConfig(wco, host, extract = false) {
    const { tsConfigPath, buildOptions } = wco;
    const loaders = [webpackLoader];
    if (buildOptions.buildOptimizer) {
        loaders.unshift({
            loader: common_1.buildOptimizerLoader,
            options: { sourceMap: buildOptions.sourceMap }
        });
    }
    const test = /(?:\.ngfactory\.js|\.ngstyle\.js|\.ts)$/;
    return {
        module: { rules: [{ test, use: loaders }] },
        plugins: [_createAotPlugin(wco, { tsConfigPath }, host, true, extract)]
    };
}
exports.getAotConfig = getAotConfig;
function getNonAotTestConfig(wco, host) {
    const { tsConfigPath } = wco;
    return {
        module: { rules: [{ test: /\.tsx?$/, loader: webpackLoader }] },
        plugins: [_createAotPlugin(wco, { tsConfigPath, skipCodeGeneration: true }, host, false)]
    };
}
exports.getNonAotTestConfig = getNonAotTestConfig;
//# sourceMappingURL=data:application/json;base64,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