"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
// TODO: cleanup this file, it's copied as is from Angular CLI.
const core_1 = require("@angular-devkit/core");
const crypto = require("crypto");
const fs = require("fs");
const rxjs_1 = require("rxjs");
const operators_1 = require("rxjs/operators");
const semver = require("semver");
const require_project_module_1 = require("../require-project-module");
exports.NEW_SW_VERSION = '5.0.0-rc.0';
class CliFilesystem {
    constructor(_host, base) {
        this._host = _host;
        this.base = base;
    }
    list(path) {
        const recursiveList = (path) => this._host.list(path).pipe(
        // Emit each fragment individually.
        operators_1.concatMap(fragments => rxjs_1.from(fragments)), 
        // Join the path with fragment.
        operators_1.map(fragment => core_1.join(path, fragment)), 
        // Emit directory content paths instead of the directory path.
        operators_1.mergeMap(path => this._host.isDirectory(path).pipe(operators_1.concatMap(isDir => isDir ? recursiveList(path) : rxjs_1.of(path)))));
        return recursiveList(this._resolve(path)).pipe(operators_1.map(path => path.replace(this.base, '')), operators_1.toArray()).toPromise().then(x => x, _err => []);
    }
    read(path) {
        return this._readIntoBuffer(path)
            .then(content => core_1.virtualFs.fileBufferToString(content));
    }
    hash(path) {
        const sha1 = crypto.createHash('sha1');
        return this._readIntoBuffer(path)
            .then(content => sha1.update(Buffer.from(content)))
            .then(() => sha1.digest('hex'));
    }
    write(path, content) {
        return this._host.write(this._resolve(path), core_1.virtualFs.stringToFileBuffer(content))
            .toPromise();
    }
    _readIntoBuffer(path) {
        return this._host.read(this._resolve(path))
            .toPromise();
    }
    _resolve(path) {
        return core_1.join(core_1.normalize(this.base), path);
    }
}
function usesServiceWorker(projectRoot) {
    let swPackageJsonPath;
    try {
        swPackageJsonPath = require_project_module_1.resolveProjectModule(projectRoot, '@angular/service-worker/package.json');
    }
    catch (_) {
        // @angular/service-worker is not installed
        throw new Error(core_1.tags.stripIndent `
    Your project is configured with serviceWorker = true, but @angular/service-worker
    is not installed. Run \`npm install --save-dev @angular/service-worker\`
    and try again, or run \`ng set apps.0.serviceWorker=false\` in your .angular-cli.json.
  `);
    }
    const swPackageJson = fs.readFileSync(swPackageJsonPath).toString();
    const swVersion = JSON.parse(swPackageJson)['version'];
    if (!semver.gte(swVersion, exports.NEW_SW_VERSION)) {
        throw new Error(core_1.tags.stripIndent `
    The installed version of @angular/service-worker is ${swVersion}. This version of the CLI
    requires the @angular/service-worker version to satisfy ${exports.NEW_SW_VERSION}. Please upgrade
    your service worker version.
  `);
    }
    return true;
}
exports.usesServiceWorker = usesServiceWorker;
function augmentAppWithServiceWorker(host, projectRoot, appRoot, outputPath, baseHref, ngswConfigPath) {
    // Path to the worker script itself.
    const distPath = core_1.normalize(outputPath);
    const workerPath = core_1.normalize(require_project_module_1.resolveProjectModule(core_1.getSystemPath(projectRoot), '@angular/service-worker/ngsw-worker.js'));
    const swConfigPath = require_project_module_1.resolveProjectModule(core_1.getSystemPath(projectRoot), '@angular/service-worker/config');
    const safetyPath = core_1.join(core_1.dirname(workerPath), 'safety-worker.js');
    const configPath = ngswConfigPath || core_1.join(appRoot, 'ngsw-config.json');
    return host.exists(configPath).pipe(operators_1.switchMap(exists => {
        if (!exists) {
            throw new Error(core_1.tags.oneLine `
          Error: Expected to find an ngsw-config.json configuration
          file in the ${appRoot} folder. Either provide one or disable Service Worker
          in your angular.json configuration file.`);
        }
        return host.read(configPath);
    }), operators_1.map(content => JSON.parse(core_1.virtualFs.fileBufferToString(content))), operators_1.switchMap(configJson => {
        const GeneratorConstructor = require(swConfigPath).Generator;
        const gen = new GeneratorConstructor(new CliFilesystem(host, outputPath), baseHref);
        return gen.process(configJson);
    }), operators_1.switchMap(output => {
        const manifest = JSON.stringify(output, null, 2);
        return host.read(workerPath).pipe(operators_1.switchMap(workerCode => {
            return rxjs_1.merge(host.write(core_1.join(distPath, 'ngsw.json'), core_1.virtualFs.stringToFileBuffer(manifest)), host.write(core_1.join(distPath, 'ngsw-worker.js'), workerCode));
        }));
    }), operators_1.switchMap(() => host.exists(safetyPath)), 
    // If @angular/service-worker has the safety script, copy it into two locations.
    operators_1.switchMap(exists => {
        if (!exists) {
            return rxjs_1.of(undefined);
        }
        return host.read(safetyPath).pipe(operators_1.switchMap(safetyCode => {
            return rxjs_1.merge(host.write(core_1.join(distPath, 'worker-basic.min.js'), safetyCode), host.write(core_1.join(distPath, 'safety-worker.js'), safetyCode));
        }));
    }), 
    // Remove all elements, reduce them to a single emit.
    operators_1.reduce(() => { })).toPromise();
}
exports.augmentAppWithServiceWorker = augmentAppWithServiceWorker;
//# sourceMappingURL=data:application/json;base64,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