"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
// tslint:disable
// TODO: cleanup this file, it's copied as is from Angular CLI.
const core_1 = require("@angular-devkit/core");
const { bold, green, red, reset, white, yellow } = core_1.terminal;
function formatSize(size) {
    if (size <= 0) {
        return '0 bytes';
    }
    const abbreviations = ['bytes', 'kB', 'MB', 'GB'];
    const index = Math.floor(Math.log(size) / Math.log(1000));
    return `${+(size / Math.pow(1000, index)).toPrecision(3)} ${abbreviations[index]}`;
}
exports.formatSize = formatSize;
function statsToString(json, statsConfig) {
    const colors = statsConfig.colors;
    const rs = (x) => colors ? reset(x) : x;
    const w = (x) => colors ? bold(white(x)) : x;
    const g = (x) => colors ? bold(green(x)) : x;
    const y = (x) => colors ? bold(yellow(x)) : x;
    const changedChunksStats = json.chunks
        .filter((chunk) => chunk.rendered)
        .map((chunk) => {
        const asset = json.assets.filter((x) => x.name == chunk.files[0])[0];
        const size = asset ? ` ${formatSize(asset.size)}` : '';
        const files = chunk.files.join(', ');
        const names = chunk.names ? ` (${chunk.names.join(', ')})` : '';
        const initial = y(chunk.entry ? '[entry]' : chunk.initial ? '[initial]' : '');
        const flags = ['rendered', 'recorded']
            .map(f => f && chunk[f] ? g(` [${f}]`) : '')
            .join('');
        return `chunk {${y(chunk.id)}} ${g(files)}${names}${size} ${initial}${flags}`;
    });
    const unchangedChunkNumber = json.chunks.length - changedChunksStats.length;
    if (unchangedChunkNumber > 0) {
        return '\n' + rs(core_1.tags.stripIndents `
      Date: ${w(new Date().toISOString())} - Hash: ${w(json.hash)} - Time: ${w('' + json.time)}ms
      ${unchangedChunkNumber} unchanged chunks
      ${changedChunksStats.join('\n')}
      `);
    }
    else {
        return '\n' + rs(core_1.tags.stripIndents `
      Date: ${w(new Date().toISOString())}
      Hash: ${w(json.hash)}
      Time: ${w('' + json.time)}ms
      ${changedChunksStats.join('\n')}
      `);
    }
}
exports.statsToString = statsToString;
function statsWarningsToString(json, statsConfig) {
    const colors = statsConfig.colors;
    const rs = (x) => colors ? reset(x) : x;
    const y = (x) => colors ? bold(yellow(x)) : x;
    return rs('\n' + json.warnings.map((warning) => y(`WARNING in ${warning}`)).join('\n\n'));
}
exports.statsWarningsToString = statsWarningsToString;
function statsErrorsToString(json, statsConfig) {
    const colors = statsConfig.colors;
    const rs = (x) => colors ? reset(x) : x;
    const r = (x) => colors ? bold(red(x)) : x;
    return rs('\n' + json.errors.map((error) => r(`ERROR in ${error}`)).join('\n'));
}
exports.statsErrorsToString = statsErrorsToString;
//# sourceMappingURL=data:application/json;base64,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