"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const _env = (typeof process == 'object' && process.env) || {};
const _platform = (typeof process == 'object' && process.platform) || '';
const _versions = (typeof process == 'object' && process.versions) || { node: '' };
const _os = (typeof os == 'object' && os) || { release: () => '' };
const streamMap = new WeakMap();
const ciVars = ['TRAVIS', 'CIRCLECI', 'APPVEYOR', 'GITLAB_CI'];
function _getColorLevel(stream) {
    if (stream && !stream.isTTY && !_env.MSYSTEM) {
        return 0;
    }
    if (_platform.startsWith('win32') && !_env.MSYSTEM) {
        // Node.js 7.5.0 is the first version of Node.js to include a patch to
        // libuv that enables 256 color output on Windows. Anything earlier and it
        // won't work. However, here we target Node.js 8 at minimum as it is an LTS
        // release, and Node.js 7 is not. Windows 10 build 10586 is the first Windows
        // release that supports 256 colors.
        const osRelease = _os.release().split('.');
        if (Number(_versions.node.split('.')[0]) >= 8
            && Number(osRelease[0]) >= 10
            && Number(osRelease[2]) >= 10586) {
            return 2;
        }
        return 1;
    }
    if ('CI' in _env) {
        if (ciVars.some(sign => sign in _env) || _env.CI_NAME === 'codeship') {
            return 1;
        }
        return 0;
    }
    if ('TEAMCITY_VERSION' in _env) {
        return /^(9\.(0*[1-9]\d*)\.|\d{2,}\.)/.test(_env.TEAMCITY_VERSION) ? 1 : 0;
    }
    if ('TERM_PROGRAM' in _env) {
        const version = parseInt((_env.TERM_PROGRAM_VERSION || '').split('.')[0], 10);
        switch (_env.TERM_PROGRAM) {
            case 'iTerm.app':
                return version >= 3 ? 3 : 2;
            case 'Hyper':
                return 3;
            case 'Apple_Terminal':
                return 2;
            // No default
        }
    }
    if (/-256(color)?$/i.test(_env.TERM)) {
        return 2;
    }
    if (/^screen|^xterm|^vt100|^rxvt|color|ansi|cygwin|linux/i.test(_env.TERM)) {
        return 1;
    }
    if ('COLORTERM' in _env) {
        return 1;
    }
    if (_env.TERM === 'dumb') {
        return 0;
    }
    return 0;
}
function _getRows() {
    return process.stdout.rows || null;
}
function _getColumns() {
    return process.stdout.columns || null;
}
function _createCapabilities(stream, isTerminalStream) {
    const level = _getColorLevel(stream);
    return {
        readable: stream.readable,
        writable: stream.writable,
        text: true,
        colors: level > 0,
        color256: level > 1,
        color16m: level > 2,
        rows: isTerminalStream ? _getRows() : null,
        columns: isTerminalStream ? _getColumns() : null,
    };
}
function getCapabilities(stream, isTerminalStream = !!stream.isTTY) {
    let maybeCaps = streamMap.get(stream);
    if (!maybeCaps) {
        maybeCaps = _createCapabilities(stream, isTerminalStream);
        streamMap.set(stream, maybeCaps);
    }
    return maybeCaps;
}
exports.getCapabilities = getCapabilities;
exports.stdin = getCapabilities(process.stdin);
exports.stdout = getCapabilities(process.stdout);
exports.stderr = getCapabilities(process.stderr);
//# sourceMappingURL=data:application/json;base64,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