"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
const object_1 = require("../utils/object");
const kColors = {
    modifiers: {
        reset: [0, 0],
        bold: [1, 22],
        dim: [2, 22],
        italic: [3, 23],
        underline: [4, 24],
        inverse: [7, 27],
        hidden: [8, 28],
        strikethrough: [9, 29],
    },
    colors: {
        black: [30, 39],
        red: [31, 39],
        green: [32, 39],
        yellow: [33, 39],
        blue: [34, 39],
        magenta: [35, 39],
        cyan: [36, 39],
        white: [37, 39],
        gray: [90, 39],
    },
    bgColors: {
        bgBlack: [40, 49],
        bgRed: [41, 49],
        bgGreen: [42, 49],
        bgYellow: [43, 49],
        bgBlue: [44, 49],
        bgMagenta: [45, 49],
        bgCyan: [46, 49],
        bgWhite: [47, 49],
    },
};
const kColorFunctions = object_1.mapObject(kColors, (_, v) => {
    return object_1.mapObject(v, (_, vv) => (x) => `\u001b[${vv[0]}m${x}\u001b[${vv[1]}m`);
});
exports.reset = kColorFunctions.modifiers.reset;
exports.bold = kColorFunctions.modifiers.bold;
exports.dim = kColorFunctions.modifiers.dim;
exports.italic = kColorFunctions.modifiers.italic;
exports.underline = kColorFunctions.modifiers.underline;
exports.inverse = kColorFunctions.modifiers.inverse;
exports.hidden = kColorFunctions.modifiers.hidden;
exports.strikethrough = kColorFunctions.modifiers.strikethrough;
exports.black = kColorFunctions.colors.black;
exports.red = kColorFunctions.colors.red;
exports.green = kColorFunctions.colors.green;
exports.yellow = kColorFunctions.colors.yellow;
exports.blue = kColorFunctions.colors.blue;
exports.magenta = kColorFunctions.colors.magenta;
exports.cyan = kColorFunctions.colors.cyan;
exports.white = kColorFunctions.colors.white;
exports.grey = kColorFunctions.colors.gray;
exports.gray = kColorFunctions.colors.gray;
exports.bgBlack = kColorFunctions.bgColors.bgBlack;
exports.bgRed = kColorFunctions.bgColors.bgRed;
exports.bgGreen = kColorFunctions.bgColors.bgGreen;
exports.bgYellow = kColorFunctions.bgColors.bgYellow;
exports.bgBlue = kColorFunctions.bgColors.bgBlue;
exports.bgMagenta = kColorFunctions.bgColors.bgMagenta;
exports.bgCyan = kColorFunctions.bgColors.bgCyan;
exports.bgWhite = kColorFunctions.bgColors.bgWhite;
//# sourceMappingURL=data:application/json;base64,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