"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
// tslint:disable-next-line:no-any
function oneLine(strings, ...values) {
    const endResult = String.raw(strings, ...values);
    return endResult.replace(/(?:\r?\n(?:\s*))+/gm, ' ').trim();
}
exports.oneLine = oneLine;
function indentBy(indentations) {
    let i = '';
    while (indentations--) {
        i += ' ';
    }
    return (strings, ...values) => {
        return i + stripIndent(strings, ...values).replace(/\n/g, '\n' + i);
    };
}
exports.indentBy = indentBy;
// tslint:disable-next-line:no-any
function stripIndent(strings, ...values) {
    const endResult = String.raw(strings, ...values);
    // remove the shortest leading indentation from each line
    const match = endResult.match(/^[ \t]*(?=\S)/gm);
    // return early if there's nothing to strip
    if (match === null) {
        return endResult;
    }
    const indent = Math.min(...match.map(el => el.length));
    const regexp = new RegExp('^[ \\t]{' + indent + '}', 'gm');
    return (indent > 0 ? endResult.replace(regexp, '') : endResult).trim();
}
exports.stripIndent = stripIndent;
// tslint:disable-next-line:no-any
function stripIndents(strings, ...values) {
    return String.raw(strings, ...values)
        .split('\n')
        .map(line => line.trim())
        .join('\n')
        .trim();
}
exports.stripIndents = stripIndents;
// tslint:disable-next-line:no-any
function trimNewlines(strings, ...values) {
    const endResult = String.raw(strings, ...values);
    return endResult
        .replace(/^(?:\r?\n)+/, '')
        .replace(/(?:\r?\n(?:\s*))$/, '');
}
exports.trimNewlines = trimNewlines;
//# sourceMappingURL=data:application/json;base64,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