"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
const core_1 = require("@angular-devkit/core");
const node_1 = require("@angular-devkit/core/node");
const rxjs_1 = require("rxjs");
const host_1 = require("./host");
class DryRunSink extends host_1.HostSink {
    constructor(host, force = false) {
        super(typeof host == 'string'
            ? new core_1.virtualFs.ScopedHost(new node_1.NodeJsSyncHost(), core_1.normalize(host))
            : host, force);
        this._subject = new rxjs_1.Subject();
        this._fileDoesNotExistExceptionSet = new Set();
        this._fileAlreadyExistExceptionSet = new Set();
        this.reporter = this._subject.asObservable();
    }
    _fileAlreadyExistException(path) {
        this._fileAlreadyExistExceptionSet.add(path);
    }
    _fileDoesNotExistException(path) {
        this._fileDoesNotExistExceptionSet.add(path);
    }
    _done() {
        this._fileAlreadyExistExceptionSet.forEach(path => {
            this._subject.next({
                kind: 'error',
                description: 'alreadyExist',
                path,
            });
        });
        this._fileDoesNotExistExceptionSet.forEach(path => {
            this._subject.next({
                kind: 'error',
                description: 'doesNotExist',
                path,
            });
        });
        this._filesToDelete.forEach(path => {
            // Check if this is a renaming.
            for (const [from] of this._filesToRename) {
                if (from == path) {
                    // The event is sent later on.
                    return;
                }
            }
            this._subject.next({ kind: 'delete', path });
        });
        this._filesToRename.forEach(([path, to]) => {
            this._subject.next({ kind: 'rename', path, to });
        });
        this._filesToCreate.forEach((content, path) => {
            // Check if this is a renaming.
            for (const [, to] of this._filesToRename) {
                if (to == path) {
                    // The event is sent later on.
                    return;
                }
            }
            if (this._fileAlreadyExistExceptionSet.has(path)
                || this._fileDoesNotExistExceptionSet.has(path)) {
                return;
            }
            this._subject.next({ kind: 'create', path, content: content.generate() });
        });
        this._filesToUpdate.forEach((content, path) => {
            this._subject.next({ kind: 'update', path, content: content.generate() });
        });
        this._subject.complete();
        return rxjs_1.of(undefined);
    }
}
exports.DryRunSink = DryRunSink;
//# sourceMappingURL=data:application/json;base64,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