/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define("@angular/compiler-cli/src/metadata/schema", ["require", "exports"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    // Metadata Schema
    // If you make a backwards incompatible change to the schema, increment the METADTA_VERSION number.
    // If you make a backwards compatible change to the metadata (such as adding an option field) then
    // leave METADATA_VERSION the same. If possible, supply as many versions of the metadata that can
    // represent the semantics of the file in an array. For example, when generating a version 2 file,
    // if version 1 can accurately represent the metadata, generate both version 1 and version 2 in
    // an array.
    exports.METADATA_VERSION = 4;
    function isModuleMetadata(value) {
        return value && value.__symbolic === 'module';
    }
    exports.isModuleMetadata = isModuleMetadata;
    function isClassMetadata(value) {
        return value && value.__symbolic === 'class';
    }
    exports.isClassMetadata = isClassMetadata;
    function isInterfaceMetadata(value) {
        return value && value.__symbolic === 'interface';
    }
    exports.isInterfaceMetadata = isInterfaceMetadata;
    function isMemberMetadata(value) {
        if (value) {
            switch (value.__symbolic) {
                case 'constructor':
                case 'method':
                case 'property':
                    return true;
            }
        }
        return false;
    }
    exports.isMemberMetadata = isMemberMetadata;
    function isMethodMetadata(value) {
        return value && (value.__symbolic === 'constructor' || value.__symbolic === 'method');
    }
    exports.isMethodMetadata = isMethodMetadata;
    function isConstructorMetadata(value) {
        return value && value.__symbolic === 'constructor';
    }
    exports.isConstructorMetadata = isConstructorMetadata;
    function isFunctionMetadata(value) {
        return value && value.__symbolic === 'function';
    }
    exports.isFunctionMetadata = isFunctionMetadata;
    function isMetadataSymbolicExpression(value) {
        if (value) {
            switch (value.__symbolic) {
                case 'binary':
                case 'call':
                case 'index':
                case 'new':
                case 'pre':
                case 'reference':
                case 'select':
                case 'spread':
                case 'if':
                    return true;
            }
        }
        return false;
    }
    exports.isMetadataSymbolicExpression = isMetadataSymbolicExpression;
    function isMetadataSymbolicBinaryExpression(value) {
        return value && value.__symbolic === 'binary';
    }
    exports.isMetadataSymbolicBinaryExpression = isMetadataSymbolicBinaryExpression;
    function isMetadataSymbolicIndexExpression(value) {
        return value && value.__symbolic === 'index';
    }
    exports.isMetadataSymbolicIndexExpression = isMetadataSymbolicIndexExpression;
    function isMetadataSymbolicCallExpression(value) {
        return value && (value.__symbolic === 'call' || value.__symbolic === 'new');
    }
    exports.isMetadataSymbolicCallExpression = isMetadataSymbolicCallExpression;
    function isMetadataSymbolicPrefixExpression(value) {
        return value && value.__symbolic === 'pre';
    }
    exports.isMetadataSymbolicPrefixExpression = isMetadataSymbolicPrefixExpression;
    function isMetadataSymbolicIfExpression(value) {
        return value && value.__symbolic === 'if';
    }
    exports.isMetadataSymbolicIfExpression = isMetadataSymbolicIfExpression;
    function isMetadataGlobalReferenceExpression(value) {
        return value && value.name && !value.module && isMetadataSymbolicReferenceExpression(value);
    }
    exports.isMetadataGlobalReferenceExpression = isMetadataGlobalReferenceExpression;
    function isMetadataModuleReferenceExpression(value) {
        return value && value.module && !value.name && !value.default &&
            isMetadataSymbolicReferenceExpression(value);
    }
    exports.isMetadataModuleReferenceExpression = isMetadataModuleReferenceExpression;
    function isMetadataImportedSymbolReferenceExpression(value) {
        return value && value.module && !!value.name && isMetadataSymbolicReferenceExpression(value);
    }
    exports.isMetadataImportedSymbolReferenceExpression = isMetadataImportedSymbolReferenceExpression;
    function isMetadataImportDefaultReference(value) {
        return value && value.module && value.default && isMetadataSymbolicReferenceExpression(value);
    }
    exports.isMetadataImportDefaultReference = isMetadataImportDefaultReference;
    function isMetadataSymbolicReferenceExpression(value) {
        return value && value.__symbolic === 'reference';
    }
    exports.isMetadataSymbolicReferenceExpression = isMetadataSymbolicReferenceExpression;
    function isMetadataSymbolicSelectExpression(value) {
        return value && value.__symbolic === 'select';
    }
    exports.isMetadataSymbolicSelectExpression = isMetadataSymbolicSelectExpression;
    function isMetadataSymbolicSpreadExpression(value) {
        return value && value.__symbolic === 'spread';
    }
    exports.isMetadataSymbolicSpreadExpression = isMetadataSymbolicSpreadExpression;
    function isMetadataError(value) {
        return value && value.__symbolic === 'error';
    }
    exports.isMetadataError = isMetadataError;
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2NoZW1hLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vLi4vcGFja2FnZXMvY29tcGlsZXItY2xpL3NyYy9tZXRhZGF0YS9zY2hlbWEudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7Ozs7OztHQU1HOzs7Ozs7Ozs7Ozs7SUFFSCxrQkFBa0I7SUFFbEIsbUdBQW1HO0lBRW5HLGtHQUFrRztJQUNsRyxpR0FBaUc7SUFDakcsa0dBQWtHO0lBQ2xHLCtGQUErRjtJQUMvRixZQUFZO0lBRUMsUUFBQSxnQkFBZ0IsR0FBRyxDQUFDLENBQUM7SUFZbEMsMEJBQWlDLEtBQVU7UUFDekMsT0FBTyxLQUFLLElBQUksS0FBSyxDQUFDLFVBQVUsS0FBSyxRQUFRLENBQUM7SUFDaEQsQ0FBQztJQUZELDRDQUVDO0lBZUQseUJBQWdDLEtBQVU7UUFDeEMsT0FBTyxLQUFLLElBQUksS0FBSyxDQUFDLFVBQVUsS0FBSyxPQUFPLENBQUM7SUFDL0MsQ0FBQztJQUZELDBDQUVDO0lBR0QsNkJBQW9DLEtBQVU7UUFDNUMsT0FBTyxLQUFLLElBQUksS0FBSyxDQUFDLFVBQVUsS0FBSyxXQUFXLENBQUM7SUFDbkQsQ0FBQztJQUZELGtEQUVDO0lBUUQsMEJBQWlDLEtBQVU7UUFDekMsSUFBSSxLQUFLLEVBQUU7WUFDVCxRQUFRLEtBQUssQ0FBQyxVQUFVLEVBQUU7Z0JBQ3hCLEtBQUssYUFBYSxDQUFDO2dCQUNuQixLQUFLLFFBQVEsQ0FBQztnQkFDZCxLQUFLLFVBQVU7b0JBQ2IsT0FBTyxJQUFJLENBQUM7YUFDZjtTQUNGO1FBQ0QsT0FBTyxLQUFLLENBQUM7SUFDZixDQUFDO0lBVkQsNENBVUM7SUFNRCwwQkFBaUMsS0FBVTtRQUN6QyxPQUFPLEtBQUssSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLEtBQUssYUFBYSxJQUFJLEtBQUssQ0FBQyxVQUFVLEtBQUssUUFBUSxDQUFDLENBQUM7SUFDeEYsQ0FBQztJQUZELDRDQUVDO0lBTUQsK0JBQXNDLEtBQVU7UUFDOUMsT0FBTyxLQUFLLElBQUksS0FBSyxDQUFDLFVBQVUsS0FBSyxhQUFhLENBQUM7SUFDckQsQ0FBQztJQUZELHNEQUVDO0lBUUQsNEJBQW1DLEtBQVU7UUFDM0MsT0FBTyxLQUFLLElBQUksS0FBSyxDQUFDLFVBQVUsS0FBSyxVQUFVLENBQUM7SUFDbEQsQ0FBQztJQUZELGdEQUVDO0lBcUJELHNDQUE2QyxLQUFVO1FBQ3JELElBQUksS0FBSyxFQUFFO1lBQ1QsUUFBUSxLQUFLLENBQUMsVUFBVSxFQUFFO2dCQUN4QixLQUFLLFFBQVEsQ0FBQztnQkFDZCxLQUFLLE1BQU0sQ0FBQztnQkFDWixLQUFLLE9BQU8sQ0FBQztnQkFDYixLQUFLLEtBQUssQ0FBQztnQkFDWCxLQUFLLEtBQUssQ0FBQztnQkFDWCxLQUFLLFdBQVcsQ0FBQztnQkFDakIsS0FBSyxRQUFRLENBQUM7Z0JBQ2QsS0FBSyxRQUFRLENBQUM7Z0JBQ2QsS0FBSyxJQUFJO29CQUNQLE9BQU8sSUFBSSxDQUFDO2FBQ2Y7U0FDRjtRQUNELE9BQU8sS0FBSyxDQUFDO0lBQ2YsQ0FBQztJQWhCRCxvRUFnQkM7SUFTRCw0Q0FBbUQsS0FBVTtRQUUzRCxPQUFPLEtBQUssSUFBSSxLQUFLLENBQUMsVUFBVSxLQUFLLFFBQVEsQ0FBQztJQUNoRCxDQUFDO0lBSEQsZ0ZBR0M7SUFPRCwyQ0FBa0QsS0FBVTtRQUUxRCxPQUFPLEtBQUssSUFBSSxLQUFLLENBQUMsVUFBVSxLQUFLLE9BQU8sQ0FBQztJQUMvQyxDQUFDO0lBSEQsOEVBR0M7SUFPRCwwQ0FBaUQsS0FBVTtRQUV6RCxPQUFPLEtBQUssSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLEtBQUssTUFBTSxJQUFJLEtBQUssQ0FBQyxVQUFVLEtBQUssS0FBSyxDQUFDLENBQUM7SUFDOUUsQ0FBQztJQUhELDRFQUdDO0lBT0QsNENBQW1ELEtBQVU7UUFFM0QsT0FBTyxLQUFLLElBQUksS0FBSyxDQUFDLFVBQVUsS0FBSyxLQUFLLENBQUM7SUFDN0MsQ0FBQztJQUhELGdGQUdDO0lBUUQsd0NBQStDLEtBQVU7UUFDdkQsT0FBTyxLQUFLLElBQUksS0FBSyxDQUFDLFVBQVUsS0FBSyxJQUFJLENBQUM7SUFDNUMsQ0FBQztJQUZELHdFQUVDO0lBbUJELDZDQUFvRCxLQUFVO1FBRTVELE9BQU8sS0FBSyxJQUFJLEtBQUssQ0FBQyxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsTUFBTSxJQUFJLHFDQUFxQyxDQUFDLEtBQUssQ0FBQyxDQUFDO0lBQzlGLENBQUM7SUFIRCxrRkFHQztJQU1ELDZDQUFvRCxLQUFVO1FBRTVELE9BQU8sS0FBSyxJQUFJLEtBQUssQ0FBQyxNQUFNLElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLE9BQU87WUFDekQscUNBQXFDLENBQUMsS0FBSyxDQUFDLENBQUM7SUFDbkQsQ0FBQztJQUpELGtGQUlDO0lBUUQscURBQTRELEtBQVU7UUFFcEUsT0FBTyxLQUFLLElBQUksS0FBSyxDQUFDLE1BQU0sSUFBSSxDQUFDLENBQUMsS0FBSyxDQUFDLElBQUksSUFBSSxxQ0FBcUMsQ0FBQyxLQUFLLENBQUMsQ0FBQztJQUMvRixDQUFDO0lBSEQsa0dBR0M7SUFTRCwwQ0FBaUQsS0FBVTtRQUV6RCxPQUFPLEtBQUssSUFBSSxLQUFLLENBQUMsTUFBTSxJQUFJLEtBQUssQ0FBQyxPQUFPLElBQUkscUNBQXFDLENBQUMsS0FBSyxDQUFDLENBQUM7SUFDaEcsQ0FBQztJQUhELDRFQUdDO0lBS0QsK0NBQXNELEtBQVU7UUFFOUQsT0FBTyxLQUFLLElBQUksS0FBSyxDQUFDLFVBQVUsS0FBSyxXQUFXLENBQUM7SUFDbkQsQ0FBQztJQUhELHNGQUdDO0lBT0QsNENBQW1ELEtBQVU7UUFFM0QsT0FBTyxLQUFLLElBQUksS0FBSyxDQUFDLFVBQVUsS0FBSyxRQUFRLENBQUM7SUFDaEQsQ0FBQztJQUhELGdGQUdDO0lBTUQsNENBQW1ELEtBQVU7UUFFM0QsT0FBTyxLQUFLLElBQUksS0FBSyxDQUFDLFVBQVUsS0FBSyxRQUFRLENBQUM7SUFDaEQsQ0FBQztJQUhELGdGQUdDO0lBeUJELHlCQUFnQyxLQUFVO1FBQ3hDLE9BQU8sS0FBSyxJQUFJLEtBQUssQ0FBQyxVQUFVLEtBQUssT0FBTyxDQUFDO0lBQy9DLENBQUM7SUFGRCwwQ0FFQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogQGxpY2Vuc2VcbiAqIENvcHlyaWdodCBHb29nbGUgSW5jLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuICpcbiAqIFVzZSBvZiB0aGlzIHNvdXJjZSBjb2RlIGlzIGdvdmVybmVkIGJ5IGFuIE1JVC1zdHlsZSBsaWNlbnNlIHRoYXQgY2FuIGJlXG4gKiBmb3VuZCBpbiB0aGUgTElDRU5TRSBmaWxlIGF0IGh0dHBzOi8vYW5ndWxhci5pby9saWNlbnNlXG4gKi9cblxuLy8gTWV0YWRhdGEgU2NoZW1hXG5cbi8vIElmIHlvdSBtYWtlIGEgYmFja3dhcmRzIGluY29tcGF0aWJsZSBjaGFuZ2UgdG8gdGhlIHNjaGVtYSwgaW5jcmVtZW50IHRoZSBNRVRBRFRBX1ZFUlNJT04gbnVtYmVyLlxuXG4vLyBJZiB5b3UgbWFrZSBhIGJhY2t3YXJkcyBjb21wYXRpYmxlIGNoYW5nZSB0byB0aGUgbWV0YWRhdGEgKHN1Y2ggYXMgYWRkaW5nIGFuIG9wdGlvbiBmaWVsZCkgdGhlblxuLy8gbGVhdmUgTUVUQURBVEFfVkVSU0lPTiB0aGUgc2FtZS4gSWYgcG9zc2libGUsIHN1cHBseSBhcyBtYW55IHZlcnNpb25zIG9mIHRoZSBtZXRhZGF0YSB0aGF0IGNhblxuLy8gcmVwcmVzZW50IHRoZSBzZW1hbnRpY3Mgb2YgdGhlIGZpbGUgaW4gYW4gYXJyYXkuIEZvciBleGFtcGxlLCB3aGVuIGdlbmVyYXRpbmcgYSB2ZXJzaW9uIDIgZmlsZSxcbi8vIGlmIHZlcnNpb24gMSBjYW4gYWNjdXJhdGVseSByZXByZXNlbnQgdGhlIG1ldGFkYXRhLCBnZW5lcmF0ZSBib3RoIHZlcnNpb24gMSBhbmQgdmVyc2lvbiAyIGluXG4vLyBhbiBhcnJheS5cblxuZXhwb3J0IGNvbnN0IE1FVEFEQVRBX1ZFUlNJT04gPSA0O1xuXG5leHBvcnQgdHlwZSBNZXRhZGF0YUVudHJ5ID0gQ2xhc3NNZXRhZGF0YSB8IEludGVyZmFjZU1ldGFkYXRhIHwgRnVuY3Rpb25NZXRhZGF0YSB8IE1ldGFkYXRhVmFsdWU7XG5cbmV4cG9ydCBpbnRlcmZhY2UgTW9kdWxlTWV0YWRhdGEge1xuICBfX3N5bWJvbGljOiAnbW9kdWxlJztcbiAgdmVyc2lvbjogbnVtYmVyO1xuICBleHBvcnRzPzogTW9kdWxlRXhwb3J0TWV0YWRhdGFbXTtcbiAgaW1wb3J0QXM/OiBzdHJpbmc7XG4gIG1ldGFkYXRhOiB7W25hbWU6IHN0cmluZ106IE1ldGFkYXRhRW50cnl9O1xuICBvcmlnaW5zPzoge1tuYW1lOiBzdHJpbmddOiBzdHJpbmd9O1xufVxuZXhwb3J0IGZ1bmN0aW9uIGlzTW9kdWxlTWV0YWRhdGEodmFsdWU6IGFueSk6IHZhbHVlIGlzIE1vZHVsZU1ldGFkYXRhIHtcbiAgcmV0dXJuIHZhbHVlICYmIHZhbHVlLl9fc3ltYm9saWMgPT09ICdtb2R1bGUnO1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIE1vZHVsZUV4cG9ydE1ldGFkYXRhIHtcbiAgZXhwb3J0PzogKHN0cmluZ3x7bmFtZTogc3RyaW5nLCBhczogc3RyaW5nfSlbXTtcbiAgZnJvbTogc3RyaW5nO1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIENsYXNzTWV0YWRhdGEge1xuICBfX3N5bWJvbGljOiAnY2xhc3MnO1xuICBleHRlbmRzPzogTWV0YWRhdGFTeW1ib2xpY0V4cHJlc3Npb258TWV0YWRhdGFFcnJvcjtcbiAgYXJpdHk/OiBudW1iZXI7XG4gIGRlY29yYXRvcnM/OiAoTWV0YWRhdGFTeW1ib2xpY0V4cHJlc3Npb258TWV0YWRhdGFFcnJvcilbXTtcbiAgbWVtYmVycz86IE1ldGFkYXRhTWFwO1xuICBzdGF0aWNzPzoge1tuYW1lOiBzdHJpbmddOiBNZXRhZGF0YVZhbHVlIHwgRnVuY3Rpb25NZXRhZGF0YX07XG59XG5leHBvcnQgZnVuY3Rpb24gaXNDbGFzc01ldGFkYXRhKHZhbHVlOiBhbnkpOiB2YWx1ZSBpcyBDbGFzc01ldGFkYXRhIHtcbiAgcmV0dXJuIHZhbHVlICYmIHZhbHVlLl9fc3ltYm9saWMgPT09ICdjbGFzcyc7XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgSW50ZXJmYWNlTWV0YWRhdGEgeyBfX3N5bWJvbGljOiAnaW50ZXJmYWNlJzsgfVxuZXhwb3J0IGZ1bmN0aW9uIGlzSW50ZXJmYWNlTWV0YWRhdGEodmFsdWU6IGFueSk6IHZhbHVlIGlzIEludGVyZmFjZU1ldGFkYXRhIHtcbiAgcmV0dXJuIHZhbHVlICYmIHZhbHVlLl9fc3ltYm9saWMgPT09ICdpbnRlcmZhY2UnO1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIE1ldGFkYXRhTWFwIHsgW25hbWU6IHN0cmluZ106IE1lbWJlck1ldGFkYXRhW107IH1cblxuZXhwb3J0IGludGVyZmFjZSBNZW1iZXJNZXRhZGF0YSB7XG4gIF9fc3ltYm9saWM6ICdjb25zdHJ1Y3Rvcid8J21ldGhvZCd8J3Byb3BlcnR5JztcbiAgZGVjb3JhdG9ycz86IChNZXRhZGF0YVN5bWJvbGljRXhwcmVzc2lvbnxNZXRhZGF0YUVycm9yKVtdO1xufVxuZXhwb3J0IGZ1bmN0aW9uIGlzTWVtYmVyTWV0YWRhdGEodmFsdWU6IGFueSk6IHZhbHVlIGlzIE1lbWJlck1ldGFkYXRhIHtcbiAgaWYgKHZhbHVlKSB7XG4gICAgc3dpdGNoICh2YWx1ZS5fX3N5bWJvbGljKSB7XG4gICAgICBjYXNlICdjb25zdHJ1Y3Rvcic6XG4gICAgICBjYXNlICdtZXRob2QnOlxuICAgICAgY2FzZSAncHJvcGVydHknOlxuICAgICAgICByZXR1cm4gdHJ1ZTtcbiAgICB9XG4gIH1cbiAgcmV0dXJuIGZhbHNlO1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIE1ldGhvZE1ldGFkYXRhIGV4dGVuZHMgTWVtYmVyTWV0YWRhdGEge1xuICBfX3N5bWJvbGljOiAnY29uc3RydWN0b3InfCdtZXRob2QnO1xuICBwYXJhbWV0ZXJEZWNvcmF0b3JzPzogKChNZXRhZGF0YVN5bWJvbGljRXhwcmVzc2lvbiB8IE1ldGFkYXRhRXJyb3IpW118dW5kZWZpbmVkKVtdO1xufVxuZXhwb3J0IGZ1bmN0aW9uIGlzTWV0aG9kTWV0YWRhdGEodmFsdWU6IGFueSk6IHZhbHVlIGlzIE1ldGhvZE1ldGFkYXRhIHtcbiAgcmV0dXJuIHZhbHVlICYmICh2YWx1ZS5fX3N5bWJvbGljID09PSAnY29uc3RydWN0b3InIHx8IHZhbHVlLl9fc3ltYm9saWMgPT09ICdtZXRob2QnKTtcbn1cblxuZXhwb3J0IGludGVyZmFjZSBDb25zdHJ1Y3Rvck1ldGFkYXRhIGV4dGVuZHMgTWV0aG9kTWV0YWRhdGEge1xuICBfX3N5bWJvbGljOiAnY29uc3RydWN0b3InO1xuICBwYXJhbWV0ZXJzPzogKE1ldGFkYXRhU3ltYm9saWNFeHByZXNzaW9ufE1ldGFkYXRhRXJyb3J8bnVsbHx1bmRlZmluZWQpW107XG59XG5leHBvcnQgZnVuY3Rpb24gaXNDb25zdHJ1Y3Rvck1ldGFkYXRhKHZhbHVlOiBhbnkpOiB2YWx1ZSBpcyBDb25zdHJ1Y3Rvck1ldGFkYXRhIHtcbiAgcmV0dXJuIHZhbHVlICYmIHZhbHVlLl9fc3ltYm9saWMgPT09ICdjb25zdHJ1Y3Rvcic7XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgRnVuY3Rpb25NZXRhZGF0YSB7XG4gIF9fc3ltYm9saWM6ICdmdW5jdGlvbic7XG4gIHBhcmFtZXRlcnM6IHN0cmluZ1tdO1xuICBkZWZhdWx0cz86IE1ldGFkYXRhVmFsdWVbXTtcbiAgdmFsdWU6IE1ldGFkYXRhVmFsdWU7XG59XG5leHBvcnQgZnVuY3Rpb24gaXNGdW5jdGlvbk1ldGFkYXRhKHZhbHVlOiBhbnkpOiB2YWx1ZSBpcyBGdW5jdGlvbk1ldGFkYXRhIHtcbiAgcmV0dXJuIHZhbHVlICYmIHZhbHVlLl9fc3ltYm9saWMgPT09ICdmdW5jdGlvbic7XG59XG5cbmV4cG9ydCB0eXBlIE1ldGFkYXRhVmFsdWUgPSBzdHJpbmcgfCBudW1iZXIgfCBib29sZWFuIHwgdW5kZWZpbmVkIHwgbnVsbCB8IE1ldGFkYXRhT2JqZWN0IHxcbiAgICBNZXRhZGF0YUFycmF5IHwgTWV0YWRhdGFTeW1ib2xpY0V4cHJlc3Npb24gfCBNZXRhZGF0YVN5bWJvbGljUmVmZXJlbmNlRXhwcmVzc2lvbiB8XG4gICAgTWV0YWRhdGFTeW1ib2xpY0JpbmFyeUV4cHJlc3Npb24gfCBNZXRhZGF0YVN5bWJvbGljSW5kZXhFeHByZXNzaW9uIHxcbiAgICBNZXRhZGF0YVN5bWJvbGljQ2FsbEV4cHJlc3Npb24gfCBNZXRhZGF0YVN5bWJvbGljUHJlZml4RXhwcmVzc2lvbiB8XG4gICAgTWV0YWRhdGFTeW1ib2xpY0lmRXhwcmVzc2lvbiB8IE1ldGFkYXRhU3ltYm9saWNTcHJlYWRFeHByZXNzaW9uIHxcbiAgICBNZXRhZGF0YVN5bWJvbGljU2VsZWN0RXhwcmVzc2lvbiB8IE1ldGFkYXRhRXJyb3I7XG5cbmV4cG9ydCBpbnRlcmZhY2UgTWV0YWRhdGFPYmplY3QgeyBbbmFtZTogc3RyaW5nXTogTWV0YWRhdGFWYWx1ZTsgfVxuXG5leHBvcnQgaW50ZXJmYWNlIE1ldGFkYXRhQXJyYXkgeyBbbmFtZTogbnVtYmVyXTogTWV0YWRhdGFWYWx1ZTsgfVxuXG5leHBvcnQgdHlwZSBNZXRhZGF0YVN5bWJvbGljRXhwcmVzc2lvbiA9IE1ldGFkYXRhU3ltYm9saWNCaW5hcnlFeHByZXNzaW9uIHxcbiAgICBNZXRhZGF0YVN5bWJvbGljSW5kZXhFeHByZXNzaW9uIHwgTWV0YWRhdGFTeW1ib2xpY0luZGV4RXhwcmVzc2lvbiB8XG4gICAgTWV0YWRhdGFTeW1ib2xpY0NhbGxFeHByZXNzaW9uIHwgTWV0YWRhdGFTeW1ib2xpY0NhbGxFeHByZXNzaW9uIHxcbiAgICBNZXRhZGF0YVN5bWJvbGljUHJlZml4RXhwcmVzc2lvbiB8IE1ldGFkYXRhU3ltYm9saWNJZkV4cHJlc3Npb24gfFxuICAgIE1ldGFkYXRhR2xvYmFsUmVmZXJlbmNlRXhwcmVzc2lvbiB8IE1ldGFkYXRhTW9kdWxlUmVmZXJlbmNlRXhwcmVzc2lvbiB8XG4gICAgTWV0YWRhdGFJbXBvcnRlZFN5bWJvbFJlZmVyZW5jZUV4cHJlc3Npb24gfCBNZXRhZGF0YUltcG9ydGVkRGVmYXVsdFJlZmVyZW5jZUV4cHJlc3Npb24gfFxuICAgIE1ldGFkYXRhU3ltYm9saWNTZWxlY3RFeHByZXNzaW9uIHwgTWV0YWRhdGFTeW1ib2xpY1NwcmVhZEV4cHJlc3Npb247XG5cbmV4cG9ydCBmdW5jdGlvbiBpc01ldGFkYXRhU3ltYm9saWNFeHByZXNzaW9uKHZhbHVlOiBhbnkpOiB2YWx1ZSBpcyBNZXRhZGF0YVN5bWJvbGljRXhwcmVzc2lvbiB7XG4gIGlmICh2YWx1ZSkge1xuICAgIHN3aXRjaCAodmFsdWUuX19zeW1ib2xpYykge1xuICAgICAgY2FzZSAnYmluYXJ5JzpcbiAgICAgIGNhc2UgJ2NhbGwnOlxuICAgICAgY2FzZSAnaW5kZXgnOlxuICAgICAgY2FzZSAnbmV3JzpcbiAgICAgIGNhc2UgJ3ByZSc6XG4gICAgICBjYXNlICdyZWZlcmVuY2UnOlxuICAgICAgY2FzZSAnc2VsZWN0JzpcbiAgICAgIGNhc2UgJ3NwcmVhZCc6XG4gICAgICBjYXNlICdpZic6XG4gICAgICAgIHJldHVybiB0cnVlO1xuICAgIH1cbiAgfVxuICByZXR1cm4gZmFsc2U7XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgTWV0YWRhdGFTeW1ib2xpY0JpbmFyeUV4cHJlc3Npb24ge1xuICBfX3N5bWJvbGljOiAnYmluYXJ5JztcbiAgb3BlcmF0b3I6ICcmJid8J3x8J3wnfCd8J14nfCcmJ3wnPT0nfCchPSd8Jz09PSd8JyE9PSd8JzwnfCc+J3wnPD0nfCc+PSd8J2luc3RhbmNlb2YnfCdpbid8J2FzJ3xcbiAgICAgICc8PCd8Jz4+J3wnPj4+J3wnKyd8Jy0nfCcqJ3wnLyd8JyUnfCcqKic7XG4gIGxlZnQ6IE1ldGFkYXRhVmFsdWU7XG4gIHJpZ2h0OiBNZXRhZGF0YVZhbHVlO1xufVxuZXhwb3J0IGZ1bmN0aW9uIGlzTWV0YWRhdGFTeW1ib2xpY0JpbmFyeUV4cHJlc3Npb24odmFsdWU6IGFueSk6XG4gICAgdmFsdWUgaXMgTWV0YWRhdGFTeW1ib2xpY0JpbmFyeUV4cHJlc3Npb24ge1xuICByZXR1cm4gdmFsdWUgJiYgdmFsdWUuX19zeW1ib2xpYyA9PT0gJ2JpbmFyeSc7XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgTWV0YWRhdGFTeW1ib2xpY0luZGV4RXhwcmVzc2lvbiB7XG4gIF9fc3ltYm9saWM6ICdpbmRleCc7XG4gIGV4cHJlc3Npb246IE1ldGFkYXRhVmFsdWU7XG4gIGluZGV4OiBNZXRhZGF0YVZhbHVlO1xufVxuZXhwb3J0IGZ1bmN0aW9uIGlzTWV0YWRhdGFTeW1ib2xpY0luZGV4RXhwcmVzc2lvbih2YWx1ZTogYW55KTpcbiAgICB2YWx1ZSBpcyBNZXRhZGF0YVN5bWJvbGljSW5kZXhFeHByZXNzaW9uIHtcbiAgcmV0dXJuIHZhbHVlICYmIHZhbHVlLl9fc3ltYm9saWMgPT09ICdpbmRleCc7XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgTWV0YWRhdGFTeW1ib2xpY0NhbGxFeHByZXNzaW9uIHtcbiAgX19zeW1ib2xpYzogJ2NhbGwnfCduZXcnO1xuICBleHByZXNzaW9uOiBNZXRhZGF0YVZhbHVlO1xuICBhcmd1bWVudHM/OiBNZXRhZGF0YVZhbHVlW107XG59XG5leHBvcnQgZnVuY3Rpb24gaXNNZXRhZGF0YVN5bWJvbGljQ2FsbEV4cHJlc3Npb24odmFsdWU6IGFueSk6XG4gICAgdmFsdWUgaXMgTWV0YWRhdGFTeW1ib2xpY0NhbGxFeHByZXNzaW9uIHtcbiAgcmV0dXJuIHZhbHVlICYmICh2YWx1ZS5fX3N5bWJvbGljID09PSAnY2FsbCcgfHwgdmFsdWUuX19zeW1ib2xpYyA9PT0gJ25ldycpO1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIE1ldGFkYXRhU3ltYm9saWNQcmVmaXhFeHByZXNzaW9uIHtcbiAgX19zeW1ib2xpYzogJ3ByZSc7XG4gIG9wZXJhdG9yOiAnKyd8Jy0nfCd+J3wnISc7XG4gIG9wZXJhbmQ6IE1ldGFkYXRhVmFsdWU7XG59XG5leHBvcnQgZnVuY3Rpb24gaXNNZXRhZGF0YVN5bWJvbGljUHJlZml4RXhwcmVzc2lvbih2YWx1ZTogYW55KTpcbiAgICB2YWx1ZSBpcyBNZXRhZGF0YVN5bWJvbGljUHJlZml4RXhwcmVzc2lvbiB7XG4gIHJldHVybiB2YWx1ZSAmJiB2YWx1ZS5fX3N5bWJvbGljID09PSAncHJlJztcbn1cblxuZXhwb3J0IGludGVyZmFjZSBNZXRhZGF0YVN5bWJvbGljSWZFeHByZXNzaW9uIHtcbiAgX19zeW1ib2xpYzogJ2lmJztcbiAgY29uZGl0aW9uOiBNZXRhZGF0YVZhbHVlO1xuICB0aGVuRXhwcmVzc2lvbjogTWV0YWRhdGFWYWx1ZTtcbiAgZWxzZUV4cHJlc3Npb246IE1ldGFkYXRhVmFsdWU7XG59XG5leHBvcnQgZnVuY3Rpb24gaXNNZXRhZGF0YVN5bWJvbGljSWZFeHByZXNzaW9uKHZhbHVlOiBhbnkpOiB2YWx1ZSBpcyBNZXRhZGF0YVN5bWJvbGljSWZFeHByZXNzaW9uIHtcbiAgcmV0dXJuIHZhbHVlICYmIHZhbHVlLl9fc3ltYm9saWMgPT09ICdpZic7XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgTWV0YWRhdGFTb3VyY2VMb2NhdGlvbkluZm8ge1xuICAvKipcbiAgICogVGhlIGxpbmUgbnVtYmVyIG9mIHRoZSBlcnJvciBpbiB0aGUgLnRzIGZpbGUgdGhlIG1ldGFkYXRhIHdhcyBjcmVhdGVkIGZvci5cbiAgICovXG4gIGxpbmU/OiBudW1iZXI7XG5cbiAgLyoqXG4gICAqIFRoZSBudW1iZXIgb2YgdXRmOCBjb2RlLXVuaXRzIGZyb20gdGhlIGJlZ2lubmluZyBvZiB0aGUgZmlsZSBvZiB0aGUgZXJyb3IuXG4gICAqL1xuICBjaGFyYWN0ZXI/OiBudW1iZXI7XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgTWV0YWRhdGFHbG9iYWxSZWZlcmVuY2VFeHByZXNzaW9uIGV4dGVuZHMgTWV0YWRhdGFTb3VyY2VMb2NhdGlvbkluZm8ge1xuICBfX3N5bWJvbGljOiAncmVmZXJlbmNlJztcbiAgbmFtZTogc3RyaW5nO1xuICBhcmd1bWVudHM/OiBNZXRhZGF0YVZhbHVlW107XG59XG5leHBvcnQgZnVuY3Rpb24gaXNNZXRhZGF0YUdsb2JhbFJlZmVyZW5jZUV4cHJlc3Npb24odmFsdWU6IGFueSk6XG4gICAgdmFsdWUgaXMgTWV0YWRhdGFHbG9iYWxSZWZlcmVuY2VFeHByZXNzaW9uIHtcbiAgcmV0dXJuIHZhbHVlICYmIHZhbHVlLm5hbWUgJiYgIXZhbHVlLm1vZHVsZSAmJiBpc01ldGFkYXRhU3ltYm9saWNSZWZlcmVuY2VFeHByZXNzaW9uKHZhbHVlKTtcbn1cblxuZXhwb3J0IGludGVyZmFjZSBNZXRhZGF0YU1vZHVsZVJlZmVyZW5jZUV4cHJlc3Npb24gZXh0ZW5kcyBNZXRhZGF0YVNvdXJjZUxvY2F0aW9uSW5mbyB7XG4gIF9fc3ltYm9saWM6ICdyZWZlcmVuY2UnO1xuICBtb2R1bGU6IHN0cmluZztcbn1cbmV4cG9ydCBmdW5jdGlvbiBpc01ldGFkYXRhTW9kdWxlUmVmZXJlbmNlRXhwcmVzc2lvbih2YWx1ZTogYW55KTpcbiAgICB2YWx1ZSBpcyBNZXRhZGF0YU1vZHVsZVJlZmVyZW5jZUV4cHJlc3Npb24ge1xuICByZXR1cm4gdmFsdWUgJiYgdmFsdWUubW9kdWxlICYmICF2YWx1ZS5uYW1lICYmICF2YWx1ZS5kZWZhdWx0ICYmXG4gICAgICBpc01ldGFkYXRhU3ltYm9saWNSZWZlcmVuY2VFeHByZXNzaW9uKHZhbHVlKTtcbn1cblxuZXhwb3J0IGludGVyZmFjZSBNZXRhZGF0YUltcG9ydGVkU3ltYm9sUmVmZXJlbmNlRXhwcmVzc2lvbiBleHRlbmRzIE1ldGFkYXRhU291cmNlTG9jYXRpb25JbmZvIHtcbiAgX19zeW1ib2xpYzogJ3JlZmVyZW5jZSc7XG4gIG1vZHVsZTogc3RyaW5nO1xuICBuYW1lOiBzdHJpbmc7XG4gIGFyZ3VtZW50cz86IE1ldGFkYXRhVmFsdWVbXTtcbn1cbmV4cG9ydCBmdW5jdGlvbiBpc01ldGFkYXRhSW1wb3J0ZWRTeW1ib2xSZWZlcmVuY2VFeHByZXNzaW9uKHZhbHVlOiBhbnkpOlxuICAgIHZhbHVlIGlzIE1ldGFkYXRhSW1wb3J0ZWRTeW1ib2xSZWZlcmVuY2VFeHByZXNzaW9uIHtcbiAgcmV0dXJuIHZhbHVlICYmIHZhbHVlLm1vZHVsZSAmJiAhIXZhbHVlLm5hbWUgJiYgaXNNZXRhZGF0YVN5bWJvbGljUmVmZXJlbmNlRXhwcmVzc2lvbih2YWx1ZSk7XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgTWV0YWRhdGFJbXBvcnRlZERlZmF1bHRSZWZlcmVuY2VFeHByZXNzaW9uIGV4dGVuZHMgTWV0YWRhdGFTb3VyY2VMb2NhdGlvbkluZm8ge1xuICBfX3N5bWJvbGljOiAncmVmZXJlbmNlJztcbiAgbW9kdWxlOiBzdHJpbmc7XG4gIGRlZmF1bHQ6XG4gICAgYm9vbGVhbjtcbiAgICBhcmd1bWVudHM/OiBNZXRhZGF0YVZhbHVlW107XG59XG5leHBvcnQgZnVuY3Rpb24gaXNNZXRhZGF0YUltcG9ydERlZmF1bHRSZWZlcmVuY2UodmFsdWU6IGFueSk6XG4gICAgdmFsdWUgaXMgTWV0YWRhdGFJbXBvcnRlZERlZmF1bHRSZWZlcmVuY2VFeHByZXNzaW9uIHtcbiAgcmV0dXJuIHZhbHVlICYmIHZhbHVlLm1vZHVsZSAmJiB2YWx1ZS5kZWZhdWx0ICYmIGlzTWV0YWRhdGFTeW1ib2xpY1JlZmVyZW5jZUV4cHJlc3Npb24odmFsdWUpO1xufVxuXG5leHBvcnQgdHlwZSBNZXRhZGF0YVN5bWJvbGljUmVmZXJlbmNlRXhwcmVzc2lvbiA9IE1ldGFkYXRhR2xvYmFsUmVmZXJlbmNlRXhwcmVzc2lvbiB8XG4gICAgTWV0YWRhdGFNb2R1bGVSZWZlcmVuY2VFeHByZXNzaW9uIHwgTWV0YWRhdGFJbXBvcnRlZFN5bWJvbFJlZmVyZW5jZUV4cHJlc3Npb24gfFxuICAgIE1ldGFkYXRhSW1wb3J0ZWREZWZhdWx0UmVmZXJlbmNlRXhwcmVzc2lvbjtcbmV4cG9ydCBmdW5jdGlvbiBpc01ldGFkYXRhU3ltYm9saWNSZWZlcmVuY2VFeHByZXNzaW9uKHZhbHVlOiBhbnkpOlxuICAgIHZhbHVlIGlzIE1ldGFkYXRhU3ltYm9saWNSZWZlcmVuY2VFeHByZXNzaW9uIHtcbiAgcmV0dXJuIHZhbHVlICYmIHZhbHVlLl9fc3ltYm9saWMgPT09ICdyZWZlcmVuY2UnO1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIE1ldGFkYXRhU3ltYm9saWNTZWxlY3RFeHByZXNzaW9uIHtcbiAgX19zeW1ib2xpYzogJ3NlbGVjdCc7XG4gIGV4cHJlc3Npb246IE1ldGFkYXRhVmFsdWU7XG4gIG1lbWJlcjogc3RyaW5nO1xufVxuZXhwb3J0IGZ1bmN0aW9uIGlzTWV0YWRhdGFTeW1ib2xpY1NlbGVjdEV4cHJlc3Npb24odmFsdWU6IGFueSk6XG4gICAgdmFsdWUgaXMgTWV0YWRhdGFTeW1ib2xpY1NlbGVjdEV4cHJlc3Npb24ge1xuICByZXR1cm4gdmFsdWUgJiYgdmFsdWUuX19zeW1ib2xpYyA9PT0gJ3NlbGVjdCc7XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgTWV0YWRhdGFTeW1ib2xpY1NwcmVhZEV4cHJlc3Npb24ge1xuICBfX3N5bWJvbGljOiAnc3ByZWFkJztcbiAgZXhwcmVzc2lvbjogTWV0YWRhdGFWYWx1ZTtcbn1cbmV4cG9ydCBmdW5jdGlvbiBpc01ldGFkYXRhU3ltYm9saWNTcHJlYWRFeHByZXNzaW9uKHZhbHVlOiBhbnkpOlxuICAgIHZhbHVlIGlzIE1ldGFkYXRhU3ltYm9saWNTcHJlYWRFeHByZXNzaW9uIHtcbiAgcmV0dXJuIHZhbHVlICYmIHZhbHVlLl9fc3ltYm9saWMgPT09ICdzcHJlYWQnO1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIE1ldGFkYXRhRXJyb3IgZXh0ZW5kcyBNZXRhZGF0YVNvdXJjZUxvY2F0aW9uSW5mbyB7XG4gIF9fc3ltYm9saWM6ICdlcnJvcic7XG5cbiAgLyoqXG4gICAqIFRoaXMgbWVzc2FnZSBzaG91bGQgYmUgc2hvcnQgYW5kIHJlbGF0aXZlbHkgZGlzY3JpcHRpdmUgYW5kIHNob3VsZCBiZSBmaXhlZCBvbmNlIGl0IGlzIGNyZWF0ZWQuXG4gICAqIElmIHRoZSByZWFkZXIgZG9lc24ndCByZWNvZ25pemUgdGhlIG1lc3NhZ2UsIGl0IHdpbGwgZGlzcGxheSB0aGUgbWVzc2FnZSB1bm1vZGlmaWVkLiBJZiB0aGVcbiAgICogcmVhZGVyIHJlY29nbml6ZXMgdGhlIGVycm9yIG1lc3NhZ2UgaXMgaXQgZnJlZSB0byB1c2Ugc3Vic3RpdHV0ZSBtZXNzYWdlIHRoZSBpcyBtb3JlXG4gICAqIGRlc2NyaXB0aXZlIGFuZC9vciBsb2NhbGl6ZWQuXG4gICAqL1xuICBtZXNzYWdlOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBtb2R1bGUgb2YgdGhlIGVycm9yIChvbmx5IHVzZWQgaW4gYnVuZGxlZCBtZXRhZGF0YSlcbiAgICovXG4gIG1vZHVsZT86IHN0cmluZztcblxuICAvKipcbiAgICogQ29udGV4dCBpbmZvcm1hdGlvbiB0aGF0IGNhbiBiZSB1c2VkIHRvIGdlbmVyYXRlIGEgbW9yZSBkZXNjcmlwdGl2ZSBlcnJvciBtZXNzYWdlLiBUaGUgY29udGVudFxuICAgKiBvZiB0aGUgY29udGV4dCBpcyBkZXBlbmRlbnQgb24gdGhlIGVycm9yIG1lc3NhZ2UuXG4gICAqL1xuICBjb250ZXh0Pzoge1tuYW1lOiBzdHJpbmddOiBzdHJpbmd9O1xufVxuXG5leHBvcnQgZnVuY3Rpb24gaXNNZXRhZGF0YUVycm9yKHZhbHVlOiBhbnkpOiB2YWx1ZSBpcyBNZXRhZGF0YUVycm9yIHtcbiAgcmV0dXJuIHZhbHVlICYmIHZhbHVlLl9fc3ltYm9saWMgPT09ICdlcnJvcic7XG59XG4iXX0=