/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,uselessCode} checked by tsc
 */
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { defineInjectable, defineInjector, } from '../../di/defs';
import { inject } from '../../di/injector';
import * as r3 from '../index';
import * as sanitization from '../../sanitization/sanitization';
/** *
 * A mapping of the \@angular/core API surface used in generated expressions to the actual symbols.
 *
 * This should be kept up to date with the public exports of \@angular/core.
  @type {?} */
export const angularCoreEnv = {
    'ɵdefineComponent': r3.defineComponent,
    'ɵdefineDirective': r3.defineDirective,
    'defineInjectable': defineInjectable,
    'defineInjector': defineInjector,
    'ɵdefineNgModule': r3.defineNgModule,
    'ɵdefinePipe': r3.definePipe,
    'ɵdirectiveInject': r3.directiveInject,
    'inject': inject,
    'ɵinjectAttribute': r3.injectAttribute,
    'ɵinjectChangeDetectorRef': r3.injectChangeDetectorRef,
    'ɵinjectElementRef': r3.injectElementRef,
    'ɵinjectTemplateRef': r3.injectTemplateRef,
    'ɵinjectViewContainerRef': r3.injectViewContainerRef,
    'ɵNgOnChangesFeature': r3.NgOnChangesFeature,
    'ɵInheritDefinitionFeature': r3.InheritDefinitionFeature,
    'ɵa': r3.a,
    'ɵb': r3.b,
    'ɵC': r3.C,
    'ɵcR': r3.cR,
    'ɵcr': r3.cr,
    'ɵd': r3.d,
    'ɵql': r3.ql,
    'ɵNH': r3.NH,
    'ɵNM': r3.NM,
    'ɵNS': r3.NS,
    'ɵE': r3.E,
    'ɵe': r3.e,
    'ɵEe': r3.Ee,
    'ɵf0': r3.f0,
    'ɵf1': r3.f1,
    'ɵf2': r3.f2,
    'ɵf3': r3.f3,
    'ɵf4': r3.f4,
    'ɵf5': r3.f5,
    'ɵf6': r3.f6,
    'ɵf7': r3.f7,
    'ɵf8': r3.f8,
    'ɵfV': r3.fV,
    'ɵi1': r3.i1,
    'ɵi2': r3.i2,
    'ɵi3': r3.i3,
    'ɵi4': r3.i4,
    'ɵi5': r3.i5,
    'ɵi6': r3.i6,
    'ɵi7': r3.i7,
    'ɵi8': r3.i8,
    'ɵiV': r3.iV,
    'ɵcp': r3.cp,
    'ɵL': r3.L,
    'ɵld': r3.ld,
    'ɵP': r3.P,
    'ɵp': r3.p,
    'ɵpb1': r3.pb1,
    'ɵpb2': r3.pb2,
    'ɵpb3': r3.pb3,
    'ɵpb4': r3.pb4,
    'ɵpbV': r3.pbV,
    'ɵpD': r3.pD,
    'ɵPp': r3.Pp,
    'ɵQ': r3.Q,
    'ɵqR': r3.qR,
    'ɵQr': r3.Qr,
    'ɵrS': r3.rS,
    'ɵs': r3.s,
    'ɵsm': r3.sm,
    'ɵsp': r3.sp,
    'ɵsa': r3.sa,
    'ɵT': r3.T,
    'ɵt': r3.t,
    'ɵV': r3.V,
    'ɵv': r3.v,
    'ɵzh': sanitization.sanitizeHtml,
    'ɵzs': sanitization.sanitizeStyle,
    'ɵzss': sanitization.defaultStyleSanitizer,
    'ɵzr': sanitization.sanitizeResourceUrl,
    'ɵzc': sanitization.sanitizeScript,
    'ɵzu': sanitization.sanitizeUrl
};

//# sourceMappingURL=data:application/json;base64,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