/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
/**
 * @description
 *
 * Represents a type that a Component or other object is instances of.
 *
 * An example of a `Type` is `MyCustomComponent` class, which in JavaScript is be represented by
 * the `MyCustomComponent` constructor function.
 *
 *
 */
export var Type = Function;
export function isType(v) {
    return typeof v === 'function';
}

//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidHlwZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uLy4uLy4uLy4uL3BhY2thZ2VzL2NvcmUvc3JjL3R5cGUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7Ozs7OztHQU1HO0FBRUg7Ozs7Ozs7OztHQVNHO0FBQ0gsTUFBTSxDQUFDLElBQU0sSUFBSSxHQUFHLFFBQVEsQ0FBQztBQUU3QixNQUFNLGlCQUFpQixDQUFNO0lBQzNCLE9BQU8sT0FBTyxDQUFDLEtBQUssVUFBVSxDQUFDO0FBQ2pDLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIEBsaWNlbnNlXG4gKiBDb3B5cmlnaHQgR29vZ2xlIEluYy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbiAqXG4gKiBVc2Ugb2YgdGhpcyBzb3VyY2UgY29kZSBpcyBnb3Zlcm5lZCBieSBhbiBNSVQtc3R5bGUgbGljZW5zZSB0aGF0IGNhbiBiZVxuICogZm91bmQgaW4gdGhlIExJQ0VOU0UgZmlsZSBhdCBodHRwczovL2FuZ3VsYXIuaW8vbGljZW5zZVxuICovXG5cbi8qKlxuICogQGRlc2NyaXB0aW9uXG4gKlxuICogUmVwcmVzZW50cyBhIHR5cGUgdGhhdCBhIENvbXBvbmVudCBvciBvdGhlciBvYmplY3QgaXMgaW5zdGFuY2VzIG9mLlxuICpcbiAqIEFuIGV4YW1wbGUgb2YgYSBgVHlwZWAgaXMgYE15Q3VzdG9tQ29tcG9uZW50YCBjbGFzcywgd2hpY2ggaW4gSmF2YVNjcmlwdCBpcyBiZSByZXByZXNlbnRlZCBieVxuICogdGhlIGBNeUN1c3RvbUNvbXBvbmVudGAgY29uc3RydWN0b3IgZnVuY3Rpb24uXG4gKlxuICpcbiAqL1xuZXhwb3J0IGNvbnN0IFR5cGUgPSBGdW5jdGlvbjtcblxuZXhwb3J0IGZ1bmN0aW9uIGlzVHlwZSh2OiBhbnkpOiB2IGlzIFR5cGU8YW55PiB7XG4gIHJldHVybiB0eXBlb2YgdiA9PT0gJ2Z1bmN0aW9uJztcbn1cblxuZXhwb3J0IGludGVyZmFjZSBUeXBlPFQ+IGV4dGVuZHMgRnVuY3Rpb24geyBuZXcgKC4uLmFyZ3M6IGFueVtdKTogVDsgfVxuIl19