"use strict";

var Luci = Luci || {};

Luci.Search = function() {
  const searchInputs = document.querySelectorAll('.luci-search__form-input');
  const suggestionsHiddenClass = 'luci-search__suggest--is-hidden';
  const clearSearchButtonHiddenClass = 'luci-search__button-close--is-hidden';
  const comments = [
    {name: "FAS Auto-suggest option one"}, {name: "FAS9200 Configuration"}, {name: "FAS Upgrade Advisor"}, {name: "FAS AutoSupport"}, {name: "FAS Troubleshooting"}
  ];

  function navigateList(searchInput) {
    const list = document.querySelector('.luci-search__suggest-group');
    const firstListItem = list.firstChild.nextSibling.querySelector('.luci-list-group__element--link');
    switch (event.keyCode) {
      case 38:
        if (document.activeElement === (searchInput || firstListItem)) {
          break;
        } else {
          document.activeElement.parentNode.previousSibling.previousSibling.firstChild.nextSibling.focus();
        }
        break;
      case 40:
        if (document.activeElement === searchInput) {
          firstListItem.focus();
        } else {
          document.activeElement.parentNode.nextSibling.nextSibling.firstChild.nextSibling.focus();
        }
      break;
    }
  }

  function clearSearch(search, suggestions) {
    search.value = '';
    if (suggestions) {
      suggestions.classList.add(suggestionsHiddenClass);
    }
  }

  function toggleClearSearchButton(search, suggestions) {
    const clearSearchButton = search.nextSibling.nextSibling;
    clearSearchButton.classList.remove(clearSearchButtonHiddenClass);
    clearSearchButton.addEventListener('click', function() {
      this.classList.add(clearSearchButtonHiddenClass);
      clearSearch(search, suggestions);
    });
    if (event.keyCode === 27) {
      clearSearchButton.classList.add(clearSearchButtonHiddenClass);
      clearSearch(search, suggestions);
    }
  }
  /* eslint-disable no-shadow */
  function findMatches(wordToMatch, comments) {
    return comments.filter(text => {
      const regex = new RegExp(wordToMatch, 'gi');
      return text.name.match(regex);
    });
  }
  /* eslint-enable no-shadow */

  function displayMatches(search, suggestions) {
    const suggestionList = suggestions.firstChild.nextSibling;
    const matchArray = findMatches(search.value, comments);
    const html = matchArray.map(text => {
      const regex = new RegExp(search.value, 'gi');
      const title = text.name.replace(regex, search.value);
      return `
        <li class="luci-list-group__item" tabindex="-1">
          <a href="#" class="luci-list-group__element luci-list-group__element--link">${title}</a>
        </li>
      `;
    }).join('');
    suggestionList.innerHTML = html;
    if (suggestionList.children.length === 0) {
      suggestions.classList.add(suggestionsHiddenClass);
    } else if (search.value.length >= 2) {
      suggestions.classList.remove(suggestionsHiddenClass);
    }
  }

  function handleSearchInput() {
    const suggestions = this.parentNode.nextSibling.nextSibling;
    if (suggestions) {
      displayMatches(this, suggestions);
    }
    toggleClearSearchButton(this, suggestions);

    suggestions.addEventListener('keydown', function() {
      if (event.keyCode === 13) {
        event.preventDefault();
        const listItemText = document.activeElement.textContent;
        const searchInput = this.parentNode.querySelector('.luci-search__form-input');
        searchInput.value = listItemText;
        suggestions.classList.add(suggestionsHiddenClass);
      }
    });
  }

  function handleDocumentKeydown(event) {
    const suggestions = document.querySelector('.luci-search__suggest');
    const clearSearchButton = document.querySelectorAll('.luci-search__button-close');
    searchInputs.forEach(function(el) {
      if (event.keyCode === 27) {
        el.value = '';
        suggestions.classList.add(suggestionsHiddenClass);
        clearSearchButton.forEach(function (button) {
          button.classList.add(clearSearchButtonHiddenClass);
        });
      }
    });
    if (suggestions) {
      const searchInput = suggestions.parentNode.querySelector('.luci-search__form-input');
      if (event.keyCode === 40 || event.keyCode === 38) {
        event.preventDefault();
        navigateList(searchInput);
      }
    }
  }

  const init = function init() {
    searchInputs.forEach(function(searchInput) {
      searchInput.addEventListener('keydown', handleSearchInput);
      if (searchInput.value !== '') {
        toggleClearSearchButton(searchInput);
      }
    });
    document.addEventListener('keydown', handleDocumentKeydown);
  };

  return {
    init: init
  };
}();

document.addEventListener('DOMContentLoaded', function() {
  Luci.Search.init();
});
