"use strict";

var Luci = Luci || {};

Luci.DataTable = function() {
  // code goes here
  const selectRowCheckbox = document.querySelectorAll('tbody .luci-checkbox__label input'),
        selectHeadCheckbox = document.querySelectorAll('thead .luci-checkbox__label input'),
        selectedRowClass = 'luci-table__row--selected',
        expanableRowAction = document.querySelectorAll('.luci-table--expand-button'),
        inlineAction = document.querySelectorAll('.luci-list-group__element--table-inline-action'),
        inlineActionEdit = document.querySelectorAll('.luci-table__action--inline-edit'),
        inlineActionDelete = document.querySelectorAll('.luci-table__action--inline-delete'),
        inlineActionClone = document.querySelectorAll('.luci-table__action--inline-clone'),
        inlineEditButtonSave = document.querySelectorAll('.luci-button--inline-edit-success'),
        inlineEditButtonCancel = document.querySelectorAll('.luci-button--inline-edit-close'),
        editModeRowClass = 'luci-table__row--edit-mode';

  function toggleSelectedRow(checkbox) {
    const selectedRow = Luci.Utils.getClosestParent(checkbox, '.luci-table__row--select');
    if (selectedRow.classList.contains(selectedRowClass)) {
      selectedRow.classList.remove(selectedRowClass);
    } else {
      selectedRow.classList.add(selectedRowClass);
    }
  }

  function handleSelectedRow() {
    toggleSelectedRow(this);
  }

  function handleToggleAllRows() {
    let targetTable = this.closest('.luci-table__table');
    let targetCheckboxes = targetTable.querySelectorAll('tbody .luci-checkbox__label input');
    let targetRows = targetTable.querySelectorAll('tbody tr');

    if (this.checked === true) {
      targetCheckboxes.forEach(function (el) {
        el.checked = true;
      });
      targetRows.forEach(function (el) {
        el.classList.add(selectedRowClass);
      });
    } else {
      targetCheckboxes.forEach(function (el) {
        el.checked = false;
      });
      targetRows.forEach(function (el) {
        el.classList.remove(selectedRowClass);
      });
    }
  }

  function watchCheckedRows() {
    let targetTable = this.closest('.luci-table__table');
    let targetCheckboxes = targetTable.querySelectorAll('tbody .luci-checkbox__label input');
    let toggleAllCheckboxes = targetTable.querySelector('thead .luci-checkbox__label input');
    let totalCheckboxes = targetCheckboxes.length;
    let totalChecked = 0;

    targetCheckboxes.forEach(function (el) {
      if (el.checked === true) {
        totalChecked += 1;
      }
    });

    if (totalChecked === totalCheckboxes) {
      toggleAllCheckboxes.checked = true;
    } else {
      toggleAllCheckboxes.checked = false;
    }
  }

  function handleExpandableRow() {
    let expandable_row = this.closest('.luci-table__row--expandable');
    let child_row = expandable_row.nextElementSibling;

    if (expandable_row.classList.contains('luci-table__row--is-expanded')) {
      expandable_row.classList.remove('luci-table__row--is-expanded');
      child_row.classList.remove('luci-table__row--is-expanded');
    } else {
      expandable_row.classList.add('luci-table__row--is-expanded');
    }
  }

  function handleInlineAction(e) {
    e.preventDefault();
    let menu = this.closest('.luci-menu');
    let menuTrigger = menu.querySelector('.luci-menu__trigger');

    menuTrigger.click();
  }

  function handleInlineActionEdit() {
    let row = this.closest('tr');
    let editableCells = row.querySelectorAll('.luci-table__cell--inline-edit');
    let radioCells = row.querySelectorAll('.luci-table__cell--inline-edit-radio');
    let saveButton = row.querySelector('.luci-button--inline-edit-success');
    let cancelButton = row.querySelector('.luci-button--inline-edit-close');

    function handleInlineEdit(e) {
      if (e.keyCode === 13) {
        saveButton.click();
      }
      if (e.keyCode === 27) {
        cancelButton.click();
      }
    }

    if (!row.classList.contains(editModeRowClass)) {
      row.classList.add(editModeRowClass);

      editableCells.forEach(function (el) {
        let oldText = el.textContent.trim();

        el.dataset.oldText = oldText;

        el.innerHTML = '<input type="text" name="small" class="luci-form__input luci-form__input--sm" value="' + oldText + '">';
      });

      let inlineEdit = row.querySelectorAll('.luci-table__cell--inline-edit .luci-form__input');

      inlineEdit.forEach(function (el) {
        el.addEventListener('keyup', handleInlineEdit);
      });

      inlineEdit[0].focus();
      inlineEdit[0].select();

      radioCells.forEach(function (el) {
        let oldValue = el.querySelector('span').textContent.trim();
        let randomIdOn = Math.floor(Math.random() * 3000);
        let randomIdOff = Math.floor(Math.random() * 3000);
        let onIsCheked = oldValue === "ON" ? "checked" : null;
        let offIsCheked = oldValue === "OFF" ? "checked" : null;

        el.dataset.oldValue = oldValue;

        el.innerHTML = `
          <span class="luci-form__radio">
            <label for="luci-input-on-` + randomIdOn + `" class="luci-radio__label">
              <input class="luci-table__radio" type="radio" name="options-` + randomIdOn + `" id="luci-input-on-` + randomIdOn + `" value="ON" ` + onIsCheked + `>
              <span class="luci-radio__button"></span>
              <span class="luci-radio__label-text">On</span>
            </label>
          </span>
          <span class="luci-form__radio">
            <label for="luci-input-off-` + randomIdOff + `" class="luci-radio__label">
              <input class="luci-table__radio" type="radio" name="options-` + randomIdOn + `" id="luci-input-off-` + randomIdOff + `" value="OFF" ` + offIsCheked + `>
              <span class="luci-radio__button"></span>
              <span class="luci-radio__label-text">Off</span>
            </label>
          </span>
        `;
      });

      let inlineRadio = row.querySelectorAll('.luci-table__cell--inline-edit-radio .luci-table__radio');

      inlineRadio.forEach(function (el) {
        el.addEventListener('keyup', handleInlineEdit);
      });
    }
  }

  function handleInlineEditButtonSave() {
    let row = this.closest('tr');
    let editableCells = row.querySelectorAll('.luci-table__cell--inline-edit');
    let radioCells = row.querySelectorAll('.luci-table__cell--inline-edit-radio');

    row.classList.remove(editModeRowClass);

    editableCells.forEach(function (el) {
      let newText = el.querySelector('.luci-form__input').value;

      el.innerHTML = newText;

      el.removeAttribute('data-old-text');
    });

    radioCells.forEach(function (el) {
      let newValue = el.querySelector('.luci-table__radio:checked').value;

      el.innerHTML = "<span>" + newValue + "</span> | <a href='#'>Action</a>";

      el.removeAttribute('data-old-value');
    });
  }

  function handleInlineEditButtonCancel() {
    let row = this.closest('tr');
    let editableCells = row.querySelectorAll('.luci-table__cell--inline-edit');
    let radioCells = row.querySelectorAll('.luci-table__cell--inline-edit-radio');

    row.classList.remove(editModeRowClass);

    editableCells.forEach(function (el) {
      let oldText = el.dataset.oldText;

      el.innerHTML = oldText;

      el.removeAttribute('data-old-text');
    });

    radioCells.forEach(function (el) {
      el.innerHTML = "<span>" + el.dataset.oldValue + "</span> | <a href='#'>Action</a>";

      el.removeAttribute('data-old-value');
    });
  }

  function handleInlineActionDelete() {
    let row = this.closest('tr');

    row.classList.add('luci-table__row--fadeout');

    setTimeout(function(){
        row.remove();
    }, 500);
  }

  function handleInlineActionClone() {
    let row = this.closest('tr');
    let newClone = row.cloneNode(true);

    newClone.classList.add('luci-table__row--fadein');

    row.parentNode.insertBefore(newClone, row.nextSibling);

    const inlineActionEditClone = newClone.querySelector('.luci-table__action--inline-edit'),
        inlineActionDeleteClone = newClone.querySelector('.luci-table__action--inline-delete'),
        inlineActionCloneClone = newClone.querySelector('.luci-table__action--inline-clone'),
        inlineEditButtonSaveClone = newClone.querySelector('.luci-button--inline-edit-success'),
        inlineEditButtonCancelClone = newClone.querySelector('.luci-button--inline-edit-close');

    inlineActionEditClone.addEventListener('click', handleInlineActionEdit);
    inlineEditButtonSaveClone.addEventListener('click', handleInlineEditButtonSave);
    inlineEditButtonCancelClone.addEventListener('click', handleInlineEditButtonCancel);
    inlineActionDeleteClone.addEventListener('click', handleInlineActionDelete);
    inlineActionCloneClone.addEventListener('click', handleInlineActionClone);
  }

  const init = function init() {
    selectRowCheckbox.forEach(function (el) {
      el.addEventListener('click', handleSelectedRow);
    });

    selectRowCheckbox.forEach(function (el) {
      el.addEventListener('change', watchCheckedRows);
    });

    selectHeadCheckbox.forEach(function (el) {
      el.addEventListener('change', handleToggleAllRows);
    });

    expanableRowAction.forEach(function (el) {
      el.addEventListener('click', handleExpandableRow);
    });

    inlineAction.forEach(function (el) {
      el.addEventListener('click', handleInlineAction);
    });

    inlineActionEdit.forEach(function (el) {
      el.addEventListener('click', handleInlineActionEdit);
    });

    inlineEditButtonSave.forEach(function (el) {
      el.addEventListener('click', handleInlineEditButtonSave);
    });

    inlineEditButtonCancel.forEach(function (el) {
      el.addEventListener('click', handleInlineEditButtonCancel);
    });

    inlineActionDelete.forEach(function (el) {
      el.addEventListener('click', handleInlineActionDelete);
    });

    inlineActionClone.forEach(function (el) {
      el.addEventListener('click', handleInlineActionClone);
    });
  };

  return {
    init: init
  };
}();

document.addEventListener('DOMContentLoaded', function() {
  Luci.DataTable.init();
});
