"use strict";

function luciTag() {
    const tagButton = document.querySelectorAll('.luci-tag__button'),
        tagDismissiClass = 'luci-tag--is-dismissing';

    function toggleMenu(menu) {
        var target = menu.closest('.luci-tag__item');

        target.classList.add(tagDismissiClass);
        setTimeout(function() {
         target.remove();
        }, 300);
    }

    function handletagButtonClick() {
        toggleMenu(this);
    }

    tagButton.forEach(function(e){
        e.addEventListener('click', handletagButtonClick);
    });
}

document.addEventListener('DOMContentLoaded', function() {
    luciTag();
});
