/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Injectable } from '@angular/core';
import { TransitionService } from '@uirouter/core';
import { get } from 'lodash-es';
import { interval, merge, of, Subject, zip } from 'rxjs';
import { concatMap, filter, map, share, takeUntil } from 'rxjs/operators';
import { NwfjsConfigService } from '../../../nwfjs.config.service';
export class NwfBeaconService {
    /**
     * @param {?} transitionService
     * @param {?} config
     */
    constructor(transitionService, config) {
        this.transitionService = transitionService;
        this.config = config;
        // Reset beacon on transition
        this.transitionService.onBefore({}, (/**
         * @return {?}
         */
        () => {
            this.ngOnDestroy();
            this.ngOnInit();
        }));
        // Initial construction of the beacon service
        this.ngOnInit();
    }
    /**
     * @param {?} pollInterval
     * @return {?}
     */
    setInterval(pollInterval) {
        this.resetTrigger();
        // Polling interval and signal to start the next request
        /** @type {?} */
        const pollIntervalObs = interval(pollInterval);
        // Wait for previous poll to compolete before starting another
        /** @type {?} */
        const polling = zip(pollIntervalObs, this.nextPoll.pipe(takeUntil(this.destroyTrigger)));
        polling.pipe(takeUntil(this.destroyTrigger)).subscribe(this.triggerLoad);
    }
    /**
     * @param {?} trigger
     * @return {?}
     */
    setTrigger(trigger) {
        this.resetTrigger();
        trigger.pipe(takeUntil(this.destroyTrigger), takeUntil(this.destroy)).subscribe(this.triggerLoad);
    }
    // Trigger interval data request
    /**
     * @return {?}
     */
    start() {
        this.triggerLoad.next();
    }
    // Trigger manual data request
    /**
     * @return {?}
     */
    refresh() {
        this.manualLoad.next();
    }
    // Register service call to load data and return observable that emits the data
    /**
     * @template T
     * @param {?} serviceCall
     * @return {?}
     */
    register(serviceCall) {
        /** @type {?} */
        const serviceObservable = this.loadData.pipe(takeUntil(this.destroy), concatMap(serviceCall), share());
        this.services.push(serviceObservable);
        return serviceObservable;
    }
    /**
     * @private
     * @return {?}
     */
    ngOnInit() {
        this.services = [];
        this.destroy = new Subject();
        this.manualLoad = new Subject();
        this.nextPoll = new Subject();
        this.triggerLoad = new Subject();
        this.destroyTrigger = new Subject();
        /** @type {?} */
        const beaconInterval = get(this.config, 'beaconInterval');
        if (beaconInterval) {
            this.setInterval(beaconInterval);
        }
        /*if(this.beaconListener) {
            this.setTrigger(this.beaconListener.getBeacon());
        }*/
        // Load data triggers all the service calls
        this.loadData = merge(this.triggerLoad.pipe(map((/**
         * @return {?}
         */
        () => NwfBeaconService.TRIGGER))), this.manualLoad.pipe(map((/**
         * @return {?}
         */
        () => NwfBeaconService.MANUAL))))
            .pipe(takeUntil(this.destroy), // complete all subscriptions on destroy
        share());
        // We want to wait until all request are complete before firing off the next poll request
        this.loadComplete = this.loadData.pipe(concatMap((/**
         * @param {?} value
         * @return {?}
         */
        (value) => zip(of(value), ...this.services))), share());
        this.loadComplete.pipe(filter((/**
         * @param {?} __0
         * @return {?}
         */
        ([val]) => val === NwfBeaconService.TRIGGER))).subscribe(this.nextPoll);
    }
    /**
     * @private
     * @return {?}
     */
    resetTrigger() {
        if (this.destroyTrigger) {
            this.destroyTrigger.next();
            this.destroyTrigger.complete();
        }
        this.destroyTrigger = new Subject();
    }
    // Clean up subjects
    /**
     * @private
     * @return {?}
     */
    ngOnDestroy() {
        this.destroy.next();
        this.destroy.complete();
        this.destroyTrigger.next();
        this.destroyTrigger.complete();
        this.nextPoll.complete();
        this.manualLoad.complete();
        this.triggerLoad.complete();
    }
}
NwfBeaconService.MANUAL = 'manual';
NwfBeaconService.TRIGGER = 'trigger';
NwfBeaconService.decorators = [
    { type: Injectable }
];
/** @nocollapse */
NwfBeaconService.ctorParameters = () => [
    { type: TransitionService },
    { type: NwfjsConfigService }
];
if (false) {
    /**
     * @type {?}
     * @private
     */
    NwfBeaconService.MANUAL;
    /**
     * @type {?}
     * @private
     */
    NwfBeaconService.TRIGGER;
    /** @type {?} */
    NwfBeaconService.prototype.loadData;
    /** @type {?} */
    NwfBeaconService.prototype.loadComplete;
    /**
     * @type {?}
     * @private
     */
    NwfBeaconService.prototype.triggerLoad;
    /**
     * @type {?}
     * @private
     */
    NwfBeaconService.prototype.destroyTrigger;
    /**
     * @type {?}
     * @private
     */
    NwfBeaconService.prototype.destroy;
    /**
     * @type {?}
     * @private
     */
    NwfBeaconService.prototype.manualLoad;
    /**
     * @type {?}
     * @private
     */
    NwfBeaconService.prototype.nextPoll;
    /**
     * @type {?}
     * @private
     */
    NwfBeaconService.prototype.services;
    /**
     * @type {?}
     * @private
     */
    NwfBeaconService.prototype.transitionService;
    /**
     * @type {?}
     * @private
     */
    NwfBeaconService.prototype.config;
}
//# sourceMappingURL=data:application/json;base64,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