/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
/**
 * Sets the date and time value as provided by the user.
 * When the user selects a date or time using this datetimepicker, setDateTime is called and the value is setted.
 */
import { Component, Input } from '@angular/core';
import { NG_VALUE_ACCESSOR } from '@angular/forms';
/** @type {?} */
const currentDate = new Date();
/** @type {?} */
const last13MonthsDate = new Date(currentDate.getTime() - (395 * 24 * 60 * 60 * 1000));
export class NwfDatetimePicker {
    constructor() {
        this.minDate = { year: last13MonthsDate.getFullYear(), month: last13MonthsDate.getMonth() + 1, day: last13MonthsDate.getDate() };
        this.maxDate = { year: currentDate.getFullYear(), month: currentDate.getMonth() + 1, day: currentDate.getDate() };
        this.navigation = 'arrows';
    }
    /**
     * @return {?}
     */
    ngOnInit() { }
    /**
     * Sets the min and max date for the widget. By default, minDate is the exact 13 months ago date and maxDate is the current date.
     * These dates are updated according to the min and max data provided in the argument of the function.
     * @param {?} changes - SimpleChanges
     * @return {?} void
     */
    ngOnChanges(changes) {
        // set maxDate, minDate if it exists in changes object.
        // else it takes default values defined above.
        if (changes.maxDate) {
            // converting string to Date object.
            /** @type {?} */
            const maxDateObject = new Date(changes.maxDate.currentValue);
            // creating NgbDateStruct model representation out of regular js date object.
            this.maxDate = { year: maxDateObject.getFullYear(), month: maxDateObject.getMonth() + 1, day: maxDateObject.getDate() };
        }
        if (changes.minDate) {
            // converting string to Date object.
            /** @type {?} */
            const minDateObject = new Date(changes.minDate.currentValue);
            // creating NgbDateStruct model representation out of regular js date object.
            this.minDate = { year: minDateObject.getFullYear(), month: minDateObject.getMonth() + 1, day: minDateObject.getDate() };
        }
    }
    /**
     *
     * writeValue() - Sets the datepickerModel, timePickerModel and startDate according to the date passed in the argument of the function.
     * @param {?} datetimePickerValue - string
     * @return {?} void
     */
    writeValue(datetimePickerValue) {
        if (datetimePickerValue) {
            // converting string to Date object.
            /** @type {?} */
            const dateObject = new Date(datetimePickerValue);
            // creating NgbDateStruct model representation out of regular js date object.
            // we add +1 to month because NgbDateStruct month property takes in value as ISO format ie. month should be between 1-12,
            // whereas getMonth returns month values from 0-11.
            this.datepickerModel = { year: dateObject.getFullYear(), month: dateObject.getMonth() + 1, day: dateObject.getDate() };
            this.startDate = { year: this.datepickerModel.year, month: this.datepickerModel.month };
            // creating NgbTimeStruct model representation out of regular js date object.
            this.timepickerModel = { hour: dateObject.getHours(), minute: dateObject.getMinutes(), second: 0 };
        }
    }
    /**
     * @param {?} fn
     * @return {?}
     */
    registerOnChange(fn) { this._onChange = fn; }
    /**
     * @param {?} fn
     * @return {?}
     */
    registerOnTouched(fn) { }
    /**
     * @return {?}
     */
    setDatetime() {
        const { year, month, day } = this.datepickerModel;
        const { hour, minute } = this.timepickerModel;
        /** @type {?} */
        const newDate = new Date(year, month - 1, day, hour, minute);
        this._onChange(newDate.toISOString());
    }
}
NwfDatetimePicker.decorators = [
    { type: Component, args: [{
                selector: 'nwf-datetime-picker',
                template: `
        <ngb-datepicker [(ngModel)]="datepickerModel" [maxDate]="maxDate" [minDate]="minDate" [startDate]="startDate"
            [navigation]="navigation" firstDayOfWeek="7" (ngModelChange)="setDatetime()"></ngb-datepicker>
        <div class="col my-2 p-0">
            <span class="label">{{'nwfjs:time' | i18next}}:</span>
            <ngb-timepicker [(ngModel)]="timepickerModel" [meridian]=true (ngModelChange)="setDatetime()"></ngb-timepicker>
        </div>
    `,
                providers: [{
                        provide: NG_VALUE_ACCESSOR,
                        useExisting: NwfDatetimePicker,
                        multi: true,
                    }],
                styles: [".ngb-tp-input-container{color:red}.ngb-tp-input-container .form-control{width:60px}"]
            }] }
];
NwfDatetimePicker.propDecorators = {
    minDate: [{ type: Input }],
    maxDate: [{ type: Input }]
};
if (false) {
    /** @type {?} */
    NwfDatetimePicker.prototype.minDate;
    /** @type {?} */
    NwfDatetimePicker.prototype.maxDate;
    /** @type {?} */
    NwfDatetimePicker.prototype.datepickerModel;
    /** @type {?} */
    NwfDatetimePicker.prototype.timepickerModel;
    /** @type {?} */
    NwfDatetimePicker.prototype.navigation;
    /** @type {?} */
    NwfDatetimePicker.prototype.startDate;
    /**
     * @type {?}
     * @private
     */
    NwfDatetimePicker.prototype._onChange;
}
//# sourceMappingURL=data:application/json;base64,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