/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
/**
 * Sets the date-time range as provided by the user. The widget has 2 calendars for selecting a set of fromDate and toDate.
 */
import { Component } from '@angular/core';
import { NG_VALUE_ACCESSOR } from '@angular/forms';
export class NwfDatetimeRangePicker {
    constructor() { }
    /**
     * @return {?}
     */
    ngOnInit() { }
    /**
     * @param {?} changes
     * @return {?}
     */
    ngOnChanges(changes) { }
    /**
     * writeValue() - Sets the fromDate and toDate according to the input.
     * @param {?} datetimeRangeValue - any
     * @return {?} void
     */
    writeValue(datetimeRangeValue) {
        if (datetimeRangeValue) {
            [this.fromDateISOString, this.toDateISOString] = datetimeRangeValue.split('~');
            // setting visible value.
            this.setVisibleValue();
        }
    }
    /**
     * @param {?} fn
     * @return {?}
     */
    registerOnChange(fn) { this._onChange = fn; }
    /**
     * @param {?} fn
     * @return {?}
     */
    registerOnTouched(fn) { }
    /**
     * setDatetimeRange() - Sets the fromDate and toDate from the ISOStrings
     * These dates are updated according to the min and max data provided in the argument of the function.
     * @return {?} void
     */
    setDatetimeRange() {
        // create comma-separated range.
        /** @type {?} */
        const newDatetimeRange = `${this.fromDateISOString}~${this.toDateISOString}`;
        // setting visible value.
        this.setVisibleValue();
        // calling callback with sending the datetime range.
        this._onChange(newDatetimeRange);
    }
    /**
     * @return {?}
     */
    setVisibleValue() {
        this.fromDate = new Date(this.fromDateISOString);
        this.toDate = new Date(this.toDateISOString);
    }
}
NwfDatetimeRangePicker.decorators = [
    { type: Component, args: [{
                selector: 'nwf-datetime-range-picker',
                template: `
        <ng-template #datetimerangePickerTemplate>
            <div class="d-flex" data-netapp-id="datetime-range-picker">
                <div class="p-2 d-flex flex-column" (click)="$event.stopPropagation()" data-netapp-id="datetime-from-picker">
                    From:
                    <nwf-datetime-picker [(ngModel)]="fromDateISOString" [maxDate]="toDateISOString" (ngModelChange)="setDatetimeRange()"></nwf-datetime-picker>
                </div>
                <div class="p-2 d-flex flex-column" (click)="$event.stopPropagation()" data-netapp-id="datetime-to-picker">
                    To:
                    <nwf-datetime-picker [(ngModel)]="toDateISOString" [minDate]="fromDateISOString" (ngModelChange)="setDatetimeRange()"></nwf-datetime-picker>
                </div>
            </div>
        </ng-template>
        <button type="button" class="btn btn-default datetimepicker-button form-control" [ngbPopover]="datetimerangePickerTemplate" placement="bottom-right"
        data-netapp-id="filter-widget-btn">
            <nwf-icon iconClass="icon-action-calendar"></nwf-icon>
            <span class="datetimepicker-value" data-netapp-id="dateTimePicker-widget-label">
                {{ fromDate | i18nextFormat: { format: 'datetime' } }} to {{ toDate | i18nextFormat: { format: 'datetime' } }}
            </span>
        </button>
    `,
                providers: [{
                        provide: NG_VALUE_ACCESSOR,
                        useExisting: NwfDatetimeRangePicker,
                        multi: true,
                    }],
                styles: [".datetimepicker-button{width:190px;height:50px!important;display:flex}.datetimepicker-value{white-space:normal;text-align:initial;width:170px;margin:0}"]
            }] }
];
/** @nocollapse */
NwfDatetimeRangePicker.ctorParameters = () => [];
if (false) {
    /** @type {?} */
    NwfDatetimeRangePicker.prototype.fromDateISOString;
    /** @type {?} */
    NwfDatetimeRangePicker.prototype.toDateISOString;
    /** @type {?} */
    NwfDatetimeRangePicker.prototype.fromDate;
    /** @type {?} */
    NwfDatetimeRangePicker.prototype.toDate;
    /**
     * @type {?}
     * @private
     */
    NwfDatetimeRangePicker.prototype._onChange;
}
//# sourceMappingURL=data:application/json;base64,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