/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Injectable } from '@angular/core';
import { NwfLeftnavService } from '../../shell/leftnav/leftnav.service';
import * as i0 from "@angular/core";
import * as i1 from "../../shell/leftnav/leftnav.service";
export class NwfFeatureTourService {
    /**
     * @param {?} leftnavService
     */
    constructor(leftnavService) {
        this.leftnavService = leftnavService;
        this.tours = {};
    }
    /**
     * @param {?} group
     * @param {?} pop
     * @param {?=} slf
     * @return {?}
     */
    registerTour(group, pop, slf) {
        const [groupName, order] = group.split('-');
        /** @type {?} */
        let orderInt = parseInt(order);
        if (!orderInt) {
            /** @type {?} */
            const tourGroup = this.tours[groupName];
            orderInt = tourGroup && tourGroup.length ? tourGroup.length : 0;
        }
        this.addTourToGroup(groupName, orderInt, pop, slf);
        pop.hidden.subscribe((/**
         * @return {?}
         */
        () => {
            /** @type {?} */
            const thisGroup = this.tours[groupName];
            /** @type {?} */
            let nextInd;
            for (let i = 0; i < thisGroup.length; i++) {
                if (pop == thisGroup[i].pop) {
                    nextInd = i + 1;
                    break;
                }
            }
            /** @type {?} */
            const nextTour = thisGroup[nextInd];
            if (nextTour) {
                nextTour.pop.open();
            }
            else {
                // at end of tour!
            }
        }));
    }
    /**
     * @param {?} group
     * @return {?}
     */
    startTour(group) {
        const [nextTour] = this.tours[group];
        if (nextTour && nextTour.self) {
            this.leftnavService.recurseNavData((/**
             * @param {?} node
             * @return {?}
             */
            (node) => {
                if (node.children.indexOf(nextTour.self) !== -1) {
                    node.isCollapsed = false;
                }
            }));
        }
        nextTour.pop.open();
    }
    /**
     * @private
     * @param {?} group
     * @param {?} order
     * @param {?} pop
     * @param {?} slf
     * @return {?}
     */
    addTourToGroup(group, order, pop, slf) {
        if (!this.tours[group]) {
            this.tours[group] = [];
        }
        this.tours[group].splice(order, 1, { pop, self: slf });
    }
}
NwfFeatureTourService.decorators = [
    { type: Injectable, args: [{
                providedIn: 'root',
            },] }
];
/** @nocollapse */
NwfFeatureTourService.ctorParameters = () => [
    { type: NwfLeftnavService }
];
/** @nocollapse */ NwfFeatureTourService.ngInjectableDef = i0.defineInjectable({ factory: function NwfFeatureTourService_Factory() { return new NwfFeatureTourService(i0.inject(i1.NwfLeftnavService)); }, token: NwfFeatureTourService, providedIn: "root" });
if (false) {
    /** @type {?} */
    NwfFeatureTourService.prototype.tours;
    /** @type {?} */
    NwfFeatureTourService.prototype.leftnavService;
}
//# sourceMappingURL=data:application/json;base64,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