/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Injectable } from '@angular/core';
import { Subject } from 'rxjs';
import { debounceTime, share } from 'rxjs/operators';
/**
 * This service is for observing column changes of the dxdatagrid through the onColumnsChanging event.
 *
 * Example:
 * onInitialized: (e) => {
 *     e.component.option("onColumnsChanging", (e) => {
 *         this.columnsChangingService.onColumnsChanging(e);
 *     });
 * }
 */
export class NwfColumnsChangingService {
    constructor() {
        this.columnsChanging = new Subject();
        this.columnsChanging$ = this.columnsChanging.asObservable().pipe(debounceTime(10), share());
    }
    /**
     * @param {?} event
     * @return {?}
     */
    onColumnsChanging(event) {
        this.columnsChanging.next(event);
    }
}
NwfColumnsChangingService.decorators = [
    { type: Injectable }
];
if (false) {
    /** @type {?} */
    NwfColumnsChangingService.prototype.columnsChanging;
    /** @type {?} */
    NwfColumnsChangingService.prototype.columnsChanging$;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZ3JpZC1jb2x1bW5zLWNoYW5naW5nLnNlcnZpY2UuanMiLCJzb3VyY2VSb290Ijoibmc6Ly9AbmV0YXBwL253ZmpzX2FuZ3VsYXJfY29tcG9uZW50cy8iLCJzb3VyY2VzIjpbImxpYi9jb21wb25lbnRzL2dyaWQtY29sdW1ucy1jaGFuZ2luZy5zZXJ2aWNlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7QUFBQSxPQUFPLEVBQUUsVUFBVSxFQUFFLE1BQU0sZUFBZSxDQUFDO0FBQzNDLE9BQU8sRUFBYyxPQUFPLEVBQUUsTUFBTSxNQUFNLENBQUM7QUFDM0MsT0FBTyxFQUFFLFlBQVksRUFBRSxLQUFLLEVBQUUsTUFBTSxnQkFBZ0IsQ0FBQzs7Ozs7Ozs7Ozs7QUFhckQsTUFBTSxPQUFPLHlCQUF5QjtJQUR0QztRQUdXLG9CQUFlLEdBQWlCLElBQUksT0FBTyxFQUFFLENBQUM7UUFDOUMscUJBQWdCLEdBQW9CLElBQUksQ0FBQyxlQUFlLENBQUMsWUFBWSxFQUFFLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQyxFQUFFLENBQUMsRUFBRSxLQUFLLEVBQUUsQ0FBQyxDQUFDO0lBS25ILENBQUM7Ozs7O0lBSFUsaUJBQWlCLENBQUMsS0FBSztRQUMxQixJQUFJLENBQUMsZUFBZSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQztJQUNyQyxDQUFDOzs7WUFSSixVQUFVOzs7O0lBR1Asb0RBQXFEOztJQUNyRCxxREFBK0ciLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBJbmplY3RhYmxlIH0gZnJvbSAnQGFuZ3VsYXIvY29yZSc7XG5pbXBvcnQgeyBPYnNlcnZhYmxlLCBTdWJqZWN0IH0gZnJvbSAncnhqcyc7XG5pbXBvcnQgeyBkZWJvdW5jZVRpbWUsIHNoYXJlIH0gZnJvbSAncnhqcy9vcGVyYXRvcnMnO1xuXG4vKipcbiAqIFRoaXMgc2VydmljZSBpcyBmb3Igb2JzZXJ2aW5nIGNvbHVtbiBjaGFuZ2VzIG9mIHRoZSBkeGRhdGFncmlkIHRocm91Z2ggdGhlIG9uQ29sdW1uc0NoYW5naW5nIGV2ZW50LlxuICpcbiAqIEV4YW1wbGU6XG4gKiBvbkluaXRpYWxpemVkOiAoZSkgPT4ge1xuICogICAgIGUuY29tcG9uZW50Lm9wdGlvbihcIm9uQ29sdW1uc0NoYW5naW5nXCIsIChlKSA9PiB7XG4gKiAgICAgICAgIHRoaXMuY29sdW1uc0NoYW5naW5nU2VydmljZS5vbkNvbHVtbnNDaGFuZ2luZyhlKTtcbiAqICAgICB9KTtcbiAqIH1cbiAqL1xuQEluamVjdGFibGUoKVxuZXhwb3J0IGNsYXNzIE53ZkNvbHVtbnNDaGFuZ2luZ1NlcnZpY2Uge1xuXG4gICAgcHVibGljIGNvbHVtbnNDaGFuZ2luZzogU3ViamVjdDxhbnk+ID0gbmV3IFN1YmplY3QoKTtcbiAgICBwdWJsaWMgY29sdW1uc0NoYW5naW5nJDogT2JzZXJ2YWJsZTxhbnk+ID0gdGhpcy5jb2x1bW5zQ2hhbmdpbmcuYXNPYnNlcnZhYmxlKCkucGlwZShkZWJvdW5jZVRpbWUoMTApLCBzaGFyZSgpKTtcblxuICAgIHB1YmxpYyBvbkNvbHVtbnNDaGFuZ2luZyhldmVudCkge1xuICAgICAgICB0aGlzLmNvbHVtbnNDaGFuZ2luZy5uZXh0KGV2ZW50KTtcbiAgICB9XG59XG4iXX0=