/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Injectable } from '@angular/core';
import { Subject } from 'rxjs';
export class NwfPageAlertService {
    constructor() {
        this.pageAlert = new Subject();
        this.pageAlert$ = this.pageAlert.asObservable();
    }
    // Method to Show Page Alert
    /**
     * @param {?} message
     * @param {?} severity
     * @param {?=} fade
     * @return {?}
     */
    show(message, severity, fade) {
        this.pageAlert.next({ type: 'show', config: { message, severity, fade } });
    }
    // Method to Hide Page Alert
    /**
     * @return {?}
     */
    hide() {
        this.pageAlert.next({ type: 'hide' });
    }
}
NwfPageAlertService.decorators = [
    { type: Injectable }
];
if (false) {
    /** @type {?} */
    NwfPageAlertService.prototype.pageAlert;
    /** @type {?} */
    NwfPageAlertService.prototype.pageAlert$;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGFnZS1hbGVydC5zZXJ2aWNlLmpzIiwic291cmNlUm9vdCI6Im5nOi8vQG5ldGFwcC9ud2Zqc19hbmd1bGFyX2NvbXBvbmVudHMvIiwic291cmNlcyI6WyJsaWIvY29tcG9uZW50cy9wYWdlLWFsZXJ0L3BhZ2UtYWxlcnQuc2VydmljZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7O0FBQUEsT0FBTyxFQUFFLFVBQVUsRUFBRSxNQUFNLGVBQWUsQ0FBQztBQUMzQyxPQUFPLEVBQUUsT0FBTyxFQUFFLE1BQU0sTUFBTSxDQUFDO0FBRy9CLE1BQU0sT0FBTyxtQkFBbUI7SUFEaEM7UUFHVyxjQUFTLEdBQWlCLElBQUksT0FBTyxFQUFFLENBQUM7UUFFeEMsZUFBVSxHQUFRLElBQUksQ0FBQyxTQUFTLENBQUMsWUFBWSxFQUFFLENBQUM7SUFXM0QsQ0FBQzs7Ozs7Ozs7SUFSVSxJQUFJLENBQUMsT0FBTyxFQUFFLFFBQVEsRUFBRSxJQUFhO1FBQ3hDLElBQUksQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLEVBQUMsSUFBSSxFQUFFLE1BQU0sRUFBRSxNQUFNLEVBQUUsRUFBRSxPQUFPLEVBQUUsUUFBUSxFQUFFLElBQUksRUFBRSxFQUFDLENBQUMsQ0FBQztJQUM3RSxDQUFDOzs7OztJQUdNLElBQUk7UUFDUCxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxFQUFDLElBQUksRUFBRSxNQUFNLEVBQUMsQ0FBQyxDQUFDO0lBQ3hDLENBQUM7OztZQWZKLFVBQVU7Ozs7SUFHUCx3Q0FBK0M7O0lBRS9DLHlDQUF1RCIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEluamVjdGFibGUgfSBmcm9tICdAYW5ndWxhci9jb3JlJztcbmltcG9ydCB7IFN1YmplY3QgfSBmcm9tICdyeGpzJztcblxuQEluamVjdGFibGUoKVxuZXhwb3J0IGNsYXNzIE53ZlBhZ2VBbGVydFNlcnZpY2Uge1xuXG4gICAgcHVibGljIHBhZ2VBbGVydDogU3ViamVjdDxhbnk+ID0gbmV3IFN1YmplY3QoKTtcblxuICAgIHB1YmxpYyBwYWdlQWxlcnQkOiBhbnkgPSB0aGlzLnBhZ2VBbGVydC5hc09ic2VydmFibGUoKTtcblxuICAgICAvLyBNZXRob2QgdG8gU2hvdyBQYWdlIEFsZXJ0XG4gICAgcHVibGljIHNob3cobWVzc2FnZSwgc2V2ZXJpdHksIGZhZGU/OiBudW1iZXIpOiB2b2lkIHtcbiAgICAgICAgdGhpcy5wYWdlQWxlcnQubmV4dCh7dHlwZTogJ3Nob3cnLCBjb25maWc6IHsgbWVzc2FnZSwgc2V2ZXJpdHksIGZhZGUgfX0pO1xuICAgIH1cblxuICAgIC8vIE1ldGhvZCB0byBIaWRlIFBhZ2UgQWxlcnRcbiAgICBwdWJsaWMgaGlkZSgpOiB2b2lkIHtcbiAgICAgICAgdGhpcy5wYWdlQWxlcnQubmV4dCh7dHlwZTogJ2hpZGUnfSk7XG4gICAgfVxufVxuIl19