/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, EventEmitter, Output } from '@angular/core';
/* todo - the 'nwf*cellTemplate' stuff should really be constants since they are shared in the../schema/schema' */
// nwf-grid-cell-templates
// this component contains all the templates that are common across all the grids.
// Currently it contains templates for checkboxTemplate, metricCellTemplate, dateCellTemplate, statusCellTemplate.
// metric, date celTemplates are i18n compliant.
export class CellsComponent {
    constructor() {
        // Output Event handler. This selects a row on the grid.
        this.onRowSelect = new EventEmitter();
    }
    /**
     * @param {?} data
     * @return {?}
     */
    onSelect(data) {
        // emit the onRowSelect event containing rowData.
        // This event is handled by the consumer.
        this.onRowSelect.emit(data);
    }
}
CellsComponent.decorators = [
    { type: Component, args: [{
                selector: 'nwf-grid-cell-templates',
                template: `
    <div *dxTemplate="let cellInfo of 'nwfRadioBoxCellTemplate'">
      <div class="custom-control custom-radio">
          <input type="radio" id="dx-data-grid-checkid-{{cellInfo.value}}" data-netapp-id="cell-radiobtn" class="custom-control-input" [value]="cellInfo.value" [checked]="cellInfo.component.isRowSelected(cellInfo.key) ? true : null"
          (click)="onSelect(cellInfo)">
          <label class="custom-control-label" for="dx-data-grid-checkid-{{cellInfo.value}}"></label>
      </div>
    </div>

    <div *dxTemplate="let cellInfo of 'nwfNumberCellTemplate'" attr.data-netapp-id="cell-{{cellInfo.column.dataField}}">
      {{cellInfo.value | i18nextFormat : { format: 'number'} }}
    </div>

    <div *dxTemplate="let cellInfo of 'nwfDateCellTemplate'" attr.data-netapp-id="cell-{{cellInfo.column.dataField}}">
      {{cellInfo.value | i18nextFormat : { format: 'datetime' } }}
    </div>

    <div *dxTemplate="let cellInfo of 'nwfStatusCellTemplate'" attr.data-netapp-id="cell-{{cellInfo.column.dataField}}">
      <nwf-icon [severity]="cellInfo.value"></nwf-icon>
    </div>

	<div *dxTemplate="let cellInfo of 'nwfMetricCellTemplate'" attr.data-netapp-id="cell-{{cellInfo.column.dataField}}">
      {{cellInfo.value | NwfRoundUnit : {unit: cellInfo.column.unit, statType: cellInfo.column.name} }}
    </div>

    <div *dxTemplate="let cellInfo of 'nwfDefaultCellTemplate'" attr.data-netapp-id="cell-{{cellInfo.column.dataField}}">
      {{cellInfo.value}}
    </div>
  `
            }] }
];
/** @nocollapse */
CellsComponent.ctorParameters = () => [];
CellsComponent.propDecorators = {
    onRowSelect: [{ type: Output }]
};
if (false) {
    /** @type {?} */
    CellsComponent.prototype.onRowSelect;
}
//# sourceMappingURL=data:application/json;base64,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