/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
/** @type {?} */
const containsOptions = [{
        name: 'nwfjs:contains', value: 'contains',
    }, {
        name: 'nwfjs:startsWith', value: 'startswith',
    }];
/** @type {?} */
const resourceContainsOptions = [{
        name: 'nwfjs:nameContains', value: 'contains',
    }, {
        name: 'nwfjs:nameStartsWith', value: 'startswith',
    }];
/** @type {?} */
const isOption = { name: 'nwfjs:is', value: '=' };
/** @type {?} */
const booleanOptions = [
    isOption,
    { name: 'nwfjs:isNot', value: '<>' },
];
/** @type {?} */
const numericOptions = [{
        name: 'nwfjs:greaterThan', value: '>',
    }, {
        name: 'nwfjs:lessThan', value: '<',
    }];
export default {
    'string': {
        inputType: 'text',
        options: containsOptions,
    },
    'associatedobjects': {
        inputType: 'text',
        options: containsOptions,
    },
    'volumetype': {
        inputType: 'select',
        options: [
            isOption,
        ],
    },
    'resource': {
        inputType: 'text',
        options: resourceContainsOptions,
    },
    'resource_null': {
        inputType: 'text',
        options: [...resourceContainsOptions,
            { name: 'nwfjs:is', value: '=', default: 'null' },
            { name: 'nwfjs:isNot', value: '<>', default: 'null' },
        ],
    },
    'metric': {
        inputType: 'number',
        options: numericOptions,
    },
    'enum': {
        inputType: 'select',
        options: booleanOptions,
    },
    'enum-single': {
        inputType: 'select',
        options: [
            isOption,
        ],
    },
    'enum-multiple': {
        inputType: 'multiselect',
        options: booleanOptions,
    },
    'number': {
        inputType: 'number',
        options: numericOptions,
    },
    'datetime': {
        inputType: 'dateTime',
        options: [{
                name: 'nwfjs:inTheLast', value: 'lst',
            }, {
                name: 'nwfjs:between', value: 'between',
            }, {
                name: 'nwfjs:greaterThan', value: '>=',
            }, {
                name: 'nwfjs:lessThan', value: '<=',
            }],
    },
};
//# sourceMappingURL=data:application/json;base64,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