/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, EventEmitter, Input, Output } from '@angular/core';
import { FormGroup } from '@angular/forms';
import { find } from 'lodash-es';
import FilterConfig from '../filter-config';
/**
 * A filter criterion consist of filter property, operator and a value.
 * Each filter-property have a list of operators.
 * Filter criterion row gets a critierion(filter) from parent filterGroup, and it breaks that criterion down into property, operator and a value.
 * Filter property and type means same thing and are interchangeable
 */
export class FilterCriterionRowComponent {
    constructor() {
        this.deleteCriterion = new EventEmitter();
        this.config = FilterConfig;
    }
    /**
     * @return {?}
     */
    ngOnInit() {
        // on birth, we set the operator and value based on incoming filter property.
        this.setColumnBasedOnCriteria();
    }
    /**
     * \@description method to set the operator and value of a particular criterion when property dropdown value is changed.
     * Whenever we change the filter property, we update the operator and reset the value associated with the filter, so that we can start fresh for the new filter.
     * @return {?}
     */
    updateCriterion() {
        // updating the new criterion.
        this.setColumnBasedOnCriteria();
        // resetting the form group with default criteria.
        this.criteria.reset(this.initCriterion(this.selectedColumn));
    }
    /**
     * @param {?} change
     * @return {?}
     */
    updateOperator(change) {
        /** @type {?} */
        const selectedOperator = change.target.value;
        // If there is a default value associate with the selected operator we want to set the criteria to have that value
        /** @type {?} */
        const defaultValue = find(this.config[this.selectedColumn.dataType].options, (/**
         * @param {?} option
         * @return {?}
         */
        (option) => option.value === selectedOperator)).default;
        if (defaultValue) {
            this.criteria.reset({ property: this.selectedColumn.dataField, operator: selectedOperator, value: defaultValue });
            // If the current value of the criteria is the same as the default value associated with the previous operator we want to clear it away
        }
        else if (this.previousOperator &&
            find(this.config[this.selectedColumn.dataType].options, (/**
             * @param {?} option
             * @return {?}
             */
            (option) => option.value === this.previousOperator)).default === this.criteria.controls.value.value) {
            this.criteria.reset({ property: this.selectedColumn.dataField, operator: selectedOperator, value: '' });
        }
        this.previousOperator = selectedOperator;
    }
    /**
     * Method to get the default filter critierion based on filter property.
     * @private
     * @param {?} __0
     * @return {?}
     */
    initCriterion({ dataField, dataType }) {
        this.previousOperator = this.config[dataType].options[0].value;
        return {
            property: dataField,
            operator: this.config[dataType].options[0].value,
            value: '',
        };
    }
    /**
     * This method finds the property to be set to individual criterion
     * from properties passed-in.
     * @private
     * @return {?}
     */
    setColumnBasedOnCriteria() {
        // update property based on new selection.
        this.selectedColumn = this.dxColumns.filter((/**
         * @param {?} prop
         * @return {?}
         */
        (prop) => {
            return prop.dataField === this.criteria.value.property;
        }))[0];
        // update prevoious operator based on criteria
        this.previousOperator = this.criteria.controls.operator.value;
        // updating operator list based on new filter property.
        this.propertyTypeConfig = this.config[this.selectedColumn.dataType];
    }
}
FilterCriterionRowComponent.decorators = [
    { type: Component, args: [{
                selector: 'nwf-grid-filter-criterion-row',
                template: "<div [formGroup]=\"criteria\" class=\"d-flex mb-2 w-100\">\n\n    <!-- Property -->\n    <div class=\"filter-criterion-control mr-1\">\n        <select class=\"custom-select\" data-netapp-id=\"filter-widget-select-type\" (change)=\"updateCriterion()\" formControlName=\"property\">\n            <option *ngFor=\"let dxColumn of dxColumns\" [value]=\"dxColumn.dataField\">{{dxColumn.caption}}</option>\n        </select>\n    </div>\n\n    <!-- Operator -->\n    <div class=\"filter-criterion-control mr-1\">\n        <select class=\"custom-select\" data-netapp-id=\"filter-widget-select-operator\" (change)=\"updateOperator($event)\" formControlName=\"operator\">\n            <option *ngFor=\"let operator of propertyTypeConfig.options\" [value]=\"operator.value\">{{operator.name | i18next}}\n            </option>\n        </select>\n    </div>\n\n    <!-- Value -->\n    <div class=\"mr-1\" [ngSwitch]=\"propertyTypeConfig.inputType\">\n        <div *ngSwitchCase=\"'text'\" class=\"align-items-center\">\n            <input type=\"text\" [hidden]=\"criteria.controls.operator.value === '<>' || criteria.controls.operator.value === '='\"\n            class=\"form-control filter-criterion-control\" required data-netapp-id=\"filter-searchText\" formControlName=\"value\">\n            <div *ngIf=\"criteria.controls.operator.value === '<>' || criteria.controls.operator.value === '='\" class=\"form-control\">\n                {{'nwfjs:empty' | i18next}}\n            </div>\n        </div>\n\n        <div *ngSwitchCase=\"'number'\" class=\"d-flex align-items-center\">\n            <input type=\"number\" *ngSwitchCase=\"'number'\" class=\"form-control filter-criterion-control\" required data-netapp-id=\"filter-searchText\" formControlName=\"value\"\n                step=\"any\">\n            <!-- unit -->\n            <div class=\"px-2\" *ngIf=\"selectedColumn.unit\" data-netapp-id=\"filter-widget-unit\">{{selectedColumn.unit}}</div>\n        </div>\n        <select class=\"custom-select filter-criterion-control\" data-netapp-id=\"filter-widget-property-options\" required formControlName=\"value\" *ngSwitchCase=\"'select'\">\n            <option [selected]=\"!criteria.value\" value>{{'nwfjs:choose' | i18next}}</option>\n            <option [selected]=\"criteria.value.value == option.id\" *ngFor=\"let option of selectedColumn.editorOptions\" [value]=\"option.id\">{{option.label}}\n                </option>\n        </select>\n\n        <nwf-grid-filter-multiselect [options]=\"selectedColumn.editorOptions\" required *ngSwitchCase=\"'multiselect'\" formControlName=\"value\">\n        </nwf-grid-filter-multiselect>\n\n        <nwf-grid-filter-criterion-date [operator]=\"criteria.controls.operator.value\" *ngSwitchCase=\"'dateTime'\" formControlName=\"value\"></nwf-grid-filter-criterion-date>\n\n        <div *ngIf=\"criteria.invalid && (criteria.controls.value.touched || criteria.controls.value.dirty)\" class=\"invalid-feedback\">\n            <span *ngSwitchCase=\"'select'\">{{'nwfjs:isRequiredInvalidMessage' | i18next}}</span>\n            <span *ngSwitchCase=\"'multiselect'\">{{'nwfjs:isRequiredAtLeastOne' | i18next}}</span>\n            <span *ngSwitchCase=\"'dateTime'\">{{'nwfjs:isInvalidTimeMessage' | i18next}}</span>\n            <span *ngSwitchCase=\"'text'\">{{'nwfjs:isRequiredInvalidMessage' | i18next}}</span>\n            <span *ngSwitchCase=\"'number'\">{{'nwfjs:isNumberInvalidMessage' | i18next}}</span>\n        </div>\n    </div>\n\n    <!-- remove button -->\n    <div class=\"d-flex flex-fill justify-content-end\">\n        <div>\n            <button type=\"button\" class=\"btn btn-default btn-delete-criterion\" data-netapp-id=\"filter-widget-remove-criteria-btn\" (click)=\"deleteCriterion.emit();$event.stopPropagation();\">\n                <nwf-icon iconClass=\"icon-action-delete\"></nwf-icon>\n            </button>\n        </div>\n    </div>\n</div>",
                styles: [`.filter-criterion-control {
            width: 200px;
        }`]
            }] }
];
/** @nocollapse */
FilterCriterionRowComponent.ctorParameters = () => [];
FilterCriterionRowComponent.propDecorators = {
    dxColumns: [{ type: Input }],
    criteria: [{ type: Input }],
    deleteCriterion: [{ type: Output }]
};
if (false) {
    /** @type {?} */
    FilterCriterionRowComponent.prototype.dxColumns;
    /** @type {?} */
    FilterCriterionRowComponent.prototype.criteria;
    /** @type {?} */
    FilterCriterionRowComponent.prototype.deleteCriterion;
    /** @type {?} */
    FilterCriterionRowComponent.prototype.selectedColumn;
    /** @type {?} */
    FilterCriterionRowComponent.prototype.propertyTypeConfig;
    /** @type {?} */
    FilterCriterionRowComponent.prototype.config;
    /**
     * Track operator changes to set default and remove defaults based on changes
     * @type {?}
     */
    FilterCriterionRowComponent.prototype.previousOperator;
}
//# sourceMappingURL=data:application/json;base64,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