/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, Input } from '@angular/core';
import { NG_VALUE_ACCESSOR } from '@angular/forms';
/** @type {?} */
let nextId = 0;
export class FilterMultiselectComponent {
    constructor() {
        this.id = `nwf-filter-multiselect-${nextId++}`;
        this.valueModel = {};
        // the private data used within
        this._optionsIconClasses = [
            'ok',
            'warning',
            'critical',
            'error',
            'information',
        ];
        this._valDelimiter = '|';
    }
    /**
     * @param {?} changes
     * @return {?}
     */
    ngOnChanges(changes) {
        if (changes.options) {
            // I need to intitalize my options
            this.setOptionIcons();
        }
    }
    /**
     * Writes a new value to the element.
     * This method will be called by the forms API to write to the view when programmatic (model -> view) changes are requested.
     * This is incoming 'value' into the component. This value is pre-set value to multiselect.
     * @param {?} value
     * @return {?}
     */
    writeValue(value) {
        if (value) {
            // each multiselect is a string separated by a '|'. So we split the string on '|' to get individual values selected on a multiselect.
            // eg: a|b|c. This translates to a b c should be selected in multiselect widget, hence setting them to true.
            value.split(this._valDelimiter).forEach((/**
             * @param {?} iValue
             * @return {?}
             */
            (iValue) => this.valueModel[iValue] = true));
        }
    }
    /**
     * @param {?} fn
     * @return {?}
     */
    registerOnChange(fn) { this._onChange = fn; }
    /**
     * @param {?} fn
     * @return {?}
     */
    registerOnTouched(fn) { }
    /**
     * This method is called whenever model tied to the component changes. This invoked change handler on the component
     * that can be handled by the widget's consumer.
     * This is outgoing value from this widget.
     * @return {?}
     */
    onValueModelChange() {
        /** @type {?} */
        const vArr = [];
        // looping over the entire object and pulling out keys that have true value
        for (const val in this.valueModel) {
            // filter out keys whose value is false.
            if (!this.valueModel[val]) {
                continue;
            }
            vArr.push(val);
        }
        // joining keys by '|' delimiter.
        this._onChange(vArr.join(this._valDelimiter));
    }
    /**
     * This method sets the icon next to option label.
     * It also sets all checkboxes to false initially.
     * @return {?}
     */
    setOptionIcons() {
        // reset model if options are set.
        this.valueModel = {};
        this.options.map((/**
         * @param {?} option
         * @return {?}
         */
        (option) => {
            /** @type {?} */
            const optionLowercase = option.id.toLowerCase();
            // setting all checkboxes as unchecked initially.
            this.valueModel[option.id] = false;
            if (this._optionsIconClasses.indexOf(optionLowercase) !== -1) {
                option.iconClass = optionLowercase;
            }
        }));
    }
}
FilterMultiselectComponent.decorators = [
    { type: Component, args: [{
                selector: 'nwf-grid-filter-multiselect',
                template: `
    <div class="border border-secondary filter-multiselect-list w-100">
        <div data-netapp-id="filter-multiselect-list-option" class="d-flex align-items-center p-1 filter-multiselect-list-option" *ngFor="let option of options; let i = index">
            <div class="custom-control custom-checkbox">
                <input type="checkbox" id="{{id}}-{{i}}" data-netapp-id="filter-multiselect-list-option-checkbox" class="custom-control-input p-2" name="filter-multiselect-list-option-checkbox"  [(ngModel)]="valueModel[option.id]" (change)="onValueModelChange()">
                <label class="custom-control-label" for="{{id}}-{{i}}">
                    <nwf-icon *ngIf="option.iconClass" severity="{{option.iconClass}}" class="option-icon"></nwf-icon>
                    <span class="pl-2">{{ option.label ? option.label : option.id }}</span>
                </label>
            </div>
        </div>
    </div>
    `,
                providers: [{
                        provide: NG_VALUE_ACCESSOR,
                        useExisting: FilterMultiselectComponent,
                        multi: true,
                    }],
                styles: [".filter-multiselect-list{max-height:100px;overflow-y:auto}.filter-multiselect-list-option:hover{cursor:pointer}.filter-multiselect-list-option-label{width:170px}"]
            }] }
];
FilterMultiselectComponent.propDecorators = {
    options: [{ type: Input }],
    id: [{ type: Input }]
};
if (false) {
    /** @type {?} */
    FilterMultiselectComponent.prototype.options;
    /** @type {?} */
    FilterMultiselectComponent.prototype.id;
    /** @type {?} */
    FilterMultiselectComponent.prototype.valueModel;
    /**
     * @type {?}
     * @private
     */
    FilterMultiselectComponent.prototype._optionsIconClasses;
    /**
     * @type {?}
     * @private
     */
    FilterMultiselectComponent.prototype._onChange;
    /**
     * @type {?}
     * @private
     */
    FilterMultiselectComponent.prototype._valDelimiter;
}
//# sourceMappingURL=data:application/json;base64,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