/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { DxiDataGridColumn } from 'devextreme-angular/ui/nested/base/data-grid-column-dxi';
import { assign, get } from 'lodash-es';
export class NwfGridSchemaProcessor {
    /**
     * @param {?} schemaObject
     * @param {?=} schemaIdToDxColumn
     * @param {?=} customSchemaTypeToDxColumn
     */
    constructor(schemaObject, schemaIdToDxColumn = {}, customSchemaTypeToDxColumn) {
        /* First, we take the schemaIdToDxColumn and mix it over our own standard definition ,
            so we allow the user to provide us with custom schemaType to DxColumns,
            but we also handle a standard dataType provided by nwf, to make it easy.
            Note: this schemaTypeToDxColumn we have in this class is married to um's ftm.
        */
        this.columns = [];
        this.filterableColumns = [];
        this.schemaTypeToDxColumn = {
            dateTime: NwfDateColumn,
            metric: NwfMetricColumn,
            number: NwfNumberColumn,
        };
        for (const columnId in schemaObject) {
            if (schemaObject.hasOwnProperty(columnId)) {
                /** @type {?} */
                const schemaProp = schemaObject[columnId];
                /** @type {?} */
                const hasMatchingId = columnId in schemaIdToDxColumn ? true : false;
                // updating schemaTypeToDxColumn mapping.
                this.schemaTypeToDxColumn = assign({}, this.schemaTypeToDxColumn, customSchemaTypeToDxColumn);
                /** @type {?} */
                const hasMatchingType = schemaProp.type in this.schemaTypeToDxColumn ? true : false;
                /** @type {?} */
                let dxColumnObject;
                /* First I see if the id has an associated columnId from the caller's schemaIdToDxColumn map.
                    This is because I want to allow the user to easily customize the cell based on the id.
                    for example, they tell me how to render a clusterObject. If it has a matching id, it wins over the nwf
                    mapped type.
                */
                if (hasMatchingId) {
                    dxColumnObject = new schemaIdToDxColumn[schemaProp.id](schemaProp);
                }
                else if (hasMatchingType) {
                    /* There is no matching Id, so I next try to create a column based on the schemaProp's type.
                        This is so I can best render a column's value based on the type (date, number) to a nice i18n default.
                    */
                    dxColumnObject = new this.schemaTypeToDxColumn[schemaProp.type](schemaProp);
                }
                else {
                    /* now I dont know */
                    dxColumnObject = new NwfSchemaColumn(schemaProp);
                }
                this.columns.push(dxColumnObject);
                // finding all filterable properties.
                if (schemaProp.filterable) {
                    this.filterableColumns.push(schemaProp);
                }
            }
        }
    }
}
if (false) {
    /** @type {?} */
    NwfGridSchemaProcessor.prototype.columns;
    /** @type {?} */
    NwfGridSchemaProcessor.prototype.filterableColumns;
    /**
     * @type {?}
     * @private
     */
    NwfGridSchemaProcessor.prototype.schemaTypeToDxColumn;
}
export class NwfSchemaColumn extends DxiDataGridColumn {
    /**
     * @param {?} schemaProp
     */
    constructor(schemaProp) {
        super();
        this.allowHeaderFiltering = false;
        this.alignment = 'left';
        this.visible = true;
        this.allowFiltering = true;
        this.allowSorting = true;
        this.allowHiding = true;
        this.allowReordering = true;
        this.cellTemplate = 'nwfDefaultCellTemplate';
        this.width = '100%';
        const { id, label, type, options, visible } = schemaProp;
        // the dataField is how dx identifies the column, for us it is the same as the id, name is needed because that is how
        // we identify the column by name later to set options.
        this.name = this.dataField = id;
        // set a descriptive or friendly name for the column.
        this.caption = label;
        // our type field is pretty close to the default dataTypes (which are just lowercased strings)
        // this can be improved if we have other types, but I bet it will work.
        this.dataType = type.toLowerCase();
        // we allow search only for columns having 'resource','string', or associatedObjects dataType;
        this.allowSearch = ['resource', 'string', 'associatedObjects'].indexOf(this.dataType) !== -1;
        this.allowFiltering = get(schemaProp, 'filterable', this.allowFiltering);
        this.allowSorting = get(schemaProp, 'sortable', this.allowSorting);
        // editorOptions becomes options for 'enum-single' and 'enum-multiple' values.
        this.editorOptions = options;
        this.showInColumnChooser = visible;
    }
}
if (false) {
    /** @type {?} */
    NwfSchemaColumn.prototype.allowHeaderFiltering;
    /** @type {?} */
    NwfSchemaColumn.prototype.alignment;
    /** @type {?} */
    NwfSchemaColumn.prototype.visible;
    /** @type {?} */
    NwfSchemaColumn.prototype.allowFiltering;
    /** @type {?} */
    NwfSchemaColumn.prototype.allowSorting;
    /** @type {?} */
    NwfSchemaColumn.prototype.allowHiding;
    /** @type {?} */
    NwfSchemaColumn.prototype.allowReordering;
    /** @type {?} */
    NwfSchemaColumn.prototype.cellTemplate;
    /** @type {?} */
    NwfSchemaColumn.prototype.width;
    /** @type {?} */
    NwfSchemaColumn.prototype._optionPath;
}
export class NwfNumberColumn extends NwfSchemaColumn {
    /**
     * @param {?} schemaProp
     */
    constructor(schemaProp) {
        super(schemaProp);
        this.cellTemplate = 'nwfNumberCellTemplate';
    }
}
if (false) {
    /** @type {?} */
    NwfNumberColumn.prototype.cellTemplate;
}
export class NwfMetricColumn extends NwfSchemaColumn {
    /**
     * @param {?} schemaProp
     */
    constructor(schemaProp) {
        super(schemaProp);
        this.cellTemplate = 'nwfMetricCellTemplate';
        this.unit = schemaProp.unit;
    }
}
if (false) {
    /** @type {?} */
    NwfMetricColumn.prototype.cellTemplate;
    /** @type {?} */
    NwfMetricColumn.prototype.unit;
}
export class NwfDateColumn extends NwfSchemaColumn {
    /**
     * @param {?} schemaProp
     */
    constructor(schemaProp) {
        super(schemaProp);
        this.cellTemplate = 'nwfDateCellTemplate';
    }
}
if (false) {
    /** @type {?} */
    NwfDateColumn.prototype.cellTemplate;
}
export class NwfStatusColumn extends NwfSchemaColumn {
    // creating a cell template based on UX requirements.
    /**
     * @param {?} schemaProp
     */
    constructor(schemaProp) {
        super(schemaProp);
        this.alignment = 'center';
        this.width = 80;
        this.cellTemplate = 'nwfStatusCellTemplate';
        this.calculateSortValue = (/**
         * @param {?} __0
         * @return {?}
         */
        ({ status }) => {
            // we assign 'z' to critical so that it shows as first,last when sorted alphabettically
            // for possible status values.
            if (status.toLowerCase() === 'critical') {
                status = 'z'; // Critical are always displayed at the top
            }
            return status;
        });
    }
}
if (false) {
    /** @type {?} */
    NwfStatusColumn.prototype.alignment;
    /** @type {?} */
    NwfStatusColumn.prototype.width;
    /** @type {?} */
    NwfStatusColumn.prototype.cellTemplate;
    /** @type {?} */
    NwfStatusColumn.prototype.calculateSortValue;
}
//# sourceMappingURL=data:application/json;base64,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