/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Pipe } from '@angular/core';
import { I18NextFormatPipe } from 'angular-i18next';
export class NwfRoundUnit {
    /**
     * @param {?} i18NextPipeFormatPipe
     */
    constructor(i18NextPipeFormatPipe) {
        this.i18NextPipeFormatPipe = i18NextPipeFormatPipe;
        this.units = ['bytes', 'KB', 'MB', 'GB', 'TB', 'PB'];
    }
    /**
     * @param {?} value
     * @param {?} config
     * @return {?}
     */
    transform(value, config) {
        let { unit, statType } = config;
        /** @type {?} */
        const isPercent = (unit === '%');
        if (this.units.indexOf(unit) >= 0) {
            const { value: newValue, unit: newUnit } = this.getReadable(value, unit);
            value = newValue;
            unit = newUnit;
        }
        /** @type {?} */
        let text = this.round(value, isPercent, statType);
        if (text) { // parsing through number locale if value is truthy.if (value !== null) {
            if (!isNaN(parseFloat(text))) {
                // Use i18next formatting for number
                text = this.i18NextPipeFormatPipe.transform(parseFloat(text), { format: 'number' });
            }
            if (unit) { // add unit only if unit is not undefined and not null
                text += (isPercent ? '' : ' ') + unit;
            }
            return text;
        }
        else {
            return 'N/A';
        }
    }
    /**
     * @param {?} value
     * @param {?=} isPercent
     * @param {?=} statType
     * @return {?}
     */
    round(value, isPercent = false, statType = '') {
        if (value === null) { //  return null if null
            return null;
        }
        else if (value === 0) {
            return '0';
        }
        if (isPercent) {
            if (value < 1) { // "<1" if < 1
                return '< 1';
            }
            else { // Whole number otherwise
                return parseFloat(value).toFixed();
            }
        }
        else {
            if (value < 1) {
                switch (statType) {
                    case 'latency':
                        return parseFloat(value).toFixed(3); // 3 decimal points between 0 and 1 for Latency
                    default:
                        return '< 1'; // "<1" if < 1 for everything else
                }
            }
            else if (value < 10 && value >= 1) { // 2 decimal points between 1 and 10
                return parseFloat(value).toFixed(2);
            }
            else if (value < 100 && value >= 10) { // 1 decimal point between 10 and  100
                return parseFloat(value).toFixed(1);
            }
            else if (value >= 100) { // Whole number if greater than 100
                return parseFloat(value).toFixed();
            }
            else {
                return value;
            }
        }
    }
    /**
     * @param {?} value
     * @param {?} unit
     * @return {?}
     */
    getReadable(value, unit) {
        /** @type {?} */
        let idx = this.units.indexOf(unit);
        /** @type {?} */
        let result;
        // we always need a value handling undefined case
        while (value && !(value >= 1 && value < 1024)) {
            if (value < 1) {
                // The current unit is too big
                if (idx > 0) {
                    // Decrease the unit by one level
                    value *= 1024.0;
                    idx -= 1;
                }
                else {
                    // The current unit is KB, there is no smaller unit, we have the result
                    result = { value, unit: this.units[idx] };
                    break;
                }
            }
            if (value >= 1024) {
                // The current unit is too small
                if (idx < this.units.length - 1) {
                    // Increase the unit by one level
                    value /= 1024.0;
                    idx += 1;
                }
                else {
                    // The current unit is PB, there is no bigger unit, we have the result
                    result = { value, unit: this.units[idx] };
                    break;
                }
            }
        }
        if (!result) {
            // The give arguments are proper value and unit
            result = { value, unit: this.units[idx] };
        }
        return result;
    }
}
NwfRoundUnit.decorators = [
    { type: Pipe, args: [{ name: 'NwfRoundUnit' },] }
];
/** @nocollapse */
NwfRoundUnit.ctorParameters = () => [
    { type: I18NextFormatPipe }
];
if (false) {
    /** @type {?} */
    NwfRoundUnit.prototype.units;
    /**
     * @type {?}
     * @private
     */
    NwfRoundUnit.prototype.i18NextPipeFormatPipe;
}
//# sourceMappingURL=data:application/json;base64,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